/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.HashSet;
import org.apache.datasketches.memory.WritableHandle;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchIterator;
import org.apache.datasketches.quantiles.DoublesUnion;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.datasketches.quantiles.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DebugUnionTest {
    @Test
    public void test() {
        UpdateDoublesSketch dSketch;
        int n = 70000;
        int valueLimit = 1000;
        int numSketches = 3;
        int sketchK = 8;
        int unionK = 8;
        UpdateDoublesSketch[] sketchArr = new UpdateDoublesSketch[3];
        DoublesSketch.setRandom((long)1L);
        HashSet<Double> set = new HashSet<Double>();
        for (int s = 0; s < 3; ++s) {
            sketchArr[s] = DebugUnionTest.buildHeapSketch(8, 70000, 1000, set);
        }
        DoublesSketch.setRandom((long)1L);
        DoublesUnion hUnion = DoublesUnion.builder().setMaxK(8).build();
        for (int s = 0; s < 3; ++s) {
            hUnion.update((DoublesSketch)sketchArr[s]);
        }
        UpdateDoublesSketch hSketch = hUnion.getResult();
        DoublesSketch.setRandom((long)1L);
        try (WritableHandle wdh = WritableMemory.allocateDirect((long)10000000L);){
            WritableMemory wmem = wdh.getWritable();
            DoublesUnion dUnion = DoublesUnion.builder().setMaxK(8).build(wmem);
            for (int s = 0; s < 3; ++s) {
                dUnion.update((DoublesSketch)sketchArr[s]);
            }
            dSketch = dUnion.getResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        int hCount = hSketch.getRetainedItems();
        int dCount = dSketch.getRetainedItems();
        Assert.assertEquals((int)hCount, (int)dCount);
        int hErrors = 0;
        int dErrors = 0;
        DoublesSketchIterator hit = hSketch.iterator();
        DoublesSketchIterator dit = dSketch.iterator();
        while (hit.next() && dit.next()) {
            double w;
            double v = hit.getValue();
            if (!set.contains(v)) {
                ++hErrors;
            }
            if (!set.contains(w = dit.getValue())) {
                ++dErrors;
            }
            Assert.assertEquals((double)v, (double)w, (double)0.0);
        }
        Assert.assertTrue((hErrors == 0 ? 1 : 0) != 0);
        Assert.assertTrue((dErrors == 0 ? 1 : 0) != 0);
        DebugUnionTest.println("HeapUnion  : Values: " + hCount + ", errors: " + hErrors);
        DebugUnionTest.println("DirectUnion: Values: " + dCount + ", errors: " + dErrors);
    }

    private static UpdateDoublesSketch buildHeapSketch(int k, int n, int valueLimit, HashSet<Double> set) {
        UpdateDoublesSketch uSk = DoublesSketch.builder().setK(k).build();
        for (int i = 0; i < n; ++i) {
            double value = DoublesSketch.rand.nextInt(valueLimit) + 1;
            uSk.update(value);
            set.add(value);
        }
        return uSk;
    }

    @Test
    public void printlnTest() {
        DebugUnionTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
        DebugUnionTest.print(s + Util.LS);
    }

    static void print(String s) {
    }
}

