/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.frequencies;

import org.testng.Assert;

public class DistTest {
    public static long randomGeometricDist(double prob) {
        assert (prob > 0.0 && prob < 1.0);
        return 1L + (long)(Math.log(Math.random()) / Math.log(1.0 - prob));
    }

    public static double zeta(long n, double theta) {
        double ans = 0.0;
        int i = 1;
        while ((long)i <= n) {
            ans += Math.pow(1.0 / (double)i, theta);
            ++i;
        }
        return ans;
    }

    public static long zipf(double theta, long n, double zetan) {
        double alpha = 1.0 / (1.0 - theta);
        double eta = (1.0 - Math.pow(2.0 / (double)n, 1.0 - theta)) / (1.0 - DistTest.zeta(2L, theta) / zetan);
        double u = 0.0;
        while (u == 0.0) {
            u = Math.random();
        }
        double uz = u * zetan;
        double val = uz < 1.0 ? 1.0 : (uz < 1.0 + Math.pow(0.5, theta) ? 2.0 : 1.0 + (double)n * Math.pow(eta * u - eta + 1.0, alpha));
        return (long)val;
    }

    public static void testRandomGeometricDist() {
        long maxItem = 0L;
        double prob = 0.1;
        for (int i = 0; i < 100; ++i) {
            long item = DistTest.randomGeometricDist(prob);
            if (item > maxItem) {
                maxItem = item;
            }
            Assert.assertTrue(((double)maxItem < 20.0 / prob ? 1 : 0) != 0);
        }
    }
}

