/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import java.io.File;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.Util;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UtilTest {
    private static final String LS = System.getProperty("line.separator");

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkPowerOf2() {
        Util.checkIfPowerOf2((int)31, (String)"31");
    }

    @Test
    public void numTrailingOnes() {
        long mask = 1L;
        for (int i = 0; i <= 64; ++i) {
            long v = (mask ^ 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFFFFL;
            mask <<= 1;
            int numT1s = Util.numberOfTrailingOnes((long)v);
            int numL1s = Util.numberOfLeadingOnes((long)v);
            Assert.assertEquals((int)Long.numberOfTrailingZeros(v ^ 0xFFFFFFFFFFFFFFFFL), (int)numT1s);
            Assert.assertEquals((int)Long.numberOfLeadingZeros(v ^ 0xFFFFFFFFFFFFFFFFL), (int)numL1s);
        }
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkBoundsTest() {
        Util.checkBounds((long)999L, (long)2L, (long)1000L);
    }

    @Test
    public void checkIsPowerOf2() {
        Assert.assertEquals((boolean)Util.isPowerOf2((int)0), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)1), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)2), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)4), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)8), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)0x40000000), (boolean)true);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)3), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)5), (boolean)false);
        Assert.assertEquals((boolean)Util.isPowerOf2((int)-1), (boolean)false);
    }

    @Test
    public void checkCheckIfPowerOf2() {
        Util.checkIfPowerOf2((int)8, (String)"Test 8");
        try {
            Util.checkIfPowerOf2((int)7, (String)"Test 7");
            Assert.fail((String)"Expected SketchesArgumentException");
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkCeilingPowerOf2() {
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)Integer.MAX_VALUE), (int)0x40000000);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)0x40000000), (int)0x40000000);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)64), (int)64);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)65), (int)128);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)0), (int)1);
        Assert.assertEquals((int)Util.ceilingPowerOf2((int)-1), (int)1);
    }

    @Test
    public void checkCeilingPowerOf2double() {
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)2.147483647E9), (double)Math.pow(2.0, 31.0));
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)1.073741824E9), (double)Math.pow(2.0, 30.0));
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)64.0), (double)64.0);
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)65.0), (double)128.0);
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)0.0), (double)1.0);
        Assert.assertEquals((double)Util.ceilingPowerOfBdouble((double)2.0, (double)-1.0), (double)1.0);
    }

    @Test
    public void checkFloorPowerOf2Int() {
        Assert.assertEquals((int)Util.floorPowerOf2((int)-1), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)1), (int)1);
        Assert.assertEquals((int)Util.floorPowerOf2((int)2), (int)2);
        Assert.assertEquals((int)Util.floorPowerOf2((int)3), (int)2);
        Assert.assertEquals((int)Util.floorPowerOf2((int)4), (int)4);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x3FFFFFFF), (int)0x20000000);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x40000000), (int)0x40000000);
        Assert.assertEquals((int)Util.floorPowerOf2((int)0x40000001), (int)0x40000000);
    }

    @Test
    public void checkFloorPowerOf2Long() {
        Assert.assertEquals((long)Util.floorPowerOf2((long)-1L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)1L), (long)1L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)2L), (long)2L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)3L), (long)2L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)4L), (long)4L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)Long.MAX_VALUE), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0x4000000000000000L), (long)0x4000000000000000L);
        Assert.assertEquals((long)Util.floorPowerOf2((long)0x4000000000000001L), (long)0x4000000000000000L);
    }

    @Test
    public void checkFloorPowerOf2double() {
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)-1.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)0.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)1.0), (double)1.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)2.0), (double)2.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)3.0), (double)2.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)4.0), (double)4.0);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)1.073741823E9), (double)5.36870912E8);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)1.073741824E9), (double)1.073741824E9);
        Assert.assertEquals((double)Util.floorPowerOfBdouble((double)2.0, (double)1.073741825E9), (double)1.073741824E9);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIfMultipleOf8AndGTzero() {
        Util.checkIfMultipleOf8AndGT0((long)8L, (String)"test");
        Util.checkIfMultipleOf8AndGT0((long)7L, (String)"test");
    }

    @Test
    public void checkIsMultipleOf8AndGT0() {
        Assert.assertTrue((boolean)Util.isMultipleOf8AndGT0((long)8L));
        Assert.assertFalse((boolean)Util.isMultipleOf8AndGT0((long)7L));
        Assert.assertFalse((boolean)Util.isMultipleOf8AndGT0((long)-1L));
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkIfMultipleOf8AndGTzero2() {
        Util.checkIfMultipleOf8AndGT0((long)8L, (String)"test");
        Util.checkIfMultipleOf8AndGT0((long)-1L, (String)"test");
    }

    @Test
    public void checkIsLessThanUnsigned() {
        long n1 = 1L;
        long n2 = 3L;
        long n3 = -3L;
        long n4 = -1L;
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)1L, (long)3L));
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)3L, (long)-3L));
        Assert.assertTrue((boolean)Util.isLessThanUnsigned((long)-3L, (long)-1L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)3L, (long)1L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)-3L, (long)3L));
        Assert.assertFalse((boolean)Util.isLessThanUnsigned((long)-1L, (long)-3L));
    }

    @Test
    public void checkZeroPad() {
        long v = 123456789L;
        String vHex = Long.toHexString(123456789L);
        String out = Util.zeroPad((String)vHex, (int)16);
        UtilTest.println("Pad 16, prepend 0: " + out);
    }

    @Test
    public void checkCharacterPad() {
        String s = "Pad 30, postpend z:";
        String out = Util.characterPad((String)"Pad 30, postpend z:", (int)30, (char)'z', (boolean)true);
        UtilTest.println(out);
    }

    @Test
    public void checkProbabilityFn1() {
        Util.checkProbability((double)0.5, (String)"Good");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkProbabilityFn2() {
        Util.checkProbability((double)-0.5, (String)"Too Low");
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkProbabilityFn3() {
        Util.checkProbability((double)1.5, (String)"Too High");
    }

    @Test
    public void checkEvenlySpaced() {
        double[] arr = Util.evenlySpaced((double)0.0, (double)1.0, (int)3);
        Assert.assertEquals((double)arr[0], (double)0.0);
        Assert.assertEquals((double)arr[1], (double)0.5);
        Assert.assertEquals((double)arr[2], (double)1.0);
        arr = Util.evenlySpaced((double)3.0, (double)7.0, (int)3);
        Assert.assertEquals((double)arr[0], (double)3.0);
        Assert.assertEquals((double)arr[1], (double)5.0);
        Assert.assertEquals((double)arr[2], (double)7.0);
    }

    @Test
    public void checkEvenlySpacedFloats() {
        float[] arr = Util.evenlySpacedFloats((float)0.0f, (float)1.0f, (int)3);
        Assert.assertEquals((float)arr[0], (float)0.0f);
        Assert.assertEquals((float)arr[1], (float)0.5f);
        Assert.assertEquals((float)arr[2], (float)1.0f);
        arr = Util.evenlySpacedFloats((float)3.0f, (float)7.0f, (int)3);
        Assert.assertEquals((float)arr[0], (float)3.0f);
        Assert.assertEquals((float)arr[1], (float)5.0f);
        Assert.assertEquals((float)arr[2], (float)7.0f);
    }

    @Test
    public void checkEvenlyLogSpaced() {
        double[] arr = Util.evenlyLogSpaced((double)1.0, (double)8.0, (int)4);
        Assert.assertEquals((double)arr[0], (double)1.0);
        Assert.assertEquals((double)arr[1], (double)2.0);
        Assert.assertEquals((double)arr[2], (double)4.0);
        Assert.assertEquals((double)arr[3], (double)8.0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkEvenlySpacedExcep() {
        Util.evenlySpaced((double)1.0, (double)2.0, (int)1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkEvenlyLogSpacedExcep1() {
        Util.evenlyLogSpaced((double)1.0, (double)2.0, (int)1);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkEvenlyLogSpacedExcep2() {
        Util.evenlyLogSpaced((double)-1.0, (double)2.0, (int)2);
    }

    @Test
    public void checkBytesToInt() {
        byte[] arr = new byte[]{4, 3, 2, 1};
        int result = 16909060;
        Assert.assertEquals((int)Util.bytesToInt((byte[])arr), (int)16909060);
        byte[] arr2 = Util.intToBytes((int)16909060, (byte[])new byte[4]);
        Assert.assertEquals((byte[])arr, (byte[])arr2);
    }

    @Test
    public void checkBytesToLong() {
        byte[] arr = new byte[]{8, 7, 6, 5, 4, 3, 2, 1};
        long result = 72623859790382856L;
        Assert.assertEquals((long)Util.bytesToLong((byte[])arr), (long)72623859790382856L);
    }

    @Test
    public void checkBytesToString() {
        long lng = -506664900861165055L;
        byte[] bytes = new byte[8];
        bytes = Util.longToBytes((long)-506664900861165055L, (byte[])bytes);
        String sep = ".";
        String unsignLE = Util.bytesToString((byte[])bytes, (boolean)false, (boolean)true, (String)".");
        String signedLE = Util.bytesToString((byte[])bytes, (boolean)true, (boolean)true, (String)".");
        String unsignBE = Util.bytesToString((byte[])bytes, (boolean)false, (boolean)false, (String)".");
        String signedBE = Util.bytesToString((byte[])bytes, (boolean)true, (boolean)false, (String)".");
        Assert.assertEquals((String)unsignLE, (String)"1.2.3.4.245.246.247.248");
        Assert.assertEquals((String)signedLE, (String)"1.2.3.4.-11.-10.-9.-8");
        Assert.assertEquals((String)unsignBE, (String)"248.247.246.245.4.3.2.1");
        Assert.assertEquals((String)signedBE, (String)"-8.-9.-10.-11.4.3.2.1");
    }

    @Test
    public void checkNsecToString() {
        long nS = 1001001001L;
        String result = Util.nanoSecToString((long)1001001001L);
        String expected = "1.001_001_001";
        Assert.assertEquals((String)result, (String)"1.001_001_001");
    }

    @Test
    public void checkMsecToString() {
        long nS = 3661001L;
        String result = Util.milliSecToString((long)3661001L);
        String expected = "1:01:01.001";
        Assert.assertEquals((String)result, (String)"1:01:01.001");
    }

    @Test
    public void checkPwr2LawNext() {
        int next = Util.pwr2LawNext((int)2, (int)1);
        Assert.assertEquals((int)next, (int)2);
        next = Util.pwr2LawNext((int)2, (int)0);
        Assert.assertEquals((int)next, (int)1);
    }

    @Test
    public void checkPwr2LawNextDouble() {
        double next = Util.pwrLawNextDouble((int)2, (double)1.0, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
        next = Util.pwrLawNextDouble((int)2, (double)1.0, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)Math.sqrt(2.0), (double)0.0);
        next = Util.pwrLawNextDouble((int)2, (double)0.5, (boolean)true, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
        next = Util.pwrLawNextDouble((int)2, (double)0.5, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)Math.sqrt(2.0), (double)0.0);
        next = Util.pwrLawNextDouble((int)2, (double)next, (boolean)false, (double)2.0);
        Assert.assertEquals((double)next, (double)2.0, (double)0.0);
    }

    @Test
    public void checkPwr2LawExamples() {
        int maxP = 32;
        boolean minP = true;
        int ppo = 4;
        int p = 1;
        while (p <= 32) {
            UtilTest.print(p + " ");
            p = Util.pwr2LawNext((int)4, (int)p);
        }
        UtilTest.println("");
        p = 32;
        while (p >= 1) {
            UtilTest.print(p + " ");
            p = Util.pwr2LawPrev((int)4, (int)p);
        }
        UtilTest.println("");
    }

    @Test
    public void checkSimpleLog2OfLong() {
        Assert.assertEquals((int)Util.simpleLog2OfLong((long)2L), (int)1);
        Assert.assertEquals((int)Util.simpleLog2OfLong((long)1L), (int)0);
        Assert.assertEquals((int)Util.simpleLog2OfLong((long)0x4000000000000000L), (int)62);
        try {
            Util.simpleLog2OfLong((long)0L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void resourcefileExists() {
        String shortFileName = "cpc-empty.sk";
        File file = Util.getResourceFile((String)"cpc-empty.sk");
        Assert.assertTrue((boolean)file.exists());
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void resourceFileNotFound() {
        String shortFileName = "cpc-empty.sk";
        Util.getResourceFile((String)"cpc-empty.sk123");
    }

    @Test
    public void resourceBytesCorrect() {
        String shortFileName = "cpc-empty.sk";
        byte[] bytes = Util.getResourceBytes((String)"cpc-empty.sk");
        Assert.assertTrue((bytes.length == 8 ? 1 : 0) != 0);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void resourceBytesFileNotFound() {
        String shortFileName = "cpc-empty.sk";
        Util.getResourceBytes((String)"cpc-empty.sk123");
    }

    @Test
    public void printlnTest() {
        UtilTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(Object o) {
        if (o == null) {
            UtilTest.print(LS);
        } else {
            UtilTest.print(o.toString() + LS);
        }
    }

    static void print(Object o) {
        if (o != null) {
            // empty if block
        }
    }
}

