/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches;

import org.apache.datasketches.HashOperations;
import org.apache.datasketches.SketchesArgumentException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.hash.MurmurHash3;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HashOperationsTest {
    @Test(expectedExceptions={SketchesStateException.class})
    public void testThetaCorruption1() {
        HashOperations.checkThetaCorruption((long)0L);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void testThetaCorruption2() {
        HashOperations.checkThetaCorruption((long)-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void testHashCorruption() {
        HashOperations.checkHashCorruption((long)-1L);
    }

    @Test(expectedExceptions={SketchesArgumentException.class})
    public void checkHashSearch() {
        HashOperations.hashSearch((long[])new long[4], (int)2, (long)0L);
    }

    @Test
    public void checkHashArrayInsert() {
        long[] hTable = new long[16];
        long[] hashIn = new long[1];
        for (int i = 0; i < 8; ++i) {
            hashIn[0] = i;
            long h = MurmurHash3.hash((long[])hashIn, (long)0L)[0] >>> 1;
            HashOperations.hashInsertOnly((long[])hTable, (int)4, (long)h);
            int count = HashOperations.hashArrayInsert((long[])hTable, (long[])hTable, (int)4, (long)Long.MAX_VALUE);
            Assert.assertEquals((int)count, (int)0);
        }
    }

    @Test
    public void testContinueCondtion() {
        long thetaLong = 0x3FFFFFFFFFFFFFFFL;
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0L));
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x3FFFFFFFFFFFFFFFL));
        Assert.assertTrue((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x4000000000000000L));
        Assert.assertFalse((boolean)HashOperations.continueCondition((long)0x3FFFFFFFFFFFFFFFL, (long)0x3FFFFFFFFFFFFFFEL));
    }

    @Test
    public void testHashInsertOnlyNoStride() {
        long[] table = new long[32];
        int index = HashOperations.hashInsertOnly((long[])table, (int)5, (long)1L);
        Assert.assertEquals((int)index, (int)1);
        Assert.assertEquals((long)table[1], (long)1L);
    }

    @Test
    public void testHashInsertOnlyWithStride() {
        long[] table = new long[32];
        table[1] = 1L;
        int index = HashOperations.hashInsertOnly((long[])table, (int)5, (long)1L);
        Assert.assertEquals((int)index, (int)2);
        Assert.assertEquals((long)table[2], (long)1L);
    }

    @Test
    public void testHashInsertOnlyMemoryNoStride() {
        long[] table = new long[32];
        WritableMemory mem = WritableMemory.writableWrap((long[])table);
        int index = HashOperations.hashInsertOnlyMemory((WritableMemory)mem, (int)5, (long)1L, (int)0);
        Assert.assertEquals((int)index, (int)1);
        Assert.assertEquals((long)table[1], (long)1L);
    }

    @Test
    public void testHashInsertOnlyMemoryWithStride() {
        long[] table = new long[32];
        table[1] = 1L;
        WritableMemory mem = WritableMemory.writableWrap((long[])table);
        int index = HashOperations.hashInsertOnlyMemory((WritableMemory)mem, (int)5, (long)1L, (int)0);
        Assert.assertEquals((int)index, (int)2);
        Assert.assertEquals((long)table[2], (long)1L);
    }

    @Test
    public void checkFullHeapTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnly((long[])table, (int)5, (long)i);
        }
        int retVal = HashOperations.hashSearch((long[])table, (int)5, (long)33L);
        Assert.assertEquals((int)retVal, (int)-1);
        try {
            HashOperations.hashInsertOnly((long[])table, (int)5, (long)33L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsert((long[])table, (int)5, (long)33L);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFullDirectTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        WritableMemory mem = WritableMemory.writableWrap((long[])table);
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnlyMemory((WritableMemory)mem, (int)5, (long)i, (int)0);
        }
        int retVal = HashOperations.hashSearchMemory((Memory)mem, (int)5, (long)33L, (int)0);
        Assert.assertEquals((int)retVal, (int)-1);
        try {
            HashOperations.hashInsertOnlyMemory((WritableMemory)mem, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsertMemory((WritableMemory)mem, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void checkFullFastDirectTableCatchesInfiniteLoop() {
        long[] table = new long[32];
        WritableMemory wmem = WritableMemory.writableWrap((long[])table);
        for (int i = 1; i <= 32; ++i) {
            HashOperations.hashInsertOnlyMemory((WritableMemory)wmem, (int)5, (long)i, (int)0);
        }
        try {
            HashOperations.hashInsertOnlyMemory((WritableMemory)wmem, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
        try {
            HashOperations.hashSearchOrInsertMemory((WritableMemory)wmem, (int)5, (long)33L, (int)0);
            Assert.fail();
        }
        catch (SketchesArgumentException sketchesArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void printlnTest() {
        HashOperationsTest.println("PRINTING: " + this.getClass().getName());
    }

    static void println(String s) {
    }
}

