// This file is @generated by prost-build.
/// logical plan
/// LogicalPlan is a nested type
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogicalPlanNode {
    #[prost(
        oneof = "logical_plan_node::LogicalPlanType",
        tags = "1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33"
    )]
    pub logical_plan_type: ::core::option::Option<logical_plan_node::LogicalPlanType>,
}
/// Nested message and enum types in `LogicalPlanNode`.
pub mod logical_plan_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum LogicalPlanType {
        #[prost(message, tag = "1")]
        ListingScan(super::ListingTableScanNode),
        #[prost(message, tag = "3")]
        Projection(::prost::alloc::boxed::Box<super::ProjectionNode>),
        #[prost(message, tag = "4")]
        Selection(::prost::alloc::boxed::Box<super::SelectionNode>),
        #[prost(message, tag = "5")]
        Limit(::prost::alloc::boxed::Box<super::LimitNode>),
        #[prost(message, tag = "6")]
        Aggregate(::prost::alloc::boxed::Box<super::AggregateNode>),
        #[prost(message, tag = "7")]
        Join(::prost::alloc::boxed::Box<super::JoinNode>),
        #[prost(message, tag = "8")]
        Sort(::prost::alloc::boxed::Box<super::SortNode>),
        #[prost(message, tag = "9")]
        Repartition(::prost::alloc::boxed::Box<super::RepartitionNode>),
        #[prost(message, tag = "10")]
        EmptyRelation(super::EmptyRelationNode),
        #[prost(message, tag = "11")]
        CreateExternalTable(super::CreateExternalTableNode),
        #[prost(message, tag = "12")]
        Explain(::prost::alloc::boxed::Box<super::ExplainNode>),
        #[prost(message, tag = "13")]
        Window(::prost::alloc::boxed::Box<super::WindowNode>),
        #[prost(message, tag = "14")]
        Analyze(::prost::alloc::boxed::Box<super::AnalyzeNode>),
        #[prost(message, tag = "15")]
        CrossJoin(::prost::alloc::boxed::Box<super::CrossJoinNode>),
        #[prost(message, tag = "16")]
        Values(super::ValuesNode),
        #[prost(message, tag = "17")]
        Extension(super::LogicalExtensionNode),
        #[prost(message, tag = "18")]
        CreateCatalogSchema(super::CreateCatalogSchemaNode),
        #[prost(message, tag = "19")]
        Union(super::UnionNode),
        #[prost(message, tag = "20")]
        CreateCatalog(super::CreateCatalogNode),
        #[prost(message, tag = "21")]
        SubqueryAlias(::prost::alloc::boxed::Box<super::SubqueryAliasNode>),
        #[prost(message, tag = "22")]
        CreateView(::prost::alloc::boxed::Box<super::CreateViewNode>),
        #[prost(message, tag = "23")]
        Distinct(::prost::alloc::boxed::Box<super::DistinctNode>),
        #[prost(message, tag = "24")]
        ViewScan(::prost::alloc::boxed::Box<super::ViewTableScanNode>),
        #[prost(message, tag = "25")]
        CustomScan(super::CustomTableScanNode),
        #[prost(message, tag = "26")]
        Prepare(::prost::alloc::boxed::Box<super::PrepareNode>),
        #[prost(message, tag = "27")]
        DropView(super::DropViewNode),
        #[prost(message, tag = "28")]
        DistinctOn(::prost::alloc::boxed::Box<super::DistinctOnNode>),
        #[prost(message, tag = "29")]
        CopyTo(::prost::alloc::boxed::Box<super::CopyToNode>),
        #[prost(message, tag = "30")]
        Unnest(::prost::alloc::boxed::Box<super::UnnestNode>),
        #[prost(message, tag = "31")]
        RecursiveQuery(::prost::alloc::boxed::Box<super::RecursiveQueryNode>),
        #[prost(message, tag = "32")]
        CteWorkTableScan(super::CteWorkTableScanNode),
        #[prost(message, tag = "33")]
        Dml(::prost::alloc::boxed::Box<super::DmlNode>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogicalExtensionNode {
    #[prost(bytes = "vec", tag = "1")]
    pub node: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, repeated, tag = "2")]
    pub inputs: ::prost::alloc::vec::Vec<LogicalPlanNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProjectionColumns {
    #[prost(string, repeated, tag = "1")]
    pub columns: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogicalExprNodeCollection {
    #[prost(message, repeated, tag = "1")]
    pub logical_expr_nodes: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortExprNodeCollection {
    #[prost(message, repeated, tag = "1")]
    pub sort_expr_nodes: ::prost::alloc::vec::Vec<SortExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListingTableScanNode {
    #[prost(message, optional, tag = "14")]
    pub table_name: ::core::option::Option<TableReference>,
    #[prost(string, repeated, tag = "2")]
    pub paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "3")]
    pub file_extension: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub projection: ::core::option::Option<ProjectionColumns>,
    #[prost(message, optional, tag = "5")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "6")]
    pub filters: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(string, repeated, tag = "7")]
    pub table_partition_cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "8")]
    pub collect_stat: bool,
    #[prost(uint32, tag = "9")]
    pub target_partitions: u32,
    #[prost(message, repeated, tag = "13")]
    pub file_sort_order: ::prost::alloc::vec::Vec<SortExprNodeCollection>,
    #[prost(oneof = "listing_table_scan_node::FileFormatType", tags = "10, 11, 12, 15")]
    pub file_format_type: ::core::option::Option<
        listing_table_scan_node::FileFormatType,
    >,
}
/// Nested message and enum types in `ListingTableScanNode`.
pub mod listing_table_scan_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FileFormatType {
        #[prost(message, tag = "10")]
        Csv(super::super::datafusion_common::CsvFormat),
        #[prost(message, tag = "11")]
        Parquet(super::super::datafusion_common::ParquetFormat),
        #[prost(message, tag = "12")]
        Avro(super::super::datafusion_common::AvroFormat),
        #[prost(message, tag = "15")]
        Json(super::super::datafusion_common::NdJsonFormat),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ViewTableScanNode {
    #[prost(message, optional, tag = "6")]
    pub table_name: ::core::option::Option<TableReference>,
    #[prost(message, optional, boxed, tag = "2")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, optional, tag = "4")]
    pub projection: ::core::option::Option<ProjectionColumns>,
    #[prost(string, tag = "5")]
    pub definition: ::prost::alloc::string::String,
}
/// Logical Plan to Scan a CustomTableProvider registered at runtime
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CustomTableScanNode {
    #[prost(message, optional, tag = "6")]
    pub table_name: ::core::option::Option<TableReference>,
    #[prost(message, optional, tag = "2")]
    pub projection: ::core::option::Option<ProjectionColumns>,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "4")]
    pub filters: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(bytes = "vec", tag = "5")]
    pub custom_table_data: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProjectionNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(oneof = "projection_node::OptionalAlias", tags = "3")]
    pub optional_alias: ::core::option::Option<projection_node::OptionalAlias>,
}
/// Nested message and enum types in `ProjectionNode`.
pub mod projection_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum OptionalAlias {
        #[prost(string, tag = "3")]
        Alias(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SelectionNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub expr: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<SortExprNode>,
    /// Maximum number of highest/lowest rows to fetch; negative means no limit
    #[prost(int64, tag = "3")]
    pub fetch: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RepartitionNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(oneof = "repartition_node::PartitionMethod", tags = "2, 3")]
    pub partition_method: ::core::option::Option<repartition_node::PartitionMethod>,
}
/// Nested message and enum types in `RepartitionNode`.
pub mod repartition_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum PartitionMethod {
        #[prost(uint64, tag = "2")]
        RoundRobin(u64),
        #[prost(message, tag = "3")]
        Hash(super::HashRepartition),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HashRepartition {
    #[prost(message, repeated, tag = "1")]
    pub hash_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(uint64, tag = "2")]
    pub partition_count: u64,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct EmptyRelationNode {
    #[prost(bool, tag = "1")]
    pub produce_one_row: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateExternalTableNode {
    #[prost(message, optional, tag = "9")]
    pub name: ::core::option::Option<TableReference>,
    #[prost(string, tag = "2")]
    pub location: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub file_type: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub schema: ::core::option::Option<super::datafusion_common::DfSchema>,
    #[prost(string, repeated, tag = "5")]
    pub table_partition_cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "6")]
    pub if_not_exists: bool,
    #[prost(bool, tag = "14")]
    pub temporary: bool,
    #[prost(string, tag = "7")]
    pub definition: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "10")]
    pub order_exprs: ::prost::alloc::vec::Vec<SortExprNodeCollection>,
    #[prost(bool, tag = "11")]
    pub unbounded: bool,
    #[prost(map = "string, string", tag = "8")]
    pub options: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(message, optional, tag = "12")]
    pub constraints: ::core::option::Option<super::datafusion_common::Constraints>,
    #[prost(map = "string, message", tag = "13")]
    pub column_defaults: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        LogicalExprNode,
    >,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PrepareNode {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub data_types: ::prost::alloc::vec::Vec<super::datafusion_common::ArrowType>,
    #[prost(message, optional, boxed, tag = "3")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateCatalogSchemaNode {
    #[prost(string, tag = "1")]
    pub schema_name: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub if_not_exists: bool,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::DfSchema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateCatalogNode {
    #[prost(string, tag = "1")]
    pub catalog_name: ::prost::alloc::string::String,
    #[prost(bool, tag = "2")]
    pub if_not_exists: bool,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::DfSchema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DropViewNode {
    #[prost(message, optional, tag = "1")]
    pub name: ::core::option::Option<TableReference>,
    #[prost(bool, tag = "2")]
    pub if_exists: bool,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::DfSchema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CreateViewNode {
    #[prost(message, optional, tag = "5")]
    pub name: ::core::option::Option<TableReference>,
    #[prost(message, optional, boxed, tag = "2")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(bool, tag = "3")]
    pub or_replace: bool,
    #[prost(bool, tag = "6")]
    pub temporary: bool,
    #[prost(string, tag = "4")]
    pub definition: ::prost::alloc::string::String,
}
/// a node containing data for defining values list. unlike in SQL where it's two dimensional, here
/// the list is flattened, and with the field n_cols it can be parsed and partitioned into rows
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ValuesNode {
    #[prost(uint64, tag = "1")]
    pub n_cols: u64,
    #[prost(message, repeated, tag = "2")]
    pub values_list: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnalyzeNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(bool, tag = "2")]
    pub verbose: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExplainNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(bool, tag = "2")]
    pub verbose: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregateNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub group_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "3")]
    pub aggr_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub window_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JoinNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(enumeration = "super::datafusion_common::JoinType", tag = "3")]
    pub join_type: i32,
    #[prost(enumeration = "super::datafusion_common::JoinConstraint", tag = "4")]
    pub join_constraint: i32,
    #[prost(message, repeated, tag = "5")]
    pub left_join_key: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "6")]
    pub right_join_key: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(bool, tag = "7")]
    pub null_equals_null: bool,
    #[prost(message, optional, tag = "8")]
    pub filter: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DistinctNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DistinctOnNode {
    #[prost(message, repeated, tag = "1")]
    pub on_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "2")]
    pub select_expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "3")]
    pub sort_expr: ::prost::alloc::vec::Vec<SortExprNode>,
    #[prost(message, optional, boxed, tag = "4")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CopyToNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(string, tag = "2")]
    pub output_url: ::prost::alloc::string::String,
    #[prost(bytes = "vec", tag = "3")]
    pub file_type: ::prost::alloc::vec::Vec<u8>,
    #[prost(string, repeated, tag = "7")]
    pub partition_by: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DmlNode {
    #[prost(enumeration = "dml_node::Type", tag = "1")]
    pub dml_type: i32,
    #[prost(message, optional, boxed, tag = "2")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, tag = "3")]
    pub table_name: ::core::option::Option<TableReference>,
    #[prost(message, optional, boxed, tag = "5")]
    pub target: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
}
/// Nested message and enum types in `DmlNode`.
pub mod dml_node {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Type {
        Update = 0,
        Delete = 1,
        Ctas = 2,
        InsertAppend = 3,
        InsertOverwrite = 4,
        InsertReplace = 5,
    }
    impl Type {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Update => "UPDATE",
                Self::Delete => "DELETE",
                Self::Ctas => "CTAS",
                Self::InsertAppend => "INSERT_APPEND",
                Self::InsertOverwrite => "INSERT_OVERWRITE",
                Self::InsertReplace => "INSERT_REPLACE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UPDATE" => Some(Self::Update),
                "DELETE" => Some(Self::Delete),
                "CTAS" => Some(Self::Ctas),
                "INSERT_APPEND" => Some(Self::InsertAppend),
                "INSERT_OVERWRITE" => Some(Self::InsertOverwrite),
                "INSERT_REPLACE" => Some(Self::InsertReplace),
                _ => None,
            }
        }
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnnestNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub exec_columns: ::prost::alloc::vec::Vec<super::datafusion_common::Column>,
    #[prost(message, repeated, tag = "3")]
    pub list_type_columns: ::prost::alloc::vec::Vec<ColumnUnnestListItem>,
    #[prost(uint64, repeated, tag = "4")]
    pub struct_type_columns: ::prost::alloc::vec::Vec<u64>,
    #[prost(uint64, repeated, tag = "5")]
    pub dependency_indices: ::prost::alloc::vec::Vec<u64>,
    #[prost(message, optional, tag = "6")]
    pub schema: ::core::option::Option<super::datafusion_common::DfSchema>,
    #[prost(message, optional, tag = "7")]
    pub options: ::core::option::Option<UnnestOptions>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ColumnUnnestListItem {
    #[prost(uint32, tag = "1")]
    pub input_index: u32,
    #[prost(message, optional, tag = "2")]
    pub recursion: ::core::option::Option<ColumnUnnestListRecursion>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ColumnUnnestListRecursions {
    #[prost(message, repeated, tag = "2")]
    pub recursions: ::prost::alloc::vec::Vec<ColumnUnnestListRecursion>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ColumnUnnestListRecursion {
    #[prost(message, optional, tag = "1")]
    pub output_column: ::core::option::Option<super::datafusion_common::Column>,
    #[prost(uint32, tag = "2")]
    pub depth: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnnestOptions {
    #[prost(bool, tag = "1")]
    pub preserve_nulls: bool,
    #[prost(message, repeated, tag = "2")]
    pub recursions: ::prost::alloc::vec::Vec<RecursionUnnestOption>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RecursionUnnestOption {
    #[prost(message, optional, tag = "1")]
    pub output_column: ::core::option::Option<super::datafusion_common::Column>,
    #[prost(message, optional, tag = "2")]
    pub input_column: ::core::option::Option<super::datafusion_common::Column>,
    #[prost(uint32, tag = "3")]
    pub depth: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnionNode {
    #[prost(message, repeated, tag = "1")]
    pub inputs: ::prost::alloc::vec::Vec<LogicalPlanNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CrossJoinNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LimitNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    /// The number of rows to skip before fetch; non-positive means don't skip any
    #[prost(int64, tag = "2")]
    pub skip: i64,
    /// Maximum number of rows to fetch; negative means no limit
    #[prost(int64, tag = "3")]
    pub fetch: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SelectionExecNode {
    #[prost(message, optional, tag = "1")]
    pub expr: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SubqueryAliasNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, tag = "3")]
    pub alias: ::core::option::Option<TableReference>,
}
/// logical expressions
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogicalExprNode {
    #[prost(
        oneof = "logical_expr_node::ExprType",
        tags = "1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 13, 14, 15, 17, 18, 19, 20, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35"
    )]
    pub expr_type: ::core::option::Option<logical_expr_node::ExprType>,
}
/// Nested message and enum types in `LogicalExprNode`.
pub mod logical_expr_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ExprType {
        /// column references
        #[prost(message, tag = "1")]
        Column(super::super::datafusion_common::Column),
        /// alias
        #[prost(message, tag = "2")]
        Alias(::prost::alloc::boxed::Box<super::AliasNode>),
        #[prost(message, tag = "3")]
        Literal(super::super::datafusion_common::ScalarValue),
        /// binary expressions
        #[prost(message, tag = "4")]
        BinaryExpr(super::BinaryExprNode),
        /// null checks
        #[prost(message, tag = "6")]
        IsNullExpr(::prost::alloc::boxed::Box<super::IsNull>),
        #[prost(message, tag = "7")]
        IsNotNullExpr(::prost::alloc::boxed::Box<super::IsNotNull>),
        #[prost(message, tag = "8")]
        NotExpr(::prost::alloc::boxed::Box<super::Not>),
        #[prost(message, tag = "9")]
        Between(::prost::alloc::boxed::Box<super::BetweenNode>),
        #[prost(message, tag = "10")]
        Case(::prost::alloc::boxed::Box<super::CaseNode>),
        #[prost(message, tag = "11")]
        Cast(::prost::alloc::boxed::Box<super::CastNode>),
        #[prost(message, tag = "13")]
        Negative(::prost::alloc::boxed::Box<super::NegativeNode>),
        #[prost(message, tag = "14")]
        InList(::prost::alloc::boxed::Box<super::InListNode>),
        #[prost(message, tag = "15")]
        Wildcard(super::Wildcard),
        /// was  ScalarFunctionNode scalar_function = 16;
        #[prost(message, tag = "17")]
        TryCast(::prost::alloc::boxed::Box<super::TryCastNode>),
        /// window expressions
        #[prost(message, tag = "18")]
        WindowExpr(super::WindowExprNode),
        /// AggregateUDF expressions
        #[prost(message, tag = "19")]
        AggregateUdfExpr(::prost::alloc::boxed::Box<super::AggregateUdfExprNode>),
        /// Scalar UDF expressions
        #[prost(message, tag = "20")]
        ScalarUdfExpr(super::ScalarUdfExprNode),
        #[prost(message, tag = "22")]
        GroupingSet(super::GroupingSetNode),
        #[prost(message, tag = "23")]
        Cube(super::CubeNode),
        #[prost(message, tag = "24")]
        Rollup(super::RollupNode),
        #[prost(message, tag = "25")]
        IsTrue(::prost::alloc::boxed::Box<super::IsTrue>),
        #[prost(message, tag = "26")]
        IsFalse(::prost::alloc::boxed::Box<super::IsFalse>),
        #[prost(message, tag = "27")]
        IsUnknown(::prost::alloc::boxed::Box<super::IsUnknown>),
        #[prost(message, tag = "28")]
        IsNotTrue(::prost::alloc::boxed::Box<super::IsNotTrue>),
        #[prost(message, tag = "29")]
        IsNotFalse(::prost::alloc::boxed::Box<super::IsNotFalse>),
        #[prost(message, tag = "30")]
        IsNotUnknown(::prost::alloc::boxed::Box<super::IsNotUnknown>),
        #[prost(message, tag = "31")]
        Like(::prost::alloc::boxed::Box<super::LikeNode>),
        #[prost(message, tag = "32")]
        Ilike(::prost::alloc::boxed::Box<super::ILikeNode>),
        #[prost(message, tag = "33")]
        SimilarTo(::prost::alloc::boxed::Box<super::SimilarToNode>),
        #[prost(message, tag = "34")]
        Placeholder(super::PlaceholderNode),
        #[prost(message, tag = "35")]
        Unnest(super::Unnest),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Wildcard {
    #[prost(message, optional, tag = "1")]
    pub qualifier: ::core::option::Option<TableReference>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PlaceholderNode {
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub data_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LogicalExprList {
    #[prost(message, repeated, tag = "1")]
    pub expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GroupingSetNode {
    #[prost(message, repeated, tag = "1")]
    pub expr: ::prost::alloc::vec::Vec<LogicalExprList>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CubeNode {
    #[prost(message, repeated, tag = "1")]
    pub expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RollupNode {
    #[prost(message, repeated, tag = "1")]
    pub expr: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NamedStructField {
    #[prost(message, optional, tag = "1")]
    pub name: ::core::option::Option<super::datafusion_common::ScalarValue>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListIndex {
    #[prost(message, optional, tag = "1")]
    pub key: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListRange {
    #[prost(message, optional, tag = "1")]
    pub start: ::core::option::Option<LogicalExprNode>,
    #[prost(message, optional, tag = "2")]
    pub stop: ::core::option::Option<LogicalExprNode>,
    #[prost(message, optional, tag = "3")]
    pub stride: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNotNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsTrue {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsFalse {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsUnknown {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNotTrue {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNotFalse {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IsNotUnknown {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Not {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AliasNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(string, tag = "2")]
    pub alias: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "3")]
    pub relation: ::prost::alloc::vec::Vec<TableReference>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BinaryExprNode {
    /// Represents the operands from the left inner most expression
    /// to the right outer most expression where each of them are chained
    /// with the operator 'op'.
    #[prost(message, repeated, tag = "1")]
    pub operands: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(string, tag = "3")]
    pub op: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NegativeNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Unnest {
    #[prost(message, repeated, tag = "1")]
    pub exprs: ::prost::alloc::vec::Vec<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InListNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, repeated, tag = "2")]
    pub list: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(bool, tag = "3")]
    pub negated: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregateUdfExprNode {
    #[prost(string, tag = "1")]
    pub fun_name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub args: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(bool, tag = "5")]
    pub distinct: bool,
    #[prost(message, optional, boxed, tag = "3")]
    pub filter: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, repeated, tag = "4")]
    pub order_by: ::prost::alloc::vec::Vec<SortExprNode>,
    #[prost(bytes = "vec", optional, tag = "6")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ScalarUdfExprNode {
    #[prost(string, tag = "1")]
    pub fun_name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub args: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(bytes = "vec", optional, tag = "3")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowExprNode {
    #[prost(message, repeated, tag = "4")]
    pub exprs: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "5")]
    pub partition_by: ::prost::alloc::vec::Vec<LogicalExprNode>,
    #[prost(message, repeated, tag = "6")]
    pub order_by: ::prost::alloc::vec::Vec<SortExprNode>,
    /// repeated LogicalExprNode filter = 7;
    #[prost(message, optional, tag = "8")]
    pub window_frame: ::core::option::Option<WindowFrame>,
    #[prost(bytes = "vec", optional, tag = "10")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(oneof = "window_expr_node::WindowFunction", tags = "3, 9")]
    pub window_function: ::core::option::Option<window_expr_node::WindowFunction>,
}
/// Nested message and enum types in `WindowExprNode`.
pub mod window_expr_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum WindowFunction {
        /// BuiltInWindowFunction built_in_function = 2;
        #[prost(string, tag = "3")]
        Udaf(::prost::alloc::string::String),
        #[prost(string, tag = "9")]
        Udwf(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BetweenNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(bool, tag = "2")]
    pub negated: bool,
    #[prost(message, optional, boxed, tag = "3")]
    pub low: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, boxed, tag = "4")]
    pub high: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LikeNode {
    #[prost(bool, tag = "1")]
    pub negated: bool,
    #[prost(message, optional, boxed, tag = "2")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub pattern: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(string, tag = "4")]
    pub escape_char: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ILikeNode {
    #[prost(bool, tag = "1")]
    pub negated: bool,
    #[prost(message, optional, boxed, tag = "2")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub pattern: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(string, tag = "4")]
    pub escape_char: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SimilarToNode {
    #[prost(bool, tag = "1")]
    pub negated: bool,
    #[prost(message, optional, boxed, tag = "2")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub pattern: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(string, tag = "4")]
    pub escape_char: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CaseNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, repeated, tag = "2")]
    pub when_then_expr: ::prost::alloc::vec::Vec<WhenThen>,
    #[prost(message, optional, boxed, tag = "3")]
    pub else_expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WhenThen {
    #[prost(message, optional, tag = "1")]
    pub when_expr: ::core::option::Option<LogicalExprNode>,
    #[prost(message, optional, tag = "2")]
    pub then_expr: ::core::option::Option<LogicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CastNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, tag = "2")]
    pub arrow_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TryCastNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<LogicalExprNode>>,
    #[prost(message, optional, tag = "2")]
    pub arrow_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortExprNode {
    #[prost(message, optional, tag = "1")]
    pub expr: ::core::option::Option<LogicalExprNode>,
    #[prost(bool, tag = "2")]
    pub asc: bool,
    #[prost(bool, tag = "3")]
    pub nulls_first: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowFrame {
    #[prost(enumeration = "WindowFrameUnits", tag = "1")]
    pub window_frame_units: i32,
    #[prost(message, optional, tag = "2")]
    pub start_bound: ::core::option::Option<WindowFrameBound>,
    /// "optional" keyword is stable in protoc 3.15 but prost is still on 3.14 (see <https://github.com/tokio-rs/prost/issues/430> and <https://github.com/tokio-rs/prost/pull/455>)
    /// this syntax is ugly but is binary compatible with the "optional" keyword (see <https://stackoverflow.com/questions/42622015/how-to-define-an-optional-field-in-protobuf-3>)
    #[prost(oneof = "window_frame::EndBound", tags = "3")]
    pub end_bound: ::core::option::Option<window_frame::EndBound>,
}
/// Nested message and enum types in `WindowFrame`.
pub mod window_frame {
    /// "optional" keyword is stable in protoc 3.15 but prost is still on 3.14 (see <https://github.com/tokio-rs/prost/issues/430> and <https://github.com/tokio-rs/prost/pull/455>)
    /// this syntax is ugly but is binary compatible with the "optional" keyword (see <https://stackoverflow.com/questions/42622015/how-to-define-an-optional-field-in-protobuf-3>)
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum EndBound {
        #[prost(message, tag = "3")]
        Bound(super::WindowFrameBound),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowFrameBound {
    #[prost(enumeration = "WindowFrameBoundType", tag = "1")]
    pub window_frame_bound_type: i32,
    #[prost(message, optional, tag = "2")]
    pub bound_value: ::core::option::Option<super::datafusion_common::ScalarValue>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FixedSizeBinary {
    #[prost(int32, tag = "1")]
    pub length: i32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnalyzedLogicalPlanType {
    #[prost(string, tag = "1")]
    pub analyzer_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OptimizedLogicalPlanType {
    #[prost(string, tag = "1")]
    pub optimizer_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OptimizedPhysicalPlanType {
    #[prost(string, tag = "1")]
    pub optimizer_name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PlanType {
    #[prost(
        oneof = "plan_type::PlanTypeEnum",
        tags = "1, 7, 8, 2, 3, 4, 9, 11, 5, 6, 10, 12, 13"
    )]
    pub plan_type_enum: ::core::option::Option<plan_type::PlanTypeEnum>,
}
/// Nested message and enum types in `PlanType`.
pub mod plan_type {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum PlanTypeEnum {
        #[prost(message, tag = "1")]
        InitialLogicalPlan(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "7")]
        AnalyzedLogicalPlan(super::AnalyzedLogicalPlanType),
        #[prost(message, tag = "8")]
        FinalAnalyzedLogicalPlan(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "2")]
        OptimizedLogicalPlan(super::OptimizedLogicalPlanType),
        #[prost(message, tag = "3")]
        FinalLogicalPlan(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "4")]
        InitialPhysicalPlan(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "9")]
        InitialPhysicalPlanWithStats(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "11")]
        InitialPhysicalPlanWithSchema(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "5")]
        OptimizedPhysicalPlan(super::OptimizedPhysicalPlanType),
        #[prost(message, tag = "6")]
        FinalPhysicalPlan(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "10")]
        FinalPhysicalPlanWithStats(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "12")]
        FinalPhysicalPlanWithSchema(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "13")]
        PhysicalPlanError(super::super::datafusion_common::EmptyMessage),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StringifiedPlan {
    #[prost(message, optional, tag = "1")]
    pub plan_type: ::core::option::Option<PlanType>,
    #[prost(string, tag = "2")]
    pub plan: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BareTableReference {
    #[prost(string, tag = "1")]
    pub table: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartialTableReference {
    #[prost(string, tag = "1")]
    pub schema: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub table: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FullTableReference {
    #[prost(string, tag = "1")]
    pub catalog: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub schema: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub table: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TableReference {
    #[prost(oneof = "table_reference::TableReferenceEnum", tags = "1, 2, 3")]
    pub table_reference_enum: ::core::option::Option<
        table_reference::TableReferenceEnum,
    >,
}
/// Nested message and enum types in `TableReference`.
pub mod table_reference {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum TableReferenceEnum {
        #[prost(message, tag = "1")]
        Bare(super::BareTableReference),
        #[prost(message, tag = "2")]
        Partial(super::PartialTableReference),
        #[prost(message, tag = "3")]
        Full(super::FullTableReference),
    }
}
/// PhysicalPlanNode is a nested type
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalPlanNode {
    #[prost(
        oneof = "physical_plan_node::PhysicalPlanType",
        tags = "1, 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30"
    )]
    pub physical_plan_type: ::core::option::Option<physical_plan_node::PhysicalPlanType>,
}
/// Nested message and enum types in `PhysicalPlanNode`.
pub mod physical_plan_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum PhysicalPlanType {
        #[prost(message, tag = "1")]
        ParquetScan(super::ParquetScanExecNode),
        #[prost(message, tag = "2")]
        CsvScan(super::CsvScanExecNode),
        #[prost(message, tag = "3")]
        Empty(super::EmptyExecNode),
        #[prost(message, tag = "4")]
        Projection(::prost::alloc::boxed::Box<super::ProjectionExecNode>),
        #[prost(message, tag = "6")]
        GlobalLimit(::prost::alloc::boxed::Box<super::GlobalLimitExecNode>),
        #[prost(message, tag = "7")]
        LocalLimit(::prost::alloc::boxed::Box<super::LocalLimitExecNode>),
        #[prost(message, tag = "8")]
        Aggregate(::prost::alloc::boxed::Box<super::AggregateExecNode>),
        #[prost(message, tag = "9")]
        HashJoin(::prost::alloc::boxed::Box<super::HashJoinExecNode>),
        #[prost(message, tag = "10")]
        Sort(::prost::alloc::boxed::Box<super::SortExecNode>),
        #[prost(message, tag = "11")]
        CoalesceBatches(::prost::alloc::boxed::Box<super::CoalesceBatchesExecNode>),
        #[prost(message, tag = "12")]
        Filter(::prost::alloc::boxed::Box<super::FilterExecNode>),
        #[prost(message, tag = "13")]
        Merge(::prost::alloc::boxed::Box<super::CoalescePartitionsExecNode>),
        #[prost(message, tag = "14")]
        Repartition(::prost::alloc::boxed::Box<super::RepartitionExecNode>),
        #[prost(message, tag = "15")]
        Window(::prost::alloc::boxed::Box<super::WindowAggExecNode>),
        #[prost(message, tag = "16")]
        CrossJoin(::prost::alloc::boxed::Box<super::CrossJoinExecNode>),
        #[prost(message, tag = "17")]
        AvroScan(super::AvroScanExecNode),
        #[prost(message, tag = "18")]
        Extension(super::PhysicalExtensionNode),
        #[prost(message, tag = "19")]
        Union(super::UnionExecNode),
        #[prost(message, tag = "20")]
        Explain(super::ExplainExecNode),
        #[prost(message, tag = "21")]
        SortPreservingMerge(
            ::prost::alloc::boxed::Box<super::SortPreservingMergeExecNode>,
        ),
        #[prost(message, tag = "22")]
        NestedLoopJoin(::prost::alloc::boxed::Box<super::NestedLoopJoinExecNode>),
        #[prost(message, tag = "23")]
        Analyze(::prost::alloc::boxed::Box<super::AnalyzeExecNode>),
        #[prost(message, tag = "24")]
        JsonSink(::prost::alloc::boxed::Box<super::JsonSinkExecNode>),
        #[prost(message, tag = "25")]
        SymmetricHashJoin(::prost::alloc::boxed::Box<super::SymmetricHashJoinExecNode>),
        #[prost(message, tag = "26")]
        Interleave(super::InterleaveExecNode),
        #[prost(message, tag = "27")]
        PlaceholderRow(super::PlaceholderRowExecNode),
        #[prost(message, tag = "28")]
        CsvSink(::prost::alloc::boxed::Box<super::CsvSinkExecNode>),
        #[prost(message, tag = "29")]
        ParquetSink(::prost::alloc::boxed::Box<super::ParquetSinkExecNode>),
        #[prost(message, tag = "30")]
        Unnest(::prost::alloc::boxed::Box<super::UnnestExecNode>),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartitionColumn {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub arrow_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileSinkConfig {
    #[prost(string, tag = "1")]
    pub object_store_url: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub file_groups: ::prost::alloc::vec::Vec<PartitionedFile>,
    #[prost(string, repeated, tag = "3")]
    pub table_paths: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "4")]
    pub output_schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "5")]
    pub table_partition_cols: ::prost::alloc::vec::Vec<PartitionColumn>,
    #[prost(bool, tag = "9")]
    pub keep_partition_by_columns: bool,
    #[prost(enumeration = "InsertOp", tag = "10")]
    pub insert_op: i32,
    #[prost(string, tag = "11")]
    pub file_extension: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JsonSink {
    #[prost(message, optional, tag = "1")]
    pub config: ::core::option::Option<FileSinkConfig>,
    #[prost(message, optional, tag = "2")]
    pub writer_options: ::core::option::Option<
        super::datafusion_common::JsonWriterOptions,
    >,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JsonSinkExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub sink: ::core::option::Option<JsonSink>,
    #[prost(message, optional, tag = "3")]
    pub sink_schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, optional, tag = "4")]
    pub sort_order: ::core::option::Option<PhysicalSortExprNodeCollection>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CsvSink {
    #[prost(message, optional, tag = "1")]
    pub config: ::core::option::Option<FileSinkConfig>,
    #[prost(message, optional, tag = "2")]
    pub writer_options: ::core::option::Option<
        super::datafusion_common::CsvWriterOptions,
    >,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CsvSinkExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub sink: ::core::option::Option<CsvSink>,
    #[prost(message, optional, tag = "3")]
    pub sink_schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, optional, tag = "4")]
    pub sort_order: ::core::option::Option<PhysicalSortExprNodeCollection>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParquetSink {
    #[prost(message, optional, tag = "1")]
    pub config: ::core::option::Option<FileSinkConfig>,
    #[prost(message, optional, tag = "2")]
    pub parquet_options: ::core::option::Option<
        super::datafusion_common::TableParquetOptions,
    >,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParquetSinkExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub sink: ::core::option::Option<ParquetSink>,
    #[prost(message, optional, tag = "3")]
    pub sink_schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, optional, tag = "4")]
    pub sort_order: ::core::option::Option<PhysicalSortExprNodeCollection>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnnestExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "3")]
    pub list_type_columns: ::prost::alloc::vec::Vec<ListUnnest>,
    #[prost(uint64, repeated, tag = "4")]
    pub struct_type_columns: ::prost::alloc::vec::Vec<u64>,
    #[prost(message, optional, tag = "5")]
    pub options: ::core::option::Option<UnnestOptions>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ListUnnest {
    #[prost(uint32, tag = "1")]
    pub index_in_input_schema: u32,
    #[prost(uint32, tag = "2")]
    pub depth: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalExtensionNode {
    #[prost(bytes = "vec", tag = "1")]
    pub node: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, repeated, tag = "2")]
    pub inputs: ::prost::alloc::vec::Vec<PhysicalPlanNode>,
}
/// physical expressions
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalExprNode {
    #[prost(
        oneof = "physical_expr_node::ExprType",
        tags = "1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14, 15, 16, 18, 19, 20"
    )]
    pub expr_type: ::core::option::Option<physical_expr_node::ExprType>,
}
/// Nested message and enum types in `PhysicalExprNode`.
pub mod physical_expr_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum ExprType {
        /// column references
        #[prost(message, tag = "1")]
        Column(super::PhysicalColumn),
        #[prost(message, tag = "2")]
        Literal(super::super::datafusion_common::ScalarValue),
        /// binary expressions
        #[prost(message, tag = "3")]
        BinaryExpr(::prost::alloc::boxed::Box<super::PhysicalBinaryExprNode>),
        /// aggregate expressions
        #[prost(message, tag = "4")]
        AggregateExpr(super::PhysicalAggregateExprNode),
        /// null checks
        #[prost(message, tag = "5")]
        IsNullExpr(::prost::alloc::boxed::Box<super::PhysicalIsNull>),
        #[prost(message, tag = "6")]
        IsNotNullExpr(::prost::alloc::boxed::Box<super::PhysicalIsNotNull>),
        #[prost(message, tag = "7")]
        NotExpr(::prost::alloc::boxed::Box<super::PhysicalNot>),
        #[prost(message, tag = "8")]
        Case(::prost::alloc::boxed::Box<super::PhysicalCaseNode>),
        #[prost(message, tag = "9")]
        Cast(::prost::alloc::boxed::Box<super::PhysicalCastNode>),
        #[prost(message, tag = "10")]
        Sort(::prost::alloc::boxed::Box<super::PhysicalSortExprNode>),
        #[prost(message, tag = "11")]
        Negative(::prost::alloc::boxed::Box<super::PhysicalNegativeNode>),
        #[prost(message, tag = "12")]
        InList(::prost::alloc::boxed::Box<super::PhysicalInListNode>),
        ///   was PhysicalScalarFunctionNode scalar_function = 13;
        #[prost(message, tag = "14")]
        TryCast(::prost::alloc::boxed::Box<super::PhysicalTryCastNode>),
        /// window expressions
        #[prost(message, tag = "15")]
        WindowExpr(super::PhysicalWindowExprNode),
        /// was PhysicalDateTimeIntervalExprNode date_time_interval_expr = 17;
        #[prost(message, tag = "16")]
        ScalarUdf(super::PhysicalScalarUdfNode),
        #[prost(message, tag = "18")]
        LikeExpr(::prost::alloc::boxed::Box<super::PhysicalLikeExprNode>),
        #[prost(message, tag = "19")]
        Extension(super::PhysicalExtensionExprNode),
        #[prost(message, tag = "20")]
        UnknownColumn(super::UnknownColumn),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalScalarUdfNode {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub args: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(bytes = "vec", optional, tag = "3")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(message, optional, tag = "4")]
    pub return_type: ::core::option::Option<super::datafusion_common::ArrowType>,
    #[prost(bool, tag = "5")]
    pub nullable: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalAggregateExprNode {
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(message, repeated, tag = "5")]
    pub ordering_req: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
    #[prost(bool, tag = "3")]
    pub distinct: bool,
    #[prost(bool, tag = "6")]
    pub ignore_nulls: bool,
    #[prost(bytes = "vec", optional, tag = "7")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(oneof = "physical_aggregate_expr_node::AggregateFunction", tags = "4")]
    pub aggregate_function: ::core::option::Option<
        physical_aggregate_expr_node::AggregateFunction,
    >,
}
/// Nested message and enum types in `PhysicalAggregateExprNode`.
pub mod physical_aggregate_expr_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum AggregateFunction {
        #[prost(string, tag = "4")]
        UserDefinedAggrFunction(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalWindowExprNode {
    #[prost(message, repeated, tag = "4")]
    pub args: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(message, repeated, tag = "5")]
    pub partition_by: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(message, repeated, tag = "6")]
    pub order_by: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
    #[prost(message, optional, tag = "7")]
    pub window_frame: ::core::option::Option<WindowFrame>,
    #[prost(string, tag = "8")]
    pub name: ::prost::alloc::string::String,
    #[prost(bytes = "vec", optional, tag = "9")]
    pub fun_definition: ::core::option::Option<::prost::alloc::vec::Vec<u8>>,
    #[prost(oneof = "physical_window_expr_node::WindowFunction", tags = "3, 10")]
    pub window_function: ::core::option::Option<
        physical_window_expr_node::WindowFunction,
    >,
}
/// Nested message and enum types in `PhysicalWindowExprNode`.
pub mod physical_window_expr_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum WindowFunction {
        /// BuiltInWindowFunction built_in_function = 2;
        #[prost(string, tag = "3")]
        UserDefinedAggrFunction(::prost::alloc::string::String),
        #[prost(string, tag = "10")]
        UserDefinedWindowFunction(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalIsNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalIsNotNull {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalNot {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalAliasNode {
    #[prost(message, optional, tag = "1")]
    pub expr: ::core::option::Option<PhysicalExprNode>,
    #[prost(string, tag = "2")]
    pub alias: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalBinaryExprNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub l: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub r: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(string, tag = "3")]
    pub op: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalDateTimeIntervalExprNode {
    #[prost(message, optional, tag = "1")]
    pub l: ::core::option::Option<PhysicalExprNode>,
    #[prost(message, optional, tag = "2")]
    pub r: ::core::option::Option<PhysicalExprNode>,
    #[prost(string, tag = "3")]
    pub op: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalLikeExprNode {
    #[prost(bool, tag = "1")]
    pub negated: bool,
    #[prost(bool, tag = "2")]
    pub case_insensitive: bool,
    #[prost(message, optional, boxed, tag = "3")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, optional, boxed, tag = "4")]
    pub pattern: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalSortExprNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(bool, tag = "2")]
    pub asc: bool,
    #[prost(bool, tag = "3")]
    pub nulls_first: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalWhenThen {
    #[prost(message, optional, tag = "1")]
    pub when_expr: ::core::option::Option<PhysicalExprNode>,
    #[prost(message, optional, tag = "2")]
    pub then_expr: ::core::option::Option<PhysicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalInListNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, repeated, tag = "2")]
    pub list: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(bool, tag = "3")]
    pub negated: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalCaseNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, repeated, tag = "2")]
    pub when_then_expr: ::prost::alloc::vec::Vec<PhysicalWhenThen>,
    #[prost(message, optional, boxed, tag = "3")]
    pub else_expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalTryCastNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, optional, tag = "2")]
    pub arrow_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalCastNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
    #[prost(message, optional, tag = "2")]
    pub arrow_type: ::core::option::Option<super::datafusion_common::ArrowType>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalNegativeNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub expr: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalExprNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalExtensionExprNode {
    #[prost(bytes = "vec", tag = "1")]
    pub expr: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, repeated, tag = "2")]
    pub inputs: ::prost::alloc::vec::Vec<PhysicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FilterExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "2")]
    pub expr: ::core::option::Option<PhysicalExprNode>,
    #[prost(uint32, tag = "3")]
    pub default_filter_selectivity: u32,
    #[prost(uint32, repeated, tag = "9")]
    pub projection: ::prost::alloc::vec::Vec<u32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileGroup {
    #[prost(message, repeated, tag = "1")]
    pub files: ::prost::alloc::vec::Vec<PartitionedFile>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ScanLimit {
    /// wrap into a message to make it optional
    #[prost(uint32, tag = "1")]
    pub limit: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalSortExprNodeCollection {
    #[prost(message, repeated, tag = "1")]
    pub physical_sort_expr_nodes: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileScanExecConf {
    #[prost(message, repeated, tag = "1")]
    pub file_groups: ::prost::alloc::vec::Vec<FileGroup>,
    #[prost(message, optional, tag = "2")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(uint32, repeated, tag = "4")]
    pub projection: ::prost::alloc::vec::Vec<u32>,
    #[prost(message, optional, tag = "5")]
    pub limit: ::core::option::Option<ScanLimit>,
    #[prost(message, optional, tag = "6")]
    pub statistics: ::core::option::Option<super::datafusion_common::Statistics>,
    #[prost(string, repeated, tag = "7")]
    pub table_partition_cols: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "8")]
    pub object_store_url: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "9")]
    pub output_ordering: ::prost::alloc::vec::Vec<PhysicalSortExprNodeCollection>,
    #[prost(message, optional, tag = "11")]
    pub constraints: ::core::option::Option<super::datafusion_common::Constraints>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParquetScanExecNode {
    #[prost(message, optional, tag = "1")]
    pub base_conf: ::core::option::Option<FileScanExecConf>,
    #[prost(message, optional, tag = "3")]
    pub predicate: ::core::option::Option<PhysicalExprNode>,
    #[prost(message, optional, tag = "4")]
    pub parquet_options: ::core::option::Option<
        super::datafusion_common::TableParquetOptions,
    >,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CsvScanExecNode {
    #[prost(message, optional, tag = "1")]
    pub base_conf: ::core::option::Option<FileScanExecConf>,
    #[prost(bool, tag = "2")]
    pub has_header: bool,
    #[prost(string, tag = "3")]
    pub delimiter: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub quote: ::prost::alloc::string::String,
    #[prost(bool, tag = "7")]
    pub newlines_in_values: bool,
    #[prost(oneof = "csv_scan_exec_node::OptionalEscape", tags = "5")]
    pub optional_escape: ::core::option::Option<csv_scan_exec_node::OptionalEscape>,
    #[prost(oneof = "csv_scan_exec_node::OptionalComment", tags = "6")]
    pub optional_comment: ::core::option::Option<csv_scan_exec_node::OptionalComment>,
}
/// Nested message and enum types in `CsvScanExecNode`.
pub mod csv_scan_exec_node {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum OptionalEscape {
        #[prost(string, tag = "5")]
        Escape(::prost::alloc::string::String),
    }
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum OptionalComment {
        #[prost(string, tag = "6")]
        Comment(::prost::alloc::string::String),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AvroScanExecNode {
    #[prost(message, optional, tag = "1")]
    pub base_conf: ::core::option::Option<FileScanExecConf>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct HashJoinExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "3")]
    pub on: ::prost::alloc::vec::Vec<JoinOn>,
    #[prost(enumeration = "super::datafusion_common::JoinType", tag = "4")]
    pub join_type: i32,
    #[prost(enumeration = "PartitionMode", tag = "6")]
    pub partition_mode: i32,
    #[prost(bool, tag = "7")]
    pub null_equals_null: bool,
    #[prost(message, optional, tag = "8")]
    pub filter: ::core::option::Option<JoinFilter>,
    #[prost(uint32, repeated, tag = "9")]
    pub projection: ::prost::alloc::vec::Vec<u32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SymmetricHashJoinExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "3")]
    pub on: ::prost::alloc::vec::Vec<JoinOn>,
    #[prost(enumeration = "super::datafusion_common::JoinType", tag = "4")]
    pub join_type: i32,
    #[prost(enumeration = "StreamPartitionMode", tag = "6")]
    pub partition_mode: i32,
    #[prost(bool, tag = "7")]
    pub null_equals_null: bool,
    #[prost(message, optional, tag = "8")]
    pub filter: ::core::option::Option<JoinFilter>,
    #[prost(message, repeated, tag = "9")]
    pub left_sort_exprs: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
    #[prost(message, repeated, tag = "10")]
    pub right_sort_exprs: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct InterleaveExecNode {
    #[prost(message, repeated, tag = "1")]
    pub inputs: ::prost::alloc::vec::Vec<PhysicalPlanNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnionExecNode {
    #[prost(message, repeated, tag = "1")]
    pub inputs: ::prost::alloc::vec::Vec<PhysicalPlanNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExplainExecNode {
    #[prost(message, optional, tag = "1")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "2")]
    pub stringified_plans: ::prost::alloc::vec::Vec<StringifiedPlan>,
    #[prost(bool, tag = "3")]
    pub verbose: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AnalyzeExecNode {
    #[prost(bool, tag = "1")]
    pub verbose: bool,
    #[prost(bool, tag = "2")]
    pub show_statistics: bool,
    #[prost(message, optional, boxed, tag = "3")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, tag = "4")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CrossJoinExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalColumn {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint32, tag = "2")]
    pub index: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UnknownColumn {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JoinOn {
    #[prost(message, optional, tag = "1")]
    pub left: ::core::option::Option<PhysicalExprNode>,
    #[prost(message, optional, tag = "2")]
    pub right: ::core::option::Option<PhysicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EmptyExecNode {
    #[prost(message, optional, tag = "1")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PlaceholderRowExecNode {
    #[prost(message, optional, tag = "1")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ProjectionExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(string, repeated, tag = "3")]
    pub expr_name: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartiallySortedInputOrderMode {
    #[prost(uint64, repeated, tag = "6")]
    pub columns: ::prost::alloc::vec::Vec<u64>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WindowAggExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub window_expr: ::prost::alloc::vec::Vec<PhysicalWindowExprNode>,
    #[prost(message, repeated, tag = "5")]
    pub partition_keys: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    /// Set optional to `None` for `BoundedWindowAggExec`.
    #[prost(oneof = "window_agg_exec_node::InputOrderMode", tags = "7, 8, 9")]
    pub input_order_mode: ::core::option::Option<window_agg_exec_node::InputOrderMode>,
}
/// Nested message and enum types in `WindowAggExecNode`.
pub mod window_agg_exec_node {
    /// Set optional to `None` for `BoundedWindowAggExec`.
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum InputOrderMode {
        #[prost(message, tag = "7")]
        Linear(super::super::datafusion_common::EmptyMessage),
        #[prost(message, tag = "8")]
        PartiallySorted(super::PartiallySortedInputOrderMode),
        #[prost(message, tag = "9")]
        Sorted(super::super::datafusion_common::EmptyMessage),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MaybeFilter {
    #[prost(message, optional, tag = "1")]
    pub expr: ::core::option::Option<PhysicalExprNode>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MaybePhysicalSortExprs {
    #[prost(message, repeated, tag = "1")]
    pub sort_expr: ::prost::alloc::vec::Vec<PhysicalSortExprNode>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct AggLimit {
    /// wrap into a message to make it optional
    #[prost(uint64, tag = "1")]
    pub limit: u64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregateExecNode {
    #[prost(message, repeated, tag = "1")]
    pub group_expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(message, repeated, tag = "2")]
    pub aggr_expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(enumeration = "AggregateMode", tag = "3")]
    pub mode: i32,
    #[prost(message, optional, boxed, tag = "4")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(string, repeated, tag = "5")]
    pub group_expr_name: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "6")]
    pub aggr_expr_name: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// we need the input schema to the partial aggregate to pass to the final aggregate
    #[prost(message, optional, tag = "7")]
    pub input_schema: ::core::option::Option<super::datafusion_common::Schema>,
    #[prost(message, repeated, tag = "8")]
    pub null_expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(bool, repeated, tag = "9")]
    pub groups: ::prost::alloc::vec::Vec<bool>,
    #[prost(message, repeated, tag = "10")]
    pub filter_expr: ::prost::alloc::vec::Vec<MaybeFilter>,
    #[prost(message, optional, tag = "11")]
    pub limit: ::core::option::Option<AggLimit>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GlobalLimitExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    /// The number of rows to skip before fetch
    #[prost(uint32, tag = "2")]
    pub skip: u32,
    /// Maximum number of rows to fetch; negative means no limit
    #[prost(int64, tag = "3")]
    pub fetch: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LocalLimitExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(uint32, tag = "2")]
    pub fetch: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    /// Maximum number of highest/lowest rows to fetch; negative means no limit
    #[prost(int64, tag = "3")]
    pub fetch: i64,
    #[prost(bool, tag = "4")]
    pub preserve_partitioning: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SortPreservingMergeExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, repeated, tag = "2")]
    pub expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    /// Maximum number of highest/lowest rows to fetch; negative means no limit
    #[prost(int64, tag = "3")]
    pub fetch: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NestedLoopJoinExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub left: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "2")]
    pub right: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(enumeration = "super::datafusion_common::JoinType", tag = "3")]
    pub join_type: i32,
    #[prost(message, optional, tag = "4")]
    pub filter: ::core::option::Option<JoinFilter>,
    #[prost(uint32, repeated, tag = "5")]
    pub projection: ::prost::alloc::vec::Vec<u32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CoalesceBatchesExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    #[prost(uint32, tag = "2")]
    pub target_batch_size: u32,
    #[prost(uint32, optional, tag = "3")]
    pub fetch: ::core::option::Option<u32>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CoalescePartitionsExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PhysicalHashRepartition {
    #[prost(message, repeated, tag = "1")]
    pub hash_expr: ::prost::alloc::vec::Vec<PhysicalExprNode>,
    #[prost(uint64, tag = "2")]
    pub partition_count: u64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RepartitionExecNode {
    #[prost(message, optional, boxed, tag = "1")]
    pub input: ::core::option::Option<::prost::alloc::boxed::Box<PhysicalPlanNode>>,
    /// oneof partition_method {
    ///    uint64 round_robin = 2;
    ///    PhysicalHashRepartition hash = 3;
    ///    uint64 unknown = 4;
    /// }
    #[prost(message, optional, tag = "5")]
    pub partitioning: ::core::option::Option<Partitioning>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Partitioning {
    #[prost(oneof = "partitioning::PartitionMethod", tags = "1, 2, 3")]
    pub partition_method: ::core::option::Option<partitioning::PartitionMethod>,
}
/// Nested message and enum types in `Partitioning`.
pub mod partitioning {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum PartitionMethod {
        #[prost(uint64, tag = "1")]
        RoundRobin(u64),
        #[prost(message, tag = "2")]
        Hash(super::PhysicalHashRepartition),
        #[prost(uint64, tag = "3")]
        Unknown(u64),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct JoinFilter {
    #[prost(message, optional, tag = "1")]
    pub expression: ::core::option::Option<PhysicalExprNode>,
    #[prost(message, repeated, tag = "2")]
    pub column_indices: ::prost::alloc::vec::Vec<ColumnIndex>,
    #[prost(message, optional, tag = "3")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct ColumnIndex {
    #[prost(uint32, tag = "1")]
    pub index: u32,
    #[prost(enumeration = "super::datafusion_common::JoinSide", tag = "2")]
    pub side: i32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartitionedFile {
    #[prost(string, tag = "1")]
    pub path: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub size: u64,
    #[prost(uint64, tag = "3")]
    pub last_modified_ns: u64,
    #[prost(message, repeated, tag = "4")]
    pub partition_values: ::prost::alloc::vec::Vec<
        super::datafusion_common::ScalarValue,
    >,
    #[prost(message, optional, tag = "5")]
    pub range: ::core::option::Option<FileRange>,
    #[prost(message, optional, tag = "6")]
    pub statistics: ::core::option::Option<super::datafusion_common::Statistics>,
}
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct FileRange {
    #[prost(int64, tag = "1")]
    pub start: i64,
    #[prost(int64, tag = "2")]
    pub end: i64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PartitionStats {
    #[prost(int64, tag = "1")]
    pub num_rows: i64,
    #[prost(int64, tag = "2")]
    pub num_batches: i64,
    #[prost(int64, tag = "3")]
    pub num_bytes: i64,
    #[prost(message, repeated, tag = "4")]
    pub column_stats: ::prost::alloc::vec::Vec<super::datafusion_common::ColumnStats>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RecursiveQueryNode {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, optional, boxed, tag = "2")]
    pub static_term: ::core::option::Option<::prost::alloc::boxed::Box<LogicalPlanNode>>,
    #[prost(message, optional, boxed, tag = "3")]
    pub recursive_term: ::core::option::Option<
        ::prost::alloc::boxed::Box<LogicalPlanNode>,
    >,
    #[prost(bool, tag = "4")]
    pub is_distinct: bool,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CteWorkTableScanNode {
    #[prost(string, tag = "1")]
    pub name: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub schema: ::core::option::Option<super::datafusion_common::Schema>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum WindowFrameUnits {
    Rows = 0,
    Range = 1,
    Groups = 2,
}
impl WindowFrameUnits {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Rows => "ROWS",
            Self::Range => "RANGE",
            Self::Groups => "GROUPS",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "ROWS" => Some(Self::Rows),
            "RANGE" => Some(Self::Range),
            "GROUPS" => Some(Self::Groups),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum WindowFrameBoundType {
    CurrentRow = 0,
    Preceding = 1,
    Following = 2,
}
impl WindowFrameBoundType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::CurrentRow => "CURRENT_ROW",
            Self::Preceding => "PRECEDING",
            Self::Following => "FOLLOWING",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "CURRENT_ROW" => Some(Self::CurrentRow),
            "PRECEDING" => Some(Self::Preceding),
            "FOLLOWING" => Some(Self::Following),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum DateUnit {
    Day = 0,
    DateMillisecond = 1,
}
impl DateUnit {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Day => "Day",
            Self::DateMillisecond => "DateMillisecond",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Day" => Some(Self::Day),
            "DateMillisecond" => Some(Self::DateMillisecond),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum InsertOp {
    Append = 0,
    Overwrite = 1,
    Replace = 2,
}
impl InsertOp {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Append => "Append",
            Self::Overwrite => "Overwrite",
            Self::Replace => "Replace",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "Append" => Some(Self::Append),
            "Overwrite" => Some(Self::Overwrite),
            "Replace" => Some(Self::Replace),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum PartitionMode {
    CollectLeft = 0,
    Partitioned = 1,
    Auto = 2,
}
impl PartitionMode {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::CollectLeft => "COLLECT_LEFT",
            Self::Partitioned => "PARTITIONED",
            Self::Auto => "AUTO",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "COLLECT_LEFT" => Some(Self::CollectLeft),
            "PARTITIONED" => Some(Self::Partitioned),
            "AUTO" => Some(Self::Auto),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum StreamPartitionMode {
    SinglePartition = 0,
    PartitionedExec = 1,
}
impl StreamPartitionMode {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::SinglePartition => "SINGLE_PARTITION",
            Self::PartitionedExec => "PARTITIONED_EXEC",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "SINGLE_PARTITION" => Some(Self::SinglePartition),
            "PARTITIONED_EXEC" => Some(Self::PartitionedExec),
            _ => None,
        }
    }
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum AggregateMode {
    Partial = 0,
    Final = 1,
    FinalPartitioned = 2,
    Single = 3,
    SinglePartitioned = 4,
}
impl AggregateMode {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::Partial => "PARTIAL",
            Self::Final => "FINAL",
            Self::FinalPartitioned => "FINAL_PARTITIONED",
            Self::Single => "SINGLE",
            Self::SinglePartitioned => "SINGLE_PARTITIONED",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "PARTIAL" => Some(Self::Partial),
            "FINAL" => Some(Self::Final),
            "FINAL_PARTITIONED" => Some(Self::FinalPartitioned),
            "SINGLE" => Some(Self::Single),
            "SINGLE_PARTITIONED" => Some(Self::SinglePartitioned),
            _ => None,
        }
    }
}
