<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

# Apache DataFusion 44.0.0 Changelog

This release consists of 329 commits from 94 contributors. See credits at the end of this changelog for more information.

**Breaking changes:**

- Introduce `full_qualified_col` option for the unparser dialect [#13241](https://github.com/apache/datafusion/pull/13241) (goldmedal)
- Implement `Eq`, `PartialEq`, `Hash` for `dyn PhysicalExpr` [#13005](https://github.com/apache/datafusion/pull/13005) (peter-toth)
- Change `schema_infer_max_rec ` config to use `Option<usize>` rather than `usize` [#13250](https://github.com/apache/datafusion/pull/13250) (alihan-synnada)
- refactor: move PREPARE/EXECUTE into `LogicalPlan::Statement` [#13311](https://github.com/apache/datafusion/pull/13311) (jonahgao)
- Convert `nth_value` builtIn function to User Defined Window Function [#13201](https://github.com/apache/datafusion/pull/13201) (buraksenn)
- Return int32 for integer type date part [#13466](https://github.com/apache/datafusion/pull/13466) (jayzhan211)
- User documentation: Generate docs from macros, make`DocumentationBuilder::build` infallable [#12822](https://github.com/apache/datafusion/pull/12822) (comphead)
- Replace `execution_mode` with `emission_type` and `boundedness` [#13823](https://github.com/apache/datafusion/pull/13823) (jayzhan-synnada)
- feat(substrait): modular substrait consumer [#13803](https://github.com/apache/datafusion/pull/13803) (vbarua)

**Implemented enhancements:**

- feat: Add `Time`/`Interval`/`Decimal`/`Utf8View` in aggregate fuzz testing [#13226](https://github.com/apache/datafusion/pull/13226) (LeslieKid)
- feat: basic support for executing prepared statements [#13242](https://github.com/apache/datafusion/pull/13242) (jonahgao)
- feat: Updating flamegraph docs [#13299](https://github.com/apache/datafusion/pull/13299) (jonathanc-n)
- feat: Added Timestamp/Binary/Float to fuzz [#13280](https://github.com/apache/datafusion/pull/13280) (jonathanc-n)
- feat: support `DEALLOCATE` to remove prepared statements [#13327](https://github.com/apache/datafusion/pull/13327) (jonahgao)
- feat: Add boolean column to aggregate queries for fuzz testing [#13331](https://github.com/apache/datafusion/pull/13331) (jonathanc-n)
- feat: Add random timezone to aggregate fuzz test [#13349](https://github.com/apache/datafusion/pull/13349) (jonathanc-n)
- feat: Add `stringview` support to `encode` and `decode` and `bit_length` [#13332](https://github.com/apache/datafusion/pull/13332) (jonathanc-n)
- feat: Support faster multi-column grouping ( `GroupColumn`) for `Date/Time/Timestamp` types [#13457](https://github.com/apache/datafusion/pull/13457) (jonathanc-n)
- feat(substrait): replace SessionContext with a trait [#13343](https://github.com/apache/datafusion/pull/13343) (notfilippo)
- feat(function): add greatest function [#12474](https://github.com/apache/datafusion/pull/12474) (rluvaton)
- feat: Add `Boolean` Column Support for Window Functions [#13577](https://github.com/apache/datafusion/pull/13577) (jonathanc-n)
- feat(substrait): support-try-cast [#13562](https://github.com/apache/datafusion/pull/13562) (eatthepear)
- feat: Add GroupColumn `Decimal128Array` [#13564](https://github.com/apache/datafusion/pull/13564) (jonathanc-n)
- feat(substrait): remove dependency on datafusion default features [#13594](https://github.com/apache/datafusion/pull/13594) (notfilippo)
- feat: `parse_float_as_decimal` supports scientific notation and Decimal256 [#13806](https://github.com/apache/datafusion/pull/13806) (jonahgao)
- feat: support normalized expr in CSE [#13315](https://github.com/apache/datafusion/pull/13315) (zhuliquan)
- feat(function): add `least` function [#13786](https://github.com/apache/datafusion/pull/13786) (rluvaton)

**Fixed bugs:**

- fix: Fix stddev indeterministically producing NAN [#13248](https://github.com/apache/datafusion/pull/13248) (eejbyfeldt)
- fix: Fix failures caused by `array_prepend` [#13367](https://github.com/apache/datafusion/pull/13367) (jonathanc-n)
- fix: Fix documentation for `null_string` to `array_to_string` + `string_to_array` [#13397](https://github.com/apache/datafusion/pull/13397) (jonathanc-n)
- fix: serialize user-defined window functions to proto [#13421](https://github.com/apache/datafusion/pull/13421) (jcsherin)
- fix: Ignore names of technical inner fields (of List and Map types) when comparing datatypes for logical equivalence [#13522](https://github.com/apache/datafusion/pull/13522) (Blizzara)
- fix: CI build failed on main [#13640](https://github.com/apache/datafusion/pull/13640) (jonahgao)
- fix: cargo msrv check failed [#13654](https://github.com/apache/datafusion/pull/13654) (jonahgao)
- fix: repartitioned reads of CSV with custom line terminator [#13677](https://github.com/apache/datafusion/pull/13677) (korowa)
- fix: Implicitly plan `UNNEST` as lateral [#13695](https://github.com/apache/datafusion/pull/13695) (rkrishn7)
- fix: specify roottype in substrait fieldreference [#13647](https://github.com/apache/datafusion/pull/13647) (mbwhite)
- fix: add `null_buffer` length check to `StringArrayBuilder`/`LargeStringArrayBuilder` [#13758](https://github.com/apache/datafusion/pull/13758) (jdockerty)
- fix: Limit together with pushdown_filters [#13788](https://github.com/apache/datafusion/pull/13788) (zhuqi-lucas)
- fix: pruning by bloom filters for dictionary columns [#13768](https://github.com/apache/datafusion/pull/13768) (korowa)
- fix: Ignore empty files in ListingTable when listing files with or without partition filters, as well as when inferring schema [#13750](https://github.com/apache/datafusion/pull/13750) (Blizzara)
- fix: enable DF's nested_expressions feature by in datafusion-substrait tests to make them pass [#13857](https://github.com/apache/datafusion/pull/13857) (Blizzara)

**Documentation updates:**

- chore: Prepare 43.0.0 release [#13254](https://github.com/apache/datafusion/pull/13254) (andygrove)
- minor: typo in command example for flamegraph docs [#13269](https://github.com/apache/datafusion/pull/13269) (jonathanc-n)
- Remove warning logs during the document build process [#13324](https://github.com/apache/datafusion/pull/13324) (tlm365)
- minor(docs): Add docs for `regen.sh` [#13321](https://github.com/apache/datafusion/pull/13321) (jonathanc-n)
- minor(docs): Correct array_prepend docs [#13362](https://github.com/apache/datafusion/pull/13362) (NoeB)
- Docs: Update dependencies in `requirements.txt` for python3.12 [#13339](https://github.com/apache/datafusion/pull/13339) (AnthonyZhOon)
- Docs: Add Content Library Page to the docs [#13335](https://github.com/apache/datafusion/pull/13335) (alamb)
- chore: Remove `window_functions_new` docs [#13395](https://github.com/apache/datafusion/pull/13395) (jonathanc-n)
- Minor: Add SQL example for `date_bin` [#13390](https://github.com/apache/datafusion/pull/13390) (alamb)
- Fix typo in concepts-readings-events.md [#13400](https://github.com/apache/datafusion/pull/13400) (alamb)
- fix docs of register_table to match implementation [#13438](https://github.com/apache/datafusion/pull/13438) (adriangb)
- Minor: Fix broken links for meetups in content library [#13445](https://github.com/apache/datafusion/pull/13445) (alamb)
- Clarify documentation about use of tokio tasks [#13474](https://github.com/apache/datafusion/pull/13474) (alamb)
- Include license and notice files in published crates [#13512](https://github.com/apache/datafusion/pull/13512) (ankane)
- Minor: clean up error entries [#13521](https://github.com/apache/datafusion/pull/13521) (comphead)
- Move many udf implementations from `invoke` to `invoke_batch` [#13491](https://github.com/apache/datafusion/pull/13491) (joseph-isaacs)
- chore: rename known project ZincObserve to OpenObserve [#13587](https://github.com/apache/datafusion/pull/13587) (hengfeiyang)
- Minor: Add example of backporting / `cherry-pick`ing to release branch [#13565](https://github.com/apache/datafusion/pull/13565) (alamb)
- [minor] Fix logo image path by using absolute url [#13619](https://github.com/apache/datafusion/pull/13619) (A-JM)
- Update governance page for 7 days of voting [#13629](https://github.com/apache/datafusion/pull/13629) (alamb)
- Doc gen: Migrate aggregate functions doc to attribute based. [#13646](https://github.com/apache/datafusion/pull/13646) (comphead)
- Minor: Rephrase MSRV policy to be more explanatory [#13668](https://github.com/apache/datafusion/pull/13668) (comphead)
- Improve documentation for TableProvider [#13724](https://github.com/apache/datafusion/pull/13724) (alamb)
- Minor: Add documentation explaining that initcap only works for ASCII [#13749](https://github.com/apache/datafusion/pull/13749) (alamb)
- Minor: improve the Deprecation / API health guidelines [#13701](https://github.com/apache/datafusion/pull/13701) (alamb)
- Minor: Add some more blog posts to the readings page [#13761](https://github.com/apache/datafusion/pull/13761) (alamb)
- docs: update GroupsAccumulator instead of GroupAccumulator [#13787](https://github.com/apache/datafusion/pull/13787) (rluvaton)
- Improve Deprecation Guidelines more [#13776](https://github.com/apache/datafusion/pull/13776) (alamb)
- Update documentation guidelines for contribution content [#13703](https://github.com/apache/datafusion/pull/13703) (alamb)
- Minor: improve `Analyzer` docs [#13798](https://github.com/apache/datafusion/pull/13798) (alamb)
- Add configurable normalization for configuration options and preserve case for S3 paths [#13576](https://github.com/apache/datafusion/pull/13576) (blaginin)
- Improve`Signature` and `comparison_coercion` documentation [#13840](https://github.com/apache/datafusion/pull/13840) (alamb)
- Add documentation for `SHOW FUNCTIONS` [#13868](https://github.com/apache/datafusion/pull/13868) (alamb)
- Support unicode character for `initcap` function [#13752](https://github.com/apache/datafusion/pull/13752) (tlm365)
- [minor] make recursive package dependency optional [#13778](https://github.com/apache/datafusion/pull/13778) (buraksenn)
- Fix `recursive-protection` feature flag [#13887](https://github.com/apache/datafusion/pull/13887) (alamb)
- Prepare for 44.0.0 release: version and changelog [#13882](https://github.com/apache/datafusion/pull/13882) (alamb)

**Other:**

- Minor: Improve documentation about `OnceAsync` [#13223](https://github.com/apache/datafusion/pull/13223) (alamb)
- Introduce HashMap and HashSet type aliases [#13236](https://github.com/apache/datafusion/pull/13236) (drauschenbach)
- Remove `Expr` clones from `SortExpr`s [#13258](https://github.com/apache/datafusion/pull/13258) (peter-toth)
- Update substrait requirement from 0.45 to 0.46 [#13257](https://github.com/apache/datafusion/pull/13257) (dependabot[bot])
- Deprecate `LexOrderingRef` and `LexRequirementRef` [#13233](https://github.com/apache/datafusion/pull/13233) (jatin510)
- Optimize `Statistics::projection` to avoid a clone [#13225](https://github.com/apache/datafusion/pull/13225) (alamb)
- Migrate invoke_no_args to invoke_batch [#13246](https://github.com/apache/datafusion/pull/13246) (findepi)
- fix bugs explain with non-correlated query [#13210](https://github.com/apache/datafusion/pull/13210) (Lordworms)
- Example: FFI Table Provider as dynamic module loading [#13183](https://github.com/apache/datafusion/pull/13183) (timsaucer)
- Fix incorrect `... LIKE '%'` simplification with NULLs [#13259](https://github.com/apache/datafusion/pull/13259) (findepi)
- allow passing in metadata_size_hint on a per-file basis [#13213](https://github.com/apache/datafusion/pull/13213) (adriangb)
- Deprecate `PhysicalSortRequirement::from_sort_exprs` and `PhysicalSortRequirement::to_sort_exprs` [#13222](https://github.com/apache/datafusion/pull/13222) (alamb)
- Ensure schema and data have the same size [#13264](https://github.com/apache/datafusion/pull/13264) (blaginin)
- Update thiserror requirement from 1.0.44 to 2.0.0 [#13273](https://github.com/apache/datafusion/pull/13273) (dependabot[bot])
- Support vectorized append and compare for multi group by [#12996](https://github.com/apache/datafusion/pull/12996) (Rachelint)
- Use LogicalType for TypeSignature `Numeric` and `String`, `Coercible` [#13240](https://github.com/apache/datafusion/pull/13240) (jayzhan211)
- Minor: Clarify use of infallable APIs [#13217](https://github.com/apache/datafusion/pull/13217) (alamb)
- chore: Move `OptimizeAggregateOrder` from core to optimizer crate [#13284](https://github.com/apache/datafusion/pull/13284) (jonathanc-n)
- Fix license header [#12008](https://github.com/apache/datafusion/pull/12008) (waynexia)
- Introduce `INFORMATION_SCHEMA.ROUTINES` table [#13255](https://github.com/apache/datafusion/pull/13255) (goldmedal)
- minor: doc fixes in fuzz testing [#13281](https://github.com/apache/datafusion/pull/13281) (jonathanc-n)
- Minor: improve `LogicalPlanBuilder::join_with_expr_keys` docs [#13276](https://github.com/apache/datafusion/pull/13276) (alamb)
- Test LIKE with implicit `\` escape [#13288](https://github.com/apache/datafusion/pull/13288) (findepi)
- Enable `clone_on_ref_ptr` clippy lint on physical-expr-common crate [#13295](https://github.com/apache/datafusion/pull/13295) (getChan)
- chore: Move `CoalesceBatches` from core to optimizer crate [#13283](https://github.com/apache/datafusion/pull/13283) (jonathanc-n)
- Minor: Document how to test for trailing whitespace in `slt` / sqllogictests [#13215](https://github.com/apache/datafusion/pull/13215) (alamb)
- Improve documentation on start_demuxer_task and file_extension [#13216](https://github.com/apache/datafusion/pull/13216) (alamb)
- Expand LIKE simplification: cover `NULL` pattern/expression and constant [#13260](https://github.com/apache/datafusion/pull/13260) (findepi)
- join_with_expr_keys to support expressions with both unqualified and qualified column names [#13182](https://github.com/apache/datafusion/pull/13182) (onursatici)
- Derive Eq, Hash, Ord for ResolvedTableReference to be capable of map key [#13303](https://github.com/apache/datafusion/pull/13303) (kezhuw)
- chore: Post 43.0.0 release fixes [#13319](https://github.com/apache/datafusion/pull/13319) (andygrove)
- Implement get_possible_types for Uniform, Coercible, Variadic, Numeric and String [#13313](https://github.com/apache/datafusion/pull/13313) (delamarch3)
- Support `Utf8View` for string function `bit_length()` [#13221](https://github.com/apache/datafusion/pull/13221) (austin362667)
- Optimize `replace_params_with_values` [#13308](https://github.com/apache/datafusion/pull/13308) (askalt)
- minor: include datafusion-ffi in publishing instructions [#13333](https://github.com/apache/datafusion/pull/13333) (alamb)
- Update dev script to publish FFI crate [#13322](https://github.com/apache/datafusion/pull/13322) (timsaucer)
- Fix `scalar_functions.md` for CI [#13340](https://github.com/apache/datafusion/pull/13340) (goldmedal)
- Fix ExprSchema extraction of metadata for Cast expressions. [#13305](https://github.com/apache/datafusion/pull/13305) (wiedld)
- refactor: replace `instant` with `web-time` [#13355](https://github.com/apache/datafusion/pull/13355) (crepererum)
- Add stacker and recursive [#13310](https://github.com/apache/datafusion/pull/13310) (peter-toth)
- Introduce `information_schema.parameters` table [#13341](https://github.com/apache/datafusion/pull/13341) (goldmedal)
- support recursive CTEs logical plans in datafusion-proto [#13314](https://github.com/apache/datafusion/pull/13314) (leoyvens)
- Update substrait requirement from 0.46 to 0.47 [#13374](https://github.com/apache/datafusion/pull/13374) (dependabot[bot])
- Enable `clone_on_ref_ptr` clippy lint on core crate [#13338](https://github.com/apache/datafusion/pull/13338) (getChan)
- Support TypeSignature::Nullary [#13354](https://github.com/apache/datafusion/pull/13354) (jayzhan211)
- improve performance of regexp_count [#13364](https://github.com/apache/datafusion/pull/13364) (Dimchikkk)
- Annotate `Expr::get_type()` with recursive [#13376](https://github.com/apache/datafusion/pull/13376) (peter-toth)
- Add utf8view support in nullif [#13380](https://github.com/apache/datafusion/pull/13380) (Omega359)
- Split the GroupColumn Implementations into smaller modules [#13352](https://github.com/apache/datafusion/pull/13352) (jiashenC)
- Move filtered SMJ Full filtered join out of `join_partial` phase [#13369](https://github.com/apache/datafusion/pull/13369) (comphead)
- Remove uses of #[allow(dead_code)] in favor of \_identifier [#13328](https://github.com/apache/datafusion/pull/13328) (ding-young)
- Allow aggregation without projection in `Unparser` [#13326](https://github.com/apache/datafusion/pull/13326) (blaginin)
- Introduce `TypePlanner` for customizing type planning [#13294](https://github.com/apache/datafusion/pull/13294) (goldmedal)
- Minor: SortMergeJoin small refactoring [#13398](https://github.com/apache/datafusion/pull/13398) (comphead)
- Add Utf8View to `TypeCategory::Unknown` [#13350](https://github.com/apache/datafusion/pull/13350) (jayzhan211)
- refactor: Consolidate single group by column code into sub modules [#13392](https://github.com/apache/datafusion/pull/13392) (Rachelint)
- Update sqlparser requirement from 0.51.0 to 0.52.0 [#13373](https://github.com/apache/datafusion/pull/13373) (dependabot[bot])
- chore: expose TypeCoercionRewriter::new and add examples for type coerce expressions [#13387](https://github.com/apache/datafusion/pull/13387) (niebayes)
- Migrate code from invoke to invoke_batch. [#13345](https://github.com/apache/datafusion/pull/13345) (irenjj)
- Improve the coverage of `bit_length` testing [#13336](https://github.com/apache/datafusion/pull/13336) (goldmedal)
- Consolidate dataframe example [#13410](https://github.com/apache/datafusion/pull/13410) (alamb)
- parquet:Add file_extension for specify file_extension of ParquetReadOptions [#13353](https://github.com/apache/datafusion/pull/13353) (glfeng318)
- Add getters to `ExecutionPlan` Properties [#13409](https://github.com/apache/datafusion/pull/13409) (shehabgamin)
- Have DefaultTableSource return the correct TableType [#13416](https://github.com/apache/datafusion/pull/13416) (leoyvens)
- Remove `BuiltInWindowFunction` (LogicalPlans) [#13393](https://github.com/apache/datafusion/pull/13393) (alamb)
- Fix `regex` cache on pattern, less alloc, hash less often [#13414](https://github.com/apache/datafusion/pull/13414) (Dimchikkk)
- Fix record batch memory size double counting [#13377](https://github.com/apache/datafusion/pull/13377) (2010YOUY01)
- Make DFSchema::datatype_is_semantically_equal public [#13429](https://github.com/apache/datafusion/pull/13429) (Sevenannn)
- Add support for utf8view to nvl function [#13382](https://github.com/apache/datafusion/pull/13382) (Omega359)
- Add support for Utf8View to crypto functions [#13407](https://github.com/apache/datafusion/pull/13407) (Omega359)
- Fix `concat` simplifier for Utf8View types [#13346](https://github.com/apache/datafusion/pull/13346) (timsaucer)
- Add sort integration benchmark [#13306](https://github.com/apache/datafusion/pull/13306) (2010YOUY01)
- Minor: Remove MOVED file [#13442](https://github.com/apache/datafusion/pull/13442) (alamb)
- Deduplicate and standardize deserialization logic for streams [#13412](https://github.com/apache/datafusion/pull/13412) (alihan-synnada)
- Minor: Doc and organize fields in `struct ExternalSorter` [#13447](https://github.com/apache/datafusion/pull/13447) (2010YOUY01)
- Support unparsing Array plan to SQL string [#13418](https://github.com/apache/datafusion/pull/13418) (goldmedal)
- Fix test query results even for quick test execution [#13453](https://github.com/apache/datafusion/pull/13453) (findepi)
- [MINOR]: fix min max accumulator nan bug [#13432](https://github.com/apache/datafusion/pull/13432) (akurmustafa)
- Evaluate cheaper condition first in join selection and physical planner [#13435](https://github.com/apache/datafusion/pull/13435) (findepi)
- Fix duckdb & sqlite character_length scalar unparsing [#13428](https://github.com/apache/datafusion/pull/13428) (Sevenannn)
- chore: remove unnecessary test helpers [#13317](https://github.com/apache/datafusion/pull/13317) (findepi)
- Produce informative error on physical schema mismatch [#13434](https://github.com/apache/datafusion/pull/13434) (findepi)
- Fix invalid swap for LeftMark nested loops join [#13426](https://github.com/apache/datafusion/pull/13426) (findepi)
- Fix redundant data copying in unnest [#13441](https://github.com/apache/datafusion/pull/13441) (demetribu)
- Add docs on TableProvider::statistics() [#13454](https://github.com/apache/datafusion/pull/13454) (avantgardnerio)
- Update sqllogictest requirement from 0.22.0 to 0.23.0 [#13464](https://github.com/apache/datafusion/pull/13464) (dependabot[bot])
- Improve documentation (and ASCII art) about streaming execution, and thread pools [#13423](https://github.com/apache/datafusion/pull/13423) (alamb)
- Fix Binary & Binary View Unparsing [#13427](https://github.com/apache/datafusion/pull/13427) (Sevenannn)
- Support Utf8View in Unparser `expr_to_sql` [#13462](https://github.com/apache/datafusion/pull/13462) (phillipleblanc)
- Unparse inner join with no conditions as a cross join [#13460](https://github.com/apache/datafusion/pull/13460) (phillipleblanc)
- Remove unreachable filter logic in final grouping stage [#13463](https://github.com/apache/datafusion/pull/13463) (jayzhan211)
- MINOR: remove one duplicated inparam in TopK [#13479](https://github.com/apache/datafusion/pull/13479) (waynexia)
- Fix join on arrays of unhashable types and allow hash join on all types supported at run-time [#13388](https://github.com/apache/datafusion/pull/13388) (findepi)
- Remove redundant dead_code check suppressions [#13490](https://github.com/apache/datafusion/pull/13490) (findepi)
- chore: try make Setup Rust CI step immune to network hang [#13495](https://github.com/apache/datafusion/pull/13495) (findepi)
- Move `Pruning` into `physical-optimizer` crate [#13485](https://github.com/apache/datafusion/pull/13485) (irenjj)
- Add `Container` trait and to simplify `Expr` and `LogicalPlan` apply and map methods [#13467](https://github.com/apache/datafusion/pull/13467) (peter-toth)
- Chunk based iteration in `accumulate_indices` [#13451](https://github.com/apache/datafusion/pull/13451) (jayzhan211)
- Fix DataFusionError use in schema_err macro [#13488](https://github.com/apache/datafusion/pull/13488) (findepi)
- Fixed issue with md5 not support LargeUtf8 correctly [#13502](https://github.com/apache/datafusion/pull/13502) (Omega359)
- Coerce Array inner types [#13452](https://github.com/apache/datafusion/pull/13452) (blaginin)
- Update arrow/parquet to arrow/parquet `53.3.0` [#13508](https://github.com/apache/datafusion/pull/13508) (alamb)
- Minor: Add debug log message for creating GroupValuesRows [#13506](https://github.com/apache/datafusion/pull/13506) (alamb)
- Unparse struct to sql [#13493](https://github.com/apache/datafusion/pull/13493) (delamarch3)
- Add `ScalarUDFImpl::invoke_with_args` to support passing the return type created for the udf instance [#13290](https://github.com/apache/datafusion/pull/13290) (joseph-isaacs)
- Update substrait requirement from 0.47 to 0.48 [#13480](https://github.com/apache/datafusion/pull/13480) (dependabot[bot])
- Add support for Utf8View to string_to_array and array_to_string [#13403](https://github.com/apache/datafusion/pull/13403) (Omega359)
- refactor: use `std::slice::from_ref` to remove some clones [#13518](https://github.com/apache/datafusion/pull/13518) (jonahgao)
- Introduce TypeSignature::Comparable and update `NullIf` signature [#13356](https://github.com/apache/datafusion/pull/13356) (jayzhan211)
- refactor: change some `hashbrown` `RawTable` uses to `HashTable` [#13514](https://github.com/apache/datafusion/pull/13514) (crepererum)
- Avoid pushdown of volatile functions to tablescan [#13475](https://github.com/apache/datafusion/pull/13475) (theirix)
- Unparse map to sql [#13532](https://github.com/apache/datafusion/pull/13532) (delamarch3)
- Minor: add version to RuntimeEnv::new deprecation message [#13537](https://github.com/apache/datafusion/pull/13537) (alamb)
- [bug]: Fix wrong order by removal from plan [#13497](https://github.com/apache/datafusion/pull/13497) (akurmustafa)
- Fix panic when hashing empty FixedSizeList Array [#13533](https://github.com/apache/datafusion/pull/13533) (findepi)
- Minor: Fix two test cases causing CI failures by adding `rowsort` [#13547](https://github.com/apache/datafusion/pull/13547) (2010YOUY01)
- chore: add version to deprecation messages [#13543](https://github.com/apache/datafusion/pull/13543) (findepi)
- Set timezone for group column timestamp type [#13535](https://github.com/apache/datafusion/pull/13535) (jayzhan211)
- Support Unnest in Subqueries [#13523](https://github.com/apache/datafusion/pull/13523) (kosiew)
- Support LIKE with ESCAPE `\` [#13312](https://github.com/apache/datafusion/pull/13312) (findepi)
- chore: Remove redundant assert_starts_with test helper [#13542](https://github.com/apache/datafusion/pull/13542) (findepi)
- Preserve field name when casting List [#13468](https://github.com/apache/datafusion/pull/13468) (timsaucer)
- Rename `BuiltInWindow*` to `StandardWindow*` [#13536](https://github.com/apache/datafusion/pull/13536) (irenjj)
- test: allow external_access_plan run on windows [#13531](https://github.com/apache/datafusion/pull/13531) (zhuliquan)
- chore: Remove unused dependencies [#13541](https://github.com/apache/datafusion/pull/13541) (findepi)
- Update tests and resolve TODOs after arrow update [#13538](https://github.com/apache/datafusion/pull/13538) (findepi)
- Added documentation for SortMergeJoin [#13469](https://github.com/apache/datafusion/pull/13469) (athultr1997)
- Fixed imports in custom_datasource.rs example [#13561](https://github.com/apache/datafusion/pull/13561) (lucafabbian)
- Update substrait requirement from 0.48 to 0.49 [#13556](https://github.com/apache/datafusion/pull/13556) (dependabot[bot])
- [minor] Update Doc of required_indices.rs [#13555](https://github.com/apache/datafusion/pull/13555) (xinlmain)
- Add zero-`decimal`-cast test [#13571](https://github.com/apache/datafusion/pull/13571) (blaginin)
- Fix Duplicated filters within (filter(TableScan)) plan for unparser [#13422](https://github.com/apache/datafusion/pull/13422) (Sevenannn)
- chore(deps): update bigdecimal from 0.4.1 to 0.4.6 [#13569](https://github.com/apache/datafusion/pull/13569) (jonahgao)
- Doc gen: Attributes to support `related_udf`, `alternative_syntax` [#13575](https://github.com/apache/datafusion/pull/13575) (comphead)
- Deprecate `adjust_output_array` in favor of `PrimitiveArray::with_data_type` [#13585](https://github.com/apache/datafusion/pull/13585) (alamb)
- Remove redundant type constraints from ScalarUDF from [#13578](https://github.com/apache/datafusion/pull/13578) (findepi)
- Supplement as\_\*\_array functions [#13580](https://github.com/apache/datafusion/pull/13580) (findepi)
- [Minor] Use std::thread::available_parallelism instead of `num_cpus` [#13579](https://github.com/apache/datafusion/pull/13579) (Dandandan)
- Temporarily pin toolchain version to avoid clippy [#13598](https://github.com/apache/datafusion/pull/13598) (findepi)
- Apply clippy fixes for Rust 1.83 [#13596](https://github.com/apache/datafusion/pull/13596) (findepi)
- refactor: add `get_available_parallelism` function [#13595](https://github.com/apache/datafusion/pull/13595) (alan910127)
- Test sort merge join on TPC-H benchmark [#13572](https://github.com/apache/datafusion/pull/13572) (Dandandan)
- Tidy up join test code [#13604](https://github.com/apache/datafusion/pull/13604) (ozankabak)
- [minor]: Update median implementation [#13554](https://github.com/apache/datafusion/pull/13554) (akurmustafa)
- Add SimpleScalarUDF::new_with_signature [#13592](https://github.com/apache/datafusion/pull/13592) (findepi)
- Use // for unparsing DuckDB division operator [#13509](https://github.com/apache/datafusion/pull/13509) (Sevenannn)
- Fix `LogicalPlan::..._with_subqueries` methods [#13589](https://github.com/apache/datafusion/pull/13589) (peter-toth)
- chore: exposing ArraySize and ArrayFlatten [#13600](https://github.com/apache/datafusion/pull/13600) (Groennbeck)
- support unknown col expr in proto [#13603](https://github.com/apache/datafusion/pull/13603) (onursatici)
- Improve unsupported compound identifier message [#13605](https://github.com/apache/datafusion/pull/13605) (alamb)
- Minor: Simplify `IdentTaker` [#13609](https://github.com/apache/datafusion/pull/13609) (alamb)
- Add generate_series() udtf (and introduce 'lazy' `MemoryExec`) [#13540](https://github.com/apache/datafusion/pull/13540) (2010YOUY01)
- [refactor]: Convert Vec<PhysicalExpr> to HashSet<PhysicalExpr> [#13612](https://github.com/apache/datafusion/pull/13612) (akurmustafa)
- Increase minimum supported Rust version (MSRV) to 1.80 [#13622](https://github.com/apache/datafusion/pull/13622) (findepi)
- [minor] Consolidate construction of the list field [#13627](https://github.com/apache/datafusion/pull/13627) (gruuya)
- Create `ArrayScalarBuilder` for creating single element List arrays [#13623](https://github.com/apache/datafusion/pull/13623) (alamb)
- [minor]: Introduce IndexSet and IndexMap aliases. [#13611](https://github.com/apache/datafusion/pull/13611) (akurmustafa)
- Improve unparsing after optimize_projections optimization [#13599](https://github.com/apache/datafusion/pull/13599) (sgrebnov)
- allow http in datafusion-cli http object store [#13626](https://github.com/apache/datafusion/pull/13626) (adriangb)
- Report current operation when coercion fails [#13628](https://github.com/apache/datafusion/pull/13628) (findepi)
- refactor: change some `hashbrown` `RawTable` uses to `HashTable` (round 2) [#13524](https://github.com/apache/datafusion/pull/13524) (crepererum)
- refactor: replace `OnceLock` with `LazyLock` [#13641](https://github.com/apache/datafusion/pull/13641) (jonahgao)
- Allow ColumnarValue to array conversion with less copying [#13644](https://github.com/apache/datafusion/pull/13644) (findepi)
- Deprecate `RuntimeConfig`, update code to use new builder style [#13635](https://github.com/apache/datafusion/pull/13635) (alamb)
- Report current function name when invoke result length wrong [#13643](https://github.com/apache/datafusion/pull/13643) (findepi)
- Minor: add examples for using `displayable` to show `ExecutionPlans` [#13636](https://github.com/apache/datafusion/pull/13636) (alamb)
- Allow place holders like `$1` in more types of queries. [#13632](https://github.com/apache/datafusion/pull/13632) (davisp)
- test: support run filter_pushdown on windows machine [#13610](https://github.com/apache/datafusion/pull/13610) (zhuliquan)
- Add csv loading benchmarks. [#13544](https://github.com/apache/datafusion/pull/13544) (dhegberg)
- Retract IndexSet, IndexMap type alias [#13655](https://github.com/apache/datafusion/pull/13655) (akurmustafa)
- chore: Minor code improvements suggested by newer clippy [#13666](https://github.com/apache/datafusion/pull/13666) (findepi)
- Increase minimum supported Rust version (MSRV) to 1.80.1 [#13667](https://github.com/apache/datafusion/pull/13667) (findepi)
- refactor: replace `OnceLock` with `LazyLock` (round 2) [#13674](https://github.com/apache/datafusion/pull/13674) (jonahgao)
- refactor: change some `hashbrown` `RawTable` uses to `HashTable` (round 3) [#13658](https://github.com/apache/datafusion/pull/13658) (crepererum)
- Minor: Comment temporary function for documentation migration [#13669](https://github.com/apache/datafusion/pull/13669) (comphead)
- chore: macros crate cleanup [#13685](https://github.com/apache/datafusion/pull/13685) (findepi)
- Refactor regexplike signature [#13394](https://github.com/apache/datafusion/pull/13394) (jiashenC)
- Performance: enable array allocation reuse (`ScalarFunctionArgs` gets owned `ColumnReference`) [#13637](https://github.com/apache/datafusion/pull/13637) (alamb)
- Temporary fix for CI [#13689](https://github.com/apache/datafusion/pull/13689) (jonahgao)
- refactor: use `LazyLock` in the `user_doc` macro [#13684](https://github.com/apache/datafusion/pull/13684) (jonahgao)
- Unlock lexical-write-integer version. [#13693](https://github.com/apache/datafusion/pull/13693) (Alexhuszagh)
- [minor]: Simplifications [#13697](https://github.com/apache/datafusion/pull/13697) (akurmustafa)
- Fix hash join with sort push down [#13560](https://github.com/apache/datafusion/pull/13560) (haohuaijin)
- Improve substr() performance by avoiding using owned string [#13688](https://github.com/apache/datafusion/pull/13688) (richox)
- chore: reinstate down_cast_any_ref [#13705](https://github.com/apache/datafusion/pull/13705) (andygrove)
- Optimize performance of `character_length` function [#13696](https://github.com/apache/datafusion/pull/13696) (tlm365)
- Update prost-build requirement from =0.13.3 to =0.13.4 [#13698](https://github.com/apache/datafusion/pull/13698) (dependabot[bot])
- Minor: Output elapsed time for sql logic test [#13718](https://github.com/apache/datafusion/pull/13718) (comphead)
- refactor: simplify the `make_udf_function` macro [#13712](https://github.com/apache/datafusion/pull/13712) (jonahgao)
- refactor: replace `Vec` with `IndexMap` for expression mappings in `ProjectionMapping` and `EquivalenceGroup` [#13675](https://github.com/apache/datafusion/pull/13675) (Weijun-H)
- Handle alias when parsing sql(parse_sql_expr) [#12939](https://github.com/apache/datafusion/pull/12939) (Eason0729)
- Reveal implementing type and return type in simple UDF implementations [#13730](https://github.com/apache/datafusion/pull/13730) (findepi)
- minor: Extract tests for `EXTRACT` AND `date_part` to their own file [#13731](https://github.com/apache/datafusion/pull/13731) (alamb)
- Support unparsing `UNNEST` plan to `UNNEST` table factor SQL [#13660](https://github.com/apache/datafusion/pull/13660) (goldmedal)
- Update to apache-avro 0.17, fix compatibility changes schema handling [#13727](https://github.com/apache/datafusion/pull/13727) (mdroogh)
- Minor: Add doc example to RecordBatchStreamAdapter [#13725](https://github.com/apache/datafusion/pull/13725) (alamb)
- Implement GroupsAccumulator for corr(x,y) aggregate function [#13581](https://github.com/apache/datafusion/pull/13581) (2010YOUY01)
- fix union serialisation order in proto [#13709](https://github.com/apache/datafusion/pull/13709) (onursatici)
- Minor: make unsupported `nanosecond` part a real (not internal) error [#13733](https://github.com/apache/datafusion/pull/13733) (alamb)
- Add tests for date_part on columns + timestamps with / without timezones [#13732](https://github.com/apache/datafusion/pull/13732) (alamb)
- Optimize performance of `initcap` function (~2x faster) [#13691](https://github.com/apache/datafusion/pull/13691) (tlm365)
- Support sqllogictest --complete with postgres [#13746](https://github.com/apache/datafusion/pull/13746) (findepi)
- doc-gen: migrate window functions documentation to attribute based [#13739](https://github.com/apache/datafusion/pull/13739) (zjregee)
- Minor: Remove memory reservation in `JoinLeftData` used in HashJoin [#13751](https://github.com/apache/datafusion/pull/13751) (jayzhan-synnada)
- Update to bigdecimal 0.4.7 [#13747](https://github.com/apache/datafusion/pull/13747) (findepi)
- chore: clean up dependencies [#13728](https://github.com/apache/datafusion/pull/13728) (comphead)
- Simplify type signatures using `TypeSignatureClass` for mixed type function signature [#13372](https://github.com/apache/datafusion/pull/13372) (jayzhan211)
- Revert the removal of reservation in HashJoin [#13792](https://github.com/apache/datafusion/pull/13792) (jayzhan-synnada)
- [minor] add missing slt tests for count(partitioned,aggregated, aggregated cube) [#13790](https://github.com/apache/datafusion/pull/13790) (buraksenn)
- Add Round trip tests for Array <--> ScalarValue [#13777](https://github.com/apache/datafusion/pull/13777) (alamb)
- Minor: cargo update in datafusion-cli [#13801](https://github.com/apache/datafusion/pull/13801) (alamb)
- Fix `ScalarValue::to_array_of_size` for DenseUnion [#13797](https://github.com/apache/datafusion/pull/13797) (kylebarron)
- Handle empty rows for `array_distinct` [#13810](https://github.com/apache/datafusion/pull/13810) (cht42)
- Fix get_type for higher-order array functions [#13756](https://github.com/apache/datafusion/pull/13756) (findepi)
- Chore: Do not return empty record batches from streams [#13794](https://github.com/apache/datafusion/pull/13794) (mertak-synnada)
- Handle possible overflows in StringArrayBuilder / LargeStringArrayBuilder [#13802](https://github.com/apache/datafusion/pull/13802) (wiedld)
- Support 'NULL' as Null in csv parser. [#13228](https://github.com/apache/datafusion/pull/13228) (dhegberg)
- Minor: Extend ScalarValue::new_zero() [#13828](https://github.com/apache/datafusion/pull/13828) (berkaysynnada)
- chore: temporarily disable Windows Rust flow [#13833](https://github.com/apache/datafusion/pull/13833) (comphead)
- Minor: Replace `BooleanArray::extend` with `append_n` [#13832](https://github.com/apache/datafusion/pull/13832) (comphead)
- Rename `TypeSignature::NullAry` --> `TypeSignature::Nullary` and improve comments [#13817](https://github.com/apache/datafusion/pull/13817) (alamb)
- [bugfix] ScalarFunctionExpr does not preserve the nullable flag on roundtrip [#13830](https://github.com/apache/datafusion/pull/13830) (ccciudatu)
- Add example of interacting with a remote catalog [#13722](https://github.com/apache/datafusion/pull/13722) (alamb)
- Update substrait requirement from 0.49 to 0.50 [#13808](https://github.com/apache/datafusion/pull/13808) (dependabot[bot])
- typo: remove extraneous "`" in doc comment, fix header [#13848](https://github.com/apache/datafusion/pull/13848) (akesling)
- MINOR: typo -- remove extra "`" interfering with doc formatting [#13847](https://github.com/apache/datafusion/pull/13847) (akesling)
- Support n-ary monotonic functions in ordering equivalence [#13841](https://github.com/apache/datafusion/pull/13841) (gokselk)
- Preserve ordering equivalencies on `with_reorder` [#13770](https://github.com/apache/datafusion/pull/13770) (gokselk)
- replace CASE expressions in predicate pruning with boolean algebra [#13795](https://github.com/apache/datafusion/pull/13795) (adriangb)
- Upgrade to sqlparser `0.53.0` [#13767](https://github.com/apache/datafusion/pull/13767) (alamb)
- Minor: Use `resize` instead of `extend` for static values in SMJ logic [#13861](https://github.com/apache/datafusion/pull/13861) (comphead)
- Improve SortPreservingMerge::enable_round_robin_repartition docs [#13826](https://github.com/apache/datafusion/pull/13826) (alamb)
- Minor: Unify `downcast_arg` method [#13865](https://github.com/apache/datafusion/pull/13865) (comphead)
- Implement `SHOW FUNCTIONS` [#13799](https://github.com/apache/datafusion/pull/13799) (goldmedal)
- Update bzip2 requirement from 0.4.3 to 0.5.0 [#13740](https://github.com/apache/datafusion/pull/13740) (dependabot[bot])
- Fix build `use of undeclared type ShowStatementFilter` [#13869](https://github.com/apache/datafusion/pull/13869) (alamb)
- Minor: fix: Include FetchRel when producing LogicalPlan from Sort [#13862](https://github.com/apache/datafusion/pull/13862) (robtandy)
- Minor: improve error message when ARRAY literals can not be planned [#13859](https://github.com/apache/datafusion/pull/13859) (alamb)
- Minor: remove unused async-compression `futures-io` feature [#13875](https://github.com/apache/datafusion/pull/13875) (jonahgao)
- Consolidate Example: dataframe_output.rs into dataframe.rs [#13877](https://github.com/apache/datafusion/pull/13877) (zhuqi-lucas)
- Restore `DocBuilder::new()` to avoid breaking API change [#13870](https://github.com/apache/datafusion/pull/13870) (alamb)
- Improve error messages for incorrect zero argument signatures [#13881](https://github.com/apache/datafusion/pull/13881) (alamb)
- chore: Consolidate Example: simplify_udwf_expression.rs into advanced_udwf.rs [#13883](https://github.com/apache/datafusion/pull/13883) (xarus01)
- minor: fix typos in comments / structure names [#13879](https://github.com/apache/datafusion/pull/13879) (zhuliquan)
- Support 1 or 3 arg in generate_series() UDTF [#13856](https://github.com/apache/datafusion/pull/13856) (UBarney)
- Support (order by / sort) for DataFrameWriteOptions [#13874](https://github.com/apache/datafusion/pull/13874) (zhuqi-lucas)
- Minor: change the sort merge join emission as incremental [#13894](https://github.com/apache/datafusion/pull/13894) (berkaysynnada)
- Minor: change visibility of hash join utils [#13893](https://github.com/apache/datafusion/pull/13893) (berkaysynnada)
- Fix visibility of `swap_hash_join` to be `pub` [#13899](https://github.com/apache/datafusion/pull/13899) (alamb)
- Minor: Avoid emitting empty batches in partial sort [#13895](https://github.com/apache/datafusion/pull/13895) (berkaysynnada)
- BACKPORT: Correct return type for initcap scalar function with utf8view (#13909) [#13934](https://github.com/apache/datafusion/pull/13934) (alamb)

## Credits

Thank you to everyone who contributed to this release. Here is a breakdown of commits (PRs merged) per contributor.

```
    55	Andrew Lamb
    35	Piotr Findeisen
    16	Jonathan Chen
    14	Jonah Gao
    14	Oleks V
    12	Jay Zhan
    10	dependabot[bot]
     9	Jax Liu
     7	Mustafa Akur
     6	Peter Toth
     6	Yongting You
     5	Bruce Ritchie
     5	Dmitrii Blaginin
     5	Qianqian
     4	Adrian Garcia Badaracco
     4	Berkay Şahin
     4	Marco Neumann
     4	Tai Le Manh
     4	Tim Saucer
     4	zhuliquan
     3	Andy Grove
     3	Arttu
     3	Burak Şen
     3	Onur Satici
     3	Qi Zhu
     3	Raz Luvaton
     3	delamarch3
     3	irenjj
     2	Alex Kesling
     2	Alihan Çelikcan
     2	Daniel Hegberg
     2	Daniël Heres
     2	Dima
     2	Eduard Karacharov
     2	Filippo Rossi
     2	Goksel Kabadayi
     2	Jiashen Cao
     2	Joe Isaacs
     2	Leonardo Yvens
     2	Namgung Chan
     2	Phillip LeBlanc
     2	Ruihang Xia
     2	kamille
     2	wiedld
     1	Albert Skalt
     1	Alex Huang
     1	Alexander Huszagh
     1	Andrew Kane
     1	AnthonyZhOon
     1	Ariana J Mann
     1	Athul T R
     1	Austin Liu
     1	Brent Gardner
     1	Costi Ciudatu
     1	David Rauschenbach
     1	Dmitrii Bu
     1	Eason
     1	Emil
     1	Emil Ejbyfeldt
     1	Hengfei Yang
     1	Huaijin
     1	Jack
     1	Jack Park
     1	Jagdish Parihar
     1	Justin Zhu
     1	Kezhu Wang
     1	Kyle Barron
     1	Leslie Su
     1	Li-Lun Lin
     1	Lordworms
     1	Luca Fabbian
     1	Marc Droogh
     1	Marko Grujic
     1	Matthew B White
     1	Mehmet Ozan Kabak
     1	NoeB
     1	Paul J. Davis
     1	Rohan Krishnaswamy
     1	Sergei Grebnov
     1	Shehab Amin
     1	Sherin Jacob
     1	UBarney
     1	Victor Barua
     1	Zhang Li
     1	cht42
     1	ding-young
     1	glfeng
     1	kosiew
     1	mertak-synnada
     1	niebayes
     1	robtandy
     1	theirix
     1	xinlmain
     1	zjregee
```

Thank you also to everyone who contributed in other ways such as filing issues, reviewing PRs, and providing feedback on this release.
