// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

// TPC, TPC Benchmark, and TPC-DS and TPC-VMS are trademarks
// of the Transaction Processing Performance Council.

// Schema and queries used in these tests are copyright
// 2015 Transaction Processing Performance Council

use datafusion::common::Result;
use datafusion::datasource::MemTable;
use datafusion::prelude::{SessionConfig, SessionContext};
use std::fs;
use std::sync::Arc;
use test_utils::tpcds::tpcds_schemas;

#[tokio::test]
async fn tpcds_logical_q1() -> Result<()> {
    create_logical_plan(1).await
}

#[tokio::test]
async fn tpcds_logical_q2() -> Result<()> {
    create_logical_plan(2).await
}

#[tokio::test]
async fn tpcds_logical_q3() -> Result<()> {
    create_logical_plan(3).await
}

#[tokio::test]
async fn tpcds_logical_q4() -> Result<()> {
    create_logical_plan(4).await
}

#[tokio::test]
async fn tpcds_logical_q5() -> Result<()> {
    create_logical_plan(5).await
}

#[tokio::test]
async fn tpcds_logical_q6() -> Result<()> {
    create_logical_plan(6).await
}

#[tokio::test]
async fn tpcds_logical_q7() -> Result<()> {
    create_logical_plan(7).await
}

#[tokio::test]
async fn tpcds_logical_q8() -> Result<()> {
    create_logical_plan(8).await
}

#[tokio::test]
async fn tpcds_logical_q9() -> Result<()> {
    create_logical_plan(9).await
}

#[tokio::test]
async fn tpcds_logical_q10() -> Result<()> {
    create_logical_plan(10).await
}

#[tokio::test]
async fn tpcds_logical_q11() -> Result<()> {
    create_logical_plan(11).await
}

#[tokio::test]
async fn tpcds_logical_q12() -> Result<()> {
    create_logical_plan(12).await
}

#[tokio::test]
async fn tpcds_logical_q13() -> Result<()> {
    create_logical_plan(13).await
}

#[tokio::test]
async fn tpcds_logical_q14() -> Result<()> {
    create_logical_plan(14).await
}

#[tokio::test]
async fn tpcds_logical_q15() -> Result<()> {
    create_logical_plan(15).await
}

#[tokio::test]
async fn tpcds_logical_q16() -> Result<()> {
    create_logical_plan(16).await
}

#[tokio::test]
async fn tpcds_logical_q17() -> Result<()> {
    create_logical_plan(17).await
}

#[tokio::test]
async fn tpcds_logical_q18() -> Result<()> {
    create_logical_plan(18).await
}

#[tokio::test]
async fn tpcds_logical_q19() -> Result<()> {
    create_logical_plan(19).await
}

#[tokio::test]
async fn tpcds_logical_q20() -> Result<()> {
    create_logical_plan(20).await
}

#[tokio::test]
async fn tpcds_logical_q21() -> Result<()> {
    create_logical_plan(21).await
}

#[tokio::test]
async fn tpcds_logical_q22() -> Result<()> {
    create_logical_plan(22).await
}

#[tokio::test]
async fn tpcds_logical_q23() -> Result<()> {
    create_logical_plan(23).await
}

#[tokio::test]
async fn tpcds_logical_q24() -> Result<()> {
    create_logical_plan(24).await
}

#[tokio::test]
async fn tpcds_logical_q25() -> Result<()> {
    create_logical_plan(25).await
}

#[tokio::test]
async fn tpcds_logical_q26() -> Result<()> {
    create_logical_plan(26).await
}

#[tokio::test]
async fn tpcds_logical_q27() -> Result<()> {
    create_logical_plan(27).await
}

#[tokio::test]
async fn tpcds_logical_q28() -> Result<()> {
    create_logical_plan(28).await
}

#[tokio::test]
async fn tpcds_logical_q29() -> Result<()> {
    create_logical_plan(29).await
}

#[tokio::test]
async fn tpcds_logical_q30() -> Result<()> {
    create_logical_plan(30).await
}

#[tokio::test]
async fn tpcds_logical_q31() -> Result<()> {
    create_logical_plan(31).await
}

#[tokio::test]
async fn tpcds_logical_q32() -> Result<()> {
    create_logical_plan(32).await
}

#[tokio::test]
async fn tpcds_logical_q33() -> Result<()> {
    create_logical_plan(33).await
}

#[tokio::test]
async fn tpcds_logical_q34() -> Result<()> {
    create_logical_plan(34).await
}

#[tokio::test]
async fn tpcds_logical_q35() -> Result<()> {
    create_logical_plan(35).await
}

#[tokio::test]
async fn tpcds_logical_q36() -> Result<()> {
    create_logical_plan(36).await
}

#[tokio::test]
async fn tpcds_logical_q37() -> Result<()> {
    create_logical_plan(37).await
}

#[tokio::test]
async fn tpcds_logical_q38() -> Result<()> {
    create_logical_plan(38).await
}

#[tokio::test]
async fn tpcds_logical_q39() -> Result<()> {
    create_logical_plan(39).await
}

#[tokio::test]
async fn tpcds_logical_q40() -> Result<()> {
    create_logical_plan(40).await
}

#[tokio::test]
#[ignore]
// Optimizer rule 'scalar_subquery_to_join' failed: Optimizing disjunctions not supported!
// issue: https://github.com/apache/datafusion/issues/5368
async fn tpcds_logical_q41() -> Result<()> {
    create_logical_plan(41).await
}

#[tokio::test]
async fn tpcds_logical_q42() -> Result<()> {
    create_logical_plan(42).await
}

#[tokio::test]
async fn tpcds_logical_q43() -> Result<()> {
    create_logical_plan(43).await
}

#[tokio::test]
async fn tpcds_logical_q44() -> Result<()> {
    create_logical_plan(44).await
}

#[tokio::test]
async fn tpcds_logical_q45() -> Result<()> {
    create_logical_plan(45).await
}

#[tokio::test]
async fn tpcds_logical_q46() -> Result<()> {
    create_logical_plan(46).await
}

#[tokio::test]
async fn tpcds_logical_q47() -> Result<()> {
    create_logical_plan(47).await
}

#[tokio::test]
async fn tpcds_logical_q48() -> Result<()> {
    create_logical_plan(48).await
}

#[tokio::test]
async fn tpcds_logical_q49() -> Result<()> {
    create_logical_plan(49).await
}

#[tokio::test]
async fn tpcds_logical_q50() -> Result<()> {
    create_logical_plan(50).await
}

#[tokio::test]
async fn tpcds_logical_q51() -> Result<()> {
    create_logical_plan(51).await
}

#[tokio::test]
async fn tpcds_logical_q52() -> Result<()> {
    create_logical_plan(52).await
}

#[tokio::test]
async fn tpcds_logical_q53() -> Result<()> {
    create_logical_plan(53).await
}

#[tokio::test]
async fn tpcds_logical_q54() -> Result<()> {
    create_logical_plan(54).await
}

#[tokio::test]
async fn tpcds_logical_q55() -> Result<()> {
    create_logical_plan(55).await
}

#[tokio::test]
async fn tpcds_logical_q56() -> Result<()> {
    create_logical_plan(56).await
}

#[tokio::test]
async fn tpcds_logical_q57() -> Result<()> {
    create_logical_plan(57).await
}

#[tokio::test]
async fn tpcds_logical_q58() -> Result<()> {
    create_logical_plan(58).await
}

#[tokio::test]
async fn tpcds_logical_q59() -> Result<()> {
    create_logical_plan(59).await
}

#[tokio::test]
async fn tpcds_logical_q60() -> Result<()> {
    create_logical_plan(60).await
}

#[tokio::test]
async fn tpcds_logical_q61() -> Result<()> {
    create_logical_plan(61).await
}

#[tokio::test]
async fn tpcds_logical_q62() -> Result<()> {
    create_logical_plan(62).await
}

#[tokio::test]
async fn tpcds_logical_q63() -> Result<()> {
    create_logical_plan(63).await
}

#[tokio::test]
async fn tpcds_logical_q64() -> Result<()> {
    create_logical_plan(64).await
}

#[tokio::test]
async fn tpcds_logical_q65() -> Result<()> {
    create_logical_plan(65).await
}

#[tokio::test]
async fn tpcds_logical_q66() -> Result<()> {
    create_logical_plan(66).await
}

#[tokio::test]
async fn tpcds_logical_q67() -> Result<()> {
    create_logical_plan(67).await
}

#[tokio::test]
async fn tpcds_logical_q68() -> Result<()> {
    create_logical_plan(68).await
}

#[tokio::test]
async fn tpcds_logical_q69() -> Result<()> {
    create_logical_plan(69).await
}

#[tokio::test]
async fn tpcds_logical_q70() -> Result<()> {
    create_logical_plan(70).await
}

#[tokio::test]
async fn tpcds_logical_q71() -> Result<()> {
    create_logical_plan(71).await
}

#[tokio::test]
async fn tpcds_logical_q72() -> Result<()> {
    create_logical_plan(72).await
}

#[tokio::test]
async fn tpcds_logical_q73() -> Result<()> {
    create_logical_plan(73).await
}

#[tokio::test]
async fn tpcds_logical_q74() -> Result<()> {
    create_logical_plan(74).await
}

#[tokio::test]
async fn tpcds_logical_q75() -> Result<()> {
    create_logical_plan(75).await
}

#[tokio::test]
async fn tpcds_logical_q76() -> Result<()> {
    create_logical_plan(76).await
}

#[tokio::test]
async fn tpcds_logical_q77() -> Result<()> {
    create_logical_plan(77).await
}

#[tokio::test]
async fn tpcds_logical_q78() -> Result<()> {
    create_logical_plan(78).await
}

#[tokio::test]
async fn tpcds_logical_q79() -> Result<()> {
    create_logical_plan(79).await
}

#[tokio::test]
async fn tpcds_logical_q80() -> Result<()> {
    create_logical_plan(80).await
}

#[tokio::test]
async fn tpcds_logical_q81() -> Result<()> {
    create_logical_plan(81).await
}

#[tokio::test]
async fn tpcds_logical_q82() -> Result<()> {
    create_logical_plan(82).await
}

#[tokio::test]
async fn tpcds_logical_q83() -> Result<()> {
    create_logical_plan(83).await
}

#[tokio::test]
async fn tpcds_logical_q84() -> Result<()> {
    create_logical_plan(84).await
}

#[tokio::test]
async fn tpcds_logical_q85() -> Result<()> {
    create_logical_plan(85).await
}

#[tokio::test]
async fn tpcds_logical_q86() -> Result<()> {
    create_logical_plan(86).await
}

#[tokio::test]
async fn tpcds_logical_q87() -> Result<()> {
    create_logical_plan(87).await
}

#[tokio::test]
async fn tpcds_logical_q88() -> Result<()> {
    create_logical_plan(88).await
}

#[tokio::test]
async fn tpcds_logical_q89() -> Result<()> {
    create_logical_plan(89).await
}

#[tokio::test]
async fn tpcds_logical_q90() -> Result<()> {
    create_logical_plan(90).await
}

#[tokio::test]
async fn tpcds_logical_q91() -> Result<()> {
    create_logical_plan(91).await
}

#[tokio::test]
async fn tpcds_logical_q92() -> Result<()> {
    create_logical_plan(92).await
}

#[tokio::test]
async fn tpcds_logical_q93() -> Result<()> {
    create_logical_plan(93).await
}

#[tokio::test]
async fn tpcds_logical_q94() -> Result<()> {
    create_logical_plan(94).await
}

#[tokio::test]
async fn tpcds_logical_q95() -> Result<()> {
    create_logical_plan(95).await
}

#[tokio::test]
async fn tpcds_logical_q96() -> Result<()> {
    create_logical_plan(96).await
}

#[tokio::test]
async fn tpcds_logical_q97() -> Result<()> {
    create_logical_plan(97).await
}

#[tokio::test]
async fn tpcds_logical_q98() -> Result<()> {
    create_logical_plan(98).await
}

#[tokio::test]
async fn tpcds_logical_q99() -> Result<()> {
    create_logical_plan(99).await
}

#[tokio::test]
async fn tpcds_physical_q1() -> Result<()> {
    create_physical_plan(1).await
}

#[tokio::test]
async fn tpcds_physical_q2() -> Result<()> {
    create_physical_plan(2).await
}

#[tokio::test]
async fn tpcds_physical_q3() -> Result<()> {
    create_physical_plan(3).await
}

#[tokio::test]
async fn tpcds_physical_q4() -> Result<()> {
    create_physical_plan(4).await
}

#[tokio::test]
async fn tpcds_physical_q5() -> Result<()> {
    create_physical_plan(5).await
}

#[tokio::test]
async fn tpcds_physical_q6() -> Result<()> {
    create_physical_plan(6).await
}

#[tokio::test]
async fn tpcds_physical_q7() -> Result<()> {
    create_physical_plan(7).await
}

#[tokio::test]
async fn tpcds_physical_q8() -> Result<()> {
    create_physical_plan(8).await
}

#[tokio::test]
async fn tpcds_physical_q9() -> Result<()> {
    create_physical_plan(9).await
}

#[ignore] // Physical plan does not support logical expression Exists(<subquery>)
#[tokio::test]
async fn tpcds_physical_q10() -> Result<()> {
    create_physical_plan(10).await
}

#[tokio::test]
async fn tpcds_physical_q11() -> Result<()> {
    create_physical_plan(11).await
}

#[tokio::test]
async fn tpcds_physical_q12() -> Result<()> {
    create_physical_plan(12).await
}

#[tokio::test]
async fn tpcds_physical_q13() -> Result<()> {
    create_physical_plan(13).await
}

#[tokio::test]
async fn tpcds_physical_q14() -> Result<()> {
    create_physical_plan(14).await
}

#[tokio::test]
async fn tpcds_physical_q15() -> Result<()> {
    create_physical_plan(15).await
}

#[tokio::test]
async fn tpcds_physical_q16() -> Result<()> {
    create_physical_plan(16).await
}

#[tokio::test]
async fn tpcds_physical_q17() -> Result<()> {
    create_physical_plan(17).await
}

#[tokio::test]
async fn tpcds_physical_q18() -> Result<()> {
    create_physical_plan(18).await
}

#[tokio::test]
async fn tpcds_physical_q19() -> Result<()> {
    create_physical_plan(19).await
}

#[tokio::test]
async fn tpcds_physical_q20() -> Result<()> {
    create_physical_plan(20).await
}

#[tokio::test]
async fn tpcds_physical_q21() -> Result<()> {
    create_physical_plan(21).await
}

#[tokio::test]
async fn tpcds_physical_q22() -> Result<()> {
    create_physical_plan(22).await
}

#[tokio::test]
async fn tpcds_physical_q23() -> Result<()> {
    create_physical_plan(23).await
}

#[tokio::test]
async fn tpcds_physical_q24() -> Result<()> {
    create_physical_plan(24).await
}

#[tokio::test]
async fn tpcds_physical_q25() -> Result<()> {
    create_physical_plan(25).await
}

#[tokio::test]
async fn tpcds_physical_q26() -> Result<()> {
    create_physical_plan(26).await
}

#[tokio::test]
async fn tpcds_physical_q27() -> Result<()> {
    create_physical_plan(27).await
}

#[tokio::test]
async fn tpcds_physical_q28() -> Result<()> {
    create_physical_plan(28).await
}

#[tokio::test]
async fn tpcds_physical_q29() -> Result<()> {
    create_physical_plan(29).await
}

#[tokio::test]
async fn tpcds_physical_q30() -> Result<()> {
    create_physical_plan(30).await
}

#[tokio::test]
async fn tpcds_physical_q31() -> Result<()> {
    create_physical_plan(31).await
}

#[tokio::test]
async fn tpcds_physical_q32() -> Result<()> {
    create_physical_plan(32).await
}

#[tokio::test]
async fn tpcds_physical_q33() -> Result<()> {
    create_physical_plan(33).await
}

#[tokio::test]
async fn tpcds_physical_q34() -> Result<()> {
    create_physical_plan(34).await
}

#[ignore] // Physical plan does not support logical expression Exists(<subquery>)
#[tokio::test]
async fn tpcds_physical_q35() -> Result<()> {
    create_physical_plan(35).await
}

#[tokio::test]
async fn tpcds_physical_q36() -> Result<()> {
    create_physical_plan(36).await
}

#[tokio::test]
async fn tpcds_physical_q37() -> Result<()> {
    create_physical_plan(37).await
}

#[tokio::test]
async fn tpcds_physical_q38() -> Result<()> {
    create_physical_plan(38).await
}

#[tokio::test]
async fn tpcds_physical_q39() -> Result<()> {
    create_physical_plan(39).await
}

#[tokio::test]
async fn tpcds_physical_q40() -> Result<()> {
    create_physical_plan(40).await
}

#[ignore]
// Context("check_analyzed_plan", Plan("Correlated column is not allowed in predicate: (..)
#[tokio::test]
async fn tpcds_physical_q41() -> Result<()> {
    create_physical_plan(41).await
}

#[tokio::test]
async fn tpcds_physical_q42() -> Result<()> {
    create_physical_plan(42).await
}

#[tokio::test]
async fn tpcds_physical_q43() -> Result<()> {
    create_physical_plan(43).await
}

#[tokio::test]
async fn tpcds_physical_q44() -> Result<()> {
    create_physical_plan(44).await
}

#[ignore] // Physical plan does not support logical expression (<subquery>)
#[tokio::test]
async fn tpcds_physical_q45() -> Result<()> {
    create_physical_plan(45).await
}

#[tokio::test]
async fn tpcds_physical_q46() -> Result<()> {
    create_physical_plan(46).await
}

#[tokio::test]
async fn tpcds_physical_q47() -> Result<()> {
    create_physical_plan(47).await
}

#[tokio::test]
async fn tpcds_physical_q48() -> Result<()> {
    create_physical_plan(48).await
}

#[tokio::test]
async fn tpcds_physical_q49() -> Result<()> {
    create_physical_plan(49).await
}

#[tokio::test]
async fn tpcds_physical_q50() -> Result<()> {
    create_physical_plan(50).await
}

#[tokio::test]
async fn tpcds_physical_q51() -> Result<()> {
    create_physical_plan(51).await
}

#[tokio::test]
async fn tpcds_physical_q52() -> Result<()> {
    create_physical_plan(52).await
}

#[tokio::test]
async fn tpcds_physical_q53() -> Result<()> {
    create_physical_plan(53).await
}

#[tokio::test]
async fn tpcds_physical_q54() -> Result<()> {
    create_physical_plan(54).await
}

#[tokio::test]
async fn tpcds_physical_q55() -> Result<()> {
    create_physical_plan(55).await
}

#[tokio::test]
async fn tpcds_physical_q56() -> Result<()> {
    create_physical_plan(56).await
}

#[tokio::test]
async fn tpcds_physical_q57() -> Result<()> {
    create_physical_plan(57).await
}

#[tokio::test]
async fn tpcds_physical_q58() -> Result<()> {
    create_physical_plan(58).await
}

#[tokio::test]
async fn tpcds_physical_q59() -> Result<()> {
    create_physical_plan(59).await
}

#[tokio::test]
async fn tpcds_physical_q60() -> Result<()> {
    create_physical_plan(60).await
}

#[tokio::test]
async fn tpcds_physical_q61() -> Result<()> {
    create_physical_plan(61).await
}

#[tokio::test]
async fn tpcds_physical_q62() -> Result<()> {
    create_physical_plan(62).await
}

#[tokio::test]
async fn tpcds_physical_q63() -> Result<()> {
    create_physical_plan(63).await
}

#[tokio::test]
async fn tpcds_physical_q64() -> Result<()> {
    create_physical_plan(64).await
}

#[tokio::test]
async fn tpcds_physical_q65() -> Result<()> {
    create_physical_plan(65).await
}

#[tokio::test]
async fn tpcds_physical_q66() -> Result<()> {
    create_physical_plan(66).await
}

#[tokio::test]
async fn tpcds_physical_q67() -> Result<()> {
    create_physical_plan(67).await
}

#[tokio::test]
async fn tpcds_physical_q68() -> Result<()> {
    create_physical_plan(68).await
}

#[tokio::test]
async fn tpcds_physical_q69() -> Result<()> {
    create_physical_plan(69).await
}

#[tokio::test]
async fn tpcds_physical_q70() -> Result<()> {
    create_physical_plan(70).await
}

#[tokio::test]
async fn tpcds_physical_q71() -> Result<()> {
    create_physical_plan(71).await
}

#[tokio::test]
async fn tpcds_physical_q72() -> Result<()> {
    create_physical_plan(72).await
}

#[tokio::test]
async fn tpcds_physical_q73() -> Result<()> {
    create_physical_plan(73).await
}

#[tokio::test]
async fn tpcds_physical_q74() -> Result<()> {
    create_physical_plan(74).await
}

#[tokio::test]
async fn tpcds_physical_q75() -> Result<()> {
    create_physical_plan(75).await
}

#[tokio::test]
async fn tpcds_physical_q76() -> Result<()> {
    create_physical_plan(76).await
}

#[tokio::test]
async fn tpcds_physical_q77() -> Result<()> {
    create_physical_plan(77).await
}

#[tokio::test]
async fn tpcds_physical_q78() -> Result<()> {
    create_physical_plan(78).await
}

#[tokio::test]
async fn tpcds_physical_q79() -> Result<()> {
    create_physical_plan(79).await
}

#[tokio::test]
async fn tpcds_physical_q80() -> Result<()> {
    create_physical_plan(80).await
}

#[tokio::test]
async fn tpcds_physical_q81() -> Result<()> {
    create_physical_plan(81).await
}

#[tokio::test]
async fn tpcds_physical_q82() -> Result<()> {
    create_physical_plan(82).await
}

#[tokio::test]
async fn tpcds_physical_q83() -> Result<()> {
    create_physical_plan(83).await
}

#[tokio::test]
async fn tpcds_physical_q84() -> Result<()> {
    create_physical_plan(84).await
}

#[tokio::test]
async fn tpcds_physical_q85() -> Result<()> {
    create_physical_plan(85).await
}

#[tokio::test]
async fn tpcds_physical_q86() -> Result<()> {
    create_physical_plan(86).await
}

#[tokio::test]
async fn tpcds_physical_q87() -> Result<()> {
    create_physical_plan(87).await
}

#[tokio::test]
async fn tpcds_physical_q88() -> Result<()> {
    create_physical_plan(88).await
}

#[tokio::test]
async fn tpcds_physical_q89() -> Result<()> {
    create_physical_plan(89).await
}

#[tokio::test]
async fn tpcds_physical_q90() -> Result<()> {
    create_physical_plan(90).await
}

#[tokio::test]
async fn tpcds_physical_q91() -> Result<()> {
    create_physical_plan(91).await
}

#[tokio::test]
async fn tpcds_physical_q92() -> Result<()> {
    create_physical_plan(92).await
}

#[tokio::test]
async fn tpcds_physical_q93() -> Result<()> {
    create_physical_plan(93).await
}

#[tokio::test]
async fn tpcds_physical_q94() -> Result<()> {
    create_physical_plan(94).await
}

#[tokio::test]
async fn tpcds_physical_q95() -> Result<()> {
    create_physical_plan(95).await
}

#[tokio::test]
async fn tpcds_physical_q96() -> Result<()> {
    create_physical_plan(96).await
}

#[tokio::test]
async fn tpcds_physical_q97() -> Result<()> {
    create_physical_plan(97).await
}

#[tokio::test]
async fn tpcds_physical_q98() -> Result<()> {
    create_physical_plan(98).await
}

#[tokio::test]
async fn tpcds_physical_q99() -> Result<()> {
    create_physical_plan(99).await
}

async fn create_logical_plan(query_no: u8) -> Result<()> {
    regression_test(query_no, false).await
}

async fn create_physical_plan(query_no: u8) -> Result<()> {
    regression_test(query_no, true).await
}

async fn regression_test(query_no: u8, create_physical: bool) -> Result<()> {
    let filename = format!("tests/tpc-ds/{query_no}.sql");
    let sql = fs::read_to_string(filename).expect("Could not read query");

    let config = SessionConfig::default();
    let ctx = SessionContext::new_with_config(config);
    let tables = tpcds_schemas();
    for table in &tables {
        ctx.register_table(
            table.name.as_str(),
            Arc::new(MemTable::try_new(
                Arc::new(table.schema.clone()),
                vec![vec![]],
            )?),
        )?;
    }

    // some queries have multiple statements
    let sql = sql
        .split(';')
        .filter(|s| !s.trim().is_empty())
        .collect::<Vec<_>>();

    for sql in &sql {
        let df = ctx.sql(sql).await?;
        let (state, plan) = df.into_parts();
        let plan = state.optimize(&plan)?;
        if create_physical {
            let _ = state.create_physical_plan(&plan).await?;
        }
    }

    Ok(())
}
