<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements. See the NOTICE file
distributed with this work for additional information
regarding copyright ownership. The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License. You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied. See the License for the
specific language governing permissions and limitations
under the License.
-->

# Roadmap

The [project introduction](../user-guide/introduction) explains the
overview and goals of DataFusion, and our development efforts largely
align to that vision.

## Planning `EPIC`s

DataFusion uses [GitHub
issues](https://github.com/apache/datafusion/issues) to track
planned work. We collect related tickets using tracking issues labeled
with `[EPIC]` which contain discussion and links to more detailed items.

Epics offer a high level roadmap of what the DataFusion
community is thinking about. The epics are not meant to restrict
possibilities, but rather help the community see where development is
headed, align our work, and inspire additional contributions.

As this project is entirely driven by volunteers, we welcome
contributions for items not currently covered by epics. However,
before submitting a large PR, we strongly suggest and request you
start a conversation using a github issue or the
[dev@arrow.apache.org](mailto:dev@arrow.apache.org) mailing list to
make review efficient and avoid surprises.

[The current list of `EPIC`s can be found here](https://github.com/apache/datafusion/issues?q=is%3Aissue+is%3Aopen+epic).
