/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.DiagnosticClause;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.functions.Trace;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public class DiagnosticClausePush
extends TuplePush {
    TuplePush destination;
    DiagnosticClause diagClause;
    int tupleSeq = 1;

    public DiagnosticClausePush(Outputter outputter, TuplePush destination, DiagnosticClause diagClause) {
        super(outputter);
        this.destination = destination;
        this.diagClause = diagClause;
    }

    @Override
    public void processTuple(XPathContext context) throws XPathException {
        Item item;
        SequenceIterator val = this.diagClause.getEvaluator().iterate(context);
        Logger out = context.getController().getTraceFunctionDestination();
        int pos = 1;
        while ((item = val.next()) != null) {
            String label = "FLWOR-> " + this.tupleSeq + "/" + pos++;
            Trace.traceItem(item, label, out);
        }
        this.destination.processTuple(context);
        ++this.tupleSeq;
    }

    @Override
    public void close() throws XPathException {
        this.destination.close();
    }
}

