/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.layers.runtime1;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.daffodil.layers.runtime1.GZIPFixedOutputStream;
import org.apache.daffodil.runtime1.layers.api.Layer;

public final class GZipLayer
extends Layer {
    private static Boolean fixNeeded = null;

    public static boolean fixIsNeeded() {
        if (Objects.isNull(fixNeeded)) {
            int n;
            String string = System.getProperty("java.version");
            if (string.startsWith("1.8")) {
                n = 8;
            } else {
                String[] stringArray = string.split("\\.");
                assert (stringArray.length > 0);
                n = Integer.parseInt(stringArray[0]);
            }
            fixNeeded = n < 16;
        }
        return fixNeeded;
    }

    public GZipLayer() {
        super("gzip", "urn:org.apache.daffodil.layers.gzip");
        this.setProcessingErrorException(IOException.class);
    }

    public InputStream wrapLayerInput(InputStream inputStream) throws Exception {
        return new GZIPInputStream(inputStream);
    }

    public OutputStream wrapLayerOutput(OutputStream outputStream) throws Exception {
        OutputStream outputStream2 = GZipLayer.fixIsNeeded() ? new GZIPFixedOutputStream(outputStream) : outputStream;
        return new GZIPOutputStream(outputStream2);
    }
}

