/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans.rules;

import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.ma.arrays.ArrayItem;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.rules.ShallowSkipRuleSet;

public class ShallowSkipAllRuleSet
extends ShallowSkipRuleSet {
    private static final ShallowSkipAllRuleSet THE_INSTANCE = new ShallowSkipAllRuleSet();

    public static ShallowSkipAllRuleSet getInstance() {
        return THE_INSTANCE;
    }

    private ShallowSkipAllRuleSet() {
    }

    @Override
    public void process(Item item, ParameterSet parameters, ParameterSet tunnelParams, Outputter out, XPathContext context, Location locationId) throws XPathException {
        if (item instanceof ArrayItem) {
            SequenceIterator iter = ((ArrayItem)item).parcels();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.trackFocus(iter);
            c2.setCurrentComponent(c2.getCurrentMode());
            for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, null, out, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
            }
        } else if (item instanceof MapItem) {
            int size = ((MapItem)item).size();
            if (size <= 1) {
                return;
            }
            SequenceIterator iter = ((MapItem)item).entries();
            XPathContextMajor c2 = context.newContext();
            c2.setOrigin(this);
            c2.trackFocus(iter);
            c2.setCurrentComponent(c2.getCurrentMode());
            for (TailCall tc = context.getCurrentMode().getActor().applyTemplates(parameters, tunnelParams, null, out, c2, locationId); tc != null; tc = tc.processLeavingTail()) {
            }
        } else {
            super.process(item, parameters, tunnelParams, out, context, locationId);
        }
    }

    @Override
    public String getName() {
        return "shallow-skip-all";
    }
}

