/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.IDFilter;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ProtocolRestrictor;
import net.sf.saxon.lib.ResourceRequest;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.resource.ResourceLoader;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.InputSource;

public class DirectResourceResolver
implements ResourceResolver {
    private final Configuration config;

    public DirectResourceResolver(Configuration config) {
        this.config = config;
    }

    @Override
    public Source resolve(ResourceRequest request) throws XPathException {
        InputStream stream;
        String relativeURI;
        if (request.uriIsNamespace) {
            return null;
        }
        ProtocolRestrictor restrictor = this.config.getProtocolRestrictor();
        if (!"all".equals(restrictor.toString())) {
            try {
                URI u = new URI(request.uri);
                if (!restrictor.test(u)) {
                    throw new XPathException("URIs using protocol " + u.getScheme() + " are not permitted");
                }
            }
            catch (URISyntaxException err) {
                throw new XPathException("Unknown URI scheme requested " + request.uri);
            }
        }
        if ((relativeURI = request.relativeUri) == null) {
            relativeURI = request.uri;
        }
        String id = null;
        int hash = relativeURI.indexOf(35);
        if (hash >= 0) {
            request = request.copy();
            request.relativeUri = relativeURI.substring(0, hash);
            id = relativeURI.substring(hash + 1);
        }
        if ("https://www.iana.org/assignments/media-types/application/binary".equals(request.nature)) {
            try {
                return ResourceLoader.typedStreamSource(this.config, request.uri);
            }
            catch (IOException e) {
                throw new XPathException("Cannot read " + request.uri, e);
            }
        }
        try {
            stream = ResourceLoader.urlStream(this.config, request.uri);
        }
        catch (IOException e) {
            stream = null;
        }
        InputSource is = new InputSource(request.uri);
        is.setByteStream(stream);
        Source ss = new SAXSource(this.config.getStyleParser(), is);
        if (stream != null) {
            ss = AugmentedSource.makeAugmentedSource(ss);
            ((AugmentedSource)ss).setPleaseCloseAfterUse(true);
        }
        if (id != null) {
            String idFinal = id;
            FilterFactory factory = next -> new IDFilter(next, idFinal);
            ss = AugmentedSource.makeAugmentedSource(ss);
            ((AugmentedSource)ss).addFilter(factory);
        }
        return ss;
    }
}

