/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.StaticFunctionCall;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemElaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.Number_1;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class Substring
extends SystemFunction
implements Callable {
    @Override
    public Expression typeCheckCaller(FunctionCall caller, ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        Expression a2;
        Expression a1;
        Expression e2 = super.typeCheckCaller(caller, visitor, contextInfo);
        if (e2 != caller) {
            return e2;
        }
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        if (caller.getArg(1).isCallOn(Number_1.class) && th.isSubType((a1 = ((StaticFunctionCall)caller.getArg(1)).getArg(0)).getItemType(), BuiltInAtomicType.INTEGER)) {
            caller.setArg(1, a1);
        }
        if (this.getArity() > 2 && caller.getArg(2).isCallOn(Number_1.class) && th.isSubType((a2 = ((StaticFunctionCall)caller.getArg(2)).getArg(0)).getItemType(), BuiltInAtomicType.INTEGER)) {
            caller.setArg(2, a2);
        }
        return caller;
    }

    public static StringValue substring(StringValue sv, NumericValue start) {
        long lstart;
        long slength = sv.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > slength) {
                return StringValue.EMPTY_STRING;
            }
            if (lstart <= 0L) {
                lstart = 1L;
            }
        } else {
            if (start.isNaN()) {
                return StringValue.EMPTY_STRING;
            }
            if (start.signum() <= 0) {
                return sv;
            }
            if (start.compareTo(slength) > 0) {
                return StringValue.EMPTY_STRING;
            }
            lstart = Math.round(start.getDoubleValue());
        }
        if (lstart > slength) {
            return StringValue.EMPTY_STRING;
        }
        return new StringValue(sv.getContent().substring((int)lstart - 1, slength));
    }

    public static StringValue substring(StringValue sv, NumericValue start, NumericValue len) {
        long lend;
        long llen;
        long lstart;
        long slength = sv.length();
        if (start instanceof Int64Value) {
            lstart = ((Int64Value)start).longValue();
            if (lstart > slength) {
                return StringValue.EMPTY_STRING;
            }
        } else {
            if (start.isNaN()) {
                return StringValue.EMPTY_STRING;
            }
            if (start.compareTo(slength) > 0) {
                return StringValue.EMPTY_STRING;
            }
            double dstart = start.getDoubleValue();
            long l = lstart = Double.isInfinite(dstart) ? -2147483647L : Math.round(dstart);
        }
        if (len instanceof Int64Value) {
            llen = ((Int64Value)len).longValue();
            if (llen <= 0L) {
                return StringValue.EMPTY_STRING;
            }
        } else {
            if (len.isNaN()) {
                return StringValue.EMPTY_STRING;
            }
            if (len.signum() <= 0) {
                return StringValue.EMPTY_STRING;
            }
            double dlen = len.getDoubleValue();
            llen = Double.isInfinite(dlen) ? Integer.MAX_VALUE : Math.round(len.getDoubleValue());
        }
        if ((lend = lstart + llen) < lstart) {
            return StringValue.EMPTY_STRING;
        }
        int a1 = (int)lstart - 1;
        if ((long)a1 >= slength) {
            return StringValue.EMPTY_STRING;
        }
        long a2 = Math.min(slength, (long)((int)lend - 1));
        if (a1 < 0) {
            if (a2 < 0L) {
                return StringValue.EMPTY_STRING;
            }
            a1 = 0;
        }
        return new StringValue(sv.getContent().substring(a1, a2));
    }

    @Override
    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        StringValue arg0 = (StringValue)arguments[0].head();
        if (arg0 == null) {
            return StringValue.EMPTY_STRING;
        }
        NumericValue arg1 = (NumericValue)arguments[1].head();
        if (arguments.length == 2) {
            return Substring.substring(arg0, arg1);
        }
        NumericValue arg2 = (NumericValue)arguments[2].head();
        return Substring.substring(arg0, arg1, arg2);
    }

    @Override
    public Elaborator getElaborator() {
        return new SubstringFnElaborator();
    }

    public static class SubstringFnElaborator
    extends ItemElaborator {
        @Override
        public ItemEvaluator elaborateForItem() {
            SystemFunctionCall fnc = (SystemFunctionCall)this.getExpression();
            ItemEvaluator arg0Eval = fnc.getArg(0).makeElaborator().elaborateForItem();
            ItemEvaluator arg1Eval = fnc.getArg(1).makeElaborator().elaborateForItem();
            boolean nullable = Cardinality.allowsZero(fnc.getArg(0).getCardinality());
            if (fnc.getArity() == 2) {
                return context -> {
                    StringValue sv = (StringValue)arg0Eval.eval(context);
                    if (nullable && sv == null) {
                        return StringValue.EMPTY_STRING;
                    }
                    NumericValue start = (NumericValue)arg1Eval.eval(context);
                    return Substring.substring(sv, start);
                };
            }
            ItemEvaluator arg2Eval = fnc.getArg(2).makeElaborator().elaborateForItem();
            return context -> {
                StringValue sv = (StringValue)arg0Eval.eval(context);
                if (nullable && sv == null) {
                    return StringValue.EMPTY_STRING;
                }
                NumericValue start = (NumericValue)arg1Eval.eval(context);
                NumericValue len = (NumericValue)arg2Eval.eval(context);
                return Substring.substring(sv, start, len);
            };
        }
    }
}

