/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatetimeDatatype;
import com.siemens.ct.exi.core.datatype.EnumDatatype;
import com.siemens.ct.exi.core.datatype.EnumerationDatatype;
import com.siemens.ct.exi.core.datatype.ExtendedStringDatatype;
import com.siemens.ct.exi.core.datatype.ListDatatype;
import com.siemens.ct.exi.core.datatype.NBitUnsignedIntegerDatatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.strings.StringCoder;
import com.siemens.ct.exi.core.datatype.strings.StringDecoder;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.DecoderChannel;
import com.siemens.ct.exi.core.types.AbstractTypeDecoder;
import com.siemens.ct.exi.core.values.BinaryBase64Value;
import com.siemens.ct.exi.core.values.BinaryHexValue;
import com.siemens.ct.exi.core.values.BooleanValue;
import com.siemens.ct.exi.core.values.IntegerValue;
import com.siemens.ct.exi.core.values.ListValue;
import com.siemens.ct.exi.core.values.StringValue;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedTypeDecoder
extends AbstractTypeDecoder {
    public TypedTypeDecoder() throws EXIException {
        this(null, null, null);
    }

    public TypedTypeDecoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    @Override
    public Value readValue(Datatype datatype, QNameContext qnContext, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        if (this.dtrMapInUse) {
            datatype = this.getDtrDatatype(datatype);
        }
        switch (datatype.getBuiltInType()) {
            case BINARY_BASE64: {
                return new BinaryBase64Value(valueChannel.decodeBinary());
            }
            case BINARY_HEX: {
                return new BinaryHexValue(valueChannel.decodeBinary());
            }
            case BOOLEAN: {
                return valueChannel.decodeBooleanValue();
            }
            case BOOLEAN_FACET: {
                int booleanID = valueChannel.decodeNBitUnsignedInteger(2);
                return BooleanValue.getBooleanValue(booleanID);
            }
            case DECIMAL: {
                return valueChannel.decodeDecimalValue();
            }
            case FLOAT: {
                return valueChannel.decodeFloatValue();
            }
            case NBIT_UNSIGNED_INTEGER: {
                NBitUnsignedIntegerDatatype nbitDT = (NBitUnsignedIntegerDatatype)datatype;
                IntegerValue iv = valueChannel.decodeNBitUnsignedIntegerValue(nbitDT.getNumberOfBits());
                return iv.add(nbitDT.getLowerBound());
            }
            case UNSIGNED_INTEGER: {
                return valueChannel.decodeUnsignedIntegerValue();
            }
            case INTEGER: {
                return valueChannel.decodeIntegerValue();
            }
            case DATETIME: {
                DatetimeDatatype dtDT = (DatetimeDatatype)datatype;
                return valueChannel.decodeDateTimeValue(dtDT.getDatetimeType());
            }
            case STRING: {
                return stringDecoder.readValue(qnContext, valueChannel);
            }
            case RCS_STRING: {
                RestrictedCharacterSetDatatype rcsDT = (RestrictedCharacterSetDatatype)datatype;
                return this.readRCSValue(rcsDT, qnContext, valueChannel, stringDecoder);
            }
            case EXTENDED_STRING: {
                ExtendedStringDatatype esDT = (ExtendedStringDatatype)datatype;
                return this.readExtendedString(esDT, qnContext, valueChannel, stringDecoder);
            }
            case ENUMERATION: {
                EnumerationDatatype enumDT = (EnumerationDatatype)datatype;
                int index = valueChannel.decodeNBitUnsignedInteger(enumDT.getCodingLength());
                assert (index >= 0 && index < enumDT.getEnumerationSize());
                return enumDT.getEnumValue(index);
            }
            case LIST: {
                ListDatatype lDT = (ListDatatype)datatype;
                Datatype listDatatype = lDT.getListDatatype();
                int len = valueChannel.decodeUnsignedInteger();
                Value[] values = new Value[len];
                for (int l = 0; l < len; ++l) {
                    values[l] = this.readValue(listDatatype, qnContext, valueChannel, stringDecoder);
                }
                ListValue retVal = new ListValue(values, listDatatype);
                return retVal;
            }
            case QNAME: {
                throw new IOException("QName is not an allowed as EXI datatype");
            }
        }
        return null;
    }

    protected StringValue readExtendedString(ExtendedStringDatatype esDT, QNameContext context, DecoderChannel valueChannel, StringDecoder stringDecoder) throws IOException {
        EnumDatatype grammarStrings = esDT.getGrammarStrings();
        StringValue value = null;
        int i = valueChannel.decodeUnsignedInteger();
        switch (i) {
            case 0: {
                if (stringDecoder.isLocalValuePartitions()) {
                    value = stringDecoder.readValueLocalHit(context, valueChannel);
                    break;
                }
                throw new IOException("EXI stream contains local-value hit even though profile options indicate otherwise.");
            }
            case 1: {
                value = stringDecoder.readValueGlobalHit(valueChannel);
                break;
            }
            case 2: {
                int index = valueChannel.decodeNBitUnsignedInteger(grammarStrings.getCodingLength());
                assert (index >= 0 && index < grammarStrings.getEnumerationSize());
                Value v = grammarStrings.getEnumValue(index);
                if (v instanceof StringValue) {
                    value = (StringValue)v;
                    break;
                }
                value = new StringValue(v.toString());
                break;
            }
            case 3: {
                throw new IOException("ExtendedString, no support for <shared string>");
            }
            case 4: {
                throw new IOException("ExtendedString, no support for <split string>");
            }
            case 5: {
                throw new IOException("ExtendedString, no support for <undefined>");
            }
            default: {
                int L = i - 6;
                if (L > 0) {
                    value = new StringValue(valueChannel.decodeStringOnly(L));
                    stringDecoder.addValue(context, value);
                    break;
                }
                value = StringCoder.EMPTY_STRING_VALUE;
            }
        }
        assert (value != null);
        return value;
    }
}

