/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.charset.RestrictedCharacterSet;
import com.siemens.ct.exi.core.datatype.strings.StringEncoder;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.EncoderChannel;
import com.siemens.ct.exi.core.types.AbstractTypeCoder;
import com.siemens.ct.exi.core.types.TypeEncoder;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeEncoder
extends AbstractTypeCoder
implements TypeEncoder {
    public AbstractTypeEncoder() throws EXIException {
        this(null, null, null);
    }

    public AbstractTypeEncoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
    }

    protected void writeRCSValue(RestrictedCharacterSetDatatype rcsDT, QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder, String lastValidValue) throws IOException {
        if (stringEncoder.isStringHit(lastValidValue)) {
            stringEncoder.writeValue(qnContext, valueChannel, lastValidValue);
        } else {
            int L = lastValidValue.length();
            valueChannel.encodeUnsignedInteger(L + 2);
            RestrictedCharacterSet rcs = rcsDT.getRestrictedCharacterSet();
            if (L > 0) {
                int numberOfBits = rcs.getCodingLength();
                for (int i = 0; i < L; ++i) {
                    int codePoint = lastValidValue.codePointAt(i);
                    int code = rcs.getCode(codePoint);
                    if (code == -1) {
                        valueChannel.encodeNBitUnsignedInteger(rcs.size(), numberOfBits);
                        valueChannel.encodeUnsignedInteger(codePoint);
                        continue;
                    }
                    valueChannel.encodeNBitUnsignedInteger(code, numberOfBits);
                }
                stringEncoder.addValue(qnContext, lastValidValue);
            }
        }
    }
}

