/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.coder;

import com.siemens.ct.exi.core.CodingMode;
import com.siemens.ct.exi.core.EXIFactory;
import com.siemens.ct.exi.core.coder.AbstractEXIBodyCoder;
import com.siemens.ct.exi.core.coder.AbstractEXIBodyDecoder;
import com.siemens.ct.exi.core.container.DocType;
import com.siemens.ct.exi.core.container.NamespaceDeclaration;
import com.siemens.ct.exi.core.container.ProcessingInstruction;
import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.grammars.event.EventType;
import com.siemens.ct.exi.core.io.channel.BitDecoderChannel;
import com.siemens.ct.exi.core.io.channel.ByteDecoderChannel;
import com.siemens.ct.exi.core.io.channel.DecoderChannel;
import com.siemens.ct.exi.core.types.BuiltIn;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EXIBodyDecoderInOrder
extends AbstractEXIBodyDecoder {
    public EXIBodyDecoderInOrder(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
    }

    @Override
    public void setInputStream(InputStream is) throws EXIException, IOException {
        this.updateInputStream(is);
        this.initForEachRun();
    }

    @Override
    public void setInputChannel(DecoderChannel decoderChannel) throws EXIException, IOException {
        this.updateInputChannel(decoderChannel);
        this.initForEachRun();
    }

    @Override
    public void updateInputStream(InputStream is) throws EXIException, IOException {
        CodingMode codingMode = this.exiFactory.getCodingMode();
        if (codingMode == CodingMode.BIT_PACKED) {
            this.updateInputChannel(new BitDecoderChannel(is));
        } else {
            assert (codingMode == CodingMode.BYTE_PACKED);
            this.updateInputChannel(new ByteDecoderChannel(is));
        }
    }

    @Override
    public void updateInputChannel(DecoderChannel decoderChannel) throws EXIException, IOException {
        this.channel = decoderChannel;
    }

    public DecoderChannel getChannel() {
        return this.channel;
    }

    @Override
    public void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.nextEvent = null;
        this.nextEventType = EventType.START_DOCUMENT;
    }

    @Override
    public EventType next() throws EXIException, IOException {
        return this.nextEventType == EventType.END_DOCUMENT ? null : this.decodeEventCode();
    }

    @Override
    public void decodeStartDocument() throws EXIException {
        this.decodeStartDocumentStructure();
    }

    @Override
    public void decodeEndDocument() throws EXIException, IOException {
        this.decodeEndDocumentStructure();
    }

    @Override
    public QNameContext decodeStartElement() throws EXIException, IOException {
        switch (this.nextEventType) {
            case START_ELEMENT: {
                return this.decodeStartElementStructure();
            }
            case START_ELEMENT_NS: {
                return this.decodeStartElementNSStructure();
            }
            case START_ELEMENT_GENERIC: {
                return this.decodeStartElementGenericStructure();
            }
            case START_ELEMENT_GENERIC_UNDECLARED: {
                return this.decodeStartElementGenericUndeclaredStructure();
            }
        }
        throw new EXIException("Invalid decode state: " + (Object)((Object)this.nextEventType));
    }

    @Override
    public QNameContext decodeEndElement() throws EXIException, IOException {
        AbstractEXIBodyCoder.ElementContext ec;
        switch (this.nextEventType) {
            case END_ELEMENT: {
                ec = this.decodeEndElementStructure();
                break;
            }
            case END_ELEMENT_UNDECLARED: {
                ec = this.decodeEndElementUndeclaredStructure();
                break;
            }
            default: {
                throw new EXIException("Invalid decode state: " + (Object)((Object)this.nextEventType));
            }
        }
        return ec.qnameContext;
    }

    @Override
    public List<NamespaceDeclaration> getDeclaredPrefixDeclarations() {
        return this.getElementContext().nsDeclarations;
    }

    @Override
    public String getElementPrefix() {
        return this.getElementContext().getPrefix();
    }

    @Override
    public String getElementQNameAsString() {
        return this.getElementContext().getQNameAsString();
    }

    @Override
    public NamespaceDeclaration decodeNamespaceDeclaration() throws EXIException, IOException {
        return this.decodeNamespaceDeclarationStructure();
    }

    @Override
    public QNameContext decodeAttributeXsiNil() throws EXIException, IOException {
        assert (this.nextEventType == EventType.ATTRIBUTE_XSI_NIL);
        this.decodeAttributeXsiNilStructure();
        return this.attributeQNameContext;
    }

    @Override
    public QNameContext decodeAttributeXsiType() throws EXIException, IOException {
        assert (this.nextEventType == EventType.ATTRIBUTE_XSI_TYPE);
        this.decodeAttributeXsiTypeStructure();
        return this.attributeQNameContext;
    }

    protected void readAttributeContent(Datatype dt) throws IOException {
        this.attributeValue = this.typeDecoder.readValue(dt, this.attributeQNameContext, this.channel, this.stringDecoder);
    }

    protected void readAttributeContent() throws IOException, EXIException {
        if (this.attributeQNameContext.getNamespaceUriID() == this.getXsiTypeContext().getNamespaceUriID()) {
            int localNameID = this.attributeQNameContext.getLocalNameID();
            if (localNameID == this.getXsiTypeContext().getLocalNameID()) {
                this.decodeAttributeXsiTypeStructure();
            } else if (localNameID == this.getXsiTypeContext().getLocalNameID() && this.getCurrentGrammar().isSchemaInformed()) {
                this.decodeAttributeXsiNilStructure();
            } else {
                this.readAttributeContent(BuiltIn.getDefaultDatatype());
            }
        } else {
            Datatype dt = BuiltIn.getDefaultDatatype();
            if (this.getCurrentGrammar().isSchemaInformed() && this.attributeQNameContext.getGlobalAttribute() != null) {
                dt = this.attributeQNameContext.getGlobalAttribute().getDatatype();
            }
            this.readAttributeContent(dt);
        }
    }

    @Override
    public QNameContext decodeAttribute() throws EXIException, IOException {
        switch (this.nextEventType) {
            case ATTRIBUTE: {
                Datatype dt = this.decodeAttributeStructure();
                if (this.attributeQNameContext.equals(this.getXsiTypeContext())) {
                    this.decodeAttributeXsiTypeStructure();
                    break;
                }
                this.readAttributeContent(dt);
                break;
            }
            case ATTRIBUTE_NS: {
                this.decodeAttributeNSStructure();
                this.readAttributeContent();
                break;
            }
            case ATTRIBUTE_GENERIC: {
                this.decodeAttributeGenericStructure();
                this.readAttributeContent();
                break;
            }
            case ATTRIBUTE_GENERIC_UNDECLARED: {
                this.decodeAttributeGenericUndeclaredStructure();
                this.readAttributeContent();
                break;
            }
            case ATTRIBUTE_INVALID_VALUE: {
                this.decodeAttributeStructure();
                this.readAttributeContent(BuiltIn.getDefaultDatatype());
                break;
            }
            case ATTRIBUTE_ANY_INVALID_VALUE: {
                this.decodeAttributeAnyInvalidValueStructure();
                this.readAttributeContent(BuiltIn.getDefaultDatatype());
                break;
            }
            default: {
                throw new EXIException("Invalid decode state: " + (Object)((Object)this.nextEventType));
            }
        }
        return this.attributeQNameContext;
    }

    @Override
    public Value decodeCharacters() throws EXIException, IOException {
        Datatype dt;
        switch (this.nextEventType) {
            case CHARACTERS: {
                dt = this.decodeCharactersStructure();
                break;
            }
            case CHARACTERS_GENERIC: {
                this.decodeCharactersGenericStructure();
                dt = BuiltIn.getDefaultDatatype();
                break;
            }
            case CHARACTERS_GENERIC_UNDECLARED: {
                this.decodeCharactersGenericUndeclaredStructure();
                dt = BuiltIn.getDefaultDatatype();
                break;
            }
            default: {
                throw new EXIException("Invalid decode state: " + (Object)((Object)this.nextEventType));
            }
        }
        return this.typeDecoder.readValue(dt, this.getElementContext().qnameContext, this.channel, this.stringDecoder);
    }

    @Override
    public char[] decodeEntityReference() throws EXIException, IOException {
        return this.decodeEntityReferenceStructure();
    }

    @Override
    public char[] decodeComment() throws EXIException, IOException {
        return this.decodeCommentStructure();
    }

    @Override
    public ProcessingInstruction decodeProcessingInstruction() throws EXIException, IOException {
        return this.decodeProcessingInstructionStructure();
    }

    @Override
    public DocType decodeDocType() throws EXIException, IOException {
        return this.decodeDocTypeStructure();
    }
}

