/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import org.apache.commons.io.IOUtils;
import org.apache.daffodil.lib.calendar.DFDLDate;
import org.apache.daffodil.lib.calendar.DFDLDateConversion$;
import org.apache.daffodil.lib.calendar.DFDLDateTime;
import org.apache.daffodil.lib.calendar.DFDLDateTimeConversion$;
import org.apache.daffodil.lib.calendar.DFDLTime;
import org.apache.daffodil.lib.calendar.DFDLTimeConversion$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.lib.xml.NS$;
import org.apache.daffodil.lib.xml.PrettyPrinter;
import org.apache.daffodil.lib.xml.RemapPUAToXMLIllegalChar;
import org.apache.daffodil.lib.xml.RemapXMLIllegalCharToPUA;
import org.apache.daffodil.lib.xml.XMLUtils;
import org.xml.sax.XMLReader;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;
import scala.xml.Atom;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.Elem$;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.PrefixedAttribute;
import scala.xml.PrefixedAttribute$;
import scala.xml.ProcInstr;
import scala.xml.Text;
import scala.xml.Text$;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Utility$;

public final class XMLUtils$ {
    public static XMLUtils$ MODULE$;
    private URI schemaForDFDLSchemas;
    private URI dafextURI;
    private URI tdmlURI;
    private final PrefixedAttribute xmlNilAttribute;
    private final String PositiveInfinityString;
    private final String NegativeInfinityString;
    private final String NaNString;
    private final RemapXMLIllegalCharToPUA remapXMLToPUA;
    private final RemapPUAToXMLIllegalChar remapPUAToXML;
    private final NS XSD_NAMESPACE;
    private final NS XSI_NAMESPACE;
    private final NS XPATH_FUNCTION_NAMESPACE;
    private final NS XPATH_MATH_NAMESPACE;
    private final NS DFDL_NAMESPACE;
    private final NS DFDLX_NAMESPACE;
    private final NS TDML_NAMESPACE;
    private final NS EXAMPLE_NAMESPACE;
    private final NS XHTML_NAMESPACE;
    private final String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    private final String EXT_PREFIX_NCSA;
    private final NS EXT_NS_NCSA;
    private final String DAFFODIL_NAMESPACE_ROOT_APACHE;
    private final NS DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    private final String EXT_PREFIX_APACHE;
    private final NS EXT_NS_APACHE;
    private final NS DAFFODIL_INTERNAL_NAMESPACE;
    private final String INT_PREFIX;
    private final NS INT_NS;
    private final String DAFFODIL_SAX_URN_ROOT;
    private final String DAFFODIL_SAX_URN_PARSERESULT;
    private final String DAFFODIL_SAX_URN_BLOBDIRECTORY;
    private final String DAFFODIL_SAX_URN_BLOBPREFIX;
    private final String DAFFODIL_SAX_URN_BLOBSUFFIX;
    private final String SAX_NAMESPACES_FEATURE;
    private final String SAX_NAMESPACE_PREFIXES_FEATURE;
    private final String XML_DISALLOW_DOCTYPE_FEATURE;
    private final String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    private final String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    private final String XML_LOAD_EXTERNAL_DTD_FEATURE;
    private final String FILE_ATTRIBUTE_NAME;
    private final String LINE_ATTRIBUTE_NAME;
    private final String COLUMN_ATTRIBUTE_NAME;
    private final NS xsdURI;
    private final NS dfdlURI;
    private final NS dfdlxURI;
    private final NS dfdlAppinfoSource;
    private final NS targetNS;
    private final NS xsiURI;
    private final NS fnURI;
    private final NS mathURI;
    private final NS dafintURI;
    private final List<String> DFDL_SIMPLE_BUILT_IN_TYPES;
    private final RemapXMLIllegalCharToPUA xmlRemapperPreservingCR;
    private final Regex xmlEntityPattern;
    private volatile byte bitmap$0;

    static {
        new XMLUtils$();
    }

    private URI schemaForDFDLSchemas$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.schemaForDFDLSchemas = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/XMLSchema_for_DFDL.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.schemaForDFDLSchemas;
    }

    public URI schemaForDFDLSchemas() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.schemaForDFDLSchemas$lzycompute();
        }
        return this.schemaForDFDLSchemas;
    }

    private URI dafextURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dafextURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/dafext.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dafextURI;
    }

    public URI dafextURI() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dafextURI$lzycompute();
        }
        return this.dafextURI;
    }

    private URI tdmlURI$lzycompute() {
        XMLUtils$ xMLUtils$ = this;
        synchronized (xMLUtils$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.tdmlURI = Misc$.MODULE$.getRequiredResource("org/apache/daffodil/xsd/tdml.xsd");
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.tdmlURI;
    }

    public URI tdmlURI() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.tdmlURI$lzycompute();
        }
        return this.tdmlURI;
    }

    public PrefixedAttribute xmlNilAttribute() {
        return this.xmlNilAttribute;
    }

    public String PositiveInfinityString() {
        return this.PositiveInfinityString;
    }

    public String NegativeInfinityString() {
        return this.NegativeInfinityString;
    }

    public String NaNString() {
        return this.NaNString;
    }

    public int uncodeLength(String s) {
        int res = s.getBytes("UTF-32BE").length / 4;
        return res;
    }

    public <T> Seq<T> walkUnicodeString(String str, Function3<Object, Object, Object, T> bodyFunc) {
        int len = str.length();
        if (len == 0) {
            return Nil$.MODULE$;
        }
        ListBuffer list = new ListBuffer();
        char prev = (char)0;
        char curr = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), 0);
        char next = (char)0;
        for (int pos = 0; pos < len; ++pos) {
            next = pos + 1 < len ? StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), pos + 1) : (char)0;
            list.$plus$eq(bodyFunc.apply((Object)BoxesRunTime.boxToCharacter((char)prev), (Object)BoxesRunTime.boxToCharacter((char)curr), (Object)BoxesRunTime.boxToCharacter((char)next)));
            prev = curr;
            curr = next;
        }
        return list;
    }

    private RemapXMLIllegalCharToPUA remapXMLToPUA() {
        return this.remapXMLToPUA;
    }

    public String remapXMLIllegalCharactersToPUA(String s) {
        return this.remapXMLToPUA().remap(s);
    }

    private RemapPUAToXMLIllegalChar remapPUAToXML() {
        return this.remapPUAToXML;
    }

    public String remapPUAToXMLIllegalCharacters(String text) {
        return this.remapPUAToXML().remap(text);
    }

    public Node coalesceAllAdjacentTextNodes(Node node) {
        Node node2 = node;
        Option option = Elem$.MODULE$.unapplySeq(node2);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq coalescedChildren = (Seq)child.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.coalesceAllAdjacentTextNodes((Node)x$1), Seq$.MODULE$.canBuildFrom());
            Seq<Node> newChildren = this.coalesceAdjacentTextNodes((Seq<Node>)coalescedChildren);
            return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        }
        return node2;
    }

    public Seq<Node> coalesceAdjacentTextNodes(Seq<Node> seq) {
        if (seq.length() == 0) {
            return seq;
        }
        if (seq.length() == 1) {
            Node node = (Node)seq.apply(0);
            if (node instanceof Atom) {
                return seq;
            }
        }
        ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(Node.class));
        boolean i = false;
        ObjectRef tn = ObjectRef.create(null);
        ObjectRef sb = ObjectRef.create(null);
        seq.foreach((Function1 & Serializable & scala.Serializable)current -> {
            if (current instanceof Text || current instanceof Unparsed) {
                if ((Node)tn$1.elem == null) {
                    if ((StringBuilder)sb$1.elem == null || ((StringBuilder)sb$1.elem).length() == 0) {
                        tn$1.elem = current;
                        return BoxedUnit.UNIT;
                    }
                    return ((StringBuilder)sb$1.elem).append(current.text());
                }
                if ((StringBuilder)sb$1.elem == null) {
                    sb$1.elem = new StringBuilder();
                }
                ((StringBuilder)sb$1.elem).append(((Node)tn$1.elem).text());
                ((StringBuilder)sb$1.elem).append(current.text());
                tn$1.elem = null;
                return BoxedUnit.UNIT;
            }
            XMLUtils$.processText$1(tn, sb, ab);
            return ab.$plus$eq(current);
        });
        XMLUtils$.processText$1(tn, sb, ab);
        return Predef$.MODULE$.wrapRefArray((Object[])ab.result());
    }

    public NS XSD_NAMESPACE() {
        return this.XSD_NAMESPACE;
    }

    public NS XSI_NAMESPACE() {
        return this.XSI_NAMESPACE;
    }

    public NS XPATH_FUNCTION_NAMESPACE() {
        return this.XPATH_FUNCTION_NAMESPACE;
    }

    public NS XPATH_MATH_NAMESPACE() {
        return this.XPATH_MATH_NAMESPACE;
    }

    public NS DFDL_NAMESPACE() {
        return this.DFDL_NAMESPACE;
    }

    public NS DFDLX_NAMESPACE() {
        return this.DFDLX_NAMESPACE;
    }

    public NS TDML_NAMESPACE() {
        return this.TDML_NAMESPACE;
    }

    public NS EXAMPLE_NAMESPACE() {
        return this.EXAMPLE_NAMESPACE;
    }

    public NS XHTML_NAMESPACE() {
        return this.XHTML_NAMESPACE;
    }

    public Elem getXSDElement(NamespaceBinding scope) {
        String string;
        boolean isXSDTheDefaultNS;
        String xsdPre = scope.getPrefix(this.XSD_NAMESPACE().toString());
        String string2 = this.XSD_NAMESPACE().toString();
        String string3 = scope.getURI(null);
        boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null) ? true : (isXSDTheDefaultNS = false);
        if (xsdPre != null) {
            string = xsdPre;
        } else if (isXSDTheDefaultNS) {
            string = null;
        } else {
            throw Assert$.MODULE$.usageError("Scope argument must have a binding for the XSD namespace.");
        }
        String xsdPrefix = string;
        Elem res = Elem$.MODULE$.apply(xsdPrefix, "element", (MetaData)Null$.MODULE$, scope, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        return res;
    }

    private String DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA() {
        return this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_NCSA() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_NCSA;
    }

    public String EXT_PREFIX_NCSA() {
        return this.EXT_PREFIX_NCSA;
    }

    public NS EXT_NS_NCSA() {
        return this.EXT_NS_NCSA;
    }

    private String DAFFODIL_NAMESPACE_ROOT_APACHE() {
        return this.DAFFODIL_NAMESPACE_ROOT_APACHE;
    }

    private NS DAFFODIL_EXTENSION_NAMESPACE_APACHE() {
        return this.DAFFODIL_EXTENSION_NAMESPACE_APACHE;
    }

    public String EXT_PREFIX_APACHE() {
        return this.EXT_PREFIX_APACHE;
    }

    public NS EXT_NS_APACHE() {
        return this.EXT_NS_APACHE;
    }

    private NS DAFFODIL_INTERNAL_NAMESPACE() {
        return this.DAFFODIL_INTERNAL_NAMESPACE;
    }

    public String INT_PREFIX() {
        return this.INT_PREFIX;
    }

    public NS INT_NS() {
        return this.INT_NS;
    }

    public String DAFFODIL_SAX_URN_ROOT() {
        return this.DAFFODIL_SAX_URN_ROOT;
    }

    public String DAFFODIL_SAX_URN_PARSERESULT() {
        return this.DAFFODIL_SAX_URN_PARSERESULT;
    }

    public String DAFFODIL_SAX_URN_BLOBDIRECTORY() {
        return this.DAFFODIL_SAX_URN_BLOBDIRECTORY;
    }

    public String DAFFODIL_SAX_URN_BLOBPREFIX() {
        return this.DAFFODIL_SAX_URN_BLOBPREFIX;
    }

    public String DAFFODIL_SAX_URN_BLOBSUFFIX() {
        return this.DAFFODIL_SAX_URN_BLOBSUFFIX;
    }

    public String SAX_NAMESPACES_FEATURE() {
        return this.SAX_NAMESPACES_FEATURE;
    }

    public String SAX_NAMESPACE_PREFIXES_FEATURE() {
        return this.SAX_NAMESPACE_PREFIXES_FEATURE;
    }

    public String XML_DISALLOW_DOCTYPE_FEATURE() {
        return this.XML_DISALLOW_DOCTYPE_FEATURE;
    }

    public String XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE() {
        return this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE;
    }

    public String XML_EXTERNAL_GENERAL_ENTITIES_FEATURE() {
        return this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE;
    }

    public String XML_LOAD_EXTERNAL_DTD_FEATURE() {
        return this.XML_LOAD_EXTERNAL_DTD_FEATURE;
    }

    public void setSecureDefaults(XMLReader xmlReader) {
        xmlReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        xmlReader.setFeature(this.XML_DISALLOW_DOCTYPE_FEATURE(), true);
        xmlReader.setFeature(this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE(), false);
        xmlReader.setFeature(this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE(), false);
    }

    public String FILE_ATTRIBUTE_NAME() {
        return this.FILE_ATTRIBUTE_NAME;
    }

    public String LINE_ATTRIBUTE_NAME() {
        return this.LINE_ATTRIBUTE_NAME;
    }

    public String COLUMN_ATTRIBUTE_NAME() {
        return this.COLUMN_ATTRIBUTE_NAME;
    }

    public NS xsdURI() {
        return this.xsdURI;
    }

    public NS dfdlURI() {
        return this.dfdlURI;
    }

    public NS dfdlxURI() {
        return this.dfdlxURI;
    }

    public NS dfdlAppinfoSource() {
        return this.dfdlAppinfoSource;
    }

    public NS targetNS() {
        return this.targetNS;
    }

    public NS xsiURI() {
        return this.xsiURI;
    }

    public NS fnURI() {
        return this.fnURI;
    }

    public NS mathURI() {
        return this.mathURI;
    }

    public NS dafintURI() {
        return this.dafintURI;
    }

    public List<String> DFDL_SIMPLE_BUILT_IN_TYPES() {
        return this.DFDL_SIMPLE_BUILT_IN_TYPES;
    }

    public String slashify(String s) {
        String string = s;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || s.endsWith("/")) {
            return s;
        }
        return new java.lang.StringBuilder(1).append(s).append("/").toString();
    }

    public Seq<NamespaceBinding> namespaceBindings(NamespaceBinding nsBinding) {
        if (nsBinding == null) {
            return Nil$.MODULE$;
        }
        Nil$ thisOne = nsBinding.uri() != null ? new .colon.colon((Object)nsBinding, (List)Nil$.MODULE$) : Nil$.MODULE$;
        Seq<NamespaceBinding> others = this.namespaceBindings(nsBinding.parent());
        return (Seq)thisOne.$plus$plus(others, List$.MODULE$.canBuildFrom());
    }

    public MetaData dfdlAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlAttributes$1(n, x$2)));
    }

    public MetaData dfdlxAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dfdlxAttributes$1(n, x$3)));
    }

    public MetaData dafAttributes(Node n) {
        return n.attributes().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$dafAttributes$1(n, a)));
    }

    public NamespaceBinding combineScopes(NamespaceBinding local, NamespaceBinding outer) {
        String outerURI;
        NamespaceBinding moreBindings;
        String uri;
        String pre;
        while (true) {
            NamespaceBinding namespaceBinding = local;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return outer;
            }
            NamespaceBinding namespaceBinding2 = local;
            if (namespaceBinding2 == null) {
                throw new MatchError((Object)namespaceBinding2);
            }
            String pre2 = namespaceBinding2.prefix();
            String uri2 = namespaceBinding2.uri();
            NamespaceBinding moreBindings2 = namespaceBinding2.parent();
            Tuple3 tuple3 = new Tuple3((Object)pre2, (Object)uri2, (Object)moreBindings2);
            pre = (String)tuple3._1();
            uri = (String)tuple3._2();
            moreBindings = (NamespaceBinding)tuple3._3();
            String string = outerURI = outer.getURI(pre);
            String string2 = uri;
            if (string != null ? !string.equals(string2) : string2 != null) break;
            local = moreBindings;
        }
        if (outerURI == null) {
            return new NamespaceBinding(pre, uri, this.combineScopes(moreBindings, outer));
        }
        NamespaceBinding outerWithoutDuplicate = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), outer);
        NamespaceBinding moreBindingsWithoutConflict = this.removeBindings(new NamespaceBinding(pre, uri, (NamespaceBinding)TopScope$.MODULE$), moreBindings);
        return new NamespaceBinding(pre, uri, this.combineScopes(moreBindingsWithoutConflict, outerWithoutDuplicate));
    }

    public NamespaceBinding removeBindings(NamespaceBinding nb, NamespaceBinding scope) {
        NamespaceBinding more;
        while (true) {
            NamespaceBinding namespaceBinding = nb;
            TopScope$ topScope$ = TopScope$.MODULE$;
            if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding2 = scope;
            TopScope$ topScope$2 = TopScope$.MODULE$;
            if (!(namespaceBinding2 != null ? !namespaceBinding2.equals(topScope$2) : topScope$2 != null)) {
                return scope;
            }
            NamespaceBinding namespaceBinding3 = scope;
            if (namespaceBinding3 == null) {
                throw new MatchError((Object)namespaceBinding3);
            }
            String pre = namespaceBinding3.prefix();
            NamespaceBinding more2 = namespaceBinding3.parent();
            Tuple2 tuple2 = new Tuple2((Object)pre, (Object)more2);
            String pre2 = (String)tuple2._1();
            more = (NamespaceBinding)tuple2._2();
            if (nb.getURI(pre2) == null) break;
            scope = more;
        }
        NamespaceBinding x$1 = this.removeBindings(nb, more);
        String x$2 = scope.copy$default$1();
        String x$3 = scope.copy$default$2();
        return scope.copy(x$2, x$3, x$1);
    }

    public NamespaceBinding combineScopes(String prefix, NS ns, NamespaceBinding outer) {
        if (Maybe$.MODULE$.isEmpty$extension(ns.optURI())) {
            return outer;
        }
        String uri = ((URI)Maybe$.MODULE$.get$extension(ns.optURI())).toString();
        NamespaceBinding inner = new NamespaceBinding(prefix, uri, (NamespaceBinding)TopScope$.MODULE$);
        return this.combineScopes(inner, outer);
    }

    public Node collapseScopes(Node x, NamespaceBinding outer) {
        Node node = x;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            String pre = (String)((Tuple5)option.get())._1();
            String lab = (String)((Tuple5)option.get())._2();
            MetaData md = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scp = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            NamespaceBinding newScope = this.combineScopes(scp, outer);
            return Elem$.MODULE$.apply(pre, lab, md, newScope, true, (Seq)child.flatMap((Function1 & Serializable & scala.Serializable)ch -> MODULE$.collapseScopes((Node)ch, newScope), Seq$.MODULE$.canBuildFrom()));
        }
        return x;
    }

    public NamespaceBinding filterScope(NamespaceBinding nsb, Seq<NS> nss) {
        TopScope$ topScope$;
        NamespaceBinding namespaceBinding = nsb;
        TopScope$ topScope$2 = TopScope$.MODULE$;
        if (!(namespaceBinding != null ? !namespaceBinding.equals(topScope$2) : topScope$2 != null)) {
            topScope$ = TopScope$.MODULE$;
        } else {
            NamespaceBinding parentCopy = this.filterScope(nsb.parent(), nss);
            if (nss.contains((Object)NS$.MODULE$.apply(nsb.uri()))) {
                topScope$ = parentCopy;
            } else {
                NamespaceBinding x$1 = parentCopy;
                String x$2 = nsb.copy$default$1();
                String x$3 = nsb.copy$default$2();
                topScope$ = nsb.copy(x$2, x$3, x$1);
            }
        }
        TopScope$ newHead = topScope$;
        return newHead;
    }

    public boolean prefixInScope(String prefix, NamespaceBinding scope) {
        boolean bl;
        if (scope == null) {
            bl = false;
        } else {
            String string = prefix;
            String string2 = scope.prefix();
            bl = !(string != null ? !string.equals(string2) : string2 != null) ? true : this.prefixInScope(prefix, scope.parent());
        }
        boolean ret = bl;
        return ret;
    }

    public Node removeComments(Node e) {
        Node node = e;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attribs = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq child = (Seq)((Tuple5)option.get())._5();
            Seq newChildren = (Seq)((TraversableLike)child.filterNot((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeComments$1(x$6)))).map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.removeComments((Node)x$7), Seq$.MODULE$.canBuildFrom());
            return Elem$.MODULE$.apply(prefix, label, attribs, scope, true, newChildren);
        }
        return node;
    }

    public Node removeAttributes(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Node res1 = (Node)this.removeAttributes1(n, ns, parentScope);
        Node res2 = this.removeMixedWhitespace(res1);
        Node res = res2.apply(0);
        return res;
    }

    public Seq<NS> removeAttributes$default$2() {
        return (Seq)Nil$.MODULE$;
    }

    public Option<NamespaceBinding> removeAttributes$default$3() {
        return None$.MODULE$;
    }

    private Node removeMixedWhitespace(Node ns2) {
        Elem elem;
        Seq noMixedChildren;
        if (!(ns2 instanceof Elem)) {
            return ns2;
        }
        Elem e = (Elem)ns2;
        Seq children = e.child();
        Seq seq = noMixedChildren = children.exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$1(x$8))) ? (Seq)((TraversableLike)children.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$2(e, x0$1)))).map((Function1 & Serializable & scala.Serializable)ns -> MODULE$.removeMixedWhitespace((Node)ns), Seq$.MODULE$.canBuildFrom()) : (Seq)children.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeMixedWhitespace$4(x0$2)));
        if (noMixedChildren == children) {
            elem = e;
        } else {
            Seq x$1 = noMixedChildren;
            String x$2 = e.copy$default$1();
            String x$3 = e.copy$default$2();
            MetaData x$4 = e.copy$default$3();
            NamespaceBinding x$5 = e.copy$default$4();
            boolean x$6 = e.copy$default$5();
            elem = e.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }
        Elem res = elem;
        return res;
    }

    private Node convertPCDataToText(Node n) {
        Text text;
        Node node = n;
        if (node instanceof Text) {
            Text text2;
            text = text2 = (Text)node;
        } else if (node instanceof Atom) {
            Atom atom = (Atom)node;
            text = Text$.MODULE$.apply(atom.text());
        } else {
            Option option = Elem$.MODULE$.unapplySeq(node);
            if (!option.isEmpty()) {
                String prefix = (String)((Tuple5)option.get())._1();
                String label = (String)((Tuple5)option.get())._2();
                MetaData attributes = (MetaData)((Tuple5)option.get())._3();
                NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
                Seq children = (Seq)((Tuple5)option.get())._5();
                Seq newChildren = (Seq)children.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.convertPCDataToText((Node)x$9), Seq$.MODULE$.canBuildFrom());
                text = Elem$.MODULE$.apply(prefix, label, attributes, scope, true, newChildren);
            } else {
                text = n;
            }
        }
        Text res = text;
        return res;
    }

    private NodeSeq removeAttributes1(Node n, Seq<NS> ns, Option<NamespaceBinding> parentScope) {
        Object object;
        Node node = n;
        Option option = Elem$.MODULE$.unapplySeq(node);
        if (!option.isEmpty()) {
            Object object2;
            String prefix = (String)((Tuple5)option.get())._1();
            String label = (String)((Tuple5)option.get())._2();
            MetaData attributes = (MetaData)((Tuple5)option.get())._3();
            NamespaceBinding scope = (NamespaceBinding)((Tuple5)option.get())._4();
            Seq children = (Seq)((Tuple5)option.get())._5();
            TopScope$ filteredScope = ns.length() > 0 ? this.filterScope(scope, ns) : TopScope$.MODULE$;
            Option<NamespaceBinding> option2 = parentScope;
            if (option2 instanceof Some) {
                NamespaceBinding ps;
                Some some = (Some)option2;
                NamespaceBinding namespaceBinding = ps = (NamespaceBinding)some.value();
                TopScope$ topScope$ = filteredScope;
                object2 = !(namespaceBinding != null ? !namespaceBinding.equals(topScope$) : topScope$ != null) ? ps : filteredScope;
            } else if (None$.MODULE$.equals(option2)) {
                object2 = filteredScope;
            } else {
                throw new MatchError(option2);
            }
            TopScope$ newScope = object2;
            NodeSeq newChildren = NodeSeq$.MODULE$.seqToNodeSeq((Seq)children.flatMap(arg_0 -> XMLUtils$.$anonfun$removeAttributes1$1(ns, (NamespaceBinding)newScope, arg_0), Seq$.MODULE$.canBuildFrom()));
            Seq<Node> textMergedChildren = this.coalesceAdjacentTextNodes((Seq<Node>)newChildren);
            String newPrefix = this.prefixInScope(prefix, (NamespaceBinding)newScope) ? prefix : null;
            MetaData newAttributes = attributes.filter((Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$removeAttributes1$2(node, m)));
            object = Elem$.MODULE$.apply(newPrefix, label, newAttributes, (NamespaceBinding)newScope, true, textMergedChildren);
        } else {
            object = node instanceof Comment ? NodeSeq$.MODULE$.Empty() : node;
        }
        NodeSeq res = object;
        return res;
    }

    public Node normalize(Node n) {
        Node noComments = this.removeComments(n);
        Node noPCData = this.convertPCDataToText(noComments);
        Node combinedText = this.coalesceAllAdjacentTextNodes(noPCData);
        Node noMixedWS = this.removeMixedWhitespace(combinedText);
        return noMixedWS;
    }

    public void compareAndReport(Node expected, Node actual, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces) {
        Node actualMinimized;
        Node expectedMinimized = this.normalize(expected);
        Seq<Tuple3<String, String, String>> diffs = this.computeDiff(expectedMinimized, actualMinimized = this.normalize(actual), ignoreProcInstr, checkPrefixes, checkNamespaces);
        if (diffs.length() > 0) {
            throw new XMLUtils.XMLDifferenceException(new StringOps(Predef$.MODULE$.augmentString("\nComparison failed.\nExpected (attributes %s)\n          %s\nActual (attributes %s for diff)\n          %s\nDifferences were (path, expected, actual):\n%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{checkPrefixes || checkNamespaces ? "compared for diff" : "stripped", checkPrefixes || checkNamespaces ? expected : this.removeAttributes(expected, this.removeAttributes$default$2(), this.removeAttributes$default$3()).toString(), checkPrefixes || checkNamespaces ? "compared" : "ignored", actual, ((TraversableOnce)diffs.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toString(), Seq$.MODULE$.canBuildFrom())).mkString("- ", "\n- ", "\n")})));
        }
    }

    public boolean compareAndReport$default$3() {
        return true;
    }

    public boolean compareAndReport$default$4() {
        return false;
    }

    public boolean compareAndReport$default$5() {
        return false;
    }

    public Seq<Tuple3<String, String, String>> computeDiff(Node a, Node b, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces) {
        return this.computeDiffOne(a, b, (NamespaceBinding)TopScope$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, (Option<Object>)None$.MODULE$, (Seq<String>)Nil$.MODULE$, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)None$.MODULE$);
    }

    public boolean computeDiff$default$3() {
        return true;
    }

    public boolean computeDiff$default$4() {
        return false;
    }

    public boolean computeDiff$default$5() {
        return false;
    }

    public scala.collection.immutable.Map<String, Object> childArrayCounters(Elem e) {
        Elem elem = e;
        Option option = Elem$.MODULE$.unapplySeq((Node)elem);
        if (option.isEmpty()) {
            throw new MatchError((Object)elem);
        }
        Seq children = (Seq)((Tuple5)option.get())._5();
        Seq children2 = children;
        Seq labels = (Seq)children2.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.label(), Seq$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map groups = labels.groupBy((Function1 & Serializable & scala.Serializable)x -> x);
        scala.collection.immutable.Map counts = (scala.collection.immutable.Map)groups.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                Seq labelList = (Seq)tuple2._2();
                return new Tuple2((Object)label, (Object)BoxesRunTime.boxToInteger((int)labelList.length()));
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map arrayCounts = (scala.collection.immutable.Map)counts.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$childArrayCounters$4(x0$2)));
        scala.collection.immutable.Map arrayCounters = (scala.collection.immutable.Map)arrayCounts.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String label = (String)tuple2._1();
                return new Tuple2((Object)label, (Object)BoxesRunTime.boxToLong((long)1));
            }
            throw new MatchError((Object)tuple2);
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        return arrayCounters;
    }

    public Seq<Tuple3<String, String, String>> computeDiffOne(Node an, Node bn, NamespaceBinding aParentScope, NamespaceBinding bParentScope, Option<Object> maybeIndex, Seq<String> parentPathSteps, boolean ignoreProcInstr, boolean checkPrefixes, boolean checkNamespaces, Option<String> maybeType) {
        LazyRef zPath$lzy = new LazyRef();
        Tuple2 tuple2 = new Tuple2((Object)an, (Object)bn);
        if (tuple2 != null) {
            Node a = (Node)tuple2._1();
            Node b = (Node)tuple2._2();
            if (a instanceof Elem) {
                Elem elem = (Elem)a;
                if (b instanceof Elem) {
                    Tuple2 tuple22;
                    Tuple2 tuple23;
                    String pathLabel;
                    Elem elem2 = (Elem)b;
                    Elem elem3 = elem;
                    Option option = Elem$.MODULE$.unapplySeq((Node)elem3);
                    if (option.isEmpty()) {
                        throw new MatchError((Object)elem3);
                    }
                    String prefixA = (String)((Tuple5)option.get())._1();
                    String labelA = (String)((Tuple5)option.get())._2();
                    MetaData attribsA = (MetaData)((Tuple5)option.get())._3();
                    NamespaceBinding nsbA = (NamespaceBinding)((Tuple5)option.get())._4();
                    Seq childrenA = (Seq)((Tuple5)option.get())._5();
                    Tuple5 tuple5 = new Tuple5((Object)prefixA, (Object)labelA, (Object)attribsA, (Object)nsbA, (Object)childrenA);
                    String prefixA2 = (String)tuple5._1();
                    String labelA2 = (String)tuple5._2();
                    MetaData attribsA2 = (MetaData)tuple5._3();
                    NamespaceBinding nsbA2 = (NamespaceBinding)tuple5._4();
                    Seq childrenA2 = (Seq)tuple5._5();
                    Elem elem4 = elem2;
                    Option option2 = Elem$.MODULE$.unapplySeq((Node)elem4);
                    if (option2.isEmpty()) {
                        throw new MatchError((Object)elem4);
                    }
                    String prefixB = (String)((Tuple5)option2.get())._1();
                    String labelB = (String)((Tuple5)option2.get())._2();
                    MetaData attribsB = (MetaData)((Tuple5)option2.get())._3();
                    NamespaceBinding nsbB = (NamespaceBinding)((Tuple5)option2.get())._4();
                    Seq childrenB = (Seq)((Tuple5)option2.get())._5();
                    Tuple5 tuple52 = new Tuple5((Object)prefixB, (Object)labelB, (Object)attribsB, (Object)nsbB, (Object)childrenB);
                    String prefixB2 = (String)tuple52._1();
                    String labelB2 = (String)tuple52._2();
                    MetaData attribsB2 = (MetaData)tuple52._3();
                    NamespaceBinding nsbB2 = (NamespaceBinding)tuple52._4();
                    Seq childrenB2 = (Seq)tuple52._5();
                    Option typeA = elem.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable & scala.Serializable)x$15 -> ((Node)x$15.head()).text());
                    Option typeB = elem2.attribute(this.XSI_NAMESPACE().toString(), "type").map((Function1 & Serializable & scala.Serializable)x$16 -> ((Node)x$16.head()).text());
                    Option maybeType2 = Option$.MODULE$.apply(typeA.getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)typeB.getOrElse((Function0 & Serializable & scala.Serializable)() -> null)));
                    Option nilledA = elem.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    Option nilledB = elem2.attribute(this.XSI_NAMESPACE().toString(), "nil");
                    String mappingsA = checkNamespaces ? nsbA2.buildString(aParentScope).trim() : "";
                    String mappingsB = checkNamespaces ? nsbB2.buildString(bParentScope).trim() : "";
                    String string = labelA2;
                    String string2 = labelB2;
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)labelA2, (Object)labelB2), (List)Nil$.MODULE$);
                    }
                    if (checkPrefixes) {
                        String string3 = prefixA2;
                        String string4 = prefixB2;
                        if (string3 == null ? string4 != null : !string3.equals(string4)) {
                            return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(8).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@prefix").toString(), (Object)prefixA2, (Object)prefixB2), (List)Nil$.MODULE$);
                        }
                    }
                    if (checkNamespaces) {
                        String string5 = mappingsA;
                        String string6 = mappingsB;
                        if (string5 == null ? string6 != null : !string5.equals(string6)) {
                            return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(7).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xmlns").toString(), (Object)mappingsA, (Object)mappingsB), (List)Nil$.MODULE$);
                        }
                    }
                    Option option3 = nilledA;
                    Option option4 = nilledB;
                    if (option3 == null ? option4 != null : !option3.equals(option4)) {
                        return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(9).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:nil").toString(), nilledA.map((Function1 & Serializable & scala.Serializable)x$17 -> x$17.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), nilledB.map((Function1 & Serializable & scala.Serializable)x$18 -> x$18.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$);
                    }
                    Option option5 = typeA;
                    Option option6 = typeB;
                    if ((option5 == null ? option6 != null : !option5.equals(option6)) && typeA.isDefined() && typeB.isDefined()) {
                        return new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(10).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("@xsi:type").toString(), typeA.map((Function1 & Serializable & scala.Serializable)x$19 -> x$19.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ""), typeA.map((Function1 & Serializable & scala.Serializable)x$20 -> x$20.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (List)Nil$.MODULE$);
                    }
                    String string7 = pathLabel = new java.lang.StringBuilder(0).append(labelA2).append(maybeIndex.map((Function1 & Serializable & scala.Serializable)x$21 -> XMLUtils$.$anonfun$computeDiffOne$13(BoxesRunTime.unboxToInt((Object)x$21))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString();
                    Seq thisPathStep = (Seq)parentPathSteps.$plus$colon((Object)string7, Seq$.MODULE$.canBuildFrom());
                    if (ignoreProcInstr) {
                        Seq ca = (Seq)childrenA2.filterNot((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$15(x$23)));
                        Seq cb = (Seq)childrenB2.filterNot((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$16(x$24)));
                        tuple23 = new Tuple2((Object)ca, (Object)cb);
                    } else {
                        tuple23 = tuple22 = new Tuple2((Object)childrenA2, (Object)childrenB2);
                    }
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Seq childrenACompare = (Seq)tuple22._1();
                    Seq childrenBCompare = (Seq)tuple22._2();
                    Tuple2 tuple24 = new Tuple2((Object)childrenACompare, (Object)childrenBCompare);
                    Seq childrenACompare2 = (Seq)tuple24._1();
                    Seq childrenBCompare2 = (Seq)tuple24._2();
                    Iterable repeatingChildrenLabels = ((MapLike)childrenA2.groupBy((Function1 & Serializable & scala.Serializable)x$26 -> x$26.label()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeDiffOne$18(x0$1)))).keys();
                    Iterable labelsWithZeroCount = (Iterable)repeatingChildrenLabels.map((Function1 & Serializable & scala.Serializable)x$27 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$27), (Object)BoxesRunTime.boxToInteger((int)0)), Iterable$.MODULE$.canBuildFrom());
                    Map countMap = (Map)Map$.MODULE$.apply(labelsWithZeroCount.toSeq());
                    Seq childrenDiffs = (Seq)((TraversableLike)childrenACompare2.zip((GenIterable)childrenBCompare2, Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 != null) {
                            Node ca = (Node)tuple2._1();
                            Node cb = (Node)tuple2._2();
                            Option maybeChildCount = countMap.get((Object)ca.label());
                            Option maybeChildIndex = maybeChildCount.map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)count -> {
                                String string = ca.label();
                                countMap.update((Object)string, (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)countMap.apply((Object)string)) + 1)));
                                return count + 1;
                            });
                            return MODULE$.computeDiffOne(ca, cb, nsbA2, nsbB2, (Option<Object>)maybeChildIndex, (Seq<String>)thisPathStep, ignoreProcInstr, checkPrefixes, checkNamespaces, (Option<String>)maybeType2);
                        }
                        throw new MatchError((Object)tuple2);
                    }, Seq$.MODULE$.canBuildFrom());
                    Nil$ childrenLengthDiff = childrenA2.length() != childrenB2.length() ? new .colon.colon((Object)new Tuple3((Object)new java.lang.StringBuilder(15).append(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps)).append("/").append(labelA2).append("::child@count)").toString(), (Object)Integer.toString(childrenA2.length()), (Object)Integer.toString(childrenB2.length())), (List)Nil$.MODULE$) : Nil$.MODULE$;
                    return (Seq)childrenDiffs.$plus$plus((GenTraversableOnce)childrenLengthDiff, Seq$.MODULE$.canBuildFrom());
                }
            }
        }
        if (tuple2 != null) {
            Node tA = (Node)tuple2._1();
            Node tB = (Node)tuple2._2();
            if (tA instanceof Text) {
                Text text = (Text)tA;
                if (tB instanceof Text) {
                    Text text2 = (Text)tB;
                    Seq<Tuple3<String, String, String>> thisDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), text, text2, maybeType);
                    return thisDiff;
                }
            }
        }
        if (tuple2 != null) {
            Node pA = (Node)tuple2._1();
            Node pB = (Node)tuple2._2();
            if (pA instanceof ProcInstr) {
                ProcInstr procInstr = (ProcInstr)pA;
                if (pB instanceof ProcInstr) {
                    ProcInstr procInstr2 = (ProcInstr)pB;
                    ProcInstr procInstr3 = procInstr;
                    if (procInstr3 == null) {
                        throw new MatchError((Object)procInstr3);
                    }
                    String tA1label = procInstr3.target();
                    String tA1content = procInstr3.proctext();
                    Tuple2 tuple25 = new Tuple2((Object)tA1label, (Object)tA1content);
                    String tA1label2 = (String)tuple25._1();
                    String tA1content2 = (String)tuple25._2();
                    ProcInstr procInstr4 = procInstr2;
                    if (procInstr4 == null) {
                        throw new MatchError((Object)procInstr4);
                    }
                    String tB1label = procInstr4.target();
                    String tB1content = procInstr4.proctext();
                    Tuple2 tuple26 = new Tuple2((Object)tB1label, (Object)tB1content);
                    String tB1label2 = (String)tuple26._1();
                    String tB1content2 = (String)tuple26._2();
                    Seq<Tuple3<String, String, String>> labelDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1label2, tB1label2, (Option<String>)None$.MODULE$);
                    Seq<Tuple3<String, String, String>> contentDiff = this.computeTextDiff(XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), tA1content2, tB1content2, maybeType);
                    return (Seq)labelDiff.$plus$plus(contentDiff, Seq$.MODULE$.canBuildFrom());
                }
            }
        }
        return new .colon.colon((Object)new Tuple3((Object)XMLUtils$.zPath$1(zPath$lzy, parentPathSteps), (Object)an.toString(), (Object)bn.toString()), (List)Nil$.MODULE$);
    }

    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, Text tA, Text tB, Option<String> maybeType) {
        String dataA = tA.toString();
        String dataB = tB.toString();
        return this.computeTextDiff(zPath, dataA, dataB, maybeType);
    }

    public Seq<Tuple3<String, String, String>> computeBlobDiff(String zPath, String dataA, String dataB) {
        Option<URI> uriA = Misc$.MODULE$.searchResourceOption(dataA, (Option<URI>)None$.MODULE$);
        Option<URI> uriB = Misc$.MODULE$.searchResourceOption(dataB, (Option<URI>)None$.MODULE$);
        Option pathA = uriA.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        Option pathB = uriB.map((Function1 & Serializable & scala.Serializable)u -> Paths.get(u));
        boolean canReadA = BoxesRunTime.unboxToBoolean((Object)pathA.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$3(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        boolean canReadB = BoxesRunTime.unboxToBoolean((Object)pathB.map((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$5(p))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false));
        if (!canReadA || !canReadB) {
            String path = new java.lang.StringBuilder(8).append(zPath).append(".canRead").toString();
            return (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)Boolean.toString(canReadA), (Object)Boolean.toString(canReadB)), (List)Nil$.MODULE$);
        }
        int CHUNK_SIZE = 1024;
        byte[] arrayA = new byte[CHUNK_SIZE];
        byte[] arrayB = new byte[CHUNK_SIZE];
        InputStream streamA = Files.newInputStream((Path)pathA.get(), StandardOpenOption.READ);
        InputStream streamB = Files.newInputStream((Path)pathB.get(), StandardOpenOption.READ);
        int lenA = 0;
        int lenB = 0;
        int numSameBytes = 0;
        boolean areSame = true;
        while (true) {
            boolean bl = areSame = (lenA = streamA.read(arrayA)) == (lenB = streamB.read(arrayB)) && new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).sameElements((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB));
            if (!areSame || lenA == -1 || lenB == -1) break;
            numSameBytes += lenA;
        }
        if (!areSame) {
            Tuple2[] zip = (Tuple2[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).zip((GenIterable)Predef$.MODULE$.wrapByteArray(arrayB), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            int firstDiffIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])zip)).indexWhere((Function1 & Serializable & scala.Serializable)z -> BoxesRunTime.boxToBoolean((boolean)XMLUtils$.$anonfun$computeBlobDiff$7(z)));
            int MAX_CONTEXT = 40;
            byte[] contextA = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayA)).take(lenA))).drop(firstDiffIndex))).take(MAX_CONTEXT);
            byte[] contextB = (byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps((byte[])new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arrayB)).take(lenB))).drop(firstDiffIndex))).take(MAX_CONTEXT);
            String hexA = Misc$.MODULE$.bytes2Hex(contextA);
            String hexB = Misc$.MODULE$.bytes2Hex(contextB);
            int absoluteIndex = numSameBytes + firstDiffIndex;
            String path = new java.lang.StringBuilder(10).append(zPath).append(".bytesAt(").append(absoluteIndex + 1).append(")").toString();
            return (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)hexA, (Object)hexB), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public Seq<Tuple3<String, String, String>> computeTextDiff(String zPath, String dataA, String dataB, Option<String> maybeType) {
        if (!maybeType.isDefined()) ** GOTO lbl-1000
        v0 = maybeType.get();
        var6_5 = "xs:anyURI";
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        hasBlobType = v1;
        dataLooksLikeBlobURI = ((IterableLike)new .colon.colon((Object)dataA, (List)new .colon.colon((Object)dataB, (List)Nil$.MODULE$))).forall((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$computeTextDiff$1$adapted(java.lang.String ), (Ljava/lang/String;)Ljava/lang/Object;)());
        if (hasBlobType || dataLooksLikeBlobURI) {
            return this.computeBlobDiff(zPath, dataA, dataB);
        }
        if (this.textIsSame(dataA, dataB, maybeType)) {
            return Nil$.MODULE$;
        }
        CHARS_TO_SHOW_AFTER_DIFF = 40;
        lenA = dataA.length();
        lenB = dataB.length();
        for (index = 0; index < lenA && index < lenB && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataA), index) == StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(dataB), index); ++index) {
        }
        contextA = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataA), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        contextB = Misc$.MODULE$.remapControlsAndLineEndingsToVisibleGlyphs(StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(dataB), index, index + CHARS_TO_SHOW_AFTER_DIFF));
        path = new java.lang.StringBuilder(9).append(zPath).append(".charAt(").append(index + 1).append(")").toString();
        return (Seq)new .colon.colon((Object)new Tuple3((Object)path, (Object)contextA, (Object)contextB), (List)Nil$.MODULE$);
    }

    public boolean textIsSame(String dataA, String dataB, Option<String> maybeType) {
        String string;
        String string2;
        String string3;
        boolean bl = false;
        Some some = null;
        Option<String> option = maybeType;
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String string4 = (String)some.value();
            if ("xs:hexBinary".equals(string4)) {
                return dataA.equalsIgnoreCase(dataB);
            }
        }
        if (bl && "xs:date".equals(string3 = (String)some.value())) {
            DFDLDate a = DFDLDateConversion$.MODULE$.fromXMLString(dataA);
            DFDLDate b = DFDLDateConversion$.MODULE$.fromXMLString(dataB);
            DFDLDate dFDLDate = a;
            DFDLDate dFDLDate2 = b;
            return !(dFDLDate != null ? !((Object)dFDLDate).equals(dFDLDate2) : dFDLDate2 != null);
        }
        if (bl && "xs:time".equals(string2 = (String)some.value())) {
            DFDLTime a = DFDLTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLTime b = DFDLTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLTime dFDLTime = a;
            DFDLTime dFDLTime2 = b;
            return !(dFDLTime != null ? !((Object)dFDLTime).equals(dFDLTime2) : dFDLTime2 != null);
        }
        if (bl && "xs:dateTime".equals(string = (String)some.value())) {
            DFDLDateTime a = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataA);
            DFDLDateTime b = DFDLDateTimeConversion$.MODULE$.fromXMLString(dataB);
            DFDLDateTime dFDLDateTime = a;
            DFDLDateTime dFDLDateTime2 = b;
            return !(dFDLDateTime != null ? !((Object)dFDLDateTime).equals(dFDLDateTime2) : dFDLDateTime2 != null);
        }
        String string5 = dataA;
        String string6 = dataB;
        return !(string5 != null ? !string5.equals(string6) : string6 != null);
    }

    public File convertNodeToTempFile(Node xml, File tmpDir, String nameHint) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, ".dfdl.xsd", tmpDir);
        tmpSchemaFile.deleteOnExit();
        PrettyPrinter pp = new PrettyPrinter(2);
        String xmlString = pp.format(xml);
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        OutputStreamWriter fw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        fw.write(xmlString);
        fw.close();
        return tmpSchemaFile;
    }

    public String convertNodeToTempFile$default$3() {
        return "daffodil_tmp_";
    }

    private String prefixFromHint(String nameHint) {
        int n = nameHint.length();
        switch (n) {
            case 0: {
                return "daffodil_tmp_";
            }
            case 1: {
                return new java.lang.StringBuilder(2).append(nameHint).append("__").toString();
            }
            case 2: {
                return new java.lang.StringBuilder(1).append(nameHint).append("_").toString();
            }
        }
        return nameHint;
    }

    public File convertInputStreamToTempFile(InputStream is, File tmpDir, String nameHint, String suffix) {
        String prefix = this.prefixFromHint(nameHint);
        File tmpSchemaFile = File.createTempFile(prefix, suffix, tmpDir);
        tmpSchemaFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpSchemaFile);
        IOUtils.copy((InputStream)is, (OutputStream)fos);
        fos.close();
        return tmpSchemaFile;
    }

    public StringBuilder escape(String s, StringBuilder sb) {
        int i = 0;
        String str = this.xmlRemapperPreservingCR().remap(s);
        while (i < str.length()) {
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(str), i);
            ++i;
            char c2 = c;
            switch (c2) {
                case '\'': {
                    StringBuilder stringBuilder = sb.append("&#x27;");
                    break;
                }
                case '\"': {
                    StringBuilder stringBuilder = sb.append("&quot;");
                    break;
                }
                case '&': {
                    StringBuilder stringBuilder = sb.append("&amp;");
                    break;
                }
                case '<': {
                    StringBuilder stringBuilder = sb.append("&lt;");
                    break;
                }
                case '>': {
                    StringBuilder stringBuilder = sb.append("&gt;");
                    break;
                }
                default: {
                    StringBuilder stringBuilder;
                    if (RichChar$.MODULE$.isLetterOrDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(c)) || RichChar$.MODULE$.isControl$extension(Predef$.MODULE$.charWrapper(c))) {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c == '\u00a0') {
                        stringBuilder = this.toNumericCharacterEntity(c, sb);
                        break;
                    }
                    if (c < '\u00ff') {
                        stringBuilder = sb.append(c);
                        break;
                    }
                    stringBuilder = this.toNumericCharacterEntity(c, sb);
                    break;
                }
            }
        }
        return sb;
    }

    public StringBuilder escape$default$2() {
        return new StringBuilder();
    }

    private RemapXMLIllegalCharToPUA xmlRemapperPreservingCR() {
        return this.xmlRemapperPreservingCR;
    }

    public StringBuilder toNumericCharacterEntity(char c, StringBuilder sb) {
        char i = c;
        if (i <= '\u0000') {
            throw Assert$.MODULE$.abort("Usage error: i.>(0)");
        }
        String s = Integer.toHexString(i).toUpperCase();
        sb.append("&#x");
        sb.append(s);
        return sb.append(";");
    }

    private Regex xmlEntityPattern() {
        return this.xmlEntityPattern;
    }

    /*
     * WARNING - void declaration
     */
    public String unescape(String raw) {
        void var3_2;
        String res = this.xmlEntityPattern().replaceAllIn((CharSequence)raw, (Function1 & Serializable & scala.Serializable)m -> {
            StringBuilder sb = Utility$.MODULE$.unescape(m.group("entity"), new StringBuilder());
            if (sb == null) {
                throw Assert$.MODULE$.abort("Invariant broken: sb.ne(null)");
            }
            return sb.toString();
        });
        void withoutNamedXMLCharEntities = var3_2;
        return withoutNamedXMLCharEntities;
    }

    public Object maybeURI(NamespaceBinding nsb, String prefix) {
        while (nsb != null) {
            String string = nsb.prefix();
            String string2 = prefix;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Maybe$One$.MODULE$.apply(nsb.uri());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    public Object maybePrefix(NamespaceBinding nsb, String uri) {
        while (nsb != null) {
            String string = nsb.uri();
            String string2 = uri;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                if (nsb.prefix() == null) {
                    return Maybe$.MODULE$.Nope();
                }
                return Maybe$One$.MODULE$.apply(nsb.prefix());
            }
            nsb = nsb.parent();
        }
        return Maybe$.MODULE$.Nope();
    }

    private static final void processText$1(ObjectRef tn$1, ObjectRef sb$1, ArrayBuilder ab$1) {
        if ((Node)tn$1.elem == null) {
            if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() > 0) {
                ab$1.$plus$eq((Object)new Text(((StringBuilder)sb$1.elem).toString()));
                ((StringBuilder)sb$1.elem).clear();
                return;
            }
            return;
        }
        if ((StringBuilder)sb$1.elem != null && ((StringBuilder)sb$1.elem).length() != 0) {
            throw Assert$.MODULE$.abort("Invariant broken: sb.==(null).||(sb.length.==(0))");
        }
        ab$1.$plus$eq((Object)((Node)tn$1.elem));
        tn$1.elem = null;
    }

    public static final /* synthetic */ boolean $anonfun$dfdlAttributes$1(Node n$1, MetaData x$2) {
        String string = x$2.getNamespace(n$1);
        String string2 = MODULE$.DFDL_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$dfdlxAttributes$1(Node n$2, MetaData x$3) {
        String string = x$3.getNamespace(n$2);
        String string2 = MODULE$.DFDLX_NAMESPACE().toString();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$dafAttributes$1(Node n$3, MetaData a) {
        String string = a.getNamespace(n$3);
        String string2 = MODULE$.EXT_NS_NCSA().toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = a.getNamespace(n$3);
        String string4 = MODULE$.EXT_NS_APACHE().toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$removeComments$1(Node x$6) {
        return x$6 instanceof Comment;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$1(Node x$8) {
        return x$8 instanceof Elem;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$2(Elem e$1, Node x0$1) {
        String data;
        Node node = x0$1;
        Option option = Text$.MODULE$.unapply((Object)node);
        if (!option.isEmpty() && (data = (String)option.get()).matches("\\s*")) {
            return false;
        }
        Option option2 = Text$.MODULE$.unapply((Object)node);
        if (!option2.isEmpty()) {
            String data2 = (String)option2.get();
            throw new Exception(new StringOps(Predef$.MODULE$.augmentString("Element %s contains mixed data: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e$1.label(), data2})));
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$removeMixedWhitespace$4(Node x0$2) {
        String string;
        Node node = x0$2;
        Option option = Text$.MODULE$.unapply((Object)node);
        return option.isEmpty() || !"".equals(string = (String)option.get());
    }

    public static final /* synthetic */ NodeSeq $anonfun$removeAttributes1$1(Seq ns$1, NamespaceBinding newScope$2, Node x$10) {
        return MODULE$.removeAttributes1(x$10, (Seq<NS>)ns$1, (Option<NamespaceBinding>)new Some((Object)newScope$2));
    }

    public static final /* synthetic */ boolean $anonfun$removeAttributes1$2(Node x1$1, MetaData m) {
        Some some;
        String string;
        Some some2;
        String pre;
        Some some3;
        Some some4;
        boolean bl = false;
        PrefixedAttribute prefixedAttribute = null;
        MetaData metaData = m;
        if (metaData instanceof PrefixedAttribute) {
            bl = true;
            prefixedAttribute = (PrefixedAttribute)metaData;
            Some some5 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute);
            if (!some5.isEmpty()) {
                String string2;
                Option option;
                String string3 = (String)((Tuple4)some5.get())._2();
                Seq seq = (Seq)((Tuple4)some5.get())._3();
                if ("nil".equals(string3) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string2 = (String)option.get())) {
                    NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
                    NS nS2 = MODULE$.XSI_NAMESPACE();
                    if (!(nS != null ? !((Object)nS).equals(nS2) : nS2 != null)) {
                        return true;
                    }
                }
            }
        }
        if (bl && !(some4 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string4;
            Option option;
            String string5 = (String)((Tuple4)some4.get())._1();
            String string6 = (String)((Tuple4)some4.get())._2();
            Seq seq = (Seq)((Tuple4)some4.get())._3();
            if ("xsi".equals(string5) && "nil".equals(string6) && !(option = Text$.MODULE$.unapply((Object)seq)).isEmpty() && "true".equals(string4 = (String)option.get()) && prefixedAttribute.getNamespace(x1$1) == null) {
                return true;
            }
        }
        if (bl && !(some3 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && (pre = (String)((Tuple4)some3.get())._1()) != null) {
            String string7 = prefixedAttribute.getNamespace(x1$1);
            String string8 = MODULE$.DAFFODIL_INTERNAL_NAMESPACE().toString();
            if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                String string9 = pre;
                String string10 = "";
                if (!(string9 != null ? !string9.equals(string10) : string10 != null)) {
                    throw Assert$.MODULE$.abort("Invariant broken: pre.!=(\"\")");
                }
                return false;
            }
        }
        if (bl && !(some2 = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty() && "type".equals(string = (String)((Tuple4)some2.get())._2())) {
            NS nS = NS$.MODULE$.apply(prefixedAttribute.getNamespace(x1$1));
            NS nS3 = MODULE$.XSI_NAMESPACE();
            if (!(nS != null ? !((Object)nS).equals(nS3) : nS3 != null)) {
                return true;
            }
        }
        if (bl && !(some = PrefixedAttribute$.MODULE$.unapply(prefixedAttribute)).isEmpty()) {
            String string11 = (String)((Tuple4)some.get())._1();
            String string12 = (String)((Tuple4)some.get())._2();
            if ("xsi".equals(string11) && "type".equals(string12)) {
                return true;
            }
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$childArrayCounters$4(Tuple2 x0$2) {
        int n;
        Tuple2 tuple2 = x0$2;
        return tuple2 == null || 1 != (n = tuple2._2$mcI$sp());
    }

    private static final /* synthetic */ String zPath$lzycompute$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        String string;
        LazyRef lazyRef = zPath$lzy$1;
        synchronized (lazyRef) {
            string = zPath$lzy$1.initialized() ? (String)zPath$lzy$1.value() : (String)zPath$lzy$1.initialize((Object)((TraversableOnce)parentPathSteps$1.reverse()).mkString("/"));
        }
        return string;
    }

    private static final String zPath$1(LazyRef zPath$lzy$1, Seq parentPathSteps$1) {
        if (zPath$lzy$1.initialized()) {
            return (String)zPath$lzy$1.value();
        }
        return XMLUtils$.zPath$lzycompute$1(zPath$lzy$1, parentPathSteps$1);
    }

    public static final /* synthetic */ String $anonfun$computeDiffOne$13(int x$21) {
        return new java.lang.StringBuilder(2).append("[").append(x$21).append("]").toString();
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$15(Node x$23) {
        return x$23 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$16(Node x$24) {
        return x$24 instanceof ProcInstr;
    }

    public static final /* synthetic */ boolean $anonfun$computeDiffOne$18(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Seq v = (Seq)tuple2._2();
            return v.length() > 1;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$3(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$5(Path p) {
        return Files.isReadable(p);
    }

    public static final /* synthetic */ boolean $anonfun$computeBlobDiff$7(Tuple2 z) {
        return BoxesRunTime.unboxToByte((Object)z._1()) != BoxesRunTime.unboxToByte((Object)z._2());
    }

    private XMLUtils$() {
        MODULE$ = this;
        this.xmlNilAttribute = new PrefixedAttribute("xsi", "nil", "true", (MetaData)Null$.MODULE$);
        this.PositiveInfinityString = "INF";
        this.NegativeInfinityString = "-INF";
        this.NaNString = "NaN";
        this.remapXMLToPUA = new RemapXMLIllegalCharToPUA(true, true);
        this.remapPUAToXML = new RemapPUAToXMLIllegalChar();
        this.XSD_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema");
        this.XSI_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2001/XMLSchema-instance");
        this.XPATH_FUNCTION_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions");
        this.XPATH_MATH_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/2005/xpath-functions/math");
        this.DFDL_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/");
        this.DFDLX_NAMESPACE = NS$.MODULE$.apply("http://www.ogf.org/dfdl/dfdl-1.0/extensions");
        this.TDML_NAMESPACE = NS$.MODULE$.apply("http://www.ibm.com/xmlns/dfdl/testData");
        this.EXAMPLE_NAMESPACE = NS$.MODULE$.apply("http://example.com");
        this.XHTML_NAMESPACE = NS$.MODULE$.apply("http://www.w3.org/1999/xhtml");
        this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA = "urn:ogf:dfdl:2013:imp:opensource.ncsa.illinois.edu:2012";
        this.DAFFODIL_EXTENSION_NAMESPACE_NCSA = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_EXTENSIONS_NAMESPACE_ROOT_NCSA()).append(":ext").toString());
        this.EXT_PREFIX_NCSA = "daf";
        this.EXT_NS_NCSA = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_NCSA().uri());
        this.DAFFODIL_NAMESPACE_ROOT_APACHE = "urn:ogf:dfdl:2013:imp:daffodil.apache.org:2018";
        this.DAFFODIL_EXTENSION_NAMESPACE_APACHE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":ext").toString());
        this.EXT_PREFIX_APACHE = "daf";
        this.EXT_NS_APACHE = NS$.MODULE$.apply(this.DAFFODIL_EXTENSION_NAMESPACE_APACHE().uri());
        this.DAFFODIL_INTERNAL_NAMESPACE = NS$.MODULE$.apply(new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":int").toString());
        this.INT_PREFIX = "dafint";
        this.INT_NS = NS$.MODULE$.apply(this.DAFFODIL_INTERNAL_NAMESPACE().uri());
        this.DAFFODIL_SAX_URN_ROOT = new java.lang.StringBuilder(4).append(this.DAFFODIL_NAMESPACE_ROOT_APACHE()).append(":sax").toString();
        this.DAFFODIL_SAX_URN_PARSERESULT = new java.lang.StringBuilder(12).append(this.DAFFODIL_SAX_URN_ROOT()).append(":ParseResult").toString();
        this.DAFFODIL_SAX_URN_BLOBDIRECTORY = new java.lang.StringBuilder(14).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobDirectory").toString();
        this.DAFFODIL_SAX_URN_BLOBPREFIX = new java.lang.StringBuilder(11).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobPrefix").toString();
        this.DAFFODIL_SAX_URN_BLOBSUFFIX = new java.lang.StringBuilder(11).append(this.DAFFODIL_SAX_URN_ROOT()).append(":BlobSuffix").toString();
        this.SAX_NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
        this.SAX_NAMESPACE_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
        this.XML_DISALLOW_DOCTYPE_FEATURE = "http://apache.org/xml/features/disallow-doctype-decl";
        this.XML_EXTERNAL_PARAMETER_ENTITIES_FEATURE = "http://xml.org/sax/features/external-parameter-entities";
        this.XML_EXTERNAL_GENERAL_ENTITIES_FEATURE = "http://xml.org/sax/features/external-general-entities";
        this.XML_LOAD_EXTERNAL_DTD_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
        this.FILE_ATTRIBUTE_NAME = "file";
        this.LINE_ATTRIBUTE_NAME = "line";
        this.COLUMN_ATTRIBUTE_NAME = "col";
        this.xsdURI = this.XSD_NAMESPACE();
        this.dfdlURI = this.DFDL_NAMESPACE();
        this.dfdlxURI = this.DFDLX_NAMESPACE();
        this.dfdlAppinfoSource = NS$.MODULE$.apply("http://www.ogf.org/dfdl/");
        this.targetNS = this.EXAMPLE_NAMESPACE();
        this.xsiURI = this.XSI_NAMESPACE();
        this.fnURI = this.XPATH_FUNCTION_NAMESPACE();
        this.mathURI = this.XPATH_MATH_NAMESPACE();
        this.dafintURI = this.DAFFODIL_INTERNAL_NAMESPACE();
        this.DFDL_SIMPLE_BUILT_IN_TYPES = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "float", "double", "decimal", "integer", "long", "int", "short", "byte", "unsignedLong", "unsignedInt", "nonNegativeInteger", "unsignedShort", "unsignedByte", "boolean", "date", "time", "dateTime", "hexBinary"}));
        this.xmlRemapperPreservingCR = new RemapXMLIllegalCharToPUA(false, false);
        this.xmlEntityPattern = new Regex("&(quot|amp|apos|lt|gt);", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entity"}));
    }

    public static final /* synthetic */ Object $anonfun$computeTextDiff$1$adapted(String x$30) {
        return BoxesRunTime.boxToBoolean((boolean)x$30.startsWith("file://"));
    }
}

