/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Arrays;
import net.sf.saxon.Controller;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.ComponentBinding;
import net.sf.saxon.expr.ContextOriginator;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.TailCallLoop;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.ErrorReporter;
import net.sf.saxon.lib.ResourceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XsltController;
import net.sf.saxon.trans.rules.Rule;
import net.sf.saxon.trans.rules.RuleManager;
import net.sf.saxon.tree.iter.SingletonIterator;

public class XPathContextMajor
extends XPathContextMinor {
    private ParameterSet localParameters;
    private ParameterSet tunnelParameters;
    private TailCallLoop.TailCallInfo tailCallInfo;
    private ContextProperty firstProperty;
    private ContextOriginator origin;
    private ThreadManager threadManager = null;
    private Component currentComponent;

    public XPathContextMajor(Controller controller) {
        this.controller = controller;
        this.stackFrame = StackFrame.EMPTY;
        this.origin = controller;
    }

    private XPathContextMajor() {
    }

    public XPathContextMajor(Item item, Executable exec) {
        Controller controller = this.controller = exec instanceof PreparedStylesheet ? new XsltController(exec.getConfiguration(), (PreparedStylesheet)exec) : new Controller(exec.getConfiguration(), exec);
        if (item != null) {
            SequenceIterator iter = SingletonIterator.makeIterator(item);
            this.currentIterator = SequenceTool.focusTracker(iter);
            this.currentIterator.next();
            this.last = new XPathContextMinor.LastValue(1);
        }
        this.origin = this.controller;
    }

    @Override
    public XPathContextMajor newContext() {
        XPathContextMajor c = new XPathContextMajor();
        c.controller = this.controller;
        c.currentIterator = this.currentIterator;
        c.stackFrame = this.stackFrame;
        c.localParameters = this.localParameters;
        c.tunnelParameters = this.tunnelParameters;
        c.last = this.last;
        c.currentDestination = this.currentDestination;
        c.firstProperty = this.firstProperty;
        c.caller = this;
        c.tailCallInfo = null;
        c.temporaryOutputState = this.temporaryOutputState;
        c.threadManager = this.threadManager;
        c.currentComponent = this.currentComponent;
        return c;
    }

    public static XPathContextMajor newContext(XPathContextMinor prev) {
        XPathContextMajor c = new XPathContextMajor();
        XPathContextMajor p = prev.getMajorContext();
        c.controller = p.getController();
        c.currentIterator = prev.getCurrentIterator();
        c.stackFrame = prev.getStackFrame();
        c.localParameters = p.getLocalParameters();
        c.tunnelParameters = p.getTunnelParameters();
        c.last = prev.last;
        c.currentDestination = prev.currentDestination;
        c.firstProperty = p.firstProperty;
        c.caller = prev;
        c.tailCallInfo = null;
        c.threadManager = p.threadManager;
        c.currentComponent = p.currentComponent;
        c.temporaryOutputState = prev.temporaryOutputState;
        return c;
    }

    public static XPathContextMajor newThreadContext(XPathContextMinor prev) {
        XPathContextMajor c = XPathContextMajor.newContext(prev);
        c.stackFrame = prev.stackFrame.copy();
        return c;
    }

    @Override
    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void createThreadManager() {
        this.threadManager = this.getConfiguration().makeThreadManager();
    }

    @Override
    public void waitForChildThreads() throws XPathException {
        if (this.threadManager != null) {
            this.threadManager.waitForChildThreads();
        }
    }

    @Override
    public ParameterSet getLocalParameters() {
        if (this.localParameters == null) {
            this.localParameters = new ParameterSet();
        }
        return this.localParameters;
    }

    public void setLocalParameters(ParameterSet localParameters) {
        this.localParameters = localParameters;
    }

    @Override
    public ParameterSet getTunnelParameters() {
        return this.tunnelParameters;
    }

    public void setTunnelParameters(ParameterSet tunnelParameters) {
        this.tunnelParameters = tunnelParameters;
    }

    public void setOrigin(ContextOriginator expr) {
        this.origin = expr;
    }

    public ContextOriginator getOrigin() {
        return this.origin;
    }

    public void setStackFrame(SlotManager map, Sequence[] variables) {
        this.stackFrame = new StackFrame(map, variables);
        if (map != null && variables.length != map.getNumberOfVariables()) {
            if (variables.length > map.getNumberOfVariables()) {
                throw new IllegalStateException("Attempting to set more local variables (" + variables.length + ") than the stackframe can accommodate (" + map.getNumberOfVariables() + ")");
            }
            this.stackFrame.slots = new Sequence[map.getNumberOfVariables()];
            System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
        }
    }

    public void resetStackFrameMap(SlotManager map, int numberOfParams) {
        this.stackFrame.map = map;
        if (this.stackFrame.slots.length != map.getNumberOfVariables()) {
            Sequence[] v2 = new Sequence[map.getNumberOfVariables()];
            System.arraycopy(this.stackFrame.slots, 0, v2, 0, numberOfParams);
            this.stackFrame.slots = v2;
        } else {
            Arrays.fill(this.stackFrame.slots, numberOfParams, this.stackFrame.slots.length, null);
        }
    }

    public Sequence[] getAllVariableValues() {
        return this.stackFrame.getStackFrameValues();
    }

    public void resetAllVariableValues(Sequence[] values) {
        this.stackFrame.setStackFrameValues(values);
    }

    public void resetParameterValues(Sequence[] values) {
        System.arraycopy(values, 0, this.stackFrame.slots, 0, values.length);
    }

    public void requestTailCall(TailCallLoop.TailCallInfo targetFn, Sequence[] variables) {
        if (variables != null) {
            if (variables.length > this.stackFrame.slots.length) {
                this.stackFrame.slots = Arrays.copyOf(variables, variables.length);
            } else {
                System.arraycopy(variables, 0, this.stackFrame.slots, 0, variables.length);
            }
        }
        this.tailCallInfo = targetFn;
    }

    public TailCallLoop.TailCallInfo getTailCallInfo() {
        TailCallLoop.TailCallInfo fn = this.tailCallInfo;
        this.tailCallInfo = null;
        return fn;
    }

    public void openStackFrame(SlotManager map) {
        int numberOfSlots = map.getNumberOfVariables();
        this.stackFrame = numberOfSlots == 0 ? StackFrame.EMPTY : new StackFrame(map, new Sequence[numberOfSlots]);
    }

    public void openStackFrame(int numberOfVariables) {
        this.stackFrame = new StackFrame(new SlotManager(numberOfVariables), SequenceTool.makeSequenceArray(numberOfVariables));
    }

    public void setCurrentMode(Component.M mode) {
        if (mode != this.getCurrentMode()) {
            this.firstProperty = new CurrentMode(mode, this.firstProperty);
        }
    }

    @Override
    public Component.M getCurrentMode() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentMode) {
                return ((CurrentMode)p).mode;
            }
            p = p.next;
        }
        RuleManager rm = this.getController().getRuleManager();
        if (rm != null) {
            return rm.getUnnamedMode().getDeclaringComponent();
        }
        return null;
    }

    public void setCurrentTemplateRule(Rule rule) {
        if (rule != this.getCurrentTemplateRule()) {
            this.firstProperty = new CurrentTemplateRule(rule, this.firstProperty);
        }
    }

    @Override
    public Rule getCurrentTemplateRule() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentTemplateRule) {
                return ((CurrentTemplateRule)p).currentRule;
            }
            p = p.next;
        }
        return null;
    }

    public void setCurrentGroupIterator(GroupIterator iterator) {
        if (iterator != this.getCurrentGroupIterator()) {
            this.firstProperty = new CurrentGroupIterator(iterator, this.firstProperty);
        }
    }

    @Override
    public GroupIterator getCurrentGroupIterator() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentGroupIterator) {
                return ((CurrentGroupIterator)p).iterator;
            }
            p = p.next;
        }
        return null;
    }

    public void setCurrentMergeGroupIterator(GroupIterator iterator) {
        if (iterator != this.getCurrentMergeGroupIterator()) {
            this.firstProperty = new CurrentMergeGroupIterator(iterator, this.firstProperty);
        }
    }

    @Override
    public GroupIterator getCurrentMergeGroupIterator() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentMergeGroupIterator) {
                return ((CurrentMergeGroupIterator)p).iterator;
            }
            p = p.next;
        }
        return null;
    }

    public void setCurrentRegexIterator(RegexIterator currentRegexIterator) {
        if (currentRegexIterator != this.getCurrentRegexIterator()) {
            this.firstProperty = new CurrentRegexIterator(currentRegexIterator, this.firstProperty);
        }
    }

    @Override
    public RegexIterator getCurrentRegexIterator() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentRegexIterator) {
                return ((CurrentRegexIterator)p).iterator;
            }
            p = p.next;
        }
        return null;
    }

    @Override
    public int useLocalParameter(StructuredQName paramName, int slotNumber, boolean isTunnel) throws XPathException {
        Sequence val;
        ParameterSet params;
        ParameterSet parameterSet = params = isTunnel ? this.getTunnelParameters() : this.localParameters;
        if (params == null) {
            return 0;
        }
        int index = params.getIndex(paramName);
        if (index < 0) {
            return 0;
        }
        this.stackFrame.slots[slotNumber] = val = params.getValue(index);
        boolean checked = params.isTypeChecked(index);
        return checked ? 2 : 1;
    }

    public void setResourceResolver(ResourceResolver resolver) {
        if (resolver != this.getResourceResolver()) {
            this.firstProperty = new CurrentResourceResolver(resolver, this.firstProperty);
        }
    }

    @Override
    public ResourceResolver getResourceResolver() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentResourceResolver) {
                return ((CurrentResourceResolver)p).resolver;
            }
            p = p.next;
        }
        return this.controller.getResourceResolver();
    }

    public void setErrorReporter(ErrorReporter reporter) {
        if (reporter != this.getErrorReporter()) {
            this.firstProperty = new CurrentErrorReporter(reporter, this.firstProperty);
        }
    }

    @Override
    public ErrorReporter getErrorReporter() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentErrorReporter) {
                return ((CurrentErrorReporter)p).errorReporter;
            }
            p = p.next;
        }
        return this.controller.getErrorReporter();
    }

    public void setCurrentException(XPathException exception) {
        if (exception != this.getCurrentException()) {
            this.firstProperty = new CurrentException(exception, this.firstProperty);
        }
    }

    @Override
    public XPathException getCurrentException() {
        ContextProperty p = this.firstProperty;
        while (p != null) {
            if (p instanceof CurrentException) {
                return ((CurrentException)p).exception;
            }
            p = p.next;
        }
        return null;
    }

    @Override
    public Component getCurrentComponent() {
        return this.currentComponent;
    }

    public void setCurrentComponent(Component component) {
        this.currentComponent = component;
    }

    @Override
    public Component getTargetComponent(int bindingSlot) {
        try {
            ComponentBinding binding = this.currentComponent.getComponentBindings().get(bindingSlot);
            return binding.getTarget();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private static class CurrentResourceResolver
    extends ContextProperty {
        public ResourceResolver resolver;

        public CurrentResourceResolver(ResourceResolver resolver, ContextProperty next) {
            this.resolver = resolver;
            this.next = next;
        }
    }

    private static class CurrentErrorReporter
    extends ContextProperty {
        public ErrorReporter errorReporter;

        public CurrentErrorReporter(ErrorReporter errorReporter, ContextProperty next) {
            this.errorReporter = errorReporter;
            this.next = next;
        }
    }

    private static class CurrentException
    extends ContextProperty {
        public XPathException exception;

        public CurrentException(XPathException exception, ContextProperty next) {
            this.exception = exception;
            this.next = next;
        }
    }

    private static class CurrentMode
    extends ContextProperty {
        public Component.M mode;

        public CurrentMode(Component.M mode, ContextProperty next) {
            this.mode = mode;
            this.next = next;
        }
    }

    private static class CurrentTemplateRule
    extends ContextProperty {
        public Rule currentRule;

        public CurrentTemplateRule(Rule currentRule, ContextProperty next) {
            this.currentRule = currentRule;
            this.next = next;
        }
    }

    private static class CurrentMergeGroupIterator
    extends ContextProperty {
        public GroupIterator iterator;

        public CurrentMergeGroupIterator(GroupIterator iterator, ContextProperty next) {
            this.iterator = iterator;
            this.next = next;
        }
    }

    private static class CurrentGroupIterator
    extends ContextProperty {
        public GroupIterator iterator;

        public CurrentGroupIterator(GroupIterator iterator, ContextProperty next) {
            this.iterator = iterator;
            this.next = next;
        }
    }

    private static class CurrentRegexIterator
    extends ContextProperty {
        public RegexIterator iterator;

        public CurrentRegexIterator(RegexIterator iterator, ContextProperty next) {
            this.iterator = iterator;
            this.next = next;
        }
    }

    private static abstract class ContextProperty {
        public ContextProperty next;

        private ContextProperty() {
        }
    }

    public static abstract class ThreadManager {
        public abstract void waitForChildThreads() throws XPathException;
    }
}

