/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.udf;

import java.io.ByteArrayOutputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.daffodil.dpath.NodeInfo;
import org.apache.daffodil.dpath.NodeInfo$;
import org.apache.daffodil.dpath.PrimTypeNode;
import org.apache.daffodil.udf.UserDefinedFunction;
import org.apache.daffodil.udf.UserDefinedFunctionFatalErrorException;
import org.apache.daffodil.udf.UserDefinedFunctionIdentification;
import org.apache.daffodil.udf.UserDefinedFunctionProvider;
import org.apache.daffodil.udf.UserDefinedFunctionService;
import org.apache.daffodil.util.Misc$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.scala.Logger$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Seq$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class UserDefinedFunctionService$ {
    public static UserDefinedFunctionService$ MODULE$;
    private String evaluateMethodName;
    private Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification;
    private Class<UserDefinedFunction> classUserDefinedFunction;
    private String currentClassPath;
    private final HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup;
    private final HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache;
    private volatile byte bitmap$0;

    static {
        new UserDefinedFunctionService$();
    }

    private String evaluateMethodName$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.evaluateMethodName = "evaluate";
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.evaluateMethodName;
    }

    public String evaluateMethodName() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.evaluateMethodName$lzycompute();
        }
        return this.evaluateMethodName;
    }

    private HashMap<String, UserDefinedFunctionService.UserDefinedFunctionInfo> udfInfoLookup() {
        return this.udfInfoLookup;
    }

    private HashMap<String, Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo>> initializedUserDefinedFunctionsCache() {
        return this.initializedUserDefinedFunctionsCache;
    }

    private Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.classUserDefinedFunctionIdentification = UserDefinedFunctionIdentification.class;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.classUserDefinedFunctionIdentification;
    }

    public Class<UserDefinedFunctionIdentification> classUserDefinedFunctionIdentification() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.classUserDefinedFunctionIdentification$lzycompute();
        }
        return this.classUserDefinedFunctionIdentification;
    }

    private Class<UserDefinedFunction> classUserDefinedFunction$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.classUserDefinedFunction = UserDefinedFunction.class;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.classUserDefinedFunction;
    }

    public Class<UserDefinedFunction> classUserDefinedFunction() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.classUserDefinedFunction$lzycompute();
        }
        return this.classUserDefinedFunction;
    }

    private String currentClassPath$lzycompute() {
        UserDefinedFunctionService$ userDefinedFunctionService$ = this;
        synchronized (userDefinedFunctionService$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.currentClassPath = ((TraversableOnce)Misc$.MODULE$.classPath().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), scala.collection.Seq$.MODULE$.canBuildFrom())).mkString("\n");
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.currentClassPath;
    }

    public String currentClassPath() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.currentClassPath$lzycompute();
        }
        return this.currentClassPath;
    }

    public Option<UserDefinedFunctionService.UserDefinedFunctionCallingInfo> lookupUserDefinedFunctionCallingInfo(String namespaceURI, String fname) {
        String udfid = new StringBuilder(2).append("{").append(namespaceURI).append("}").append(fname).toString();
        Option udfFunctionCallingInfo = (Option)this.initializedUserDefinedFunctionsCache().getOrElse((Object)udfid, (Function0 & Serializable & scala.Serializable)() -> {
            Option maybeUdfInfo = MODULE$.udfInfoLookup().get((Object)udfid);
            return maybeUdfInfo.flatMap((Function1 & Serializable & scala.Serializable)udfInfo -> {
                None$ none$;
                try {
                    UserDefinedFunction udf2 = udfInfo.provider().createUserDefinedFunction(namespaceURI, fname);
                    try {
                        new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(udf2);
                        none$ = Option$.MODULE$.apply((Object)udf2);
                    }
                    catch (NotSerializableException e) {
                        BoxedUnit boxedUnit;
                        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(82).append("User Defined Function is not serializable: ").append(udf2.getClass().getName()).append(". Could not serialize member of class: ").append(e.getMessage()).toString(), null);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        none$ = None$.MODULE$;
                    }
                }
                catch (Exception e) {
                    Exception exception = e;
                    Throwable actualCause = exception instanceof ReflectiveOperationException ? e.getCause() : exception;
                    throw new UserDefinedFunctionFatalErrorException(new StringBuilder(48).append("User Defined Function could not be initialized: ").append(udfid).toString(), actualCause, udfInfo.udfClass().getName(), udfInfo.provider().getClass().getName());
                }
                None$ maybeUdf = none$;
                return maybeUdf.flatMap((Function1 & Serializable & scala.Serializable)udf -> {
                    Class<?> actualUdfClass;
                    Class<?> expectedUdfClass = udfInfo.udfClass();
                    Class<?> clazz = actualUdfClass = udf.getClass();
                    Class<?> clazz2 = expectedUdfClass;
                    if (clazz == null ? clazz2 != null : !clazz.equals(clazz2)) {
                        BoxedUnit boxedUnit;
                        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(59).append("User Defined Function class mismatch: ").append(udfid).append(". Expected: ").append(expectedUdfClass).append(" Actual: ").append(actualUdfClass).toString(), null);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        return None$.MODULE$;
                    }
                    UserDefinedFunctionService.EvaluateMethodInfo udfInfoEval = udfInfo.evaluateMethodInfo();
                    udfInfoEval.evaluateMethod().method();
                    Some udfci = new Some((Object)new UserDefinedFunctionService.UserDefinedFunctionCallingInfo((UserDefinedFunction)udf, udfInfo.evaluateMethodInfo()));
                    MODULE$.initializedUserDefinedFunctionsCache().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)udfid), (Object)udfci));
                    return udfci;
                });
            });
        });
        return udfFunctionCallingInfo;
    }

    private static final /* synthetic */ Option liftedTree1$1(Iterator providerIter$1) {
        Some some;
        try {
            some = new Some(providerIter$1.next());
        }
        catch (ServiceConfigurationError e) {
            BoxedUnit boxedUnit;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(47).append("User Defined Function Provider failed to load: ").append(e.getMessage()).toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            some = None$.MODULE$;
        }
        return some;
    }

    public static final /* synthetic */ boolean $anonfun$new$3(Class udfc) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        boolean nonUdf;
        boolean nonAnn = !udfc.isAnnotationPresent(MODULE$.classUserDefinedFunctionIdentification());
        boolean bl = nonUdf = !MODULE$.classUserDefinedFunction().isAssignableFrom(udfc);
        if (nonAnn) {
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(52).append("User Defined Function ignored: ").append(udfc.getName()).append(". Missing ").append(MODULE$.classUserDefinedFunctionIdentification().getName()).append(" annotation").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        if (nonUdf) {
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(51).append("User Defined Function ignored: ").append(udfc.getName()).append(". Doesn't implement ").append(MODULE$.classUserDefinedFunction().getName()).toString(), null);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        boolean ret = !nonAnn && !nonUdf;
        return ret;
    }

    public static final /* synthetic */ boolean $anonfun$new$5(Method x$2) {
        String string = x$2.getName();
        String string2 = MODULE$.evaluateMethodName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$4(Option providerOpt$1, Class fc) {
        BoxedUnit boxedUnit;
        Some some;
        PrimTypeNode evaluateReturnType;
        String fcClassName = fc.getName();
        UserDefinedFunctionIdentification fInfo = fc.getDeclaredAnnotation(MODULE$.classUserDefinedFunctionIdentification());
        String fns = fInfo.namespaceURI();
        String fname = fInfo.name();
        Method[] evalMethods = (Method[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fc.getMethods())).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$5(x$2)));
        if (Misc$.MODULE$.isNullOrBlank(fns)) {
            BoxedUnit boxedUnit2;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(80).append("User Defined Function ignored: ").append(fcClassName).append(". Annotation namespace field is empty or invalid.").toString(), null);
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            return;
        }
        if (Misc$.MODULE$.isNullOrBlank(fname)) {
            BoxedUnit boxedUnit3;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(75).append("User Defined Function ignored: ").append(fcClassName).append(". Annotation name field is empty or invalid.").toString(), null);
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            return;
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])evalMethods)).isEmpty()) {
            BoxedUnit boxedUnit4;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(59).append("User Defined Function ignored: ").append(fcClassName).append(". Missing evaluate method: ").append(fns).append(":").append(fname).toString(), null);
                boxedUnit4 = BoxedUnit.UNIT;
            } else {
                boxedUnit4 = BoxedUnit.UNIT;
            }
            return;
        }
        if (evalMethods.length > 1) {
            BoxedUnit boxedUnit5;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(62).append("User Defined Function ignored: ").append(fcClassName).append(". Overloaded evaluate method: ").append(fns).append(":").append(fname).toString(), null);
                boxedUnit5 = BoxedUnit.UNIT;
            } else {
                boxedUnit5 = BoxedUnit.UNIT;
            }
            return;
        }
        Method evaluateMethod = (Method)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])evalMethods)).head();
        Class[] paramTypes = evaluateMethod.getParameterTypes();
        Class<?> returnType = evaluateMethod.getReturnType();
        Tuple2[] initParamTypeConv = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])paramTypes)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Class c = (Class)tuple2._1();
                int i = tuple2._2$mcI$sp();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(NodeInfo$.MODULE$.fromClass(c)), (Object)BoxesRunTime.boxToInteger((int)i));
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        Option<PrimTypeNode> initRetTypeConv = NodeInfo$.MODULE$.fromClass(returnType);
        String[] badParams = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv)).collect((PartialFunction)new scala.Serializable(paramTypes){
            public static final long serialVersionUID = 0L;
            private final Class[] paramTypes$1;

            public final <A1 extends Tuple2<Option<PrimTypeNode>, Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    Option t = (Option)A1._1();
                    int i = A1._2$mcI$sp();
                    if (t.isEmpty()) {
                        Class cn = this.paramTypes$1[i];
                        return (B1)cn.getSimpleName();
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<Option<PrimTypeNode>, Object> x1) {
                Option t;
                Tuple2<Option<PrimTypeNode>, Object> tuple2 = x1;
                return tuple2 != null && (t = (Option)tuple2._1()).isEmpty();
            }
            {
                this.paramTypes$1 = paramTypes$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])badParams)).nonEmpty()) {
            BoxedUnit boxedUnit6;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(64).append("User Defined Function ignored: ").append(fcClassName).append(". Unsupported parameter type(s): ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])badParams)).mkString(",")).toString(), null);
                boxedUnit6 = BoxedUnit.UNIT;
            } else {
                boxedUnit6 = BoxedUnit.UNIT;
            }
            return;
        }
        if (initRetTypeConv.isEmpty()) {
            BoxedUnit boxedUnit7;
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(58).append("User Defined Function ignored: ").append(fcClassName).append(". Unsupported return type: ").append(returnType.getSimpleName()).toString(), null);
                boxedUnit7 = BoxedUnit.UNIT;
            } else {
                boxedUnit7 = BoxedUnit.UNIT;
            }
            return;
        }
        List evaluateParamTypes = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])initParamTypeConv)).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> Option$.MODULE$.option2Iterable((Option)x$3._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(PrimTypeNode.class))))).toList();
        Option<PrimTypeNode> option = initRetTypeConv;
        if (!(option instanceof Some) || (evaluateReturnType = (PrimTypeNode)(some = (Some)option).value()) == null) {
            throw new MatchError(option);
        }
        PrimTypeNode primTypeNode = evaluateReturnType;
        PrimTypeNode evaluateReturnType2 = primTypeNode;
        String key = new StringBuilder(2).append("{").append(fns).append("}").append(fname).toString();
        if (MODULE$.udfInfoLookup().contains((Object)key)) {
            BoxedUnit boxedUnit8;
            UserDefinedFunctionService.UserDefinedFunctionInfo udfInfo = (UserDefinedFunctionService.UserDefinedFunctionInfo)MODULE$.udfInfoLookup().apply((Object)key);
            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(56).append("User Defined Function ignored: ").append(fcClassName).append(". Duplicate ").append(key).append(" from ").append(udfInfo.udfClass().getName()).append(" found.").toString(), null);
                boxedUnit8 = BoxedUnit.UNIT;
            } else {
                boxedUnit8 = BoxedUnit.UNIT;
            }
            return;
        }
        UserDefinedFunctionService.UserDefinedFunctionMethod serializableEvaluate = new UserDefinedFunctionService.UserDefinedFunctionMethod(evaluateMethod.getDeclaringClass(), MODULE$.evaluateMethodName(), paramTypes);
        UserDefinedFunctionService.EvaluateMethodInfo emi = new UserDefinedFunctionService.EvaluateMethodInfo(serializableEvaluate, (List<NodeInfo.Kind>)evaluateParamTypes, evaluateReturnType2);
        MODULE$.udfInfoLookup().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new UserDefinedFunctionService.UserDefinedFunctionInfo(fc, (UserDefinedFunctionProvider)providerOpt$1.get(), emi)));
        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.DEBUG)) {
            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.DEBUG, null, (CharSequence)new StringBuilder(34).append("User Defined Function loaded: ").append(fcClassName).append(" => ").append(key).toString(), null);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private UserDefinedFunctionService$() {
        MODULE$ = this;
        this.udfInfoLookup = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.initializedUserDefinedFunctionsCache = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ServiceLoader<UserDefinedFunctionProvider> loader = ServiceLoader.load(UserDefinedFunctionProvider.class);
        Iterator<UserDefinedFunctionProvider> providerIter = loader.iterator();
        while (providerIter.hasNext()) {
            Option providerOpt = UserDefinedFunctionService$.liftedTree1$1(providerIter);
            Seq providerFunctionClasses = (Seq)providerOpt.map((Function1 & Serializable & scala.Serializable)provider -> {
                Seq seq;
                block7: {
                    try {
                        Class[] functionClasses = provider.getUserDefinedFunctionClasses();
                        if (functionClasses == null || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functionClasses)).isEmpty()) {
                            BoxedUnit boxedUnit;
                            if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                                Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(74).append("User Defined Function Provider ignored: ").append(provider.getClass().getName()).append(". No User Defined Functions found.").toString(), null);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                            break block7;
                        }
                        seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])functionClasses)).toSeq();
                    }
                    catch (Exception e) {
                        BoxedUnit boxedUnit;
                        if (org.apache.daffodil.util.Logger$.MODULE$.log().isEnabled(Level.WARN)) {
                            Logger$.MODULE$.logMessage$extension1(org.apache.daffodil.util.Logger$.MODULE$.log(), Level.WARN, null, (CharSequence)new StringBuilder(80).append("User Defined Function Provider ignored: ").append(provider.getClass().getName()).append(". Error loading User Defined Functions: ").append(e).toString(), null);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                }
                return seq;
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
            Seq goodFunctionClasses = (Seq)providerFunctionClasses.filter((Function1 & Serializable & scala.Serializable)udfc -> BoxesRunTime.boxToBoolean((boolean)UserDefinedFunctionService$.$anonfun$new$3(udfc)));
            goodFunctionClasses.foreach((Function1 & Serializable & scala.Serializable)fc -> {
                UserDefinedFunctionService$.$anonfun$new$4(providerOpt, fc);
                return BoxedUnit.UNIT;
            });
        }
    }
}

