/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.parsers;

import org.apache.daffodil.api.DataLocation;
import org.apache.daffodil.exceptions.Assert$;
import org.apache.daffodil.exceptions.SchemaFileLocation;
import org.apache.daffodil.infoset.DataValue$;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.processors.PrimProcessor;
import org.apache.daffodil.processors.Processor;
import org.apache.daffodil.processors.ToBriefXMLImpl;
import org.apache.daffodil.processors.parsers.PState;
import org.apache.daffodil.processors.parsers.Parser;
import org.apache.daffodil.processors.parsers.PrimParser;
import org.apache.daffodil.schema.annotation.props.gen.LengthUnits;
import org.apache.daffodil.util.MaybeULong$;
import passera.unsigned.ULong;
import passera.unsigned.ULong$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Q\u0001C\u0005\u0002\u0002QA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\tM\u0001\u0011\t\u0011)A\u0005O!Aq\u0006\u0001B\u0001B\u0003%\u0001\u0007C\u0003=\u0001\u0011\u0005Q\bC\u0003C\u0001\u0019\u00051\t\u0003\u0005M\u0001!\u0015\r\u0011\"\u0001N\u0011\u0015q\u0005\u0001\"\u0011P\u0005]\u0011\u0015N\\1ss\n{w\u000e\\3b]B\u000b'o]3s\u0005\u0006\u001cXM\u0003\u0002\u000b\u0017\u00059\u0001/\u0019:tKJ\u001c(B\u0001\u0007\u000e\u0003)\u0001(o\\2fgN|'o\u001d\u0006\u0003\u001d=\t\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003!E\ta!\u00199bG\",'\"\u0001\n\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00039ui\u0011!C\u0005\u0003=%\u0011!\u0002\u0015:j[B\u000b'o]3s\u0003Q\u0011\u0017N\\1ss\n{w\u000e\\3b]R\u0013X/\u001a*faB\u0011\u0011\u0005J\u0007\u0002E)\u00111%D\u0001\u0005kRLG.\u0003\u0002&E\tQQ*Y=cKVcuN\\4\u0002+\tLg.\u0019:z\u0005>|G.Z1o\r\u0006d7/\u001a*faB\u0011\u0001&L\u0007\u0002S)\u0011!fK\u0001\tk:\u001c\u0018n\u001a8fI*\tA&A\u0004qCN\u001cXM]1\n\u00059J#!B+M_:<\u0017a\u00037f]\u001e$\b.\u00168jiN\u0004\"!\r\u001e\u000e\u0003IR!a\r\u001b\u0002\u0007\u001d,gN\u0003\u00026m\u0005)\u0001O]8qg*\u0011q\u0007O\u0001\u000bC:tw\u000e^1uS>t'BA\u001d\u000e\u0003\u0019\u00198\r[3nC&\u00111H\r\u0002\f\u0019\u0016tw\r\u001e5V]&$8/\u0001\u0004=S:LGO\u0010\u000b\u0005}}\u0002\u0015\t\u0005\u0002\u001d\u0001!)q\u0004\u0002a\u0001A!)a\u0005\u0002a\u0001O!)q\u0006\u0002a\u0001a\u0005aq-\u001a;CSRdUM\\4uQR\u0011Ai\u0012\t\u0003-\u0015K!AR\f\u0003\u0007%sG\u000fC\u0003I\u000b\u0001\u0007\u0011*A\u0003ti\u0006$X\r\u0005\u0002\u001d\u0015&\u00111*\u0003\u0002\u0007!N#\u0018\r^3\u0002\rQ|')\u001b;t+\u0005!\u0015!\u00029beN,GC\u0001)T!\t1\u0012+\u0003\u0002S/\t!QK\\5u\u0011\u0015!v\u00011\u0001J\u0003\u0015\u0019H/\u0019:u\u0001")
public abstract class BinaryBooleanParserBase
implements PrimParser {
    private int toBits;
    private final long binaryBooleanTrueRep;
    private final long binaryBooleanFalseRep;
    private final LengthUnits lengthUnits;
    private String parserName;
    private boolean isInitialized;
    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    private volatile byte bitmap$0;

    @Override
    public boolean isEmpty() {
        return Parser.isEmpty$(this);
    }

    @Override
    public void PE(PState pstate, String s, Seq<Object> args) {
        Parser.PE$(this, pstate, s, args);
    }

    @Override
    public void PE(PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, String s, Seq<Object> args) {
        Parser.PE$(this, pstate, sfl, dataLoc, s, args);
    }

    @Override
    public void PENotEnoughBits(PState pstate, long neededBits, long remainingBits) {
        Parser.PENotEnoughBits$(this, pstate, neededBits, remainingBits);
    }

    @Override
    public void PENotEnoughBits(PState pstate, SchemaFileLocation sfl, DataLocation dataLoc, long neededBits, long remainingBits) {
        Parser.PENotEnoughBits$(this, pstate, sfl, dataLoc, neededBits, remainingBits);
    }

    @Override
    public void processingError(PState state, String str, Seq<Object> args) {
        Parser.processingError$(this, state, str, args);
    }

    @Override
    public final void parse1(PState pstate) {
        Parser.parse1$(this, pstate);
    }

    @Override
    public Vector<Processor> childProcessors() {
        return PrimProcessor.childProcessors$(this);
    }

    @Override
    public boolean isPrimitive() {
        return PrimProcessor.isPrimitive$(this);
    }

    @Override
    public String nom() {
        return ToBriefXMLImpl.nom$(this);
    }

    @Override
    public String briefXMLAttributes() {
        return ToBriefXMLImpl.briefXMLAttributes$(this);
    }

    @Override
    public String toBriefXML(int depthLimit) {
        return ToBriefXMLImpl.toBriefXML$(this, depthLimit);
    }

    @Override
    public int toBriefXML$default$1() {
        return ToBriefXMLImpl.toBriefXML$default$1$(this);
    }

    @Override
    public String toString() {
        return ToBriefXMLImpl.toString$(this);
    }

    private String parserName$lzycompute() {
        BinaryBooleanParserBase binaryBooleanParserBase = this;
        synchronized (binaryBooleanParserBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.parserName = Parser.parserName$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.parserName;
    }

    @Override
    public String parserName() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.parserName$lzycompute();
        }
        return this.parserName;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    private String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute() {
        BinaryBooleanParserBase binaryBooleanParserBase = this;
        synchronized (binaryBooleanParserBase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_ = ToBriefXMLImpl.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    @Override
    public String org$apache$daffodil$processors$ToBriefXMLImpl$$nom_() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_$lzycompute();
        }
        return this.org$apache$daffodil$processors$ToBriefXMLImpl$$nom_;
    }

    public abstract int getBitLength(PState var1);

    private int toBits$lzycompute() {
        BinaryBooleanParserBase binaryBooleanParserBase = this;
        synchronized (binaryBooleanParserBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                int n;
                LengthUnits lengthUnits = this.lengthUnits;
                if (LengthUnits.Bits$.MODULE$.equals(lengthUnits)) {
                    n = 1;
                } else if (LengthUnits.Bytes$.MODULE$.equals(lengthUnits)) {
                    n = 8;
                } else {
                    throw this.context().schemaDefinitionError("Binary Numbers must have length units of Bits or Bytes.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                this.toBits = n;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.toBits;
    }

    public int toBits() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.toBits$lzycompute();
        }
        return this.toBits;
    }

    @Override
    public void parse(PState start) {
        Boolean bl;
        int nBits = this.getBitLength(start);
        if (nBits < 1 || nBits > 32) {
            this.PE(start, "Number of bits %d out of range for xs:boolean, must be between 1 and 32 bits.", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)nBits)}));
            return;
        }
        if (!MaybeULong$.MODULE$.isEmpty$extension(this.binaryBooleanTrueRep) && !ULong$.MODULE$.$greater$eq$extension3(MaybeULong$.MODULE$.getULong$extension(this.binaryBooleanTrueRep), 0L)) {
            throw Assert$.MODULE$.abort("Invariant broken: BinaryBooleanParserBase.this.binaryBooleanTrueRep.isEmpty.||(BinaryBooleanParserBase.this.binaryBooleanTrueRep.getULong.>=(passera.unsigned.ULong.apply(0L)))");
        }
        if (!ULong$.MODULE$.$greater$eq$extension3(this.binaryBooleanFalseRep, 0L)) {
            throw Assert$.MODULE$.abort("Invariant broken: BinaryBooleanParserBase.this.binaryBooleanFalseRep.>=(passera.unsigned.ULong.apply(0L))");
        }
        InputSourceDataInputStream dis = start.dataInputStream();
        if (!dis.isDefinedForLength((long)nBits)) {
            this.PENotEnoughBits(start, nBits, dis.remainingBits());
            return;
        }
        long sl = dis.getUnsignedLong(nBits, (FormatInfo)start);
        if (!MaybeULong$.MODULE$.isDefined$extension(this.binaryBooleanTrueRep)) {
            bl = this.binaryBooleanFalseRep == sl ? Predef$.MODULE$.boolean2Boolean(false) : Predef$.MODULE$.boolean2Boolean(true);
        } else if (MaybeULong$.MODULE$.getULong$extension(this.binaryBooleanTrueRep) == sl) {
            bl = Predef$.MODULE$.boolean2Boolean(true);
        } else if (this.binaryBooleanFalseRep == sl) {
            bl = Predef$.MODULE$.boolean2Boolean(false);
        } else {
            this.PE(start, "Unable to parse xs:boolean from binary: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new ULong(sl)}));
            return;
        }
        Boolean bool = bl;
        start.simpleElement().overwriteDataValue(DataValue$.MODULE$.toDataValue(bool));
    }

    public BinaryBooleanParserBase(long binaryBooleanTrueRep, long binaryBooleanFalseRep, LengthUnits lengthUnits) {
        this.binaryBooleanTrueRep = binaryBooleanTrueRep;
        this.binaryBooleanFalseRep = binaryBooleanFalseRep;
        this.lengthUnits = lengthUnits;
        ToBriefXMLImpl.$init$(this);
        Processor.$init$(this);
        PrimProcessor.$init$(this);
        Parser.$init$(this);
    }
}

