/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core.types;

import com.siemens.ct.exi.core.context.QNameContext;
import com.siemens.ct.exi.core.datatype.Datatype;
import com.siemens.ct.exi.core.datatype.DatetimeDatatype;
import com.siemens.ct.exi.core.datatype.EnumDatatype;
import com.siemens.ct.exi.core.datatype.EnumerationDatatype;
import com.siemens.ct.exi.core.datatype.ExtendedStringDatatype;
import com.siemens.ct.exi.core.datatype.ListDatatype;
import com.siemens.ct.exi.core.datatype.NBitUnsignedIntegerDatatype;
import com.siemens.ct.exi.core.datatype.RestrictedCharacterSetDatatype;
import com.siemens.ct.exi.core.datatype.strings.StringEncoder;
import com.siemens.ct.exi.core.datatype.strings.StringEncoderImpl;
import com.siemens.ct.exi.core.exceptions.EXIException;
import com.siemens.ct.exi.core.io.channel.EncoderChannel;
import com.siemens.ct.exi.core.types.AbstractTypeEncoder;
import com.siemens.ct.exi.core.types.BuiltInType;
import com.siemens.ct.exi.core.util.MethodsBag;
import com.siemens.ct.exi.core.values.AbstractBinaryValue;
import com.siemens.ct.exi.core.values.BinaryBase64Value;
import com.siemens.ct.exi.core.values.BinaryHexValue;
import com.siemens.ct.exi.core.values.BooleanValue;
import com.siemens.ct.exi.core.values.DateTimeValue;
import com.siemens.ct.exi.core.values.DecimalValue;
import com.siemens.ct.exi.core.values.FloatValue;
import com.siemens.ct.exi.core.values.IntegerValue;
import com.siemens.ct.exi.core.values.ListValue;
import com.siemens.ct.exi.core.values.StringValue;
import com.siemens.ct.exi.core.values.Value;
import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedTypeEncoder
extends AbstractTypeEncoder {
    public Datatype lastDatatype;
    protected final boolean doNormalize;
    protected byte[] lastBytes;
    protected BooleanValue lastBool;
    protected int lastBooleanID;
    protected boolean lastBoolean;
    protected DecimalValue lastDecimal;
    protected FloatValue lastFloat;
    protected IntegerValue lastNBitInteger;
    protected IntegerValue lastUnsignedInteger;
    protected IntegerValue lastInteger;
    protected DateTimeValue lastDatetime;
    protected String lastString;
    protected int lastEnumIndex;
    protected ListValue lastListValues;

    public TypedTypeEncoder() throws EXIException {
        this(false);
    }

    public TypedTypeEncoder(boolean doNormalize) throws EXIException {
        this(null, null, null);
    }

    public TypedTypeEncoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype) throws EXIException {
        this(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype, false);
    }

    public TypedTypeEncoder(QName[] dtrMapTypes, QName[] dtrMapRepresentations, Map<QName, Datatype> dtrMapRepresentationsDatatype, boolean doNormalize) throws EXIException {
        super(dtrMapTypes, dtrMapRepresentations, dtrMapRepresentationsDatatype);
        this.doNormalize = doNormalize;
    }

    @Override
    public boolean isValid(Datatype datatype, Value value) {
        this.lastDatatype = this.dtrMapInUse && datatype.getBuiltInType() != BuiltInType.EXTENDED_STRING ? this.getDtrDatatype(datatype) : datatype;
        switch (this.lastDatatype.getBuiltInType()) {
            case BINARY_BASE64: 
            case BINARY_HEX: {
                if (value instanceof AbstractBinaryValue) {
                    this.lastBytes = ((AbstractBinaryValue)value).toBytes();
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case BOOLEAN: {
                if (value instanceof BooleanValue) {
                    this.lastBool = (BooleanValue)value;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case BOOLEAN_FACET: {
                if (value instanceof BooleanValue) {
                    this.lastBoolean = ((BooleanValue)value).toBoolean();
                    this.lastBooleanID = this.lastBoolean ? 2 : 0;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case DECIMAL: {
                if (value instanceof DecimalValue) {
                    this.lastDecimal = (DecimalValue)value;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case FLOAT: {
                if (value instanceof FloatValue) {
                    this.lastFloat = (FloatValue)value;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case NBIT_UNSIGNED_INTEGER: {
                NBitUnsignedIntegerDatatype nbitDT = (NBitUnsignedIntegerDatatype)this.lastDatatype;
                if (value instanceof IntegerValue) {
                    this.lastNBitInteger = (IntegerValue)value;
                    return this.lastNBitInteger.compareTo(nbitDT.getLowerBound()) >= 0 && this.lastNBitInteger.compareTo(nbitDT.getUpperBound()) <= 0;
                }
                return this.isValidString(value.toString());
            }
            case UNSIGNED_INTEGER: {
                if (value instanceof IntegerValue) {
                    this.lastUnsignedInteger = (IntegerValue)value;
                    return this.lastUnsignedInteger.isPositive();
                }
                return this.isValidString(value.toString());
            }
            case INTEGER: {
                if (value instanceof IntegerValue) {
                    this.lastInteger = (IntegerValue)value;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case DATETIME: {
                if (value instanceof DateTimeValue) {
                    this.lastDatetime = (DateTimeValue)value;
                    return true;
                }
                return this.isValidString(value.toString());
            }
            case STRING: {
                this.lastString = value.toString();
                return true;
            }
            case RCS_STRING: {
                this.lastString = value.toString();
                return true;
            }
            case EXTENDED_STRING: {
                this.lastString = value.toString();
                return true;
            }
            case ENUMERATION: {
                EnumerationDatatype enumDT = (EnumerationDatatype)this.lastDatatype;
                for (int index = 0; index < enumDT.getEnumerationSize(); ++index) {
                    if (!enumDT.getEnumValue(index).equals(value)) continue;
                    this.lastEnumIndex = index;
                    return true;
                }
                return false;
            }
            case LIST: {
                if (value instanceof ListValue) {
                    ListDatatype listDT = (ListDatatype)this.lastDatatype;
                    ListValue lv = (ListValue)value;
                    if (listDT.getListDatatype().getBuiltInType() == lv.getListDatatype().getBuiltInType()) {
                        this.lastListValues = lv;
                        return true;
                    }
                    this.lastListValues = null;
                    return false;
                }
                return this.isValidString(value.toString());
            }
            case QNAME: {
                return false;
            }
        }
        return false;
    }

    protected boolean isValidString(String value) {
        switch (this.lastDatatype.getBuiltInType()) {
            case BINARY_BASE64: {
                value = value.trim();
                BinaryBase64Value bvb = BinaryBase64Value.parse(value);
                if (bvb == null) {
                    return false;
                }
                this.lastBytes = bvb.toBytes();
                return true;
            }
            case BINARY_HEX: {
                value = value.trim();
                BinaryHexValue bvh = BinaryHexValue.parse(value);
                if (bvh == null) {
                    return false;
                }
                this.lastBytes = bvh.toBytes();
                return true;
            }
            case BOOLEAN: {
                this.lastBool = BooleanValue.parse(value);
                return this.lastBool != null;
            }
            case BOOLEAN_FACET: {
                value = value.trim();
                boolean retValue = true;
                if (value.equals("false")) {
                    this.lastBooleanID = 0;
                    this.lastBoolean = false;
                } else if (value.equals("0")) {
                    this.lastBooleanID = 1;
                    this.lastBoolean = false;
                } else if (value.equals("true")) {
                    this.lastBooleanID = 2;
                    this.lastBoolean = true;
                } else if (value.equals("1")) {
                    this.lastBooleanID = 3;
                    this.lastBoolean = true;
                } else {
                    retValue = false;
                }
                return retValue;
            }
            case DECIMAL: {
                this.lastDecimal = DecimalValue.parse(value);
                return this.lastDecimal != null;
            }
            case FLOAT: {
                this.lastFloat = FloatValue.parse(value);
                return this.lastFloat != null;
            }
            case NBIT_UNSIGNED_INTEGER: {
                this.lastNBitInteger = IntegerValue.parse(value);
                if (this.lastNBitInteger == null) {
                    return false;
                }
                NBitUnsignedIntegerDatatype nbitDT = (NBitUnsignedIntegerDatatype)this.lastDatatype;
                return this.lastNBitInteger.compareTo(nbitDT.getLowerBound()) >= 0 && this.lastNBitInteger.compareTo(nbitDT.getUpperBound()) <= 0;
            }
            case UNSIGNED_INTEGER: {
                this.lastUnsignedInteger = IntegerValue.parse(value);
                if (this.lastUnsignedInteger != null) {
                    return this.lastUnsignedInteger.isPositive();
                }
                return false;
            }
            case INTEGER: {
                this.lastInteger = IntegerValue.parse(value);
                return this.lastInteger != null;
            }
            case DATETIME: {
                DatetimeDatatype datetimeDT = (DatetimeDatatype)this.lastDatatype;
                this.lastDatetime = DateTimeValue.parse(value, datetimeDT.getDatetimeType());
                return this.lastDatetime != null;
            }
            case LIST: {
                ListDatatype listDT = (ListDatatype)this.lastDatatype;
                this.lastListValues = ListValue.parse(value, listDT.getListDatatype());
                return this.lastListValues != null;
            }
        }
        return false;
    }

    protected void normalize(Datatype datatype) {
        switch (datatype.getBuiltInType()) {
            case DATETIME: {
                if (this.lastDatetime == null) break;
                this.lastDatetime = this.lastDatetime.normalize();
                break;
            }
            case LIST: {
                if (this.lastListValues == null) break;
                Datatype dt = this.lastListValues.getListDatatype();
                for (Value v : this.lastListValues.toValues()) {
                    this.isValid(dt, v);
                    this.normalize(dt);
                }
                break;
            }
        }
    }

    @Override
    public void writeValue(QNameContext qnContext, EncoderChannel valueChannel, StringEncoder stringEncoder) throws IOException {
        if (this.doNormalize) {
            this.normalize(this.lastDatatype);
        }
        switch (this.lastDatatype.getBuiltInType()) {
            case BINARY_BASE64: 
            case BINARY_HEX: {
                valueChannel.encodeBinary(this.lastBytes);
                break;
            }
            case BOOLEAN: {
                valueChannel.encodeBoolean(this.lastBool.toBoolean());
                break;
            }
            case BOOLEAN_FACET: {
                valueChannel.encodeNBitUnsignedInteger(this.lastBooleanID, 2);
                break;
            }
            case DECIMAL: {
                valueChannel.encodeDecimal(this.lastDecimal.isNegative(), this.lastDecimal.getIntegral(), this.lastDecimal.getRevFractional());
                break;
            }
            case FLOAT: {
                valueChannel.encodeFloat(this.lastFloat);
                break;
            }
            case NBIT_UNSIGNED_INTEGER: {
                NBitUnsignedIntegerDatatype nbitDT = (NBitUnsignedIntegerDatatype)this.lastDatatype;
                IntegerValue iv = this.lastNBitInteger.subtract(nbitDT.getLowerBound());
                valueChannel.encodeNBitUnsignedInteger(iv.intValue(), nbitDT.getNumberOfBits());
                break;
            }
            case UNSIGNED_INTEGER: {
                valueChannel.encodeUnsignedIntegerValue(this.lastUnsignedInteger);
                break;
            }
            case INTEGER: {
                valueChannel.encodeIntegerValue(this.lastInteger);
                break;
            }
            case DATETIME: {
                valueChannel.encodeDateTime(this.lastDatetime);
                break;
            }
            case STRING: {
                stringEncoder.writeValue(qnContext, valueChannel, this.lastString);
                break;
            }
            case RCS_STRING: {
                RestrictedCharacterSetDatatype rcsDT = (RestrictedCharacterSetDatatype)this.lastDatatype;
                this.writeRCSValue(rcsDT, qnContext, valueChannel, stringEncoder, this.lastString);
                break;
            }
            case EXTENDED_STRING: {
                ExtendedStringDatatype esDT = (ExtendedStringDatatype)this.lastDatatype;
                this.writeExtendedValue(esDT, qnContext, valueChannel, stringEncoder, this.lastString);
                break;
            }
            case ENUMERATION: {
                EnumerationDatatype enumDT = (EnumerationDatatype)this.lastDatatype;
                valueChannel.encodeNBitUnsignedInteger(this.lastEnumIndex, enumDT.getCodingLength());
                break;
            }
            case LIST: {
                ListDatatype listDT = (ListDatatype)this.lastDatatype;
                Datatype listDatatype = listDT.getListDatatype();
                Value[] values = this.lastListValues.toValues();
                valueChannel.encodeUnsignedInteger(values.length);
                for (int i = 0; i < values.length; ++i) {
                    Value v = values[i];
                    boolean valid = this.isValid(listDatatype, v);
                    if (!valid) {
                        throw new RuntimeException("ListValue is not valid, " + v);
                    }
                    this.writeValue(qnContext, valueChannel, stringEncoder);
                }
                break;
            }
            case QNAME: {
                throw new IOException("QName is not an allowed as EXI datatype");
            }
            default: {
                throw new IOException("EXI datatype not supported");
            }
        }
    }

    int getEnumIndex(EnumDatatype grammarStrings, StringValue sv) {
        for (int i = 0; i < grammarStrings.getEnumerationSize(); ++i) {
            Value v = grammarStrings.getEnumValue(i);
            if (!sv.equals(v)) continue;
            return i;
        }
        return -1;
    }

    protected void writeExtendedValue(ExtendedStringDatatype esDT, QNameContext context, EncoderChannel valueChannel, StringEncoder stringEncoder, String value) throws IOException {
        EnumDatatype grammarStrings = esDT.getGrammarStrings();
        StringEncoderImpl.ValueContainer vc = stringEncoder.getValueContainer(value);
        if (vc != null) {
            if (stringEncoder.isLocalValuePartitions() && context.equals(vc.context)) {
                valueChannel.encodeUnsignedInteger(0);
                int numberBitsLocal = MethodsBag.getCodingLength(stringEncoder.getNumberOfStringValues(context));
                valueChannel.encodeNBitUnsignedInteger(vc.localValueID, numberBitsLocal);
            } else {
                valueChannel.encodeUnsignedInteger(1);
                int numberBitsGlobal = MethodsBag.getCodingLength(stringEncoder.getValueContainerSize());
                valueChannel.encodeNBitUnsignedInteger(vc.globalValueID, numberBitsGlobal);
            }
        } else {
            int gindex = -1;
            if (grammarStrings != null && (gindex = this.getEnumIndex(grammarStrings, new StringValue(value))) >= 0) {
                valueChannel.encodeUnsignedInteger(2);
                valueChannel.encodeNBitUnsignedInteger(gindex, grammarStrings.getCodingLength());
            } else {
                int L = value.codePointCount(0, value.length());
                valueChannel.encodeUnsignedInteger(L + 6);
                if (L > 0) {
                    valueChannel.encodeStringOnly(value);
                    stringEncoder.addValue(context, value);
                }
            }
        }
    }
}

