/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.processors.charset;

import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.processors.charset.BitsCharsetDecoderCreatesSurrogates;
import org.apache.daffodil.processors.charset.BitsCharsetDecoderMalformedException;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3A!\u0002\u0004\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C)5!)a\u0006\u0001C\u0003_!)q\b\u0001C\u0003\u0001\n1\")\u001b;t\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s+R3\u0005H\u0003\u0002\b\u0011\u000591\r[1sg\u0016$(BA\u0005\u000b\u0003)\u0001(o\\2fgN|'o\u001d\u0006\u0003\u00171\t\u0001\u0002Z1gM>$\u0017\u000e\u001c\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0011\u0002CA\n\u0015\u001b\u00051\u0011BA\u000b\u0007\u0005\r\u0012\u0015\u000e^:DQ\u0006\u00148/\u001a;EK\u000e|G-\u001a:De\u0016\fG/Z:TkJ\u0014xnZ1uKN\fa\u0001P5oSRtD#\u0001\r\u0011\u0005M\u0001\u0011\u0001\u00063fG>$Wm\u00148f+:L7m\u001c3f\u0007\"\f'\u000fF\u0002\u001cC%\u0002\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011Aa\u00115be\")!E\u0001a\u0001G\u0005\u0019A-[:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019R\u0011AA5p\u0013\tASE\u0001\u000eJ]B,HoU8ve\u000e,G)\u0019;b\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0003+\u0005\u0001\u00071&A\u0003gS:4w\u000e\u0005\u0002%Y%\u0011Q&\n\u0002\u000b\r>\u0014X.\u0019;J]\u001a|\u0017!F2iK\u000e\\7i\u001c8uS:,\u0018\r^5p]\nKH/\u001a\u000b\u0005aM\"\u0014\b\u0005\u0002\u001dc%\u0011!'\b\u0002\u0005+:LG\u000fC\u0003#\u0007\u0001\u00071\u0005C\u00036\u0007\u0001\u0007a'\u0001\u0003csR,\u0007C\u0001\u000f8\u0013\tATDA\u0002J]RDQAO\u0002A\u0002Y\n\u0011CY5ug\u000e{gn];nK\u0012\u001cvNR1sQ\t\u0019A\b\u0005\u0002\u001d{%\u0011a(\b\u0002\u0007S:d\u0017N\\3\u0002\u001b\rDWmY6Pm\u0016\u0014Hn\u001c8h)\u0019\u0001\u0014iQ#H\u0013\")!\t\u0002a\u0001m\u0005)!-\u001f;fc!)A\t\u0002a\u0001m\u0005)Q.Y:lc!)a\t\u0002a\u0001m\u0005)!-\u001f;fe!)\u0001\n\u0002a\u0001m\u0005)Q.Y:le!)!\b\u0002a\u0001m!\u0012A\u0001\u0010")
public class BitsCharsetDecoderUTF8
extends BitsCharsetDecoderCreatesSurrogates {
    @Override
    public char decodeOneUnicodeChar(InputSourceDataInputStream dis, FormatInfo finfo) {
        int byte1 = this.getByte(dis, 0);
        if ((byte1 & 0x80) == 0) {
            return (char)byte1;
        }
        if ((byte1 & 0xE0) == 192) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            this.checkOverlong(byte1, 31, 0, 0, 16);
            int cp = (byte1 & 0x1F) << 6 | byte2 & 0x3F;
            return (char)cp;
        }
        if ((byte1 & 0xF0) == 224) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            this.checkOverlong(byte1, 15, byte2, 32, 24);
            int cp = (byte1 & 0xF) << 12 | (byte2 & 0x3F) << 6 | byte3 & 0x3F;
            if (cp >= 55296 && cp <= 57343) {
                throw new BitsCharsetDecoderMalformedException(24);
            }
            return (char)cp;
        }
        if ((byte1 & 0xF8) == 240) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            this.checkOverlong(byte1, 7, byte2, 48, 32);
            int cp = (byte1 & 0xF) << 18 | (byte2 & 0x3F) << 12 | (byte3 & 0x3F) << 6 | byte4 & 0x3F;
            if (cp > 0x10FFFF) {
                throw new BitsCharsetDecoderMalformedException(32);
            }
            char high = Character.highSurrogate(cp);
            this.setLowSurrogate(Character.lowSurrogate(cp));
            return high;
        }
        if ((byte1 & 0xFC) == 248) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            throw new BitsCharsetDecoderMalformedException(40);
        }
        if ((byte1 & 0xFE) == 252) {
            int byte2 = this.getByte(dis, 8);
            this.checkContinuationByte(dis, byte2, 16);
            int byte3 = this.getByte(dis, 16);
            this.checkContinuationByte(dis, byte3, 24);
            int byte4 = this.getByte(dis, 24);
            this.checkContinuationByte(dis, byte4, 32);
            int byte5 = this.getByte(dis, 32);
            this.checkContinuationByte(dis, byte5, 40);
            int byte6 = this.getByte(dis, 40);
            this.checkContinuationByte(dis, byte6, 48);
            throw new BitsCharsetDecoderMalformedException(48);
        }
        throw new BitsCharsetDecoderMalformedException(8);
    }

    public final void checkContinuationByte(InputSourceDataInputStream dis, int n, int bitsConsumedSoFar) {
        if ((n & 0xC0) != 128) {
            dis.setBitPos0b(dis.bitPos0b() - 8L);
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar - 8);
        }
    }

    public final void checkOverlong(int byte1, int mask1, int byte2, int mask2, int bitsConsumedSoFar) {
        if ((byte1 & mask1) == 0 && (byte2 & mask2) == 0) {
            throw new BitsCharsetDecoderMalformedException(bitsConsumedSoFar);
        }
    }
}

