/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.io.FormatInfo;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Maybe;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.runtime1.infoset.DISimple;
import org.apache.daffodil.runtime1.infoset.DataValue$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.PrimProcessor;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ToBriefXMLImpl;
import org.apache.daffodil.runtime1.processors.unparsers.PrimUnparser;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.runtime1.processors.unparsers.UnparseError$;
import org.apache.daffodil.runtime1.processors.unparsers.Unparser;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005-3Qa\u0002\u0005\u0002\u0002MA\u0001B\t\u0001\u0003\u0006\u0004%\te\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005I!)\u0011\u0006\u0001C\u0001U!)a\u0006\u0001C!_!)1\b\u0001D\ty!)Q\t\u0001C!\r\n)\u0002*\u001a=CS:\f'/_+oa\u0006\u00148/\u001a:CCN,'BA\u0005\u000b\u0003!\u0011XO\u001c;j[\u0016\f$BA\u0006\r\u0003%)h\u000e]1sg\u0016\u00148O\u0003\u0002\u000e\u001d\u0005AA-\u00194g_\u0012LGN\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7\u0001A\n\u0004\u0001QQ\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g\r\u0005\u0002\u001cA5\tAD\u0003\u0002\f;)\u0011adH\u0001\u000baJ|7-Z:t_J\u001c(BA\u0005\r\u0013\t\tCD\u0001\u0007Qe&lWK\u001c9beN,'/A\u0004d_:$X\r\u001f;\u0016\u0003\u0011\u0002\"!\n\u0014\u000e\u0003uI!aJ\u000f\u0003%\u0015cW-\\3oiJ+h\u000e^5nK\u0012\u000bG/Y\u0001\tG>tG/\u001a=uA\u00051A(\u001b8jiz\"\"aK\u0017\u0011\u00051\u0002Q\"\u0001\u0005\t\u000b\t\u001a\u0001\u0019\u0001\u0013\u0002'I,h\u000e^5nK\u0012+\u0007/\u001a8eK:\u001c\u0017.Z:\u0016\u0003A\u00022!\r\u001c9\u001b\u0005\u0011$BA\u001a5\u0003%IW.\\;uC\ndWM\u0003\u00026-\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005]\u0012$A\u0002,fGR|'\u000f\u0005\u0002\u0016s%\u0011!H\u0006\u0002\b\u001d>$\b.\u001b8h\u0003=9W\r\u001e'f]\u001e$\b.\u00138CSR\u001cHCA\u001fA!\t)b(\u0003\u0002@-\t!Aj\u001c8h\u0011\u0015\tU\u00011\u0001C\u0003\u0015\u0019H/\u0019;f!\tY2)\u0003\u0002E9\t1Qk\u0015;bi\u0016\fq!\u001e8qCJ\u001cX\r\u0006\u0002H\u0015B\u0011Q\u0003S\u0005\u0003\u0013Z\u0011A!\u00168ji\")\u0011I\u0002a\u0001\u0005\u0002")
public abstract class HexBinaryUnparserBase
implements PrimUnparser {
    private final ElementRuntimeData context;
    private boolean isInitialized;
    private String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    private volatile boolean bitmap$0;

    public Vector<Processor> childProcessors() {
        return PrimProcessor.childProcessors$((PrimProcessor)this);
    }

    public boolean isPrimitive() {
        return PrimProcessor.isPrimitive$((PrimProcessor)this);
    }

    public boolean isEmpty() {
        return Unparser.isEmpty$((Unparser)this);
    }

    public final void unparse1(UState ustate, Object ignore) {
        Unparser.unparse1$((Unparser)this, (UState)ustate, (Object)ignore);
    }

    public final Object unparse1$default$2() {
        return Unparser.unparse1$default$2$((Unparser)this);
    }

    public Nothing$ UE(UState ustate, String s, Seq<Object> args) {
        return Unparser.UE$((Unparser)this, (UState)ustate, (String)s, args);
    }

    public String nom() {
        return ToBriefXMLImpl.nom$((ToBriefXMLImpl)this);
    }

    public String briefXMLAttributes() {
        return ToBriefXMLImpl.briefXMLAttributes$((ToBriefXMLImpl)this);
    }

    public String toBriefXML(int depthLimit) {
        return ToBriefXMLImpl.toBriefXML$((ToBriefXMLImpl)this, (int)depthLimit);
    }

    public int toBriefXML$default$1() {
        return ToBriefXMLImpl.toBriefXML$default$1$((ToBriefXMLImpl)this);
    }

    public String toString() {
        return ToBriefXMLImpl.toString$((ToBriefXMLImpl)this);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void isInitialized_$eq(boolean x$1) {
        this.isInitialized = x$1;
    }

    private String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzycompute() {
        HexBinaryUnparserBase hexBinaryUnparserBase = this;
        synchronized (hexBinaryUnparserBase) {
            if (!this.bitmap$0) {
                this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_ = ToBriefXMLImpl.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$((ToBriefXMLImpl)this);
                this.bitmap$0 = true;
            }
        }
        return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    }

    public String org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_() {
        if (!this.bitmap$0) {
            return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_$lzycompute();
        }
        return this.org$apache$daffodil$runtime1$processors$ToBriefXMLImpl$$nom_;
    }

    public ElementRuntimeData context() {
        return this.context;
    }

    public Vector<Nothing$> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)Nil$.MODULE$);
    }

    public abstract long getLengthInBits(UState var1);

    public void unparse(UState state) {
        boolean ret;
        long l;
        DISimple node = state.currentInfosetNode().asSimple();
        byte[] value = DataValue$.MODULE$.getByteArray$extension(node.dataValue());
        long valueLengthInBytes = value.length;
        if (valueLengthInBytes > (long)state.tunable().maxHexBinaryLengthInBytes()) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Length of xs:hexBinary exceeds maximum of %s bytes: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state.tunable().maxHexBinaryLengthInBytes()), BoxesRunTime.boxToLong((long)valueLengthInBytes)}));
        }
        long lengthInBits = this.getLengthInBits(state);
        long lengthInBytes = (lengthInBits + 7L) / 8L;
        if (valueLengthInBytes > lengthInBytes) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Length of xs:hexBinary exceeds calculated length of %s bits: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(valueLengthInBytes * 8L)), BoxesRunTime.boxToLong((long)lengthInBits)}));
        }
        if (lengthInBytes > valueLengthInBytes) {
            l = valueLengthInBytes * 8L;
        } else {
            if (lengthInBytes != valueLengthInBytes) {
                throw Assert$.MODULE$.abort("Invariant broken: lengthInBytes.==(valueLengthInBytes)");
            }
            l = lengthInBits;
        }
        long bitsFromValueToPut = l;
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        if (bitsFromValueToPut > 0L && !(ret = dos.putByteArray(value, bitsFromValueToPut, (FormatInfo)state, dos.putByteArray$default$4()))) {
            throw UnparseError$.MODULE$.apply(Maybe.One$.MODULE$.apply((Object)this.context().schemaFileLocation()), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Failed to write %d hexBinary bits", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)bitsFromValueToPut)}));
        }
        long nFillBits = lengthInBits - bitsFromValueToPut;
        if (nFillBits > 0L) {
            boolean ret2 = dos.skip(nFillBits, (FormatInfo)state);
            if (!ret2) {
                throw UnparseError$.MODULE$.apply(Maybe$.MODULE$.Nope(), Maybe.One$.MODULE$.apply((Object)state.currentLocation()), "Failed to skip %d bits.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)nFillBits)}));
            }
            return;
        }
    }

    public HexBinaryUnparserBase(ElementRuntimeData context) {
        this.context = context;
        ToBriefXMLImpl.$init$((ToBriefXMLImpl)this);
        Processor.$init$((Processor)this);
        Unparser.$init$((Unparser)this);
        PrimProcessor.$init$((PrimProcessor)this);
    }
}

