/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.Misc$nonGlyphToVisibleGlyphsRemapper$;
import passera.unsigned.UByte;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;
import scala.xml.include.sax.EncodingHeuristics$;

public final class Misc$ {
    public static final Misc$ MODULE$ = new Misc$();
    private static Seq<URL> classPath;
    private static String byteToCharTable;
    private static final char[] hexLookup;
    private static volatile byte bitmap$0;

    static {
        hexLookup = (char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString("0123456789ABCDEF"), (ClassTag)ClassTag$.MODULE$.Char());
    }

    public <T> Option<T> boolToOpt(boolean test, Function0<T> thing) {
        if (test) {
            return new Some(thing.apply());
        }
        return None$.MODULE$;
    }

    public String getNameFromClass(Object obj) {
        return this.getNameGivenAClassObject(obj.getClass());
    }

    public String getNameGivenAClassObject(Class<?> clazz) {
        if (clazz == null) {
            return "null";
        }
        String nonPackageClassName = (String)Predef$.MODULE$.wrapRefArray((Object[])clazz.getName().split("\\.")).toList().reverse().head();
        List nonDollarsParts = Predef$.MODULE$.wrapRefArray((Object[])nonPackageClassName.split("\\$")).toList().reverse();
        List nonNumericParts = nonDollarsParts.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.matches("\\d*")));
        String nameToken = (String)nonNumericParts.head();
        return nameToken;
    }

    public String stripSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public String stripQuotes(String s) {
        String stripFirst = s.startsWith("\"") ? s.substring(1) : s;
        String stripLast = stripFirst.endsWith("\"") ? stripFirst.substring(0, stripFirst.length() - 1) : stripFirst;
        return stripLast;
    }

    public boolean isNullOrBlank(String s) {
        boolean b = Option$.MODULE$.apply((Object)s).isEmpty() || s.trim().isEmpty();
        return b;
    }

    public boolean isFileURI(URI uri) {
        if (uri.isAbsolute()) {
            String protocol;
            String string = protocol = uri.toURL().getProtocol();
            String string2 = "file";
            boolean result = !(string != null ? !string.equals(string2) : string2 != null);
            return result;
        }
        return false;
    }

    public Tuple2<Option<URI>, String> getResourceOption(String resourcePathRaw) {
        String resourcePath = resourcePathRaw.replaceAll("\\s", "%20");
        String resPath = resourcePath.startsWith("/") ? resourcePath : new java.lang.StringBuilder(1).append("/").append(resourcePath).toString();
        Option res = Option$.MODULE$.apply((Object)this.getClass().getResource(resPath));
        return new Tuple2((Object)res.map((Function1 & Serializable)x$2 -> x$2.toURI()), (Object)resPath);
    }

    private Option<URI> getResourceAbsoluteOrRelativeOption(String rawResName, Option<URI> optContextURI) {
        String resName = rawResName.replaceAll("\\s", "%20");
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resName);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option maybeRes = (Option)tuple2._1();
        Option maybeRes2 = maybeRes;
        if (maybeRes2.isDefined()) {
            return maybeRes2;
        }
        return optContextURI.flatMap((Function1 & Serializable)contextURI -> MODULE$.getResourceRelativeOnlyOption(resName, (URI)contextURI));
    }

    public Option<URI> getResourceRelativeOnlyOption(String relPath, URI contextURI) {
        if (relPath == null) {
            throw Assert$.MODULE$.usageError("relPath.ne(null)");
        }
        if (contextURI == null) {
            throw Assert$.MODULE$.usageError("contextURI.ne(null)");
        }
        String string = contextURI.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case -341064690: {
                if (!"resource".equals(string)) break;
                return this.optRelativeResourceURI(contextURI, relPath);
            }
            case 104987: {
                if (!"jar".equals(string)) break;
                return this.optRelativeJarFileURI(contextURI, relPath);
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                return this.optRelativeFileURI(contextURI, relPath);
            }
        }
        throw new IllegalArgumentException(new java.lang.StringBuilder(25).append("Unrecognized URI scheme: ").append(contextURI).toString());
    }

    public Tuple2<String, String> splitJarUri(URI uri) {
        String string = uri.getScheme();
        String string2 = "jar";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw Assert$.MODULE$.abort("Invariant broken: uri.getScheme().==(\"jar\")");
        }
        String uriStr = uri.toString();
        int exclamIdx = uriStr.lastIndexOf("!");
        String jarPart = uriStr.substring(0, exclamIdx);
        String pathPart = uriStr.substring(exclamIdx + 1);
        return new Tuple2((Object)jarPart, (Object)pathPart);
    }

    public Option<URI> optRelativeJarFileURI(URI contextURI, String relPath) {
        None$ none$;
        Tuple2<String, String> tuple2 = this.splitJarUri(contextURI);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String jarPart = (String)tuple2._1();
        String pathPart = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)jarPart, (Object)pathPart);
        String jarPart2 = (String)tuple22._1();
        String pathPart2 = (String)tuple22._2();
        if (!pathPart2.startsWith("/")) {
            throw Assert$.MODULE$.abort("Invariant broken: pathPart.startsWith(\"/\")");
        }
        URI contextURIPathOnly = URI.create(pathPart2);
        URI resolvedURIPathOnly = contextURIPathOnly.resolve(relPath);
        URI newJarPathURI = URI.create(new java.lang.StringBuilder(1).append(jarPart2).append("!").append(resolvedURIPathOnly.toString()).toString());
        try {
            newJarPathURI.toURL().openStream().close();
            none$ = new Some((Object)newJarPathURI);
        }
        catch (IOException io) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<URI> optRelativeFileURI(URI contextURI, String relPath) {
        URI resourceURI = contextURI.resolve(relPath);
        if (Paths.get(resourceURI).toFile().exists()) {
            return new Some((Object)resourceURI);
        }
        return None$.MODULE$;
    }

    public Option<URI> optRelativeResourceURI(URI contextURI, String relPath) {
        URI resolvedURI = contextURI.resolve(relPath);
        if (this.getClass().getResource(resolvedURI.getPath()) != null) {
            return new Some((Object)resolvedURI);
        }
        return None$.MODULE$;
    }

    public Option<URI> searchResourceOption(String resName, Option<URI> relativeTo) {
        URI resAsURI = new URI(resName);
        Path resPath = resAsURI.getScheme() != null ? Paths.get(resAsURI) : Paths.get(resName, new String[0]);
        Some resolvedURI = Files.exists(resPath, new LinkOption[0]) ? new Some((Object)resPath.toFile().toURI()) : this.getResourceAbsoluteOrRelativeOption(resName, relativeTo);
        Option res = resolvedURI.orElse((Function0 & Serializable)() -> {
            String[] parts = resName.split("/");
            if (parts.length > 1) {
                String filePart = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])parts));
                Option<URI> secondTry = MODULE$.searchResourceOption(filePart, relativeTo);
                return secondTry;
            }
            return None$.MODULE$;
        });
        return res;
    }

    private Seq<URL> classPath$lzycompute() {
        Misc$ misc$ = this;
        synchronized (misc$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                Seq urls;
                Seq seq;
                ClassLoader cl = this.getClass().getClassLoader();
                ClassLoader classLoader = cl;
                if (classLoader instanceof URLClassLoader) {
                    URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
                    seq = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])uRLClassLoader.getURLs()));
                } else {
                    seq = (Seq)package$.MODULE$.Seq().empty();
                }
                classPath = urls = seq;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return classPath;
    }

    public Seq<URL> classPath() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.classPath$lzycompute();
        }
        return classPath;
    }

    public URI getRequiredResource(String resourcePath) {
        Option option;
        Tuple2<Option<URI>, String> tuple2 = this.getResourceOption(resourcePath);
        if (tuple2 != null) {
            Option option2 = (Option)tuple2._1();
            String resPath = (String)tuple2._2();
            if (None$.MODULE$.equals(option2)) {
                String msg = new java.lang.StringBuilder(47).append("Required resource ").append(resPath).append(" was not found.\nClasspath is ").append((Object)(this.classPath().length() == 0 ? "unknown." : new java.lang.StringBuilder(2).append(": ").append(this.classPath().mkString("\n")).toString())).toString();
                throw new FileNotFoundException(msg);
            }
        }
        if (tuple2 != null && (option = (Option)tuple2._1()) instanceof Some) {
            Some some = (Some)option;
            URI res = (URI)some.value();
            return res;
        }
        throw new MatchError(tuple2);
    }

    public String initialUpperCase(String s) {
        char c = RichChar$.MODULE$.toUpper$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public String initialLowerCase(String s) {
        char c = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.head$extension(Predef$.MODULE$.augmentString(s))));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public String toInitialLowerCaseUnlessAllUpperCase(String s) {
        if (RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)))) {
            return s;
        }
        if (this.isAllUpper(s, 1)) {
            return s;
        }
        char c = RichChar$.MODULE$.toLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), 0)));
        return StringOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.augmentString(s.substring(1)), c);
    }

    public boolean isAllUpper(String s, int start) {
        int l = s.length();
        for (int i = start; i < l; ++i) {
            if (!RichChar$.MODULE$.isLower$extension(Predef$.MODULE$.charWrapper(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(s), i)))) continue;
            return false;
        }
        return true;
    }

    public boolean isAllWhitespace(StringBuilder sb) {
        if (sb.isEmpty()) {
            return false;
        }
        int sbLen = sb.length();
        for (int in = 0; in < sbLen; ++in) {
            if (RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(sb.charAt(in)))) continue;
            return false;
        }
        return true;
    }

    public String getDaffodilVersion() {
        URI uri = this.getRequiredResource("org/apache/daffodil/lib/VERSION");
        String version = Source$.MODULE$.fromInputStream(uri.toURL().openStream(), "UTF-8").mkString();
        return version;
    }

    public byte[] hex2Bytes(String hex) {
        int len = hex.length();
        if (len % 2 != 0) {
            throw new NumberFormatException(new java.lang.StringBuilder(64).append("Hex string must have an even number of characters, but was ").append(len).append(" for ").append(hex).toString());
        }
        int numBytes = len / 2;
        byte[] arr = new byte[numBytes];
        int arrIdx = 0;
        int hexIdx = 0;
        while (arrIdx < numBytes) {
            int l = Misc$.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx));
            int r = Misc$.hexCharToValue$1(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(hex), hexIdx + 1));
            arr[arrIdx] = (byte)(l << 4 | r);
            ++arrIdx;
            hexIdx += 2;
        }
        return arr;
    }

    public String hex2Bits(String hex) {
        IndexedSeq nums = StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(hex), (Function1 & Serializable)ch -> BoxesRunTime.boxToInteger((int)Misc$.$anonfun$hex2Bits$1(BoxesRunTime.unboxToChar((Object)ch))));
        IndexedSeq bits = (IndexedSeq)nums.map((Function1 & Serializable)x$4 -> Misc$.$anonfun$hex2Bits$2(BoxesRunTime.unboxToInt((Object)x$4)));
        IndexedSeq paddedBits = (IndexedSeq)bits.map((Function1 & Serializable)x$5 -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%4s"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{x$5})).replaceAll(" ", "0"));
        String res = paddedBits.mkString();
        return res;
    }

    private char[] hexLookup() {
        return hexLookup;
    }

    public String bytes2Hex(byte[] bytes) {
        if (bytes.length > 0x3FFFFFFF) {
            throw Assert$.MODULE$.abort("Invariant broken: bytes.length.<=(1073741823)");
        }
        char[] hexArr = new char[bytes.length * 2];
        int bytIdx = 0;
        int hexIdx = 0;
        while (bytIdx < bytes.length) {
            int b = bytes[bytIdx] & 0xFF;
            hexArr[hexIdx] = this.hexLookup()[b >>> 4];
            hexArr[hexIdx + 1] = this.hexLookup()[b & 0xF];
            ++bytIdx;
            hexIdx += 2;
        }
        return new String(hexArr);
    }

    public byte[] bits2Bytes(String bits) {
        if (bits.isEmpty()) {
            return (byte[])Nil$.MODULE$.toArray((ClassTag)ClassTag$.MODULE$.Byte());
        }
        return this.bits2Bytes((Seq<String>)new .colon.colon((Object)bits, (List)Nil$.MODULE$));
    }

    public byte[] bits2Bytes(Seq<String> bits) {
        String allBitsOnly = ((IterableOnceOps)bits.flatMap((Function1 & Serializable)x$6 -> Predef$.MODULE$.wrapRefArray((Object[])x$6.split("[^01]")))).mkString();
        Iterator byteSizedBits = StringOps$.MODULE$.sliding$extension(Predef$.MODULE$.augmentString(allBitsOnly), 8, 8);
        return (byte[])byteSizedBits.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToByte((byte)Misc$.$anonfun$bits2Bytes$2(x$7))).toArray((ClassTag)ClassTag$.MODULE$.Byte());
    }

    public String bytes2Bits(byte[] bytes) {
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(bytes), (Function1 & Serializable)b -> StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(RichInt$.MODULE$.toBinaryString$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToByte((Object)b) & 0xFF))))), 8, '0'))), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    public ReadableByteChannel stringToReadableByteChannel(String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        return this.byteArrayToReadableByteChannel(bytes);
    }

    public WritableByteChannel stringToWritableByteChannel(String s) {
        int size = s.length();
        return this.byteArrayToWritableByteChannel(size);
    }

    public ReadableByteChannel byteArrayToReadableByteChannel(byte[] bytes) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return rbc;
    }

    public WritableByteChannel byteArrayToWritableByteChannel(int size) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(size);
        WritableByteChannel wbc = Channels.newChannel(outputStream);
        return wbc;
    }

    public ReadableByteChannel fileToReadableByteChannel(File file) {
        FileInputStream inputStream = new FileInputStream(file);
        ReadableByteChannel rbc = Channels.newChannel(inputStream);
        return rbc;
    }

    public String remapStringToVisibleGlyphs(String s) {
        return Misc$nonGlyphToVisibleGlyphsRemapper$.MODULE$.remap(s);
    }

    public char remapControlOrLineEndingToVisibleGlyphs(char c, boolean replaceControlPictures) {
        int URC = 9254;
        char c2 = c;
        int code = c2 <= '\u001f' ? c2 + 9216 : (' ' == c2 ? 9251 : ('\u007f' == c2 ? 9249 : (c2 >= '\u0080' && c2 <= '\u009f' ? c2 + 256 : ('\u00a0' == c2 ? 9250 : ('\u00ad' == c2 ? 45 : ('\u200b' == c2 ? URC : ('\u2028' == c2 ? URC : ('\u2029' == c2 ? URC : ('\u200c' == c2 ? URC : ('\u200d' == c2 ? URC : ('\u2060' == c2 ? URC : (('\u200e' == c2 ? true : '\u200f' == c2) ? URC : (c2 >= '\u202a' && c2 <= '\u202e' ? URC : ('\ufffe' == c2 ? URC : ('\uffff' == c2 ? URC : (c2 > '\u2400' && c2 < '\u2423' && replaceControlPictures ? URC : (int)c2))))))))))))))));
        return (char)code;
    }

    public boolean remapControlOrLineEndingToVisibleGlyphs$default$2() {
        return false;
    }

    private String byteToCharTable$lzycompute() {
        Misc$ misc$ = this;
        synchronized (misc$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                String res;
                ByteBuffer bb;
                Charset cs = Charset.forName("windows-1252");
                CharsetDecoder dec = cs.newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE).onMalformedInput(CodingErrorAction.REPORT);
                CharBuffer cb = dec.decode(bb = ByteBuffer.wrap((byte[])RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 255).map((Function1 & Serializable)i -> BoxesRunTime.boxToByte((byte)Misc$.$anonfun$byteToCharTable$1(BoxesRunTime.unboxToInt((Object)i)))).toArray((ClassTag)ClassTag$.MODULE$.Byte())));
                Predef$.MODULE$.assert(cb.position() == 0);
                Predef$.MODULE$.assert(cb.limit() == 256);
                cb.put(129, '\u0181');
                cb.put(141, '\u018d');
                cb.put(143, '\u018f');
                cb.put(144, '\u0190');
                cb.put(157, '\u019d');
                byteToCharTable = res = cb.toString();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return byteToCharTable;
    }

    private String byteToCharTable() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.byteToCharTable$lzycompute();
        }
        return byteToCharTable;
    }

    public char byteToChar(byte b) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.byteToCharTable()), new UByte(b).toInt());
    }

    public String remapBytesToStringOfVisibleGlyphs(byte[] ba) {
        int len = ba.length;
        if (len == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(ba.length);
        for (int i = 0; i < ba.length; ++i) {
            sb.append(this.remapControlOrLineEndingToVisibleGlyphs(this.byteToChar(ba[i]), this.remapControlOrLineEndingToVisibleGlyphs$default$2()));
        }
        return sb.toString();
    }

    public char remapOneByteToVisibleGlyph(byte b) {
        return this.remapControlOrLineEndingToVisibleGlyphs(this.byteToChar(b), this.remapControlOrLineEndingToVisibleGlyphs$default$2());
    }

    public boolean isAsciiBased(String csName) {
        return this.isAsciiBased(Charset.forName(csName));
    }

    public boolean isAsciiBased(Charset cs) {
        Seq aliases = (Seq)CollectionConverters$.MODULE$.SetHasAsScala(cs.aliases()).asScala().toSeq().map((Function1 & Serializable)x$8 -> x$8.toUpperCase());
        boolean byName = aliases.exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Misc$.$anonfun$isAsciiBased$2(s)));
        if (byName) {
            return byName;
        }
        CharsetDecoder decoder = cs.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        byte[] abcBytes = "abc".getBytes("ascii");
        ByteBuffer bb = ByteBuffer.wrap(abcBytes);
        CharBuffer cb = decoder.decode(bb);
        String abc = cb.toString();
        return package$TypeEqual$.MODULE$.$eq$colon$eq$extension(org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(abc), "abc", package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality());
    }

    public void writeToFile(String fileName, Function1<Writer, BoxedUnit> body) {
        FileWriter writer = new FileWriter(fileName);
        Using$.MODULE$.resource((Object)writer, (Function1 & Serializable)x$9 -> {
            body.apply((Object)x$9);
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    public String determineEncoding(URI uri) {
        EncodingHeuristics$ encH = EncodingHeuristics$.MODULE$;
        InputStream is = uri.toURL().openStream();
        BufferedInputStream bis = new BufferedInputStream(is);
        String enc = encH.readEncodingFromStream((InputStream)bis);
        is.close();
        return enc;
    }

    public String determineEncoding(File file) {
        return this.determineEncoding(file.toURI());
    }

    public String csToString(CharSequence cs) {
        CharSequence charSequence = cs;
        if (charSequence instanceof String) {
            String string = (String)charSequence;
            return string;
        }
        StringBuilder sb = new StringBuilder(cs.length());
        sb.append(cs);
        return sb.mkString();
    }

    /*
     * Unable to fully structure code
     */
    public String getAMessage(Throwable th) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        m = th.getMessage();
                        var6_4 = new Tuple2((Object)m, (Object)(c = th.getCause()));
                        if (var6_4 == null) break block5;
                        var7_5 = (String)var6_4._1();
                        var8_6 = (Throwable)var6_4._2();
                        if (var7_5 != null || var8_6 != null) break block5;
                        v0 = this.getNameFromClass(th);
                        break block6;
                    }
                    if (var6_4 == null) break block7;
                    var9_7 = (String)var6_4._1();
                    var10_8 = (Throwable)var6_4._2();
                    if (!"".equals(var9_7) || var10_8 != null) break block7;
                    v0 = this.getNameFromClass(th);
                    break block6;
                }
                if (var6_4 == null) break block8;
                m = (String)var6_4._1();
                var12_10 = (Throwable)var6_4._2();
                if (var12_10 != null) break block8;
                v0 = m;
                break block6;
            }
            if (var6_4 == null) ** GOTO lbl-1000
            var13_11 = (String)var6_4._1();
            c = (Throwable)var6_4._2();
            if (var13_11 == null) {
                v0 = this.getAMessage(c);
            } else if (var6_4 != null) {
                m = (String)var6_4._1();
                c = (Throwable)var6_4._2();
                cmsg = this.getAMessage(c);
                v0 = new java.lang.StringBuilder(11).append(cmsg).append(" (within ").append(th.getClass().getSimpleName()).append(" ").append(m).append(")").toString();
            } else {
                throw new MatchError((Object)var6_4);
            }
        }
        res = v0;
        if (res == null) {
            throw Assert$.MODULE$.abort("Invariant broken: res.!=(null)");
        }
        return res;
    }

    public Some<String> getSomeMessage(Throwable th) {
        return new Some((Object)this.getAMessage(th));
    }

    public Throwable getACause(Throwable th) {
        Throwable c = th.getCause();
        Throwable throwable = c;
        Throwable res = throwable == null ? th : this.getACause(c);
        return res;
    }

    public Some<Throwable> getSomeCause(Throwable th) {
        return new Some((Object)this.getACause(th));
    }

    public File uriToDiagnosticFile(URI uri) {
        String string = uri.getScheme();
        switch (string == null ? 0 : string.hashCode()) {
            case -341064690: {
                if (!"resource".equals(string)) break;
                String resourceFilePart = uri.getPath();
                return Paths.get(resourceFilePart, new String[0]).toFile();
            }
            case 104987: {
                if (!"jar".equals(string)) break;
                Tuple2<String, String> tuple2 = this.splitJarUri(uri);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String pathPart = (String)tuple2._2();
                String pathPart2 = pathPart;
                return Paths.get(pathPart2, new String[0]).toFile();
            }
            case 3143036: {
                if (!"file".equals(string)) break;
                return Paths.get(uri).toFile();
            }
        }
        return Paths.get(uri.getPath(), new String[0]).toFile();
    }

    public Field lookupDeclaredField(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            field = clazz.getDeclaredField(new java.lang.StringBuilder(5).append(fieldName).append("$lzy1").toString());
        }
        return field;
    }

    private static final int hexCharToValue$1(char c) {
        int n;
        char i = c;
        if (i >= '0' && i <= '9') {
            n = i - 48;
        } else if (i >= 'A' && i <= 'F') {
            n = i - 65 + 10;
        } else if (i >= 'a' && i <= 'f') {
            n = i - 97 + 10;
        } else {
            throw new NumberFormatException(new java.lang.StringBuilder(50).append("Hex character must be 0-9, a-f, or A-F, but was '").append(c).append("'").toString());
        }
        int v = n;
        return v;
    }

    public static final /* synthetic */ int $anonfun$hex2Bits$1(char ch) {
        return Integer.parseInt(Character.toString(ch), 16);
    }

    public static final /* synthetic */ String $anonfun$hex2Bits$2(int x$4) {
        return Long.toString(x$4, 2);
    }

    public static final /* synthetic */ byte $anonfun$bits2Bytes$2(String x$7) {
        return (byte)Integer.parseInt(x$7, 2);
    }

    public static final /* synthetic */ byte $anonfun$byteToCharTable$1(int i) {
        return (byte)i;
    }

    public static final /* synthetic */ boolean $anonfun$isAsciiBased$2(String s) {
        return !s.contains("7-BIT") && !s.contains("EBCDIC") && (s.startsWith("ASCII") || s.startsWith("US-ASCII") || s.startsWith("ISO-8859") || s.startsWith("UTF"));
    }

    private Misc$() {
    }
}

