/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.io;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.apache.daffodil.io.RegexLimitingInputStream$;
import org.apache.daffodil.lib.exceptions.Assert$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001\u0002\u0012$\u00011B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!A1\t\u0001B\u0001B\u0003%a\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!a\u0005A!A!\u0002\u0013i\u0005\"B)\u0001\t\u0003\u0011\u0006b\u0002.\u0001\u0005\u0004%Ia\u0017\u0005\u00079\u0002\u0001\u000b\u0011B\u0017\t\u000fu\u0003!\u0019!C\u0005=\"1A\r\u0001Q\u0001\n}Cq!\u001a\u0001C\u0002\u0013%a\r\u0003\u0004h\u0001\u0001\u0006I!\u0014\u0005\bQ\u0002\u0011\r\u0011\"\u0003g\u0011\u0019I\u0007\u0001)A\u0005\u001b\"9!\u000e\u0001b\u0001\n\u0013q\u0006BB6\u0001A\u0003%q\fC\u0004m\u0001\t\u0007I\u0011B7\t\rU\u0004\u0001\u0015!\u0003o\u0011\u001d1\bA1A\u0005\n\u0019Daa\u001e\u0001!\u0002\u0013i\u0005\u0002\u0003=\u0001\u0011\u000b\u0007I\u0011B=\t\u000f\u0005\u001d\u0001\u0001\"\u0011\u0002\n!9\u00111\u0002\u0001\u0005B\u0005%\u0001bBA\u0007\u0001\u0011\u0005\u0013q\u0002\u0005\n\u0003/\u0001\u0001\u0019!C\u0005\u00033A\u0011\"!\t\u0001\u0001\u0004%I!a\t\t\u0011\u0005%\u0002\u0001)Q\u0005\u00037Aq!a\u000b\u0001\t\u0013\ti\u0003C\u0004\u0002B\u0001!I!a\u0011\b\u0013\u0005U3%!A\t\u0002\u0005]c\u0001\u0003\u0012$\u0003\u0003E\t!!\u0017\t\rE{B\u0011AA1\u0011%\t\u0019gHI\u0001\n\u0003\t)G\u0001\rSK\u001e,\u0007\u0010T5nSRLgnZ%oaV$8\u000b\u001e:fC6T!\u0001J\u0013\u0002\u0005%|'B\u0001\u0014(\u0003!!\u0017M\u001a4pI&d'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001[A\u0011aFM\u0007\u0002_)\u0011A\u0005\r\u0006\u0002c\u0005!!.\u0019<b\u0013\t\u0019tFA\u0006J]B,Ho\u0015;sK\u0006l\u0017aC5oaV$8\u000b\u001e:fC6\f\u0011C]3hKb4uN\u001d#fY&l\u0017\u000e^3s!\t9\u0004I\u0004\u00029}A\u0011\u0011\bP\u0007\u0002u)\u00111hK\u0001\u0007yI|w\u000e\u001e \u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0002\rA\u0013X\rZ3g\u0013\t\t%I\u0001\u0004TiJLgn\u001a\u0006\u0003\u007fq\nQ$\\1yS6,X\u000eT3oORDG)\u001a7j[&$XM]#yC6\u0004H.Z\u0001\bG\"\f'o]3u!\t1%*D\u0001H\u0015\t!\u0005J\u0003\u0002Ja\u0005\u0019a.[8\n\u0005-;%aB\"iCJ\u001cX\r^\u0001\u0010i\u0006\u0014x-\u001a;DQVt7nU5{KB\u0011ajT\u0007\u0002y%\u0011\u0001\u000b\u0010\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0004T+Z;\u0006,\u0017\t\u0003)\u0002i\u0011a\t\u0005\u0006i\u0019\u0001\r!\f\u0005\u0006k\u0019\u0001\rA\u000e\u0005\u0006\u0007\u001a\u0001\rA\u000e\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\b\u0019\u001a\u0001\n\u00111\u0001N\u0003\tIg.F\u0001.\u0003\rIg\u000eI\u0001\u0013[\u0006DH)\u001a7j[&$XM]%oqa*\u0014(F\u0001`!\t\u00017-D\u0001b\u0015\t\u0011\u0007'\u0001\u0003mC:<\u0017BA!b\u0003Mi\u0017\r\u001f#fY&l\u0017\u000e^3s\u0013:D\u0004(N\u001d!\u0003Ii\u0017\r\u001f#fY&l\u0017\u000e^3s\u0019\u0016tw\r\u001e5\u0016\u00035\u000b1#\\1y\t\u0016d\u0017.\\5uKJdUM\\4uQ\u0002\n\u0011b\u00195v].\u001c\u0016N_3\u0002\u0015\rDWO\\6TSj,\u0007%A\u0003sK\u001e,\u00070\u0001\u0004sK\u001e,\u0007\u0010I\u0001\ba\u0006$H/\u001a:o+\u0005q\u0007CA8t\u001b\u0005\u0001(B\u00016r\u0015\t\u0011\b'\u0001\u0003vi&d\u0017B\u0001;q\u0005\u001d\u0001\u0016\r\u001e;fe:\f\u0001\u0002]1ui\u0016\u0014h\u000eI\u0001\rY>|7.\u00115fC\u0012l\u0015\r_\u0001\u000eY>|7.\u00115fC\u0012l\u0015\r\u001f\u0011\u0002\u0013\rD\u0017M]:Ji\u0016\u0014X#\u0001>\u0011\tmt\u0018\u0011A\u0007\u0002y*\u0011Q\u0010P\u0001\u000bG>dG.Z2uS>t\u0017BA@}\u0005!IE/\u001a:bi>\u0014\bc\u0001(\u0002\u0004%\u0019\u0011Q\u0001\u001f\u0003\t\rC\u0017M]\u0001\u0005e\u0016\fG\rF\u0001N\u0003%\tg/Y5mC\ndW-A\u0003dY>\u001cX\r\u0006\u0002\u0002\u0012A\u0019a*a\u0005\n\u0007\u0005UAH\u0001\u0003V]&$\u0018\u0001\u00048p\u001b>\u0014Xm\u00115v].\u001cXCAA\u000e!\rq\u0015QD\u0005\u0004\u0003?a$a\u0002\"p_2,\u0017M\\\u0001\u0011]>luN]3DQVt7n]0%KF$B!!\u0005\u0002&!I\u0011q\u0005\u000e\u0002\u0002\u0003\u0007\u00111D\u0001\u0004q\u0012\n\u0014!\u00048p\u001b>\u0014Xm\u00115v].\u001c\b%\u0001\u0004dQVt7n]\u000b\u0003\u0003_\u0001R!!\r\u0002<YrA!a\r\u000289\u0019\u0011(!\u000e\n\u0003uJ1!!\u000f=\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0010\u0002@\t11\u000b\u001e:fC6T1!!\u000f=\u0003%\u0019\u0007.Z2l'\u000e\fg\u000eF\u0003N\u0003\u000b\nI\u0005\u0003\u0004\u0002Hu\u0001\rAN\u0001\f[\u0006$8\r[*ue&tw\rC\u0004\u0002Lu\u0001\r!!\u0014\u0002\u000fM\u001c\u0017M\u001c8feB!\u0011qJA)\u001b\u0005\t\u0018bAA*c\n91kY1o]\u0016\u0014\u0018\u0001\u0007*fO\u0016DH*[7ji&tw-\u00138qkR\u001cFO]3b[B\u0011AkH\n\u0004?\u0005m\u0003c\u0001(\u0002^%\u0019\u0011q\f\u001f\u0003\r\u0005s\u0017PU3g)\t\t9&A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0003\u0003OR3!TA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class RegexLimitingInputStream
extends InputStream {
    private Iterator<Object> charsIter;
    private final InputStream in;
    private final String maxDelimiterIn8859;
    private final int maxDelimiterLength;
    private final int chunkSize;
    private final String regex;
    private final Pattern pattern;
    private final int lookAheadMax;
    private boolean noMoreChunks;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$5() {
        return RegexLimitingInputStream$.MODULE$.$lessinit$greater$default$5();
    }

    private InputStream in() {
        return this.in;
    }

    private String maxDelimiterIn8859() {
        return this.maxDelimiterIn8859;
    }

    private int maxDelimiterLength() {
        return this.maxDelimiterLength;
    }

    private int chunkSize() {
        return this.chunkSize;
    }

    private String regex() {
        return this.regex;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private int lookAheadMax() {
        return this.lookAheadMax;
    }

    private Iterator<Object> charsIter$lzycompute() {
        RegexLimitingInputStream regexLimitingInputStream = this;
        synchronized (regexLimitingInputStream) {
            if (!this.bitmap$0) {
                Iterator iter;
                Stream<String> cks = this.chunks();
                Stream streamChars = cks.flatten((Function1 & Serializable & scala.Serializable)x -> new StringOps(Predef$.MODULE$.augmentString(x)));
                this.charsIter = iter = streamChars.iterator();
                this.bitmap$0 = true;
            }
        }
        return this.charsIter;
    }

    private Iterator<Object> charsIter() {
        if (!this.bitmap$0) {
            return this.charsIter$lzycompute();
        }
        return this.charsIter;
    }

    @Override
    public int read() {
        if (!this.charsIter().hasNext()) {
            return -1;
        }
        return BoxesRunTime.unboxToChar((Object)this.charsIter().next());
    }

    @Override
    public int available() {
        if (this.charsIter().hasNext()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
    }

    private boolean noMoreChunks() {
        return this.noMoreChunks;
    }

    private void noMoreChunks_$eq(boolean x$1) {
        this.noMoreChunks = x$1;
    }

    private Stream<String> chunks() {
        if (this.noMoreChunks()) {
            return scala.package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
        }
        this.in().mark(this.lookAheadMax());
        InputStreamReader rdr = new InputStreamReader(this.in(), StandardCharsets.ISO_8859_1);
        Scanner scanner = new Scanner(rdr);
        String beforeMatchString = scanner.findWithinHorizon(this.pattern(), 0);
        int delimMatchLength = this.checkScan(beforeMatchString, scanner);
        this.in().reset();
        this.in().skip(beforeMatchString.length() + delimMatchLength);
        if (delimMatchLength > 0) {
            this.noMoreChunks_$eq(true);
        }
        if (beforeMatchString.isEmpty()) {
            return scala.package$.MODULE$.Stream().apply((Seq)Nil$.MODULE$);
        }
        String string = beforeMatchString;
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> this.chunks()).$hash$colon$colon((Object)string);
    }

    private int checkScan(String matchString, Scanner scanner) {
        int n;
        boolean isFound;
        if (matchString == null) {
            throw Assert$.MODULE$.abort("Invariant broken: matchString.ne(null)");
        }
        MatchResult matcher = scanner.match();
        int beforeDelimMatch = matcher.end(1);
        int delimMatch = matcher.end(2);
        int noDelimMatch = matcher.end(3);
        boolean bl = isFound = beforeDelimMatch > -1;
        if (isFound) {
            if (delimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.>(-1)");
            }
            if (noDelimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.==(-1)");
            }
            n = matcher.end(2) - matcher.start(2);
        } else {
            if (delimMatch != -1) {
                throw Assert$.MODULE$.abort("Invariant broken: delimMatch.==(-1)");
            }
            if (noDelimMatch <= -1) {
                throw Assert$.MODULE$.abort("Invariant broken: noDelimMatch.>(-1)");
            }
            n = 0;
        }
        int delimMatchLength = n;
        return delimMatchLength;
    }

    public RegexLimitingInputStream(InputStream inputStream, String regexForDelimiter, String maximumLengthDelimiterExample, Charset charset, int targetChunkSize) {
        if (targetChunkSize < 1) {
            throw Assert$.MODULE$.usageError("Usage error: RegexLimitingInputStream.this.targetChunkSize.>=(1)");
        }
        if (!new StringOps(Predef$.MODULE$.augmentString(maximumLengthDelimiterExample)).nonEmpty()) {
            throw Assert$.MODULE$.usageError("Usage error: scala.Predef.augmentString(RegexLimitingInputStream.this.maximumLengthDelimiterExample).nonEmpty");
        }
        this.in = inputStream;
        this.maxDelimiterIn8859 = new String(maximumLengthDelimiterExample.getBytes(charset), StandardCharsets.ISO_8859_1);
        this.maxDelimiterLength = (int)package$.MODULE$.ceil((double)((float)this.maxDelimiterIn8859().length() * charset.newEncoder().maxBytesPerChar()));
        this.chunkSize = package$.MODULE$.max(targetChunkSize, this.maxDelimiterLength() + 1);
        this.regex = new StringBuilder(32).append("([\\s\\S]{0,").append(this.chunkSize()).append("}?)(?=(").append(regexForDelimiter).append("))|([\\s\\S]{0,").append(this.chunkSize()).append("})").toString();
        this.pattern = Pattern.compile(this.regex());
        this.lookAheadMax = this.chunkSize() + this.maxDelimiterLength();
        this.noMoreChunks = false;
    }
}

