/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.apache.daffodil.core.compiler.Compiler;
import org.apache.daffodil.core.compiler.Compiler$;
import org.apache.daffodil.core.compiler.ProcessorFactory;
import org.apache.daffodil.core.dsom.ExpressionCompilers$;
import org.apache.daffodil.core.dsom.Root;
import org.apache.daffodil.core.dsom.SchemaSet;
import org.apache.daffodil.core.dsom.SchemaSet$;
import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.io.InputSourceDataInputStream$;
import org.apache.daffodil.lib.api.DaffodilSchemaSource;
import org.apache.daffodil.lib.api.Diagnostic;
import org.apache.daffodil.lib.api.URISchemaSource;
import org.apache.daffodil.lib.api.ValidationMode;
import org.apache.daffodil.lib.exceptions.MultiException;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.util.SchemaUtils$;
import org.apache.daffodil.lib.xml.NS;
import org.apache.daffodil.runtime1.api.DFDL;
import org.apache.daffodil.runtime1.debugger.InteractiveDebugger;
import org.apache.daffodil.runtime1.debugger.InteractiveDebuggerRunner;
import org.apache.daffodil.runtime1.debugger.TraceDebuggerRunner;
import org.apache.daffodil.runtime1.debugger.TraceDebuggerRunner$;
import org.apache.daffodil.runtime1.dsom.ExpressionCompilerClass;
import org.apache.daffodil.runtime1.infoset.InfosetInputter;
import org.apache.daffodil.runtime1.infoset.InfosetOutputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetInputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter;
import org.apache.daffodil.runtime1.infoset.ScalaXMLInfosetOutputter$;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

public final class TestUtils$ {
    public static TestUtils$ MODULE$;
    private InteractiveDebugger builtInTracer;
    private final boolean useSerializedProcessor;
    private final Elem defaultIncludeImports;
    private final Elem defaultTopLevels;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public <T> void assertEquals(T expected, T actual) {
        if (!BoxesRunTime.equals(expected, actual)) {
            throw new AssertionError((Object)"assertEquals failed.");
        }
    }

    public Tuple2<DFDL.ParseResult, Node> testString(Node testSchema, String data, boolean areTracing) {
        return this.runSchemaOnRBC(testSchema, Misc$.MODULE$.stringToReadableByteChannel(data), areTracing);
    }

    public boolean testString$default$3() {
        return false;
    }

    public Tuple2<DFDL.ParseResult, Node> testBinary(Node testSchema, String hexData, boolean areTracing) {
        byte[] b = Misc$.MODULE$.hex2Bytes(hexData);
        return this.testBinary(testSchema, b, areTracing);
    }

    public Tuple2<DFDL.ParseResult, Node> testBinary(Node testSchema, byte[] data, boolean areTracing) {
        ReadableByteChannel rbc = Misc$.MODULE$.byteArrayToReadableByteChannel(data);
        return this.runSchemaOnRBC(testSchema, rbc, areTracing);
    }

    public boolean testBinary$default$3() {
        return false;
    }

    private boolean useSerializedProcessor() {
        return this.useSerializedProcessor;
    }

    public Seq<Diagnostic> testUnparsing(Elem testSchema, Node infosetXML, String unparseTo, boolean areTracing) {
        ByteArrayOutputStream outputStream;
        WritableByteChannel out;
        ScalaXMLInfosetInputter inputter;
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1()).withTunable("allowExternalPathExpressions", "true");
        ProcessorFactory pf = compiler.compileNode((Node)testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.getDiagnostics());
        }
        DataProcessor u = this.saveAndReload((DataProcessor)pf.onPath("/"));
        if (u.isError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)u.getDiagnostics());
        }
        u = areTracing ? u.withDebugger((Object)this.builtInTracer()).withDebugging(true) : u;
        DFDL.UnparseResult actual = u.unparse((InfosetInputter)(inputter = new ScalaXMLInfosetInputter(infosetXML)), out = Channels.newChannel(outputStream = new ByteArrayOutputStream()));
        if (((DFDL.Result)actual).isProcessingError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)((DFDL.Result)actual).getDiagnostics());
        }
        String unparsed = outputStream.toString();
        out.close();
        this.assertEquals(unparseTo, unparsed);
        return ((DFDL.Result)actual).getDiagnostics();
    }

    public boolean testUnparsing$default$4() {
        return false;
    }

    private Nothing$ throwDiagnostics(Seq<Diagnostic> ds) {
        return new MultiException(ds).toss();
    }

    public void testUnparsingBinary(Elem testSchema, Node infoset, byte[] unparseTo, boolean areTracing) {
        ByteArrayOutputStream outputStream;
        WritableByteChannel out;
        ScalaXMLInfosetInputter inputter;
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
        ProcessorFactory pf = compiler.compileNode((Node)testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.diagnostics());
        }
        DataProcessor u = (DataProcessor)pf.onPath("/");
        if (u.isError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)u.getDiagnostics());
        }
        u = areTracing ? u.withDebugger((Object)this.builtInTracer()).withDebugging(true) : u;
        DFDL.UnparseResult actual = u.unparse((InfosetInputter)(inputter = new ScalaXMLInfosetInputter(infoset)), out = Channels.newChannel(outputStream = new ByteArrayOutputStream()));
        if (((DFDL.Result)actual).isProcessingError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)((DFDL.Result)actual).getDiagnostics());
        }
        byte[] unparsed = outputStream.toByteArray();
        out.close();
        this.assertEquals(BoxesRunTime.boxToInteger((int)unparsed.length), BoxesRunTime.boxToInteger((int)unparseTo.length));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), unparsed.length).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> MODULE$.assertEquals(BoxesRunTime.boxToByte((byte)unparseTo[i]), BoxesRunTime.boxToByte((byte)unparsed[i])));
    }

    public boolean testUnparsingBinary$default$4() {
        return false;
    }

    private InteractiveDebugger builtInTracer$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.builtInTracer = new InteractiveDebugger((InteractiveDebuggerRunner)new TraceDebuggerRunner(TraceDebuggerRunner$.MODULE$.$lessinit$greater$default$1()), (ExpressionCompilerClass)ExpressionCompilers$.MODULE$);
                this.bitmap$0 = true;
            }
        }
        return this.builtInTracer;
    }

    private InteractiveDebugger builtInTracer() {
        if (!this.bitmap$0) {
            return this.builtInTracer$lzycompute();
        }
        return this.builtInTracer;
    }

    private DataProcessor saveAndReload(DataProcessor p) {
        if (this.useSerializedProcessor()) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            WritableByteChannel output = Channels.newChannel(os);
            p.save(output);
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            ReadableByteChannel input = Channels.newChannel(is);
            Compiler compiler_ = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
            return (DataProcessor)compiler_.reload(input);
        }
        return p;
    }

    public DataProcessor compileSchema(Node testSchema) {
        Compiler compiler = Compiler$.MODULE$.apply(Compiler$.MODULE$.apply$default$1());
        ProcessorFactory pf = compiler.compileNode(testSchema, compiler.compileNode$default$2(), compiler.compileNode$default$3(), compiler.compileNode$default$4());
        if (pf.isError()) {
            throw this.throwDiagnostics(pf.getDiagnostics());
        }
        DataProcessor p = this.saveAndReload((DataProcessor)pf.onPath("/"));
        if (p.isError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)p.getDiagnostics());
        }
        return p;
    }

    private Tuple2<DFDL.ParseResult, Node> runSchemaOnRBC(Node testSchema, ReadableByteChannel data, boolean areTracing) {
        return this.runSchemaOnInputStream(testSchema, Channels.newInputStream(data), areTracing);
    }

    private boolean runSchemaOnRBC$default$3() {
        return false;
    }

    private Tuple2<DFDL.ParseResult, Node> runSchemaOnInputStream(Node testSchema, InputStream is, boolean areTracing) {
        DataProcessor p = this.compileSchema(testSchema);
        return this.runDataProcessorOnInputStream(p, is, areTracing);
    }

    private boolean runSchemaOnInputStream$default$3() {
        return false;
    }

    public Tuple2<DFDL.ParseResult, Node> runDataProcessorOnInputStream(DataProcessor dp, InputStream is, boolean areTracing) {
        DataProcessor p1 = areTracing ? dp.withDebugger((Object)this.builtInTracer()).withDebugging(true) : dp;
        DataProcessor p = p1.withValidationMode((ValidationMode.Type)ValidationMode.Limited$.MODULE$);
        ScalaXMLInfosetOutputter outputter = new ScalaXMLInfosetOutputter(ScalaXMLInfosetOutputter$.MODULE$.$lessinit$greater$default$1());
        InputSourceDataInputStream input = InputSourceDataInputStream$.MODULE$.apply(is);
        DFDL.ParseResult actual = p.parse(input, (InfosetOutputter)outputter);
        if (((DFDL.Result)actual).isProcessingError()) {
            throw this.throwDiagnostics((Seq<Diagnostic>)((DFDL.Result)actual).getDiagnostics());
        }
        return new Tuple2((Object)actual, (Object)outputter.getResult());
    }

    public boolean runDataProcessorOnInputStream$default$3() {
        return false;
    }

    private Elem defaultIncludeImports() {
        return this.defaultIncludeImports;
    }

    private Elem defaultTopLevels() {
        return this.defaultTopLevels;
    }

    public Root getRoot(Seq<Node> contentElements, String elementFormDefault, Seq<Node> includeImports, Seq<Node> topLevels) {
        Seq<Node> x$1 = includeImports;
        Seq<Node> x$2 = topLevels;
        Seq<Node> x$3 = contentElements;
        String x$4 = elementFormDefault;
        NamespaceBinding x$5 = SchemaUtils$.MODULE$.dfdlTestSchema$default$4();
        String x$6 = SchemaUtils$.MODULE$.dfdlTestSchema$default$5();
        NS x$7 = SchemaUtils$.MODULE$.dfdlTestSchema$default$6();
        NS x$8 = SchemaUtils$.MODULE$.dfdlTestSchema$default$7();
        boolean x$9 = SchemaUtils$.MODULE$.dfdlTestSchema$default$9();
        boolean x$10 = SchemaUtils$.MODULE$.dfdlTestSchema$default$10();
        Elem testSchema = SchemaUtils$.MODULE$.dfdlTestSchema(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$4, x$9, x$10);
        SchemaSet sset = SchemaSet$.MODULE$.apply((Node)testSchema, SchemaSet$.MODULE$.apply$default$2(), SchemaSet$.MODULE$.apply$default$3(), SchemaSet$.MODULE$.apply$default$4(), SchemaSet$.MODULE$.apply$default$5());
        return sset.root();
    }

    public String getRoot$default$2() {
        return "unqualified";
    }

    public Seq<Node> getRoot$default$3() {
        return this.defaultIncludeImports();
    }

    public Seq<Node> getRoot$default$4() {
        return this.defaultTopLevels();
    }

    private Try<Tuple2<ProcessorFactory, DFDL.DataProcessor>> compileAndSave(Compiler compiler, URISchemaSource schemaSource, WritableByteChannel output) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            DFDL.ProcessorFactory pf = compiler.compileSource((DaffodilSchemaSource)schemaSource, (Option)compiler.compileSource$default$2(), (Option)compiler.compileSource$default$3());
            if (pf.isError()) {
                throw MODULE$.throwDiagnostics(pf.getDiagnostics());
            }
            DFDL.DataProcessor dp = pf.onPath("/");
            dp.save(output);
            if (dp.isError()) {
                throw MODULE$.throwDiagnostics((Seq<Diagnostic>)((Seq)dp.getDiagnostics().$plus$plus(pf.getDiagnostics(), Seq$.MODULE$.canBuildFrom())));
            }
            return new Tuple2((Object)pf, (Object)dp);
        });
    }

    private TestUtils$() {
        MODULE$ = this;
        this.useSerializedProcessor = true;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("schemaLocation", (Seq)new Text("/org/apache/daffodil/xsd/DFDLGeneralFormat.dfdl.xsd"), (MetaData)$md);
        this.defaultIncludeImports = new Elem("xs", "include", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("encoding", (Seq)new Text("US-ASCII"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("lengthKind", (Seq)new Text("delimited"), (MetaData)$md2);
        $md2 = new UnprefixedAttribute("ref", (Seq)new Text("tns:GeneralFormat"), (MetaData)$md2);
        this.defaultTopLevels = new Elem("dfdl", "format", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
    }
}

