/*
 * Decompiled with CFR 0.152.
 */
package org.rogach.scallop.tokenize;

import org.rogach.scallop.tokenize.EOF;
import org.rogach.scallop.tokenize.Failed$;
import org.rogach.scallop.tokenize.Matched;
import org.rogach.scallop.tokenize.StringView;
import org.rogach.scallop.tokenize.TokenizationResult;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class ArgumentTokenizer$ {
    public static ArgumentTokenizer$ MODULE$;
    private final Function1<StringView, TokenizationResult> inputEnd;
    private final Function1<StringView, TokenizationResult> whitespace;
    private final Function1<StringView, TokenizationResult> singleQuotedString;
    private final Function1<StringView, TokenizationResult> doubleQuotedString;
    private final Function1<StringView, TokenizationResult> plainArgument;
    private final Function1<StringView, TokenizationResult> token;
    private final Function1<StringView, TokenizationResult> argumentsParser;

    static {
        new ArgumentTokenizer$();
    }

    public TokenizationResult tokenize(String input) {
        return (TokenizationResult)this.argumentsParser().apply((Object)new StringView(input, 0));
    }

    private Function1<StringView, TokenizationResult> inputEnd() {
        return this.inputEnd;
    }

    private Function1<StringView, TokenizationResult> optional(Function1<StringView, TokenizationResult> parser) {
        return (Function1 & java.io.Serializable & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply(input);
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return new Matched((Seq<String>)Nil$.MODULE$, (StringView)input);
            }
            return tokenizationResult;
        };
    }

    private Function1<StringView, TokenizationResult> seq(Function1<StringView, TokenizationResult> parser1, Function1<StringView, TokenizationResult> parser2) {
        return (Function1 & java.io.Serializable & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser1.apply(input);
            if (tokenizationResult instanceof EOF) {
                EOF eOF = (EOF)tokenizationResult;
                return eOF;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                return Failed$.MODULE$;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = (Matched)tokenizationResult;
                Seq<String> tokens1 = matched.tokens();
                StringView rest1 = matched.rest();
                TokenizationResult tokenizationResult2 = (TokenizationResult)parser2.apply((Object)rest1);
                if (tokenizationResult2 instanceof Matched) {
                    Matched matched2 = (Matched)tokenizationResult2;
                    Seq<String> tokens2 = matched2.tokens();
                    StringView rest2 = matched2.rest();
                    return new Matched((Seq<String>)((Seq)tokens1.$plus$plus(tokens2, Seq$.MODULE$.canBuildFrom())), rest2);
                }
                return tokenizationResult2;
            }
            throw new MatchError((Object)tokenizationResult);
        };
    }

    private Function1<StringView, TokenizationResult> repeat(Function1<StringView, TokenizationResult> parser) {
        return (Function1 & java.io.Serializable & Serializable)input -> MODULE$.repeatImpl(parser, (StringView)input, (List<Seq<String>>)Nil$.MODULE$);
    }

    private TokenizationResult repeatImpl(Function1<StringView, TokenizationResult> parser, StringView input, List<Seq<String>> acc) {
        TokenizationResult tokenizationResult;
        while (true) {
            if ((tokenizationResult = (TokenizationResult)parser.apply((Object)input)) instanceof EOF) {
                EOF eOF = (EOF)tokenizationResult;
                return eOF;
            }
            if (Failed$.MODULE$.equals(tokenizationResult)) {
                if (acc.isEmpty()) {
                    return Failed$.MODULE$;
                }
                return new Matched((Seq<String>)((Seq)acc.reverse().flatten((Function1)Predef$.MODULE$.$conforms())), input);
            }
            if (!(tokenizationResult instanceof Matched)) break;
            Matched matched = (Matched)tokenizationResult;
            Seq<String> tokens = matched.tokens();
            StringView remainingInput = matched.rest();
            Seq<String> seq = tokens;
            acc = acc.$colon$colon(seq);
            input = remainingInput;
        }
        throw new MatchError((Object)tokenizationResult);
    }

    private Function1<StringView, TokenizationResult> alternatives(List<Function1<StringView, TokenizationResult>> parsers) {
        return (Function1 & java.io.Serializable & Serializable)input -> MODULE$.alternativesImpl(parsers, (StringView)input);
    }

    private TokenizationResult alternativesImpl(List<Function1<StringView, TokenizationResult>> parsers, StringView input) {
        List list;
        block4: {
            TokenizationResult tokenizationResult;
            while (true) {
                if (Nil$.MODULE$.equals(list = parsers)) {
                    return Failed$.MODULE$;
                }
                if (!(list instanceof .colon.colon)) break block4;
                .colon.colon colon2 = (.colon.colon)list;
                Function1 parser = (Function1)colon2.head();
                List remainingParsers = colon2.tl$access$1();
                tokenizationResult = (TokenizationResult)parser.apply((Object)input);
                if (tokenizationResult instanceof EOF) {
                    EOF eOF = (EOF)tokenizationResult;
                    return eOF;
                }
                if (!Failed$.MODULE$.equals(tokenizationResult)) break;
                parsers = remainingParsers;
            }
            if (tokenizationResult instanceof Matched) {
                Matched matched = (Matched)tokenizationResult;
                return matched;
            }
            throw new MatchError((Object)tokenizationResult);
        }
        throw new MatchError(list);
    }

    private Function1<StringView, TokenizationResult> mapResult(Function1<StringView, TokenizationResult> parser, Function1<Seq<String>, Seq<String>> fn) {
        return (Function1 & java.io.Serializable & Serializable)input -> {
            TokenizationResult tokenizationResult = (TokenizationResult)parser.apply(input);
            if (tokenizationResult instanceof Matched) {
                Matched matched = (Matched)tokenizationResult;
                Seq<String> tokens = matched.tokens();
                StringView rest = matched.rest();
                return new Matched((Seq<String>)((Seq)fn.apply(tokens)), rest);
            }
            return tokenizationResult;
        };
    }

    private Function1<StringView, TokenizationResult> whitespace() {
        return this.whitespace;
    }

    private Function1<StringView, TokenizationResult> singleQuotedString() {
        return this.singleQuotedString;
    }

    private Function1<StringView, TokenizationResult> doubleQuotedString() {
        return this.doubleQuotedString;
    }

    private Function1<StringView, TokenizationResult> plainArgument() {
        return this.plainArgument;
    }

    private Function1<StringView, TokenizationResult> token() {
        return this.token;
    }

    private Function1<StringView, TokenizationResult> argumentsParser() {
        return this.argumentsParser;
    }

    private ArgumentTokenizer$() {
        MODULE$ = this;
        this.inputEnd = (Function1 & java.io.Serializable & Serializable)input -> {
            if (input.length() == 0) {
                return new Matched((Seq<String>)Nil$.MODULE$, (StringView)input);
            }
            return Failed$.MODULE$;
        };
        this.whitespace = (Function1 & java.io.Serializable & Serializable)input -> {
            int i;
            int l = input.length();
            for (i = 0; i < l && Character.isWhitespace(input.charAt(i)); ++i) {
            }
            if (i == 0) {
                return Failed$.MODULE$;
            }
            return new Matched((Seq<String>)Nil$.MODULE$, input.substring(i));
        };
        this.singleQuotedString = (Function1 & java.io.Serializable & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\'') {
                return Failed$.MODULE$;
            }
            int stringEnd = input.indexOf(39, 1);
            if (stringEnd == -1) {
                return new EOF("'");
            }
            return new Matched((Seq<String>)((Seq)new .colon.colon((Object)input.extract(1, stringEnd), (List)Nil$.MODULE$)), input.substring(stringEnd + 1));
        };
        this.doubleQuotedString = (Function1 & java.io.Serializable & Serializable)input -> {
            if (input.length() == 0 || input.charAt(0) != '\"') {
                return Failed$.MODULE$;
            }
            int i = 1;
            int s = 1;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            boolean stringClosed = false;
            while (!bl && i < l) {
                while (i < l && input.charAt(i) != '\\' && input.charAt(i) != '\"') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        StringBuilder stringBuilder = input.charAt(i + 1) == '\\' || input.charAt(i + 1) == '\"' ? b.append(input.charAt(i + 1)) : b.append(input.extract(i, i + 2));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\"') {
                    stringClosed = true;
                    bl = true;
                    continue;
                }
                b.append(input.charAt(i));
                s = ++i;
            }
            if (eofEscaped) {
                return new EOF("escaped char");
            }
            if (!stringClosed) {
                return new EOF("\"");
            }
            return new Matched((Seq<String>)((Seq)new .colon.colon((Object)b.toString(), (List)Nil$.MODULE$)), input.substring(i + 1));
        };
        this.plainArgument = (Function1 & java.io.Serializable & Serializable)input -> {
            int i = 0;
            int s = 0;
            int l = input.length();
            StringBuilder b = new StringBuilder();
            boolean bl = false;
            boolean eofEscaped = false;
            while (!bl && i < l) {
                while (i < l && !Character.isWhitespace(input.charAt(i)) && input.charAt(i) != '\\' && input.charAt(i) != '\"' && input.charAt(i) != '\'') {
                    ++i;
                }
                b.append(input.extract(s, i));
                s = i;
                if (i >= l) continue;
                if (Character.isWhitespace(input.charAt(i))) {
                    bl = true;
                    continue;
                }
                if (input.charAt(i) == '\\') {
                    if (i + 1 < l) {
                        b.append(input.charAt(i + 1));
                        s = i += 2;
                        continue;
                    }
                    eofEscaped = true;
                    bl = true;
                    continue;
                }
                bl = true;
            }
            if (eofEscaped) {
                return new EOF("escaped char");
            }
            if (b.length() == 0) {
                return Failed$.MODULE$;
            }
            return new Matched((Seq<String>)((Seq)new .colon.colon((Object)b.toString(), (List)Nil$.MODULE$)), input.substring(i));
        };
        this.token = this.mapResult(this.repeat(this.alternatives((List<Function1<StringView, TokenizationResult>>)new .colon.colon(this.singleQuotedString(), (List)new .colon.colon(this.doubleQuotedString(), (List)new .colon.colon(this.plainArgument(), (List)Nil$.MODULE$))))), (Function1<Seq<String>, Seq<String>>)(Function1 & java.io.Serializable & Serializable)tokens -> (Seq)new .colon.colon((Object)tokens.mkString(""), (List)Nil$.MODULE$));
        this.argumentsParser = this.alternatives((List<Function1<StringView, TokenizationResult>>)new .colon.colon(this.seq(this.seq(this.repeat(this.seq(this.optional(this.whitespace()), this.token())), this.optional(this.whitespace())), this.inputEnd()), (List)new .colon.colon(this.seq(this.optional(this.whitespace()), this.inputEnd()), (List)Nil$.MODULE$)));
    }
}

