/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.lib.cookers;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.daffodil.lib.cookers.EntityReplacer$;
import org.apache.daffodil.lib.cookers.EntitySyntaxException;
import org.apache.daffodil.lib.equality.package$;
import org.apache.daffodil.lib.equality.package$ViewEqual$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.exceptions.ThrowsSDE;
import org.apache.daffodil.lib.util.Maybe$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u001dg\u0001B(Q\u0005mCQA\u0019\u0001\u0005\u0002\rDqA\u001a\u0001C\u0002\u0013\u0005q\r\u0003\u0004q\u0001\u0001\u0006I\u0001\u001b\u0005\bc\u0002\u0011\r\u0011\"\u0001h\u0011\u0019\u0011\b\u0001)A\u0005Q\"91\u000f\u0001b\u0001\n\u0003!\bbBA\u0014\u0001\u0001\u0006I!\u001e\u0005\t\u0003S\u0001!\u0019!C\u0001i\"9\u00111\u0006\u0001!\u0002\u0013)\b\u0002CA\u0017\u0001\t\u0007I\u0011\u0001;\t\u000f\u0005=\u0002\u0001)A\u0005k\"I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003k\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011q\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003s\u0001\u0001\u0015!\u0003\u0002\u0018!I\u00111\b\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011q\b\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002\u0018!I\u00111\t\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003\u000b\u0002\u0001\u0015!\u0003\u0002\u0018!I\u0011q\t\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u00033\u0002\u0001\u0015!\u0003\u0002L!I\u00111\f\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003;\u0002\u0001\u0015!\u0003\u0002L!I\u0011q\f\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003C\u0002\u0001\u0015!\u0003\u0002L!I\u00111\r\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003K\u0002\u0001\u0015!\u0003\u0002L!I\u0011q\r\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003S\u0002\u0001\u0015!\u0003\u0002L!I\u00111\u000e\u0001C\u0002\u0013\u0005\u0011\u0011\n\u0005\t\u0003[\u0002\u0001\u0015!\u0003\u0002L!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\b\u0003\u000f\u0003A\u0011AAE\u0011\u001d\ti\t\u0001C\u0001\u0003\u001fCq!a%\u0001\t\u0003\t)\nC\u0004\u0002\u001a\u0002!\t!a'\t\u000f\u0005}\u0005\u0001\"\u0001\u0002\"\"9\u0011Q\u0015\u0001\u0005\n\u0005\u001d\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u0007\u0004A\u0011AAc\u0011\u001d\tY\r\u0001C\u0001\u0003\u001bDq!a5\u0001\t\u0003\t)\u000eC\u0004\u0002:\u0002!\t!!7\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002^\"9\u0011\u0011\u001d\u0001\u0005\u0002\u0005\r\bbBAt\u0001\u0011\u0005\u0011\u0011\u001e\u0005\b\u0003[\u0004A\u0011AAx\u0011!\t\u0019\u0010\u0001b\u0001\n\u00039\u0007bBA{\u0001\u0001\u0006I\u0001\u001b\u0005\t\u0003o\u0004!\u0019!C\u0005O\"9\u0011\u0011 \u0001!\u0002\u0013A\u0007\"CA~\u0001\t\u0007I\u0011BA\u001a\u0011!\ti\u0010\u0001Q\u0001\n\u0005]\u0001\"CA\u0000\u0001\t\u0007I\u0011BA\u001a\u0011!\u0011\t\u0001\u0001Q\u0001\n\u0005]\u0001\"\u0003B\u0002\u0001\t\u0007I\u0011BA\u001a\u0011!\u0011)\u0001\u0001Q\u0001\n\u0005]\u0001\"\u0003B\u0004\u0001\t\u0007I\u0011BA\u001a\u0011!\u0011I\u0001\u0001Q\u0001\n\u0005]\u0001b\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005'\u0001A\u0011\u0002B\u000b\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqA!\u0012\u0001\t\u0013\u00119\u0005C\u0004\u0003b\u0001!IAa\u0019\t\u000f\t-\u0004\u0001\"\u0003\u0003n!I!1\u0010\u0001\u0012\u0002\u0013%!Q\u0010\u0005\b\u0005'\u0003A\u0011\u0002BK\u0011\u001d\u0011I\n\u0001C\u0001\u00057C\u0011B!*\u0001#\u0003%\tAa*\t\u0013\t-\u0006!%A\u0005\u0002\tu\u0004\"\u0003BW\u0001E\u0005I\u0011\u0001B?\u0011\u001d\u0011y\u000b\u0001C\u0005\u0005c;qA!/Q\u0011\u0003\u0011YL\u0002\u0004P!\"\u0005!Q\u0018\u0005\u0007E6#\tA!2\u0003\u001d\u0015sG/\u001b;z%\u0016\u0004H.Y2fe*\u0011\u0011KU\u0001\bG>|7.\u001a:t\u0015\t\u0019F+A\u0002mS\nT!!\u0016,\u0002\u0011\u0011\fgMZ8eS2T!a\u0016-\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0016aA8sO\u000e\u00011C\u0001\u0001]!\ti\u0006-D\u0001_\u0015\u0005y\u0016!B:dC2\f\u0017BA1_\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012\u0001\u001a\t\u0003K\u0002i\u0011\u0001U\u0001\u000fI\u001a$G.\u00128uSRLh*Y7f+\u0005A\u0007CA5o\u001b\u0005Q'BA6m\u0003\u0011a\u0017M\\4\u000b\u00035\fAA[1wC&\u0011qN\u001b\u0002\u0007'R\u0014\u0018N\\4\u0002\u001f\u00114G\r\\#oi&$\u0018PT1nK\u0002\nq\u0003\u001a4eY\u000eC\u0017M]\"mCN\u001cXI\u001c;jift\u0015-\\3\u00021\u00114G\r\\\"iCJ\u001cE.Y:t\u000b:$\u0018\u000e^=OC6,\u0007%\u0001\ff]RLG/_\"iCJ\f7\r^3s+:L7m\u001c3f+\u0005)\b\u0003\u0002<\u007f\u0003\u0007q!a\u001e?\u000f\u0005a\\X\"A=\u000b\u0005iT\u0016A\u0002\u001fs_>$h(C\u0001`\u0013\tih,A\u0004qC\u000e\\\u0017mZ3\n\u0007}\f\tA\u0001\u0003MSN$(BA?_!%i\u0016QAA\u0005\u0003\u0013\t9\"C\u0002\u0002\by\u0013a\u0001V;qY\u0016\u001c\u0004\u0003BA\u0006\u0003'qA!!\u0004\u0002\u0010A\u0011\u0001PX\u0005\u0004\u0003#q\u0016A\u0002)sK\u0012,g-C\u0002p\u0003+Q1!!\u0005_!\u0011\tI\"a\t\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tQA]3hKbT1!!\tm\u0003\u0011)H/\u001b7\n\t\u0005\u0015\u00121\u0004\u0002\b\u001b\u0006$8\r[3s\u0003])g\u000e^5us\u000eC\u0017M]1di\u0016\u0014XK\\5d_\u0012,\u0007%A\u000bdQ\u0006\u00148\t\\1tgJ+\u0007\u000f\\1dK6,g\u000e^:\u0002-\rD\u0017M]\"mCN\u001c(+\u001a9mC\u000e,W.\u001a8ug\u0002\n!#Z:dCB,'+\u001a9mC\u000e,W.\u001a8ug\u0006\u0019Rm]2ba\u0016\u0014V\r\u001d7bG\u0016lWM\u001c;tA\u0005\t2\r[1s\u000b:$\u0018\u000e^=QCR$XM\u001d8\u0016\u0005\u0005]\u0011AE2iCJ,e\u000e^5usB\u000bG\u000f^3s]\u0002\n!\u0002[3y!\u0006$H/\u001a:o\u0003-AW\r\u001f)biR,'O\u001c\u0011\u0002\u0015\u0011,7\rU1ui\u0016\u0014h.A\u0006eK\u000e\u0004\u0016\r\u001e;fe:\u0004\u0013a\u00032zi\u0016\u0004\u0016\r\u001e;fe:\fABY=uKB\u000bG\u000f^3s]\u0002\nac\u00195be\u000ec\u0017m]:F]RLG/\u001f)biR,'O\\\u0001\u0018G\"\f'o\u00117bgN,e\u000e^5usB\u000bG\u000f^3s]\u0002\nqb\u00195be\u0016sG/\u001b;z%\u0016<W\r_\u000b\u0003\u0003\u0017\u0002B!!\u0014\u0002V5\u0011\u0011q\n\u0006\u0005\u0003#\n\u0019&\u0001\u0005nCR\u001c\u0007.\u001b8h\u0015\r\t\tCX\u0005\u0005\u0003/\nyEA\u0003SK\u001e,\u00070\u0001\tdQ\u0006\u0014XI\u001c;jif\u0014VmZ3yA\u0005A\u0001.\u001a=SK\u001e,\u00070A\u0005iKb\u0014VmZ3yA\u0005AA-Z2SK\u001e,\u00070A\u0005eK\u000e\u0014VmZ3yA\u0005I!-\u001f;f%\u0016<W\r_\u0001\u000bEf$XMU3hKb\u0004\u0013\u0001F2iCJ\u001cE.Y:t\u000b:$\u0018\u000e^=SK\u001e,\u00070A\u000bdQ\u0006\u00148\t\\1tg\u0016sG/\u001b;z%\u0016<W\r\u001f\u0011\u0002\u001f\u00114G\r\\#oi&$\u0018PU3hKb\f\u0001\u0003\u001a4eY\u0016sG/\u001b;z%\u0016<W\r\u001f\u0011\u0002\u001b!\f7\u000f\u00124eY\u0016sG/\u001b;z)\u0011\t\u0019(!\u001f\u0011\u0007u\u000b)(C\u0002\u0002xy\u0013qAQ8pY\u0016\fg\u000eC\u0004\u0002|\t\u0002\r!!\u0003\u0002\u000b%t\u0007/\u001e;\u0002\u0013%\u001cX*\u0019;dQ\u0016$GCBA:\u0003\u0003\u000b\u0019\tC\u0004\u0002|\r\u0002\r!!\u0003\t\u000f\u0005\u00155\u00051\u0001\u0002\u0018\u0005\tQ.\u0001\fiCN$e\r\u001a7DQ\u0006\u00148\t\\1tg\u0016sG/\u001b;z)\u0011\t\u0019(a#\t\u000f\u0005mD\u00051\u0001\u0002\n\u0005\t\u0002.Y:EM\u0012d7\t[1s\u000b:$\u0018\u000e^=\u0015\t\u0005M\u0014\u0011\u0013\u0005\b\u0003w*\u0003\u0019AA\u0005\u0003MA\u0017m\u001d#fG&l\u0017\r\\\"pI\u0016\u0004v.\u001b8u)\u0011\t\u0019(a&\t\u000f\u0005md\u00051\u0001\u0002\n\u0005y\u0001.Y:IKb\u001cu\u000eZ3Q_&tG\u000f\u0006\u0003\u0002t\u0005u\u0005bBA>O\u0001\u0007\u0011\u0011B\u0001\u0011Q\u0006\u001c()\u001f;f\u0007>$W\rU8j]R$B!a\u001d\u0002$\"9\u00111\u0010\u0015A\u0002\u0005%\u0011!\u0006:fa2\f7-Z#oi&$\u0018pV5uQ\u000eC\u0017M\u001d\u000b\t\u0003\u0013\tI+a+\u00020\"9\u00111P\u0015A\u0002\u0005%\u0001bBAWS\u0001\u0007\u0011\u0011B\u0001\u0007K:$\u0018\u000e^=\t\u000f\u0005E\u0016\u00061\u0001\u00024\u00069a.Z<DQ\u0006\u0014\bcA/\u00026&\u0019\u0011q\u00170\u0003\t\rC\u0017M]\u0001\u000be\u0016\u0004H.Y2f\u0011\u0016DHCBA\u0005\u0003{\u000by\fC\u0004\u0002|)\u0002\r!!\u0003\t\u000f\u0005\u0005'\u00061\u0001\u0002\n\u00051\u0001O]3gSb\faB]3qY\u0006\u001cW\rR3dS6\fG\u000e\u0006\u0004\u0002\n\u0005\u001d\u0017\u0011\u001a\u0005\b\u0003wZ\u0003\u0019AA\u0005\u0011\u001d\t\tm\u000ba\u0001\u0003\u0013\tAB]3qY\u0006\u001cWMQ=uKN$b!!\u0003\u0002P\u0006E\u0007bBA>Y\u0001\u0007\u0011\u0011\u0002\u0005\b\u0003\u0003d\u0003\u0019AA\u0005\u0003-\u0011X\r\u001d7bG\u0016\u0014\u0015\u0010^3\u0015\t\u0005%\u0011q\u001b\u0005\b\u0003wj\u0003\u0019AA\u0005)\u0011\tI!a7\t\u000f\u0005md\u00061\u0001\u0002\nQ!\u0011\u0011BAp\u0011\u001d\tYh\fa\u0001\u0003\u0013\t\u0011C]3qY\u0006\u001cW\r\u00124eY\u0016sG/\u001b;z)\u0011\tI!!:\t\u000f\u0005m\u0004\u00071\u0001\u0002\n\u0005q!/\u001a9mC\u000e,Wi]2ba\u0016\u001cH\u0003BA\u0005\u0003WDq!a\u001f2\u0001\u0004\tI!\u0001\u000esKBd\u0017mY3DQ\u0006\u00148\t\\1tg\u001a{'/\u00168qCJ\u001cX\r\u0006\u0003\u0002\n\u0005E\bbBA>e\u0001\u0007\u0011\u0011B\u0001\f[\u0006\u00148.\u001a:G_JtE*\u0001\u0007nCJ\\WM\u001d$pe:c\u0005%\u0001\fnCJ\\WM\u001d$pe\u0012{WO\u00197f!\u0016\u00148-\u001a8u\u0003]i\u0017M]6fe\u001a{'\u000fR8vE2,\u0007+\u001a:dK:$\b%A\u0005E!6\u000bGo\u00195fe\u0006QA\tU'bi\u000eDWM\u001d\u0011\u0002%5\f'o[3s\r>\u0014H\tU'bi\u000eDWM]\u0001\u0014[\u0006\u00148.\u001a:G_J$\u0005+T1uG\",'\u000fI\u0001\n\u001d2k\u0015\r^2iKJ\f!B\u0014'NCR\u001c\u0007.\u001a:!\u0003Ii\u0017M]6fe\u001a{'O\u0014'NCR\u001c\u0007.\u001a:\u0002'5\f'o[3s\r>\u0014h\nT'bi\u000eDWM\u001d\u0011\u0002#I,\u0007\u000f\\1dK\u001a{'/\u00168qCJ\u001cX\r\u0006\u0003\u0002\n\t=\u0001b\u0002B\t\u007f\u0001\u0007\u0011\u0011B\u0001\u0004e\u0006<\u0018aE:ue&\u0004H*Z1eS:<\u0007+\u001a:dK:$Hc\u00015\u0003\u0018!9!\u0011\u0004!A\u0002\u0005%\u0011!A:\u0002\u001bI,\u0007\u000f\\1dK\u0016sG/\u001b;z)1\tIAa\b\u0003$\t\u001d\"Q\bB!\u0011\u001d\u0011\t#\u0011a\u0001\u0003\u0013\ta\u0002\u001d:pa>\u001cX\rZ#oi&$\u0018\u0010C\u0004\u0003&\u0005\u0003\r!!\u0003\u0002\t=\u0014\u0018n\u001a\u0005\b\u0005S\t\u0005\u0019\u0001B\u0016\u0003\u001d\u0019wN\u001c;fqR\u0004R!\u0018B\u0017\u0005cI1Aa\f_\u0005\u0019y\u0005\u000f^5p]B!!1\u0007B\u001d\u001b\t\u0011)DC\u0002\u00038I\u000b!\"\u001a=dKB$\u0018n\u001c8t\u0013\u0011\u0011YD!\u000e\u0003\u0013QC'o\\<t'\u0012+\u0005b\u0002B \u0003\u0002\u0007\u00111O\u0001\u000bM>\u0014XK\u001c9beN,\u0007b\u0002B\"\u0003\u0002\u0007\u00111O\u0001\u0010C2dwn\u001e\"zi\u0016,e\u000e^5us\u00069RM\u001d:CC\u0012,e\u000e^5us2{g.\u001a)fe\u000e,g\u000e\u001e\u000b\t\u0005\u0013\u0012yEa\u0015\u0003VA\u0019QLa\u0013\n\u0007\t5cL\u0001\u0003V]&$\bb\u0002B)\u0005\u0002\u0007\u0011\u0011B\u0001\u0004K:$\bb\u0002B\u0013\u0005\u0002\u0007\u0011\u0011\u0002\u0005\b\u0005S\u0011\u0005\u0019\u0001B,!\u0019\u0011IF!\u0018\u000325\u0011!1\f\u0006\u0004\u0003C\u0011\u0016\u0002\u0002B0\u00057\u0012Q!T1zE\u0016\f!#\u001a:s\u0005\u0006$WI\u001c;jiftunU3nSRA!\u0011\nB3\u0005O\u0012I\u0007C\u0004\u0003R\r\u0003\r!!\u0003\t\u000f\t\u00152\t1\u0001\u0002\n!9!\u0011F\"A\u0002\t]\u0013a\u00029s_\u000e,7o\u001d\u000b\r\u0003\u0013\u0011yG!\u001d\u0003t\tU$q\u000f\u0005\b\u0003w\"\u0005\u0019AA\u0005\u0011\u001d\u0011)\u0003\u0012a\u0001\u0003\u0013AqA!\u000bE\u0001\u0004\u0011Y\u0003C\u0004\u0003@\u0011\u0003\r!a\u001d\t\u0013\teD\t%AA\u0002\u0005M\u0014!E1mY><()\u001f;f\u000b:$\u0018\u000e^5fg\u0006\t\u0002O]8dKN\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t}$\u0006BA:\u0005\u0003[#Aa!\u0011\t\t\u0015%qR\u0007\u0003\u0005\u000fSAA!#\u0003\f\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005\u001bs\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u0013BD\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0017Q\u0006\u001cHi\\;cY\u0016\u0004VM]2f]R,e\u000eZ5oOR!\u00111\u000fBL\u0011\u001d\tYH\u0012a\u0001\u0003\u0013\t!B]3qY\u0006\u001cW-\u00117m))\tIA!(\u0003 \n\u0005&1\u0015\u0005\b\u0003w:\u0005\u0019AA\u0005\u0011%\u0011Ic\u0012I\u0001\u0002\u0004\u0011Y\u0003C\u0005\u0003@\u001d\u0003\n\u00111\u0001\u0002t!I!\u0011P$\u0011\u0002\u0003\u0007\u00111O\u0001\u0015e\u0016\u0004H.Y2f\u00032dG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t%&\u0006\u0002B\u0016\u0005\u0003\u000bAC]3qY\u0006\u001cW-\u00117mI\u0011,g-Y;mi\u0012\u001a\u0014\u0001\u0006:fa2\f7-Z!mY\u0012\"WMZ1vYR$C'A\u0004sKBd\u0017mY3\u0015\r\u0005%!1\u0017B[\u0011\u001d\tYh\u0013a\u0001\u0003\u0013AaAa.L\u0001\u0004)\u0018!B2iCJ\u001c\u0018AD#oi&$\u0018PU3qY\u0006\u001cWM\u001d\t\u0003K6\u001b2!\u0014B`!\u0015\u0011IF!1e\u0013\u0011\u0011\u0019Ma\u0017\u0003\u000f=s7\u000b^1dWR\u0011!1\u0018")
public final class EntityReplacer {
    private final String dfdlEntityName;
    private final String dfdlCharClassEntityName;
    private final List<Tuple3<String, String, Matcher>> entityCharacterUnicode = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)"NUL", (Object)"\u0000", (Object)Pattern.compile("%NUL;", 8).matcher("")), new Tuple3((Object)"SOH", (Object)"\u0001", (Object)Pattern.compile("%SOH;", 8).matcher("")), new Tuple3((Object)"STX", (Object)"\u0002", (Object)Pattern.compile("%STX;", 8).matcher("")), new Tuple3((Object)"ETX", (Object)"\u0003", (Object)Pattern.compile("%ETX;", 8).matcher("")), new Tuple3((Object)"EOT", (Object)"\u0004", (Object)Pattern.compile("%EOT;", 8).matcher("")), new Tuple3((Object)"ENQ", (Object)"\u0005", (Object)Pattern.compile("%ENQ;", 8).matcher("")), new Tuple3((Object)"ACK", (Object)"\u0006", (Object)Pattern.compile("%ACK;", 8).matcher("")), new Tuple3((Object)"BEL", (Object)"\u0007", (Object)Pattern.compile("%BEL;", 8).matcher("")), new Tuple3((Object)"BS", (Object)"\b", (Object)Pattern.compile("%BS;", 8).matcher("")), new Tuple3((Object)"HT", (Object)"\t", (Object)Pattern.compile("%HT;", 8).matcher("")), new Tuple3((Object)"LF", (Object)"\n", (Object)Pattern.compile("%LF;", 8).matcher("")), new Tuple3((Object)"VT", (Object)"\u000b", (Object)Pattern.compile("%VT;", 8).matcher("")), new Tuple3((Object)"FF", (Object)"\f", (Object)Pattern.compile("%FF;", 8).matcher("")), new Tuple3((Object)"CR", (Object)"\r", (Object)Pattern.compile("%CR;", 8).matcher("")), new Tuple3((Object)"SO", (Object)"\u000e", (Object)Pattern.compile("%SO;", 8).matcher("")), new Tuple3((Object)"SI", (Object)"\u000f", (Object)Pattern.compile("%SI;", 8).matcher("")), new Tuple3((Object)"DLE", (Object)"\u0010", (Object)Pattern.compile("%DLE;", 8).matcher("")), new Tuple3((Object)"DC1", (Object)"\u0011", (Object)Pattern.compile("%DC1;", 8).matcher("")), new Tuple3((Object)"DC2", (Object)"\u0012", (Object)Pattern.compile("%DC2;", 8).matcher("")), new Tuple3((Object)"DC3", (Object)"\u0013", (Object)Pattern.compile("%DC3;", 8).matcher("")), new Tuple3((Object)"DC4", (Object)"\u0014", (Object)Pattern.compile("%DC4;", 8).matcher("")), new Tuple3((Object)"NAK", (Object)"\u0015", (Object)Pattern.compile("%NAK;", 8).matcher("")), new Tuple3((Object)"SYN", (Object)"\u0016", (Object)Pattern.compile("%SYN;", 8).matcher("")), new Tuple3((Object)"ETB", (Object)"\u0017", (Object)Pattern.compile("%ETB;", 8).matcher("")), new Tuple3((Object)"CAN", (Object)"\u0018", (Object)Pattern.compile("%CAN;", 8).matcher("")), new Tuple3((Object)"EM", (Object)"\u0019", (Object)Pattern.compile("%EM;", 8).matcher("")), new Tuple3((Object)"SUB", (Object)"\u001a", (Object)Pattern.compile("%SUB;", 8).matcher("")), new Tuple3((Object)"ESC", (Object)"\u001b", (Object)Pattern.compile("%ESC;", 8).matcher("")), new Tuple3((Object)"FS", (Object)"\u001c", (Object)Pattern.compile("%FS;", 8).matcher("")), new Tuple3((Object)"GS", (Object)"\u001d", (Object)Pattern.compile("%GS;", 8).matcher("")), new Tuple3((Object)"RS", (Object)"\u001e", (Object)Pattern.compile("%RS;", 8).matcher("")), new Tuple3((Object)"US", (Object)"\u001f", (Object)Pattern.compile("%US;", 8).matcher("")), new Tuple3((Object)"SP", (Object)" ", (Object)Pattern.compile("%SP;", 8).matcher("")), new Tuple3((Object)"DEL", (Object)"\u007f", (Object)Pattern.compile("%DEL;", 8).matcher("")), new Tuple3((Object)"NBSP", (Object)"\u00a0", (Object)Pattern.compile("%NBSP;", 8).matcher("")), new Tuple3((Object)"NEL", (Object)"\u0085", (Object)Pattern.compile("%NEL;", 8).matcher("")), new Tuple3((Object)"LS", (Object)"\u2028", (Object)Pattern.compile("%LS;", 8).matcher(""))}));
    private final List<Tuple3<String, String, Matcher>> charClassReplacements = new .colon.colon((Object)new Tuple3((Object)"WSP", (Object)" ", (Object)Pattern.compile("%WSP;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"WSP*", (Object)"", (Object)Pattern.compile("%WSP\\*;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"WSP+", (Object)" ", (Object)Pattern.compile("%WSP\\+;", 8).matcher("")), (List)new .colon.colon((Object)new Tuple3((Object)"ES", (Object)"", (Object)Pattern.compile("%ES;", 8).matcher("")), (List)Nil$.MODULE$))));
    private final List<Tuple3<String, String, Matcher>> escapeReplacements = new .colon.colon((Object)new Tuple3((Object)"%", (Object)"%", (Object)Pattern.compile("%%", 8).matcher("")), (List)Nil$.MODULE$);
    private final Matcher charEntityPattern = Pattern.compile(new StringBuilder(4).append("%(").append(this.dfdlEntityName()).append(");").toString(), 8).matcher("");
    private final Matcher hexPattern = Pattern.compile("%#x[0-9a-fA-F]+;", 8).matcher("");
    private final Matcher decPattern = Pattern.compile("%#[0-9]+;", 8).matcher("");
    private final Matcher bytePattern = Pattern.compile("%#r[0-9a-fA-F]{2};", 8).matcher("");
    private final Matcher charClassEntityPattern = Pattern.compile(new StringBuilder(4).append("%(").append(this.dfdlCharClassEntityName()).append(");").toString(), 8).matcher("");
    private final Regex charEntityRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(%(?:").append(this.dfdlEntityName()).append(");)(.*)").toString())).r();
    private final Regex hexRegex = new StringOps(Predef$.MODULE$.augmentString("(%#x[0-9a-fA-F]+;)(.*)")).r();
    private final Regex decRegex = new StringOps(Predef$.MODULE$.augmentString("(%#[0-9]+;)(.*)")).r();
    private final Regex byteRegex = new StringOps(Predef$.MODULE$.augmentString("(%#r[0-9a-fA-F]{2};)(.*)")).r();
    private final Regex charClassEntityRegex = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(12).append("(%(?:").append(this.dfdlCharClassEntityName()).append(");)(.*)").toString())).r();
    private final Regex dfdlEntityRegex = new StringOps(Predef$.MODULE$.augmentString("(%[^%]*?;)(.*)")).r();
    private final String markerForNL;
    private final String markerForDoublePercent;
    private final Matcher DPMatcher = Pattern.compile("(?<!%)%%", 8).matcher("");
    private final Matcher markerForDPMatcher = Pattern.compile(this.markerForDoublePercent(), 8).matcher("");
    private final Matcher NLMatcher = Pattern.compile("%NL;", 8).matcher("");
    private final Matcher markerForNLMatcher = Pattern.compile(this.markerForNL(), 8).matcher("");

    public static <R> R apply(Function1<EntityReplacer, R> function1) {
        return EntityReplacer$.MODULE$.apply(function1);
    }

    public String dfdlEntityName() {
        return this.dfdlEntityName;
    }

    public String dfdlCharClassEntityName() {
        return this.dfdlCharClassEntityName;
    }

    public List<Tuple3<String, String, Matcher>> entityCharacterUnicode() {
        return this.entityCharacterUnicode;
    }

    public List<Tuple3<String, String, Matcher>> charClassReplacements() {
        return this.charClassReplacements;
    }

    public List<Tuple3<String, String, Matcher>> escapeReplacements() {
        return this.escapeReplacements;
    }

    public Matcher charEntityPattern() {
        return this.charEntityPattern;
    }

    public Matcher hexPattern() {
        return this.hexPattern;
    }

    public Matcher decPattern() {
        return this.decPattern;
    }

    public Matcher bytePattern() {
        return this.bytePattern;
    }

    public Matcher charClassEntityPattern() {
        return this.charClassEntityPattern;
    }

    public Regex charEntityRegex() {
        return this.charEntityRegex;
    }

    public Regex hexRegex() {
        return this.hexRegex;
    }

    public Regex decRegex() {
        return this.decRegex;
    }

    public Regex byteRegex() {
        return this.byteRegex;
    }

    public Regex charClassEntityRegex() {
        return this.charClassEntityRegex;
    }

    public Regex dfdlEntityRegex() {
        return this.dfdlEntityRegex;
    }

    public boolean hasDfdlEntity(String input) {
        return this.hasDfdlCharEntity(input) || this.hasDecimalCodePoint(input) || this.hasHexCodePoint(input) || this.hasByteCodePoint(input) || this.hasDfdlCharClassEntity(input);
    }

    private boolean isMatched(String input, Matcher m) {
        m.reset(input);
        return m.find();
    }

    public boolean hasDfdlCharClassEntity(String input) {
        return this.isMatched(input, this.charClassEntityPattern());
    }

    public boolean hasDfdlCharEntity(String input) {
        return this.isMatched(input, this.charEntityPattern());
    }

    public boolean hasDecimalCodePoint(String input) {
        return this.isMatched(input, this.decPattern());
    }

    public boolean hasHexCodePoint(String input) {
        return this.isMatched(input, this.hexPattern());
    }

    public boolean hasByteCodePoint(String input) {
        return this.isMatched(input, this.bytePattern());
    }

    private String replaceEntityWithChar(String input, String entity, char newChar) {
        String replacement = package$ViewEqual$.MODULE$.$eq$hash$eq$extension(package$.MODULE$.ViewEqual(BoxesRunTime.boxToCharacter((char)newChar)), BoxesRunTime.boxToCharacter((char)'%')) ? "%%" : Matcher.quoteReplacement(Character.toString(newChar));
        return input.replaceAll(entity, replacement);
    }

    public String replaceHex(String input, String prefix) {
        String res = input;
        while (this.hasHexCodePoint(res)) {
            Matcher m = this.hexPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 16);
            char newChar = (char)intStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceDecimal(String input, String prefix) {
        String res = input;
        while (this.hasDecimalCodePoint(res)) {
            Matcher m = this.decPattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int intStr = Integer.parseInt(trimmedStr, 10);
            char newChar = (char)intStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceBytes(String input, String prefix) {
        String res = input;
        while (this.hasByteCodePoint(res)) {
            Matcher m = this.bytePattern();
            m.reset(res);
            if (!m.find()) continue;
            String rawStr = m.group().toString();
            String trimmedStr = rawStr.replace(prefix, "").replace(";", "");
            int upperNibble = Byte.parseByte(trimmedStr.substring(0, 1), 16) << 4;
            byte lowerNibble = Byte.parseByte(trimmedStr.substring(1, 2), 16);
            int byteStr = upperNibble | lowerNibble;
            char newChar = (char)byteStr;
            res = this.replaceEntityWithChar(res, rawStr, newChar);
        }
        return res;
    }

    public String replaceByte(String input) {
        return this.replaceBytes(input, "%#r");
    }

    public String replaceHex(String input) {
        return this.replaceHex(input, "%#x");
    }

    public String replaceDecimal(String input) {
        return this.replaceDecimal(input, "%#");
    }

    public String replaceDfdlEntity(String input) {
        return this.replace(input, this.entityCharacterUnicode());
    }

    public String replaceEscapes(String input) {
        return this.replace(input, this.escapeReplacements());
    }

    public String replaceCharClassForUnparse(String input) {
        return this.replace(input, this.charClassReplacements());
    }

    public String markerForNL() {
        return this.markerForNL;
    }

    private String markerForDoublePercent() {
        return this.markerForDoublePercent;
    }

    private Matcher DPMatcher() {
        return this.DPMatcher;
    }

    private Matcher markerForDPMatcher() {
        return this.markerForDPMatcher;
    }

    private Matcher NLMatcher() {
        return this.NLMatcher;
    }

    private Matcher markerForNLMatcher() {
        return this.markerForNLMatcher;
    }

    public String replaceForUnparse(String raw) {
        this.markerForDPMatcher().reset(raw);
        if (this.markerForDPMatcher().find()) {
            throw Assert$.MODULE$.usageError2(new StringBuilder(35).append("Usage error: ").append("string cannot contain ").append(this.markerForDPMatcher()).toString(), "EntityReplacer.this.markerForDPMatcher.find().unary_!");
        }
        this.markerForNLMatcher().reset(raw);
        if (this.markerForNLMatcher().find()) {
            throw Assert$.MODULE$.usageError2(new StringBuilder(35).append("Usage error: ").append("string cannot contain ").append(this.markerForNL()).toString(), "EntityReplacer.this.markerForNLMatcher.find().unary_!");
        }
        this.DPMatcher().reset(raw);
        String dpMarked = this.DPMatcher().replaceAll(this.markerForDoublePercent());
        String forUnp = this.replaceAll(dpMarked, (Option<ThrowsSDE>)None$.MODULE$, true, this.replaceAll$default$4());
        this.NLMatcher().reset(forUnp);
        String nlMarked = this.NLMatcher().replaceAll(this.markerForNL());
        String s2 = nlMarked.replaceAll(this.markerForDoublePercent(), "%");
        return s2;
    }

    private String stripLeadingPercent(String s) {
        if (s.startsWith("%")) {
            return s.substring(1);
        }
        return s;
    }

    private String replaceEntity(String proposedEntity, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntity) {
        String string;
        String string2 = proposedEntity;
        Option option = this.charClassEntityRegex().unapplySeq((CharSequence)string2);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
            string = forUnparse ? this.replaceCharClassForUnparse(proposedEntity) : proposedEntity;
        } else {
            Option option2 = this.hexRegex().unapplySeq((CharSequence)string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                string = this.replaceHex(proposedEntity);
            } else {
                Option option3 = this.decRegex().unapplySeq((CharSequence)string2);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    string = this.replaceDecimal(proposedEntity);
                } else {
                    Option option4 = this.byteRegex().unapplySeq((CharSequence)string2);
                    if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(2) == 0) {
                        if (allowByteEntity) {
                            string = this.replaceByte(proposedEntity);
                        } else {
                            String msg = "DFDL Byte Entity (%%%s) is not allowed, but was found in \"%s\"";
                            string = (String)context.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity), orig}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                throw new EntitySyntaxException(new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(proposedEntity), orig})));
                            });
                        }
                    } else {
                        Option option5 = this.charEntityRegex().unapplySeq((CharSequence)string2);
                        if (!option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(2) == 0) {
                            string = this.replace(proposedEntity, this.entityCharacterUnicode());
                        } else {
                            Option option6 = this.dfdlEntityRegex().unapplySeq((CharSequence)string2);
                            if (!option6.isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(2) == 0) {
                                String invalidEntity = (String)((LinearSeqOptimized)option6.get()).apply(0);
                                String msg = "Invalid DFDL Entity (%%%s) found in \"%s\"";
                                string = (String)context.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity), orig}))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                                    throw new EntitySyntaxException(new StringOps(Predef$.MODULE$.augmentString(msg)).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(invalidEntity), orig})));
                                });
                            } else {
                                string = string2;
                            }
                        }
                    }
                }
            }
        }
        String result = string;
        return result;
    }

    private void errBadEntityLonePercent(String ent, String orig, Object context) {
        String msg = new StringOps(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%s) found in \"%s\". If a single percent was intended instead of a DFDL Entity, it must be self escaped (%%%%).")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ent, orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private void errBadEntityNoSemi(String ent, String orig, Object context) {
        String msg = new StringOps(Predef$.MODULE$.augmentString("Invalid DFDL Entity (%%%s) found in \"%s\". Missing semicolon at end of entity name?")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.stripLeadingPercent(ent), orig}));
        if (Maybe$.MODULE$.isDefined$extension(context)) {
            throw ((ThrowsSDE)Maybe$.MODULE$.get$extension(context)).SDE(msg, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        throw new EntitySyntaxException(msg);
    }

    private String process(String input, String orig, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (input.contains("%%")) {
            throw Assert$.MODULE$.usageError("Usage error: input.contains(\"%%\").unary_!");
        }
        if (!input.contains("%")) {
            return input;
        }
        if (input.equals("%")) {
            this.errBadEntityLonePercent(input, orig, Maybe$.MODULE$.toMaybe(context));
        }
        String[] tokens = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])input.split("%"))).$plus$plus((GenTraversableOnce)(input.endsWith("%") ? new .colon.colon((Object)"", (List)Nil$.MODULE$) : Nil$.MODULE$), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String startingToken = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).head();
        String[] possibleEntityTokens = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens)).tail();
        String[] tokens2 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])possibleEntityTokens)).map((Function1 & Serializable & scala.Serializable)tok -> {
            if (tok.contains("%")) {
                throw Assert$.MODULE$.abort("Invariant broken: tok.contains(\"%\").unary_!");
            }
            if (!tok.contains(";")) {
                this.errBadEntityNoSemi((String)tok, orig, Maybe$.MODULE$.toMaybe(context));
            }
            int semiPos = tok.indexOf(";");
            String possibleEntityName = tok.substring(0, semiPos);
            String afterEntity = tok.substring(semiPos + 1);
            String newEntity = this.replaceEntity(new StringBuilder(2).append("%").append(possibleEntityName).append(";").toString(), orig, context, forUnparse, allowByteEntities);
            String res = new StringBuilder(0).append(newEntity).append(afterEntity).toString();
            return res;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String output = new StringBuilder(0).append(startingToken).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tokens2)).mkString()).toString();
        return output;
    }

    private boolean process$default$5() {
        return true;
    }

    private boolean hasDoublePercentEnding(String input) {
        String string = input;
        String string2 = "";
        if (!(string == null ? string2 != null : !string.equals(string2)) || input.length() < 2) {
            return false;
        }
        return input.charAt(input.length() - 2) == '%' && BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(input)).last()) == '%';
    }

    public String replaceAll(String input, Option<ThrowsSDE> context, boolean forUnparse, boolean allowByteEntities) {
        if (!input.contains("%")) {
            return input;
        }
        int startOfPossibleEntity = input.indexOf("%");
        String inputUntilPossibleEntity = input.substring(0, startOfPossibleEntity);
        String inputWithPossibleEntity = input.substring(startOfPossibleEntity);
        if (!inputWithPossibleEntity.contains("%%")) {
            String processedInput = this.process(inputWithPossibleEntity, input, context, forUnparse, allowByteEntities);
            String fullResult = new StringBuilder(0).append(inputUntilPossibleEntity).append(processedInput).toString();
            return fullResult;
        }
        boolean endedWithDoublePercent = this.hasDoublePercentEnding(inputWithPossibleEntity);
        String[] splitByDoublePercent = inputWithPossibleEntity.split("%%");
        String[] replaced = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])splitByDoublePercent)).map((Function1 & Serializable & scala.Serializable)token -> this.process((String)token, input, context, forUnparse, this.process$default$5()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String replacementForDoublePercents = forUnparse ? "%" : "%%";
        String recomposedWithLiteralPercents = new StringBuilder(0).append(inputUntilPossibleEntity).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replaced)).mkString(replacementForDoublePercents)).append((Object)(endedWithDoublePercent ? replacementForDoublePercents : "")).toString();
        return recomposedWithLiteralPercents;
    }

    private String replace(String input, List<Tuple3<String, String, Matcher>> chars) {
        ObjectRef res = ObjectRef.create((Object)input);
        chars.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            EntityReplacer.$anonfun$replace$1(res, x0$1);
            return BoxedUnit.UNIT;
        });
        return (String)res.elem;
    }

    public Option<ThrowsSDE> replaceAll$default$2() {
        return None$.MODULE$;
    }

    public boolean replaceAll$default$3() {
        return false;
    }

    public boolean replaceAll$default$4() {
        return true;
    }

    public static final /* synthetic */ void $anonfun$replace$1(ObjectRef res$1, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            String unicode = (String)tuple3._2();
            Matcher m = (Matcher)tuple3._3();
            m.reset((String)res$1.elem);
            res$1.elem = m.replaceAll(unicode);
            return;
        }
        throw new MatchError((Object)tuple3);
    }

    public EntityReplacer() {
        this.dfdlEntityName = "NUL|SOH|STX|ETX|EOT|ENQ|ACK|BEL|BS|HT|LF|VT|FF|CR|SO|SI|DLE|DC[1-4]|NAK|SYN|ETB|CAN|EM|SUB|ESC|FS|GS|RS|US|SP|DEL|NBSP|NEL|LS";
        this.dfdlCharClassEntityName = "NL|WSP|WSP\\*|WSP\\+|ES";
        this.markerForNL = "\ufffc__NL_ENTITY__\ufffc";
        this.markerForDoublePercent = "\ufffc__DOUBLE_PERCENT__\ufffc";
    }
}

