/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.fediz.core.config.ConfigUtils;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.jaxb.CallbackType;
import org.apache.cxf.fediz.core.config.jaxb.FederationProtocolType;
import org.apache.cxf.fediz.core.config.jaxb.ProtocolType;
import org.apache.cxf.fediz.core.saml.SAMLTokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationProtocol
extends Protocol {
    private static final Logger LOG = LoggerFactory.getLogger(FederationProtocol.class);
    private Object request;
    private Object authenticationType;
    private Object homeRealm;
    private Object freshness;
    private Object signOutQuery;

    public FederationProtocol(ProtocolType protocolType) {
        super(protocolType);
        SAMLTokenValidator validator = new SAMLTokenValidator();
        this.getTokenValidators().add(validator);
    }

    protected FederationProtocolType getFederationProtocol() {
        return (FederationProtocolType)super.getProtocolType();
    }

    protected void setFederationProtocol(FederationProtocolType federationProtocol) {
        super.setProtocolType(federationProtocol);
    }

    public Object getAuthenticationType() {
        if (this.authenticationType != null) {
            return this.authenticationType;
        }
        CallbackType cbt = this.getFederationProtocol().getAuthenticationType();
        this.authenticationType = ConfigUtils.loadCallbackType(cbt, "AuthenticationType", this.getClassloader());
        return this.authenticationType;
    }

    public void setAuthenticationType(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'AuthenticationType' object");
            throw new IllegalArgumentException("Unsupported 'AuthenticationType' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.authenticationType = value;
    }

    public Object getHomeRealm() {
        if (this.homeRealm != null) {
            return this.homeRealm;
        }
        CallbackType cbt = this.getFederationProtocol().getHomeRealm();
        this.homeRealm = ConfigUtils.loadCallbackType(cbt, "HomeRealm", this.getClassloader());
        return this.homeRealm;
    }

    public void setHomeRealm(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'HomeRealm' object");
            throw new IllegalArgumentException("Unsupported 'HomeRealm' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.homeRealm = value;
    }

    public Object getFreshness() {
        if (this.freshness != null) {
            return this.freshness;
        }
        CallbackType cbt = this.getFederationProtocol().getFreshness();
        this.freshness = ConfigUtils.loadCallbackType(cbt, "Freshness", this.getClassloader());
        return this.freshness;
    }

    public void setFreshness(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Freshness' object");
            throw new IllegalArgumentException("Unsupported 'Freshness' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.freshness = value;
    }

    public Object getSignOutQuery() {
        if (this.signOutQuery != null) {
            return this.signOutQuery;
        }
        CallbackType cbt = this.getFederationProtocol().getSignOutQuery();
        this.signOutQuery = ConfigUtils.loadCallbackType(cbt, "SignOutQuery", this.getClassloader());
        return this.signOutQuery;
    }

    public void setSignOutQuery(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'SignOutQuery' object");
            throw new IllegalArgumentException("Unsupported 'SignOutQuery' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.signOutQuery = value;
    }

    public Object getRequest() {
        if (this.request != null) {
            return this.request;
        }
        CallbackType cbt = this.getFederationProtocol().getRequest();
        this.request = ConfigUtils.loadCallbackType(cbt, "Request", this.getClassloader());
        return this.request;
    }

    public void setRequest(Object value) {
        boolean isString = value instanceof String;
        boolean isCallbackHandler = value instanceof CallbackHandler;
        if (!isString && !isCallbackHandler) {
            LOG.error("Unsupported 'Request' object");
            throw new IllegalArgumentException("Unsupported 'Request' object. Type must be java.lang.String or javax.security.auth.callback.CallbackHandler.");
        }
        this.request = value;
    }

    public String getVersion() {
        return this.getFederationProtocol().getVersion();
    }

    public void setVersion(String value) {
        this.getFederationProtocol().setVersion(value);
    }

    @Override
    public String toString() {
        return this.getFederationProtocol().toString();
    }
}

