/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.jaxb.ContextConfig;
import org.apache.cxf.fediz.core.config.jaxb.FedizConfig;

public class FedizConfigurator {
    private FedizConfig rootConfig;
    private JAXBContext jaxbContext;
    private List<FedizContext> fedizContextList;

    public FedizConfig loadConfig(File f) throws JAXBException, IOException {
        try (InputStream input = Files.newInputStream(f.toPath(), new OpenOption[0]);){
            this.rootConfig = (FedizConfig)this.getJaxbContext().createUnmarshaller().unmarshal(input);
        }
        this.parseFedizContextList();
        return this.rootConfig;
    }

    public FedizConfig loadConfig(Reader reader) throws JAXBException {
        this.rootConfig = (FedizConfig)this.getJaxbContext().createUnmarshaller().unmarshal(reader);
        this.parseFedizContextList();
        return this.rootConfig;
    }

    private void parseFedizContextList() {
        this.fedizContextList = new ArrayList<FedizContext>();
        for (ContextConfig config : this.rootConfig.getContextConfig()) {
            this.fedizContextList.add(new FedizContext(config));
        }
    }

    public void saveConfiguration(File f) throws JAXBException {
        if (f.canWrite()) {
            this.jaxbContext.createMarshaller().marshal((Object)this.rootConfig, f);
        }
    }

    public void saveConfiguration(Writer writer) throws JAXBException {
        this.jaxbContext.createMarshaller().marshal((Object)this.rootConfig, writer);
    }

    private JAXBContext getJaxbContext() throws JAXBException {
        if (this.jaxbContext == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{FedizConfig.class});
        }
        return this.jaxbContext;
    }

    public List<FedizContext> getFedizContextList() {
        return this.fedizContextList;
    }

    public FedizContext getFedizContext(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("Context Name cannot be 'null'.");
        }
        if (contextName.isEmpty()) {
            contextName = "/";
        }
        if (this.rootConfig == null) {
            throw new IllegalArgumentException("No configuration loaded");
        }
        for (FedizContext fedContext : this.fedizContextList) {
            if (!fedContext.getName().equals(contextName)) continue;
            fedContext.init();
            return fedContext;
        }
        return null;
    }

    public ContextConfig getContextConfig(String contextName) {
        if (contextName == null) {
            throw new IllegalArgumentException("Context Name cannot be 'null'.");
        }
        if (contextName.isEmpty()) {
            contextName = "/";
        }
        if (this.rootConfig == null) {
            throw new IllegalArgumentException("No configuration loaded");
        }
        for (ContextConfig config : this.rootConfig.getContextConfig()) {
            if (!contextName.equals(config.getName())) continue;
            return config;
        }
        return null;
    }
}

