/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.access.expression.method;

import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.method.MethodSecurityExpressionHandler;
import org.springframework.security.access.expression.method.PostInvocationExpressionAttribute;
import org.springframework.security.access.expression.method.PreInvocationExpressionAttribute;
import org.springframework.security.access.prepost.PostInvocationAttribute;
import org.springframework.security.access.prepost.PreInvocationAttribute;
import org.springframework.security.access.prepost.PrePostInvocationAttributeFactory;

public class ExpressionBasedAnnotationAttributeFactory
implements PrePostInvocationAttributeFactory {
    private final Object parserLock = new Object();
    private ExpressionParser parser;
    private MethodSecurityExpressionHandler handler;

    public ExpressionBasedAnnotationAttributeFactory(MethodSecurityExpressionHandler handler) {
        this.handler = handler;
    }

    @Override
    public PreInvocationAttribute createPreInvocationAttribute(String preFilterAttribute, String filterObject, String preAuthorizeAttribute) {
        try {
            ExpressionParser parser = this.getParser();
            Expression preAuthorizeExpression = preAuthorizeAttribute == null ? parser.parseExpression("permitAll") : parser.parseExpression(preAuthorizeAttribute);
            Expression preFilterExpression = preFilterAttribute == null ? null : parser.parseExpression(preFilterAttribute);
            return new PreInvocationExpressionAttribute(preFilterExpression, filterObject, preAuthorizeExpression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse expression '" + e.getExpressionString() + "'", e);
        }
    }

    @Override
    public PostInvocationAttribute createPostInvocationAttribute(String postFilterAttribute, String postAuthorizeAttribute) {
        try {
            Expression postFilterExpression;
            ExpressionParser parser = this.getParser();
            Expression postAuthorizeExpression = postAuthorizeAttribute == null ? null : parser.parseExpression(postAuthorizeAttribute);
            Expression expression = postFilterExpression = postFilterAttribute == null ? null : parser.parseExpression(postFilterAttribute);
            if (postFilterExpression != null || postAuthorizeExpression != null) {
                return new PostInvocationExpressionAttribute(postFilterExpression, postAuthorizeExpression);
            }
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse expression '" + e.getExpressionString() + "'", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExpressionParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        Object object = this.parserLock;
        synchronized (object) {
            this.parser = this.handler.getExpressionParser();
            this.handler = null;
        }
        return this.parser;
    }
}

