/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.jetty9;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.JAXBException;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizConfigurator;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.config.SAMLProtocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataDocumentHandler;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.jetty9.FederationLoginService;
import org.apache.cxf.fediz.jetty9.FederationUserIdentity;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ServerAuthException;
import org.eclipse.jetty.security.UserAuthentication;
import org.eclipse.jetty.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.security.authentication.SessionAuthentication;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FederationAuthenticator
extends LoginAuthenticator {
    public static final String J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String J_CONTEXT = "org.eclipse.jetty.security.form_CONTEXT";
    private static final Logger LOG = Log.getLogger(FederationAuthenticator.class);
    private static final String SECURITY_TOKEN_ATTR = "org.apache.fediz.SECURITY_TOKEN";
    private String configFile;
    private FedizConfigurator configurator;
    private String encoding = "UTF-8";

    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        super.setConfiguration(configuration);
        LOG.debug(configuration.getInitParameterNames().toString(), new Object[0]);
        try {
            String jettyHome;
            File f = new File(this.getConfigFile());
            if (!f.exists() && (jettyHome = System.getProperty("jetty.home")) != null && jettyHome.length() > 0) {
                f = new File(jettyHome.concat(File.separator + this.getConfigFile()));
            }
            this.configurator = new FedizConfigurator();
            this.configurator.loadConfig(f);
            LOG.debug("Fediz configuration read from " + f.getAbsolutePath(), new Object[0]);
        }
        catch (IOException | JAXBException e) {
            throw new RuntimeException("Failed to load Fediz configuration", e);
        }
    }

    public String getAuthMethod() {
        return "WSFED";
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        FedizContext fedConfig;
        MetadataDocumentHandler mdHandler;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        HttpSession session = request.getSession(true);
        String contextName = request.getSession().getServletContext().getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        if ((mdHandler = new MetadataDocumentHandler(fedConfig = this.getContextConfiguration(contextName))).canHandleRequest(request)) {
            Authentication authentication = Authentication.SEND_FAILURE;
            if (mdHandler.handleRequest(request, response).booleanValue()) {
                authentication = Authentication.SEND_CONTINUE;
            }
            return authentication;
        }
        if (!mandatory) {
            return new DeferredAuthentication((LoginAuthenticator)this);
        }
        try {
            req.setCharacterEncoding(this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            LOG.warn("Unsupported encoding '" + this.encoding + "'", (Throwable)ex);
        }
        try {
            String action = request.getParameter("wa");
            Authentication authentication = null;
            if (this.isSignInRequest((ServletRequest)request, fedConfig)) {
                authentication = this.handleSignInRequest(request, response, session, fedConfig);
            } else if ("wsignoutcleanup1.0".equals(action)) {
                authentication = this.handleSignOutCleanup(response, session);
            } else if (!"wsignout1.0".equals(action) && action != null) {
                LOG.warn("Not supported action found in parameter wa: " + action, new Object[0]);
                response.sendError(400);
                authentication = Authentication.UNAUTHENTICATED;
            }
            if (authentication != null) {
                return authentication;
            }
            authentication = this.handleCachedAuthentication(request, response, session, fedConfig);
            if (authentication != null) {
                return authentication;
            }
            if (DeferredAuthentication.isDeferred((HttpServletResponse)response)) {
                LOG.debug("auth deferred {}", new Object[]{session.getId()});
                return Authentication.UNAUTHENTICATED;
            }
            HttpSession httpSession = session;
            synchronized (httpSession) {
                if (session.getAttribute(J_URI) == null) {
                    StringBuffer buf = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        buf.append('?').append(request.getQueryString());
                    }
                    session.setAttribute(J_URI, (Object)buf.toString());
                    if (MimeTypes.Type.FORM_ENCODED.asString().equals(req.getContentType()) && HttpMethod.POST.asString().equals(request.getMethod())) {
                        Request baseRequest = (Request)req;
                        baseRequest.getParameterMap();
                        session.setAttribute(J_POST, (Object)new MultiMap(baseRequest.getQueryParameters()));
                    }
                }
            }
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
            this.signInRedirectToIssuer(request, response, wfProc, session);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Authentication handleSignInRequest(HttpServletRequest request, HttpServletResponse response, HttpSession session, FedizContext fedConfig) throws IOException {
        Object wfRes = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignIn request found", new Object[0]);
        }
        String action = request.getParameter("wa");
        String responseToken = this.getResponseToken((ServletRequest)request, fedConfig);
        if (responseToken == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("SignIn request must contain a response token from the IdP", new Object[0]);
            }
            response.sendError(400);
            return Authentication.SEND_FAILURE;
        }
        FedizRequest wfReq = new FedizRequest();
        wfReq.setAction(action);
        wfReq.setResponseToken(responseToken);
        wfReq.setState(this.getState((ServletRequest)request));
        wfReq.setRequest(request);
        wfReq.setRequestState((RequestState)session.getAttribute(J_CONTEXT));
        Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        wfReq.setCerts(certs);
        FederationLoginService fedLoginService = (FederationLoginService)this._loginService;
        UserIdentity user = fedLoginService.login(null, (Object)wfReq, fedConfig);
        if (user != null) {
            String nuri;
            HttpSession httpSession = session = this.renewSession(request, response);
            synchronized (httpSession) {
                RequestState savedRequestState = (RequestState)session.getAttribute(J_CONTEXT);
                String receivedContext = this.getState((ServletRequest)request);
                if (savedRequestState == null || !savedRequestState.getState().equals(receivedContext)) {
                    LOG.warn("The received wctx/RelayState parameter does not match the saved value", new Object[0]);
                    response.sendError(403);
                    return Authentication.UNAUTHENTICATED;
                }
                nuri = (String)session.getAttribute(J_URI);
                if ((nuri == null || nuri.length() == 0) && (nuri = request.getContextPath()).length() == 0) {
                    nuri = "/";
                }
                SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, wfRes);
                session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
            }
            FederationUserIdentity fui = (FederationUserIdentity)user;
            session.setAttribute(SECURITY_TOKEN_ATTR, (Object)fui.getToken());
            response.setContentLength(0);
            response.sendRedirect(response.encodeRedirectURL(nuri));
            return new FederationAuthentication(this.getAuthMethod(), user);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("WSFED authentication FAILED", new Object[0]);
        }
        response.sendError(403);
        return Authentication.UNAUTHENTICATED;
    }

    private Authentication handleSignOutCleanup(HttpServletResponse response, HttpSession session) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("SignOutCleanup request found", new Object[0]);
            LOG.debug("SignOutCleanup action...", new Object[0]);
        }
        session.invalidate();
        ServletOutputStream responseOutputStream = response.getOutputStream();
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("logout.jpg");
        if (inputStream == null) {
            LOG.warn("Could not write logout.jpg", new Object[0]);
            return Authentication.SEND_FAILURE;
        }
        int read = 0;
        byte[] buf = new byte[1024];
        while ((read = inputStream.read(buf)) != -1) {
            responseOutputStream.write(buf, 0, read);
        }
        inputStream.close();
        responseOutputStream.flush();
        return Authentication.SEND_SUCCESS;
    }

    private Authentication handleCachedAuthentication(HttpServletRequest request, HttpServletResponse response, HttpSession session, FedizContext fedConfig) throws IOException {
        Authentication authentication = (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        if (authentication != null) {
            if (authentication instanceof Authentication.User && this.isTokenExpired(fedConfig, ((Authentication.User)authentication).getUserIdentity())) {
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            } else {
                String contextName;
                String action = request.getParameter("wa");
                boolean logout = "wsignout1.0".equals(action);
                String logoutUrl = fedConfig.getLogoutURL();
                String uri = request.getRequestURI();
                if (uri == null) {
                    uri = "/";
                }
                if ((contextName = request.getSession().getServletContext().getContextPath()) == null || contextName.isEmpty()) {
                    contextName = "/";
                }
                if (logout || logoutUrl != null && !logoutUrl.isEmpty() && uri.equals(contextName + logoutUrl)) {
                    session.invalidate();
                    FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)fedConfig.getProtocol());
                    this.signOutRedirectToIssuer(request, response, wfProc);
                    return Authentication.SEND_CONTINUE;
                }
                String jUri = (String)session.getAttribute(J_URI);
                MultiMap jPost = (MultiMap)session.getAttribute(J_POST);
                if (jUri != null && jPost != null) {
                    StringBuffer buf = request.getRequestURL();
                    if (request.getQueryString() != null) {
                        buf.append('?').append(request.getQueryString());
                    }
                    if (jUri.equals(buf.toString())) {
                        session.removeAttribute(J_POST);
                        Request baseRequest = (Request)request;
                        baseRequest.setMethod(HttpMethod.POST.asString());
                        baseRequest.setQueryParameters(jPost);
                    }
                } else if (jUri != null) {
                    session.removeAttribute(J_URI);
                }
                return authentication;
            }
        }
        return null;
    }

    private boolean isTokenExpired(FedizContext fedConfig, UserIdentity userIdentity) {
        if (fedConfig.isDetectExpiredTokens()) {
            try {
                FederationUserIdentity fui = (FederationUserIdentity)userIdentity;
                Instant tokenExpires = fui.getExpiryDate();
                if (tokenExpires == null) {
                    LOG.debug("Token doesn't expire", new Object[0]);
                    return false;
                }
                Instant currentTime = Instant.now();
                if (!currentTime.isAfter(tokenExpires)) {
                    return false;
                }
                LOG.warn("Token already expired. Clean up and redirect", new Object[0]);
                return true;
            }
            catch (ClassCastException ex) {
                LOG.warn("UserIdentity must be instance of FederationUserIdentity", new Object[0]);
                throw new IllegalStateException("UserIdentity must be instance of FederationUserIdentity");
            }
        }
        return false;
    }

    private boolean isSignInRequest(ServletRequest request, FedizContext fedConfig) {
        if (fedConfig.getProtocol() instanceof FederationProtocol && "wsignin1.0".equals(request.getParameter("wa"))) {
            return true;
        }
        return fedConfig.getProtocol() instanceof SAMLProtocol && request.getParameter("SAMLResponse") != null;
    }

    private String getResponseToken(ServletRequest request, FedizContext fedConfig) {
        if (fedConfig.getProtocol() instanceof FederationProtocol) {
            return request.getParameter("wresult");
        }
        if (fedConfig.getProtocol() instanceof SAMLProtocol) {
            return request.getParameter("SAMLResponse");
        }
        return null;
    }

    private String getState(ServletRequest request) {
        if (request.getParameter("wctx") != null) {
            return request.getParameter("wctx");
        }
        if (request.getParameter("RelayState") != null) {
            return request.getParameter("RelayState");
        }
        return null;
    }

    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signInRedirectToIssuer(HttpServletRequest request, HttpServletResponse response, FedizProcessor processor, HttpSession session) throws IOException {
        block9: {
            String contextName = request.getSession().getServletContext().getContextPath();
            if (contextName == null || contextName.isEmpty()) {
                contextName = "/";
            }
            FedizContext fedCtx = this.configurator.getFedizContext(contextName);
            try {
                RedirectionResponse redirectionResponse = processor.createSignInRequest(request, fedCtx);
                String redirectURL = redirectionResponse.getRedirectionURL();
                if (redirectURL != null) {
                    Map headers = redirectionResponse.getHeaders();
                    if (!headers.isEmpty()) {
                        for (Map.Entry entry : headers.entrySet()) {
                            response.addHeader((String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        session.setAttribute(J_CONTEXT, (Object)redirectionResponse.getRequestState());
                    }
                    response.sendRedirect(redirectURL);
                    break block9;
                }
                LOG.warn("Failed to create SignInRequest.", new Object[0]);
                response.sendError(500, "Failed to create SignInRequest.");
            }
            catch (ProcessingException ex) {
                LOG.warn("Failed to create SignInRequest: " + ex.getMessage(), new Object[0]);
                response.sendError(500, "Failed to create SignInRequest.");
            }
        }
    }

    protected void signOutRedirectToIssuer(HttpServletRequest request, HttpServletResponse response, FedizProcessor processor) throws IOException {
        String contextName = request.getSession().getServletContext().getContextPath();
        if (contextName == null || contextName.isEmpty()) {
            contextName = "/";
        }
        FedizContext fedCtx = this.configurator.getFedizContext(contextName);
        try {
            RedirectionResponse redirectionResponse = processor.createSignOutRequest(request, null, fedCtx);
            String redirectURL = redirectionResponse.getRedirectionURL();
            if (redirectURL != null) {
                Map headers = redirectionResponse.getHeaders();
                if (!headers.isEmpty()) {
                    for (Map.Entry entry : headers.entrySet()) {
                        response.addHeader((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                response.sendRedirect(redirectURL);
            } else {
                LOG.warn("Failed to create SignOutRequest.", new Object[0]);
                response.sendError(500, "Failed to create SignOutRequest.");
            }
        }
        catch (ProcessingException ex) {
            LOG.warn("Failed to create SignOutRequest: " + ex.getMessage(), new Object[0]);
            response.sendError(500, "Failed to create SignOutRequest.");
        }
    }

    private FedizContext getContextConfiguration(String contextName) {
        if (this.configurator == null) {
            throw new IllegalStateException("No Fediz configuration available");
        }
        FedizContext config = this.configurator.getFedizContext(contextName);
        if (config == null) {
            throw new IllegalStateException("No Fediz configuration for context :" + contextName);
        }
        String jettyHome = System.getProperty("jetty.home");
        if (jettyHome != null && jettyHome.length() > 0) {
            config.setRelativePath(jettyHome);
        }
        return config;
    }

    public static class FederationAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public FederationAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        public String toString() {
            return "WSFED" + super.toString();
        }
    }
}

