/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.core.processor;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import org.apache.cxf.fediz.core.Claim;
import org.apache.cxf.fediz.core.RequestState;
import org.apache.cxf.fediz.core.TokenValidator;
import org.apache.cxf.fediz.core.TokenValidatorRequest;
import org.apache.cxf.fediz.core.TokenValidatorResponse;
import org.apache.cxf.fediz.core.config.FederationProtocol;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.KeyManager;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.metadata.MetadataWriter;
import org.apache.cxf.fediz.core.processor.AbstractFedizProcessor;
import org.apache.cxf.fediz.core.processor.ClaimsProcessor;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.core.processor.RedirectionResponse;
import org.apache.cxf.fediz.core.spi.FreshnessCallback;
import org.apache.cxf.fediz.core.spi.HomeRealmCallback;
import org.apache.cxf.fediz.core.spi.ReplyConstraintCallback;
import org.apache.cxf.fediz.core.spi.SignOutQueryCallback;
import org.apache.cxf.fediz.core.spi.WAuthCallback;
import org.apache.cxf.fediz.core.spi.WReqCallback;
import org.apache.cxf.fediz.core.util.DOMUtils;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.processor.EncryptedDataProcessor;
import org.apache.wss4j.dom.processor.Processor;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FederationProcessorImpl
extends AbstractFedizProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationProcessorImpl.class);

    @Override
    public FedizResponse processRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        if (!(config.getProtocol() instanceof FederationProtocol)) {
            LOG.error("Unsupported protocol");
            throw new IllegalStateException("Unsupported protocol");
        }
        if ("wsignin1.0".equals(request.getAction())) {
            return this.processSignInRequest(request, config);
        }
        LOG.error("Invalid action '" + request.getAction() + "'");
        throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
    }

    @Override
    public Document getMetaData(HttpServletRequest request, FedizContext config) throws ProcessingException {
        return new MetadataWriter().getMetaData(request, config);
    }

    protected FedizResponse processSignInRequest(FedizRequest request, FedizContext config) throws ProcessingException {
        Element decryptedRST;
        Element el = null;
        try {
            Document doc = DOMUtils.readXml(new StringReader(request.getResponseToken()));
            el = doc.getDocumentElement();
        }
        catch (Exception e) {
            LOG.warn("Failed to parse wresult: " + e.getMessage(), (Throwable)e);
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement(el);
        }
        if (el == null || !"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            LOG.warn("Unexpected root element of wresult: '" + (el == null ? "null" : el.getLocalName()) + "'");
            throw new ProcessingException(ProcessingException.TYPE.INVALID_REQUEST);
        }
        Node rst = null;
        Element lifetimeElem = null;
        String tt = null;
        el = DOMUtils.getFirstElement(el);
        while (el != null) {
            String ln = el.getLocalName();
            if ("http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(el.getNamespaceURI()) || "http://schemas.xmlsoap.org/ws/2005/02/trust".equals(el.getNamespaceURI())) {
                if ("Lifetime".equals(ln)) {
                    lifetimeElem = el;
                } else if ("RequestedSecurityToken".equals(ln)) {
                    rst = DOMUtils.getFirstElement(el);
                } else if ("TokenType".equals(ln)) {
                    tt = DOMUtils.getContent(el);
                }
            }
            el = DOMUtils.getNextElement(el);
        }
        if (LOG.isDebugEnabled()) {
            if (rst != null) {
                LOG.debug("RST: {}", (Object)DOM2Writer.nodeToString(rst));
            }
            if (lifetimeElem != null) {
                LOG.debug("Lifetime: {}", (Object)DOM2Writer.nodeToString(lifetimeElem));
            }
        }
        LOG.debug("Tokentype: {}", tt);
        if (rst == null) {
            LOG.warn("RequestedSecurityToken element not found in wresult");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        LifeTime lifeTime = null;
        if (lifetimeElem != null) {
            lifeTime = this.processLifeTime(lifetimeElem);
            Instant rightNow = Instant.now();
            if (rightNow.isAfter(lifeTime.getExpires())) {
                LOG.warn("RSTR Lifetime expired");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_EXPIRED);
            }
            DateTime currentTime = new DateTime();
            DateTime validFrom = new DateTime((Object)Date.from(lifeTime.created));
            if (validFrom.isAfter((ReadableInstant)(currentTime = currentTime.plusSeconds(config.getMaximumClockSkew().intValue())))) {
                LOG.debug("RSTR Lifetime not yet valid");
                throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
            }
        }
        if ("EncryptedData".equals(rst.getLocalName()) && "http://www.w3.org/2001/04/xmlenc#".equals(rst.getNamespaceURI()) && (decryptedRST = this.decryptEncryptedRST((Element)rst, config)) != null) {
            rst = decryptedRST;
        }
        TokenValidatorResponse validatorResponse = this.validateToken((Element)rst, tt, config, request.getCerts());
        Instant expires = lifeTime != null && lifeTime.getExpires() != null ? lifeTime.getExpires() : validatorResponse.getExpires();
        this.testForReplayAttack(validatorResponse.getUniqueTokenId(), config, expires);
        Instant created = validatorResponse.getCreated();
        if (lifeTime != null && lifeTime.getCreated() != null) {
            created = lifeTime.getCreated();
        }
        List<Claim> claims = validatorResponse.getClaims();
        this.testForMandatoryClaims(config.getProtocol().getRoleURI(), config.getProtocol().getClaimTypesRequested(), claims);
        List<ClaimsProcessor> processors = config.getClaimsProcessor();
        if (processors != null) {
            for (ClaimsProcessor cp : processors) {
                LOG.debug("invoking ClaimsProcessor {}", (Object)cp);
                claims = cp.processClaims(claims);
            }
        }
        List<String> roles = this.getRoles(claims, config.getProtocol().getRoleURI());
        FedizResponse fedResponse = new FedizResponse(validatorResponse.getUsername(), validatorResponse.getIssuer(), roles, claims, validatorResponse.getAudience(), created, expires, (Element)rst, validatorResponse.getUniqueTokenId());
        return fedResponse;
    }

    private TokenValidatorResponse validateToken(Element token, String tokenType, FedizContext config, Certificate[] certs) throws ProcessingException {
        List<TokenValidator> validators = ((FederationProtocol)config.getProtocol()).getTokenValidators();
        Iterator<TokenValidator> iterator = validators.iterator();
        if (iterator.hasNext()) {
            TokenValidator validator = iterator.next();
            boolean canHandle = tokenType != null ? validator.canHandleTokenType(tokenType) : validator.canHandleToken(token);
            if (canHandle) {
                try {
                    TokenValidatorRequest validatorRequest = new TokenValidatorRequest(token, certs);
                    return validator.validateAndProcessToken(validatorRequest, config);
                }
                catch (ProcessingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    LOG.warn("Failed to validate token", (Throwable)ex);
                    throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
                }
            }
            LOG.warn("No security token validator found for '" + tokenType + "'");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        return null;
    }

    private Element decryptEncryptedRST(Element encryptedRST, FedizContext config) throws ProcessingException {
        KeyManager decryptionKeyManager = config.getDecryptionKey();
        if (decryptionKeyManager == null || decryptionKeyManager.getCrypto() == null) {
            LOG.debug("We must have a decryption Crypto instance configured to decrypt encrypted tokens");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        String keyPassword = decryptionKeyManager.getKeyPassword();
        if (keyPassword == null) {
            LOG.debug("We must have a decryption key password to decrypt encrypted tokens");
            throw new ProcessingException(ProcessingException.TYPE.BAD_REQUEST);
        }
        EncryptedDataProcessor proc = new EncryptedDataProcessor();
        WSDocInfo docInfo = new WSDocInfo(encryptedRST.getOwnerDocument());
        RequestData data = new RequestData();
        data.setWsDocInfo(docInfo);
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setProcessor(WSConstants.SAML_TOKEN, (Processor)new NOOpProcessor());
        wssConfig.setProcessor(WSConstants.SAML2_TOKEN, (Processor)new NOOpProcessor());
        data.setWssConfig(wssConfig);
        data.setDecCrypto(decryptionKeyManager.getCrypto());
        data.setCallbackHandler((CallbackHandler)new DecryptionCallbackHandler(keyPassword));
        try {
            List dataRefs;
            List result = proc.handleToken(encryptedRST, data);
            if (!result.isEmpty() && (dataRefs = (List)((WSSecurityEngineResult)result.get(result.size() - 1)).get((Object)"data-ref-uris")) != null && !dataRefs.isEmpty()) {
                return ((WSDataRef)dataRefs.get(0)).getProtectedElement();
            }
        }
        catch (WSSecurityException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new ProcessingException(ProcessingException.TYPE.TOKEN_INVALID);
        }
        return null;
    }

    private LifeTime processLifeTime(Element lifetimeElem) throws ProcessingException {
        Element createdElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
        ZonedDateTime createdDateTime = ZonedDateTime.parse(DOMUtils.getContent(createdElem));
        Element expiresElem = DOMUtils.getFirstChildWithName(lifetimeElem, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Expires");
        ZonedDateTime expiresDateTime = ZonedDateTime.parse(DOMUtils.getContent(expiresElem));
        return new LifeTime(createdDateTime.toInstant(), expiresDateTime.toInstant());
    }

    @Override
    public RedirectionResponse createSignInRequest(HttpServletRequest request, FedizContext config) throws ProcessingException {
        RequestState requestState;
        String redirectURL = null;
        try {
            if (!(config.getProtocol() instanceof FederationProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String issuerURL = this.resolveIssuer(request, config);
            LOG.debug("Issuer url: {}", (Object)issuerURL);
            if (issuerURL != null && !issuerURL.isEmpty()) {
                redirectURL = issuerURL;
            }
            String wAuth = this.resolveAuthenticationType(request, config);
            LOG.debug("WAuth: {}", (Object)wAuth);
            String wReq = this.resolveRequest(request, config);
            LOG.debug("WReq: {}", (Object)wReq);
            String homeRealm = this.resolveHomeRealm(request, config);
            LOG.debug("HomeRealm: {}", (Object)homeRealm);
            String freshness = this.resolveFreshness(request, config);
            LOG.debug("Freshness: {}", (Object)freshness);
            String signInQuery = this.resolveSignInQuery(request, config);
            LOG.debug("SignIn Query: {}", (Object)signInQuery);
            String wctx = URLEncoder.encode(UUID.randomUUID().toString(), StandardCharsets.UTF_8.name());
            StringBuffer requestURL = request.getRequestURL();
            String params = request.getQueryString();
            if (params != null && !params.isEmpty()) {
                requestURL.append('?').append(params);
            }
            requestState = new RequestState();
            requestState.setTargetAddress(requestURL.toString());
            requestState.setIdpServiceAddress(redirectURL);
            requestState.setState(wctx);
            requestState.setCreatedAt(System.currentTimeMillis());
            StringBuilder sb = new StringBuilder();
            sb.append("wa").append('=').append("wsignin1.0");
            String reply = this.resolveReply(request, config);
            if (reply == null || reply.isEmpty()) {
                reply = request.getRequestURL().toString();
            } else {
                try {
                    new URL(reply);
                }
                catch (MalformedURLException ex) {
                    reply = reply.startsWith("/") ? this.extractFullContextPath(request).concat(reply.substring(1)) : this.extractFullContextPath(request).concat(reply);
                }
            }
            LOG.debug("wreply={}", (Object)reply);
            sb.append('&').append("wreply").append('=').append(URLEncoder.encode(reply, StandardCharsets.UTF_8.name()));
            String realm = this.resolveWTRealm(request, config);
            LOG.debug("wtrealm={}", (Object)realm);
            sb.append('&').append("wtrealm").append('=').append(URLEncoder.encode(realm, StandardCharsets.UTF_8.name()));
            if (wAuth != null && !wAuth.isEmpty()) {
                sb.append('&').append("wauth").append('=').append(URLEncoder.encode(wAuth, StandardCharsets.UTF_8.name()));
            }
            if (wReq != null && !wReq.isEmpty()) {
                sb.append('&').append("wreq").append('=').append(URLEncoder.encode(wReq, StandardCharsets.UTF_8.name()));
            }
            if (homeRealm != null && !homeRealm.isEmpty()) {
                sb.append('&').append("whr").append('=').append(URLEncoder.encode(homeRealm, StandardCharsets.UTF_8.name()));
            }
            if (freshness != null && !freshness.isEmpty()) {
                sb.append('&').append("wfresh").append('=').append(URLEncoder.encode(freshness, StandardCharsets.UTF_8.name()));
            }
            Instant now = Instant.now();
            DateTimeFormatter formatter = DateUtil.getDateTimeFormatter((boolean)true);
            String wct = now.atZone(ZoneOffset.UTC).format(formatter);
            sb.append('&').append("wct").append('=').append(URLEncoder.encode(wct, StandardCharsets.UTF_8.name()));
            LOG.debug("wctx={}", (Object)wctx);
            sb.append('&').append("wctx").append('=').append(URLEncoder.encode(wctx, StandardCharsets.UTF_8.name()));
            if (signInQuery != null && signInQuery.length() > 0) {
                sb.append('&').append(signInQuery);
            }
            redirectURL = redirectURL + '?' + sb.toString();
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignInRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignInRequest", ex);
        }
        RedirectionResponse response = new RedirectionResponse();
        response.setRedirectionURL(redirectURL);
        response.setRequestState(requestState);
        return response;
    }

    @Override
    public RedirectionResponse createSignOutRequest(HttpServletRequest request, SamlAssertionWrapper token, FedizContext config) throws ProcessingException {
        String redirectURL = null;
        try {
            if (!(config.getProtocol() instanceof FederationProtocol)) {
                LOG.error("Unsupported protocol");
                throw new IllegalStateException("Unsupported protocol");
            }
            String issuerURL = this.resolveIssuer(request, config);
            LOG.debug("Issuer url: {}", (Object)issuerURL);
            if (issuerURL != null && !issuerURL.isEmpty()) {
                redirectURL = issuerURL;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("wa").append('=').append("wsignout1.0");
            String logoutRedirectTo = null;
            if (request.getParameter("wreply") != null) {
                Pattern logoutRedirectToConstraint = this.resolveLogoutRedirectToConstraint(request, config);
                if (logoutRedirectToConstraint == null) {
                    LOG.debug("No regular expression constraint configured for logout. Ignoring wreply parameter");
                } else {
                    Matcher matcher = logoutRedirectToConstraint.matcher(request.getParameter("wreply"));
                    if (matcher.matches()) {
                        logoutRedirectTo = request.getParameter("wreply");
                    } else {
                        LOG.warn("The received wreply address {} does not match the configured constraint {}", (Object)logoutRedirectTo, (Object)logoutRedirectToConstraint);
                    }
                }
            }
            if (logoutRedirectTo == null || logoutRedirectTo.isEmpty()) {
                logoutRedirectTo = config.getLogoutRedirectTo();
            }
            if (logoutRedirectTo != null && !logoutRedirectTo.isEmpty()) {
                if (logoutRedirectTo.startsWith("/")) {
                    logoutRedirectTo = this.extractFullContextPath(request).concat(logoutRedirectTo.substring(1));
                } else if (!logoutRedirectTo.startsWith("http") && !logoutRedirectTo.startsWith("https")) {
                    logoutRedirectTo = this.extractFullContextPath(request).concat(logoutRedirectTo);
                }
                LOG.debug("wreply={}", (Object)logoutRedirectTo);
                sb.append('&').append("wreply").append('=').append(URLEncoder.encode(logoutRedirectTo, StandardCharsets.UTF_8.name()));
            }
            String realm = this.resolveWTRealm(request, config);
            LOG.debug("wtrealm={}", (Object)realm);
            sb.append('&').append("wtrealm").append('=').append(URLEncoder.encode(realm, StandardCharsets.UTF_8.name()));
            String signOutQuery = this.resolveSignOutQuery(request, config);
            LOG.debug("SignIn Query: {}", (Object)signOutQuery);
            if (signOutQuery != null && signOutQuery.length() > 0) {
                sb.append('&').append(signOutQuery);
            }
            redirectURL = redirectURL + '?' + sb.toString();
        }
        catch (Exception ex) {
            LOG.error("Failed to create SignInRequest", (Throwable)ex);
            throw new ProcessingException("Failed to create SignInRequest");
        }
        RedirectionResponse response = new RedirectionResponse();
        response.setRedirectionURL(redirectURL);
        return response;
    }

    private Pattern resolveLogoutRedirectToConstraint(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object logoutConstraintObj = config.getLogoutRedirectToConstraint();
        if (logoutConstraintObj instanceof Pattern) {
            return (Pattern)logoutConstraintObj;
        }
        if (logoutConstraintObj instanceof CallbackHandler) {
            CallbackHandler frCB = (CallbackHandler)logoutConstraintObj;
            ReplyConstraintCallback callback = new ReplyConstraintCallback(request);
            frCB.handle(new Callback[]{callback});
            return callback.getReplyConstraint();
        }
        return null;
    }

    private String resolveSignOutQuery(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object signOutQueryObj = ((FederationProtocol)config.getProtocol()).getSignOutQuery();
        String signOutQuery = null;
        if (signOutQueryObj != null) {
            if (signOutQueryObj instanceof String) {
                signOutQuery = (String)signOutQueryObj;
            } else if (signOutQueryObj instanceof CallbackHandler) {
                CallbackHandler frCB = (CallbackHandler)signOutQueryObj;
                SignOutQueryCallback callback = new SignOutQueryCallback(request);
                frCB.handle(new Callback[]{callback});
                Map<String, String> signOutQueryMap = callback.getSignOutQueryParamMap();
                if (signOutQueryMap != null) {
                    StringBuilder sbQuery = new StringBuilder();
                    for (Map.Entry<String, String> entry : signOutQueryMap.entrySet()) {
                        if (sbQuery.length() > 0) {
                            sbQuery.append('&');
                        }
                        sbQuery.append(entry.getKey()).append('=').append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.name()));
                    }
                    signOutQuery = sbQuery.toString();
                }
            }
        }
        return signOutQuery;
    }

    private String resolveFreshness(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object freshnessObj = ((FederationProtocol)config.getProtocol()).getFreshness();
        String freshness = null;
        if (freshnessObj != null) {
            if (freshnessObj instanceof String) {
                freshness = (String)freshnessObj;
            } else if (freshnessObj instanceof CallbackHandler) {
                CallbackHandler frCB = (CallbackHandler)freshnessObj;
                FreshnessCallback callback = new FreshnessCallback(request);
                frCB.handle(new Callback[]{callback});
                freshness = callback.getFreshness();
            }
        }
        return freshness;
    }

    private String resolveHomeRealm(HttpServletRequest request, FedizContext config) {
        String homeRealm = request.getParameter("whr");
        if (homeRealm != null && !homeRealm.isEmpty()) {
            LOG.debug("HomeRealm was defined as 'whr' request parameter and will be used for IDP redirect");
        } else {
            Object homeRealmObj = ((FederationProtocol)config.getProtocol()).getHomeRealm();
            if (homeRealmObj != null) {
                if (homeRealmObj instanceof String) {
                    homeRealm = (String)homeRealmObj;
                } else if (homeRealmObj instanceof CallbackHandler) {
                    homeRealm = this.resolveHomeRealm(homeRealmObj, request);
                } else if (homeRealmObj instanceof List) {
                    for (Object cbh : (List)homeRealmObj) {
                        homeRealm = this.resolveHomeRealm(cbh, request);
                        if (homeRealm == null) continue;
                        LOG.debug("Home realm was found by {}", cbh.getClass());
                        break;
                    }
                }
            }
        }
        LOG.debug("Users home realm will be set to {}", (Object)homeRealm);
        return homeRealm;
    }

    private String resolveHomeRealm(Object cbh, HttpServletRequest request) {
        if (cbh instanceof CallbackHandler) {
            CallbackHandler hrCBH = (CallbackHandler)cbh;
            HomeRealmCallback callback = new HomeRealmCallback(request);
            try {
                hrCBH.handle(new Callback[]{callback});
            }
            catch (IOException | UnsupportedCallbackException e) {
                LOG.warn("Home Realm Callbackhandler caused an exception", (Throwable)e);
            }
            return callback.getHomeRealm();
        }
        LOG.warn("Callback Handler was not an instanceof CallbackHandler: {}", cbh);
        return null;
    }

    private String resolveAuthenticationType(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object wAuthObj = ((FederationProtocol)config.getProtocol()).getAuthenticationType();
        String wAuth = null;
        if (wAuthObj != null) {
            if (wAuthObj instanceof String) {
                wAuth = (String)wAuthObj;
            } else if (wAuthObj instanceof CallbackHandler) {
                CallbackHandler wauthCB = (CallbackHandler)wAuthObj;
                WAuthCallback callback = new WAuthCallback(request);
                wauthCB.handle(new Callback[]{callback});
                wAuth = callback.getWauth();
            }
        }
        return wAuth;
    }

    private String resolveRequest(HttpServletRequest request, FedizContext config) throws IOException, UnsupportedCallbackException {
        Object wReqObj = ((FederationProtocol)config.getProtocol()).getRequest();
        String wReq = null;
        if (wReqObj != null) {
            if (wReqObj instanceof String) {
                wReq = (String)wReqObj;
            } else if (wReqObj instanceof CallbackHandler) {
                CallbackHandler wauthCB = (CallbackHandler)wReqObj;
                WReqCallback callback = new WReqCallback(request);
                wauthCB.handle(new Callback[]{callback});
                wReq = callback.getWreq();
            }
        }
        return wReq;
    }

    static {
        WSSConfig.init();
    }

    private static class NOOpProcessor
    implements Processor {
        private NOOpProcessor() {
        }

        public List<WSSecurityEngineResult> handleToken(Element arg0, RequestData arg1) throws WSSecurityException {
            return Collections.emptyList();
        }
    }

    private static class DecryptionCallbackHandler
    implements CallbackHandler {
        private final String password;

        DecryptionCallbackHandler(String password) {
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                if (!(callbacks[i] instanceof WSPasswordCallback)) {
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                pc.setPassword(this.password);
            }
        }
    }

    public static class LifeTime {
        private final Instant created;
        private final Instant expires;

        public LifeTime(Instant created, Instant expires) {
            this.created = created;
            this.expires = expires;
        }

        public Instant getCreated() {
            return this.created;
        }

        public Instant getExpires() {
            return this.expires;
        }
    }
}

