/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.fediz.spring;

import org.apache.cxf.fediz.core.ClaimCollection;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.User;

public class FederationUser extends User {

    private static final long serialVersionUID = -2231762973730849416L;

    private ClaimCollection claims;

    public FederationUser(String username, String password, boolean enabled, boolean accountNonExpired,
                          boolean credentialsNonExpired, boolean accountNonLocked,
                          //Collection<? extends GrantedAuthority> authorities) {
                          GrantedAuthority[] authorities) {
        super(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
    }

    public FederationUser(String username, String password,
//                          Collection<? extends GrantedAuthority> authorities, ClaimCollection claims) {
                          GrantedAuthority[] authorities, ClaimCollection claims) {
        super(username, password, true, true, true, true, authorities);
        this.claims = claims;
    }

    public ClaimCollection getClaims() {
        return this.claims;
    }




}
