/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.security.AccessController;

final class SecurityActions {
    SecurityActions() {
    }

    public static String getProperty(String name, String defaultValue) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name, defaultValue);
        }
        return SysProps.PRIVILEGED.getProperty(name, defaultValue);
    }

    public static String getProperty(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getProperty(name);
        }
        return SysProps.PRIVILEGED.getProperty(name);
    }

    public static String getEnv(String name) {
        if (System.getSecurityManager() == null) {
            return SysProps.NON_PRIVILEGED.getEnv(name);
        }
        return SysProps.PRIVILEGED.getEnv(name);
    }

    static interface SysProps {
        public static final SysProps NON_PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return System.getProperty(name, defaultValue);
            }

            @Override
            public String getProperty(String name) {
                return System.getProperty(name);
            }

            @Override
            public String getEnv(String name) {
                return System.getenv(name);
            }
        };
        public static final SysProps PRIVILEGED = new SysProps(){

            @Override
            public String getProperty(String name, String defaultValue) {
                return AccessController.doPrivileged(() -> System.getProperty(name, defaultValue));
            }

            @Override
            public String getProperty(String name) {
                return AccessController.doPrivileged(() -> System.getProperty(name));
            }

            @Override
            public String getEnv(String name) {
                return AccessController.doPrivileged(() -> System.getenv(name));
            }
        };

        public String getProperty(String var1, String var2);

        public String getProperty(String var1);

        public String getEnv(String var1);
    }
}

