/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.replication;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.IOCompletion;
import org.apache.activemq.artemis.core.journal.Journal;
import org.apache.activemq.artemis.core.journal.JournalLoadInformation;
import org.apache.activemq.artemis.core.journal.JournalUpdateCallback;
import org.apache.activemq.artemis.core.journal.LoaderCallback;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TransactionFailureCallback;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.dataformat.ByteArrayEncoding;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.core.replication.ReplicationManager;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedJournal
implements Journal {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ReplicationManager replicationManager;
    private final Journal localJournal;
    private final byte journalID;

    public void setRemoveExtraFilesOnLoad(boolean removeExtraFilesOnLoad) {
        this.localJournal.setRemoveExtraFilesOnLoad(removeExtraFilesOnLoad);
    }

    public boolean isRemoveExtraFilesOnLoad() {
        return this.localJournal.isRemoveExtraFilesOnLoad();
    }

    public ReplicatedJournal(byte journalID, Journal localJournal, ReplicationManager replicationManager) {
        this.journalID = journalID;
        this.localJournal = localJournal;
        this.replicationManager = replicationManager;
    }

    public void flush() throws Exception {
    }

    public void appendAddRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendAddRecord(id, recordType, (EncodingSupport)new ByteArrayEncoding(record), sync);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Append record id = {} recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync);
    }

    public void appendAddRecord(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Append record id = {} recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, id, recordType, persister, record);
        this.localJournal.appendAddRecord(id, recordType, persister, record, sync, completionCallback);
    }

    public void appendAddEvent(long id, byte recordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Append record id = {} recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.EVENT, id, recordType, persister, record);
        this.localJournal.appendAddEvent(id, recordType, persister, record, sync, completionCallback);
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendAddRecordTransactional(txID, id, recordType, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendAddRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("Append record txID={} recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.ADD, txID, id, recordType, persister, record);
        this.localJournal.appendAddRecordTransactional(txID, id, recordType, persister, record);
    }

    public void appendCommitRecord(long txID, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendCommit txID={}", (Object)txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendCommit {}", (Object)txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, true);
        this.localJournal.appendCommitRecord(txID, sync, callback);
    }

    public void appendCommitRecord(long txID, boolean sync, IOCompletion callback, boolean lineUpContext) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendCommit {}", (Object)txID);
        }
        this.replicationManager.appendCommitRecord(this.journalID, txID, sync, lineUpContext);
        this.localJournal.appendCommitRecord(txID, sync, callback, lineUpContext);
    }

    public void appendDeleteRecord(long id, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete {}", (Object)id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync);
    }

    public void tryAppendDeleteRecord(long id, JournalUpdateCallback updateCallback, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete {}", (Object)id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.tryAppendDeleteRecord(id, updateCallback, sync);
    }

    public void appendDeleteRecord(long id, boolean sync, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete {}", (Object)id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.appendDeleteRecord(id, sync, completionCallback);
    }

    public void tryAppendDeleteRecord(long id, boolean sync, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete {}", (Object)id);
        }
        this.replicationManager.appendDeleteRecord(this.journalID, id);
        this.localJournal.tryAppendDeleteRecord(id, sync, updateCallback, completionCallback);
    }

    public void appendDeleteRecordTransactional(long txID, long id, byte[] record) throws Exception {
        this.appendDeleteRecordTransactional(txID, id, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendDeleteRecordTransactional(long txID, long id, EncodingSupport record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete txID={} id={}", (Object)txID, (Object)id);
        }
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id, record);
        this.localJournal.appendDeleteRecordTransactional(txID, id, record);
    }

    public void appendDeleteRecordTransactional(long txID, long id) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendDelete (noencoding) txID={} id={}", (Object)txID, (Object)id);
        }
        this.replicationManager.appendDeleteRecordTransactional(this.journalID, txID, id);
        this.localJournal.appendDeleteRecordTransactional(txID, id);
    }

    public void appendPrepareRecord(long txID, byte[] transactionData, boolean sync) throws Exception {
        this.appendPrepareRecord(txID, (EncodingSupport)new ByteArrayEncoding(transactionData), sync);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendPrepare txID={}", (Object)txID);
        }
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync);
    }

    public void appendPrepareRecord(long txID, EncodingSupport transactionData, boolean sync, IOCompletion callback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendPrepare txID={}", (Object)txID);
        }
        this.replicationManager.appendPrepareRecord(this.journalID, txID, transactionData);
        this.localJournal.appendPrepareRecord(txID, transactionData, sync, callback);
    }

    public void appendRollbackRecord(long txID, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendRollback {}", (Object)txID);
        }
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync);
    }

    public void appendRollbackRecord(long txID, boolean sync, IOCompletion callback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendRollback {}", (Object)txID);
        }
        this.replicationManager.appendRollbackRecord(this.journalID, txID);
        this.localJournal.appendRollbackRecord(txID, sync, callback);
    }

    public void appendUpdateRecord(long id, byte recordType, byte[] record, boolean sync) throws Exception {
        this.appendUpdateRecord(id, recordType, (EncodingSupport)new ByteArrayEncoding(record), sync);
    }

    public void tryAppendUpdateRecord(long id, byte recordType, byte[] record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceableRecord) throws Exception {
        this.tryAppendUpdateRecord(id, recordType, (EncodingSupport)new ByteArrayEncoding(record), updateCallback, sync, replaceableRecord);
    }

    public void appendUpdateRecord(long id, byte recordType, Persister persister, Object record, boolean sync) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendUpdateRecord id = {} , recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, persister, record);
        this.localJournal.appendUpdateRecord(id, recordType, persister, record, sync);
    }

    public void tryAppendUpdateRecord(long id, byte recordType, Persister persister, Object record, JournalUpdateCallback updateCallback, boolean sync, boolean replaceable) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendUpdateRecord id = {} , recordType = {}", (Object)id, (Object)recordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, recordType, persister, record);
        this.localJournal.tryAppendUpdateRecord(id, recordType, persister, record, updateCallback, sync, replaceable);
    }

    public void appendUpdateRecord(long id, byte journalRecordType, Persister persister, Object record, boolean sync, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendUpdateRecord id = {} , recordType = {}", (Object)id, (Object)journalRecordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, persister, record);
        this.localJournal.appendUpdateRecord(id, journalRecordType, persister, record, sync, completionCallback);
    }

    public void tryAppendUpdateRecord(long id, byte journalRecordType, Persister persister, Object record, boolean sync, boolean replaceableUpdate, JournalUpdateCallback updateCallback, IOCompletion completionCallback) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendUpdateRecord id = {} , recordType = {}", (Object)id, (Object)journalRecordType);
        }
        this.replicationManager.appendUpdateRecord(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, id, journalRecordType, persister, record);
        this.localJournal.tryAppendUpdateRecord(id, journalRecordType, persister, record, sync, replaceableUpdate, updateCallback, completionCallback);
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, byte[] record) throws Exception {
        this.appendUpdateRecordTransactional(txID, id, recordType, (EncodingSupport)new ByteArrayEncoding(record));
    }

    public void appendUpdateRecordTransactional(long txID, long id, byte recordType, Persister persister, Object record) throws Exception {
        if (logger.isTraceEnabled()) {
            logger.trace("AppendUpdateRecord txid={} id = {} , recordType = {}", new Object[]{txID, id, recordType});
        }
        this.replicationManager.appendAddRecordTransactional(this.journalID, ReplicationManager.ADD_OPERATION_TYPE.UPDATE, txID, id, recordType, persister, record);
        this.localJournal.appendUpdateRecordTransactional(txID, id, recordType, persister, record);
    }

    public JournalLoadInformation load(List<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadTX) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure, fixbadTX);
    }

    public JournalLoadInformation load(SparseArrayLinkedList<RecordInfo> committedRecords, List<PreparedTransactionInfo> preparedTransactions, TransactionFailureCallback transactionFailure, boolean fixbadTX) throws Exception {
        return this.localJournal.load(committedRecords, preparedTransactions, transactionFailure, fixbadTX);
    }

    public JournalLoadInformation load(LoaderCallback reloadManager) throws Exception {
        return this.localJournal.load(reloadManager);
    }

    public void start() throws Exception {
        this.localJournal.start();
    }

    public void stop() throws Exception {
        this.localJournal.stop();
    }

    public int getAlignment() throws Exception {
        return this.localJournal.getAlignment();
    }

    public boolean isStarted() {
        return this.localJournal.isStarted();
    }

    public JournalLoadInformation loadInternalOnly() throws Exception {
        return this.localJournal.loadInternalOnly();
    }

    public int getNumberOfRecords() {
        return this.localJournal.getNumberOfRecords();
    }

    public int getUserVersion() {
        return this.localJournal.getUserVersion();
    }

    public void lineUpContext(IOCompletion callback) {
        ((OperationContext)callback).replicationLineUp();
        this.localJournal.lineUpContext(callback);
    }

    public JournalLoadInformation loadSyncOnly(Journal.JournalState state) throws Exception {
        return this.localJournal.loadSyncOnly(state);
    }

    public Map<Long, JournalFile> createFilesForBackupSync(long[] fileIds) throws Exception {
        throw new UnsupportedOperationException("This method should only be called at a replicating backup");
    }

    public void synchronizationLock() {
        throw new UnsupportedOperationException();
    }

    public void synchronizationUnlock() {
        throw new UnsupportedOperationException();
    }

    public void forceMoveNextFile() throws Exception {
        this.localJournal.forceMoveNextFile();
    }

    public JournalFile[] getDataFiles() {
        throw new UnsupportedOperationException();
    }

    public SequentialFileFactory getFileFactory() {
        throw new UnsupportedOperationException();
    }

    public int getFileSize() {
        return this.localJournal.getFileSize();
    }

    public void scheduleCompactAndBlock(int timeout) throws Exception {
        this.localJournal.scheduleCompactAndBlock(timeout);
    }

    public void replicationSyncPreserveOldFiles() {
        throw new UnsupportedOperationException("should never get called");
    }

    public void replicationSyncFinished() {
        throw new UnsupportedOperationException("should never get called");
    }

    public long getMaxRecordSize() {
        return this.localJournal.getMaxRecordSize();
    }

    public long getWarningRecordSize() {
        return this.localJournal.getWarningRecordSize();
    }
}

