/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.rs.security.jose.jaxrs.JsonWebKeysProvider;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.oauth2.filters.JwtAccessTokenValidator;

public class JwsJwksJwtAccessTokenValidator
extends JwtAccessTokenValidator {
    final Map<String, JwkHolder> jsonWebKeys = new ConcurrentHashMap<String, JwkHolder>();
    private String jwksURL;

    protected JwsSignatureVerifier getInitializedSignatureVerifier(JwsHeaders jwsHeaders) {
        Objects.requireNonNull(jwsHeaders.getKeyId());
        JwkHolder jwkHolder = this.jsonWebKeys.computeIfAbsent(jwsHeaders.getKeyId(), keyId -> this.updateJwk((String)keyId));
        return jwkHolder != null ? jwkHolder.getJwsSignatureVerifier() : null;
    }

    public void setJwksURL(String jwksURL) {
        this.jwksURL = jwksURL;
    }

    public void setJwsVerifier(JwsSignatureVerifier theJwsVerifier) {
        throw new IllegalArgumentException("Actual JwsSignatureVerifier will be populated from the JWK Set URL");
    }

    private JwkHolder updateJwk(String keyId) {
        Objects.requireNonNull(this.jwksURL, "JWK Set URL must be specified");
        JwkHolder jwkHolder = null;
        HashSet<String> kids = new HashSet<String>();
        for (JsonWebKey jwk : this.getJsonWebKeys().getKeys()) {
            if (PublicKeyUse.ENCRYPT == jwk.getPublicKeyUse()) continue;
            String kid = jwk.getKeyId();
            kids.add(kid);
            JwkHolder h = new JwkHolder(jwk);
            if (keyId.equals(kid)) {
                jwkHolder = h;
                continue;
            }
            this.jsonWebKeys.putIfAbsent(kid, h);
        }
        this.jsonWebKeys.keySet().removeIf(JwsJwksJwtAccessTokenValidator.not(kids::contains));
        return jwkHolder;
    }

    JsonWebKeys getJsonWebKeys() {
        return (JsonWebKeys)WebClient.create((String)this.jwksURL, Collections.singletonList(new JsonWebKeysProvider())).accept(new String[]{"application/json"}).get(JsonWebKeys.class);
    }

    static <T> Predicate<T> not(Predicate<? super T> target) {
        return target.negate();
    }

    private static class JwkHolder {
        private final JsonWebKey jsonWebKey;
        private JwsSignatureVerifier jwsSignatureVerifier;

        JwkHolder(JsonWebKey jsonWebKey) {
            this.jsonWebKey = jsonWebKey;
        }

        public JwsSignatureVerifier getJwsSignatureVerifier() {
            if (null == this.jwsSignatureVerifier) {
                this.jwsSignatureVerifier = JwsUtils.getSignatureVerifier((JsonWebKey)this.jsonWebKey);
            }
            return this.jwsSignatureVerifier;
        }
    }
}

