/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.BiConsumer;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Message;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.protocols.relay.TopoHeader;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Bits;
import org.jgroups.util.SizeStreamable;
import org.jgroups.util.Util;

public class Topology {
    protected final RELAY2 relay;
    protected final Map<String, Set<MemberInfo>> cache = new ConcurrentHashMap<String, Set<MemberInfo>>();
    protected BiConsumer<String, MemberInfo> rsp_handler;

    public Topology(RELAY2 relay) {
        this.relay = Objects.requireNonNull(relay);
    }

    public Map<String, Set<MemberInfo>> cache() {
        return this.cache;
    }

    public Topology setResponseHandler(BiConsumer<String, MemberInfo> c) {
        this.rsp_handler = c;
        return this;
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members")
    public Topology refresh() {
        return this.refresh(null);
    }

    @ManagedOperation(description="Fetches information (site, address, IP address) from all members of a given site")
    public Topology refresh(String site) {
        SiteMaster dest = site != null ? new SiteMaster(site) : null;
        Message topo_req = new EmptyMessage(dest).putHeader((short)560, new TopoHeader(0));
        this.relay.down(topo_req);
        return this;
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print() {
        return this.print(null);
    }

    @ManagedOperation(description="Prints the cache information about all members")
    public String print(String site) {
        if (site != null) {
            return this.dumpSite(site);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Set<MemberInfo>> e : this.cache.entrySet()) {
            sb.append(this.dumpSite(e.getKey()));
        }
        return sb.toString();
    }

    public Topology removeAll(Collection<String> sites) {
        if (sites == null) {
            this.cache.keySet().clear();
        } else {
            this.cache.keySet().removeAll(sites);
        }
        return this;
    }

    public Topology adjust(String site, Collection<Address> mbrs) {
        Set<MemberInfo> list = this.cache.get(site);
        if (list != null && mbrs != null) {
            list.removeIf(mi -> !mbrs.contains(mi.address()));
        }
        return this;
    }

    public String toString() {
        return String.format("%d sites", this.cache.size());
    }

    protected String dumpSite(String site) {
        Set<MemberInfo> members = this.cache.get(site);
        if (members == null) {
            return String.format("%s: no members found", site);
        }
        StringBuilder sb = new StringBuilder(site).append("\n");
        for (MemberInfo mi : members) {
            sb.append("  ").append(mi.toStringNoSite()).append("\n");
        }
        return sb.toString();
    }

    protected void handleResponse(String site, MemberInfo rsp) {
        Set infos = this.cache.computeIfAbsent(site, s -> new ConcurrentSkipListSet());
        infos.add(rsp);
        if (this.rsp_handler != null) {
            this.rsp_handler.accept(site, rsp);
        }
    }

    public static class MemberInfo
    implements SizeStreamable,
    Comparable<MemberInfo> {
        protected String site;
        protected Address addr;
        protected IpAddress ip_addr;
        protected boolean site_master;

        public MemberInfo() {
        }

        public MemberInfo(String site, Address addr, IpAddress ip_addr, boolean site_master) {
            this.site = site;
            this.addr = Objects.requireNonNull(addr);
            this.ip_addr = ip_addr;
            this.site_master = site_master;
        }

        public String site() {
            return this.site;
        }

        public Address address() {
            return this.addr;
        }

        public IpAddress ipAddress() {
            return this.ip_addr;
        }

        public boolean siteMaster() {
            return this.site_master;
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof MemberInfo && this.compareTo((MemberInfo)obj) == 0;
        }

        @Override
        public int compareTo(MemberInfo o) {
            return this.addr.compareTo(o.addr);
        }

        @Override
        public int serializedSize() {
            return Util.size(this.site) + Util.size(this.addr) + Util.size(this.ip_addr) + 1;
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            Bits.writeString(this.site, out);
            Util.writeAddress(this.addr, out);
            Util.writeAddress(this.ip_addr, out);
            out.writeBoolean(this.site_master);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.site = Bits.readString(in);
            this.addr = Util.readAddress(in);
            this.ip_addr = (IpAddress)Util.readAddress(in);
            this.site_master = in.readBoolean();
        }

        public String toString() {
            return String.format("site=%s, addr=%s (ip=%s%s)", this.site, this.addr, this.ip_addr, this.site_master ? ", sm" : "");
        }

        public String toStringNoSite() {
            return String.format("%s (ip=%s%s)", this.addr, this.ip_addr, this.site_master ? ", sm" : "");
        }
    }

    @FunctionalInterface
    public static interface ResponseHandler {
        public void handle(String var1, MemberInfo var2);
    }
}

