/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.relay;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.Receiver;
import org.jgroups.View;
import org.jgroups.logging.Log;
import org.jgroups.protocols.relay.ForwardingRoute;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.Relay2Header;
import org.jgroups.protocols.relay.Route;
import org.jgroups.protocols.relay.SiteUUID;
import org.jgroups.protocols.relay.config.RelayConfig;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class Relayer {
    protected final Map<String, List<Route>> routes = new ConcurrentHashMap<String, List<Route>>(5);
    protected final Set<ForwardingRoute> forward_routes = new ConcurrentSkipListSet<ForwardingRoute>();
    protected final Collection<Bridge> bridges = new ConcurrentLinkedQueue<Bridge>();
    protected final Log log;
    protected final RELAY2 relay;
    protected volatile boolean done;
    protected boolean stats;

    public Relayer(RELAY2 relay, Log log) {
        this.relay = relay;
        this.stats = relay.statsEnabled();
        this.log = log;
    }

    public boolean done() {
        return this.done;
    }

    public void start(RelayConfig.SiteConfig site_cfg, String bridge_name, String my_site_id) throws Throwable {
        if (this.done) {
            this.log.trace(this.relay.getAddress() + ": will not start the Relayer as stop() has been called");
            return;
        }
        try {
            List<RelayConfig.ForwardConfig> forward_configs = site_cfg.getForwards();
            for (RelayConfig.ForwardConfig cfg : forward_configs) {
                ForwardingRoute fr = new ForwardingRoute(cfg.to(), cfg.gateway());
                this.forward_routes.add(fr);
            }
            List<RelayConfig.BridgeConfig> bridge_configs = site_cfg.getBridges();
            for (RelayConfig.BridgeConfig cfg : bridge_configs) {
                Bridge bridge = new Bridge(cfg.createChannel(), cfg.getClusterName(), bridge_name, () -> new SiteUUID(UUID.randomUUID(), null, my_site_id));
                this.bridges.add(bridge);
            }
            for (Bridge bridge : this.bridges) {
                bridge.start();
            }
        }
        catch (Throwable t) {
            this.stop();
            throw t;
        }
        finally {
            if (this.done) {
                this.log.trace(this.relay.getAddress() + ": stop() was called while starting the relayer; stopping the relayer now");
                this.stop();
            }
        }
    }

    public void stop() {
        this.done = true;
        this.bridges.forEach(Bridge::stop);
        this.bridges.clear();
    }

    public synchronized String printRoutes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<Route>> entry : this.routes.entrySet()) {
            List<Route> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            sb.append(entry.getKey() + " --> ").append(Util.print(list)).append("\n");
        }
        for (ForwardingRoute fr : this.forward_routes) {
            sb.append(String.format("%s --> %s [fwd]\n", fr.to(), fr.gateway()));
        }
        return sb.toString();
    }

    protected Route getRoute(String site) {
        return this.getRoute(site, null);
    }

    protected synchronized Route getRoute(String site, Address sender) {
        List<Route> list = this.routes.get(site);
        if (list == null) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        return this.relay.site_master_picker.pickRoute(site, list, sender);
    }

    protected synchronized Route getForwardingRouteMatching(String site, Address sender) {
        if (site == null) {
            return null;
        }
        for (ForwardingRoute fr : this.forward_routes) {
            Route r;
            if (!fr.matches(site) || (r = this.getRoute(fr.gateway(), sender)) == null) continue;
            return r;
        }
        return null;
    }

    protected List<String> getSiteNames() {
        return new ArrayList<String>(this.routes.keySet());
    }

    protected synchronized List<Route> getRoutes(String ... excluded_sites) {
        ArrayList<Route> retval = new ArrayList<Route>(this.routes.size());
        block0: for (List<Route> list : this.routes.values()) {
            for (Route route : list) {
                if (route == null || Relayer.isExcluded(route, excluded_sites)) continue;
                retval.add(route);
                continue block0;
            }
        }
        return retval;
    }

    protected View getBridgeView(String cluster_name) {
        if (cluster_name == null || this.bridges == null) {
            return null;
        }
        for (Bridge bridge : this.bridges) {
            if (!Objects.equals(bridge.cluster_name, cluster_name)) continue;
            return bridge.view;
        }
        return null;
    }

    protected static boolean isExcluded(Route route, String ... excluded_sites) {
        if (excluded_sites == null) {
            return false;
        }
        String site = ((SiteUUID)route.site_master).getSite();
        for (String excluded_site : excluded_sites) {
            if (!site.equals(excluded_site)) continue;
            return true;
        }
        return false;
    }

    protected class Bridge
    implements Receiver {
        protected JChannel channel;
        protected String cluster_name;
        protected View view;

        protected Bridge(JChannel ch, String cluster_name, String channel_name, AddressGenerator addr_generator) throws Exception {
            this.channel = ch;
            this.channel.setName(channel_name);
            this.channel.setReceiver(this);
            this.channel.addAddressGenerator(addr_generator);
            this.cluster_name = cluster_name;
        }

        protected void start() throws Exception {
            this.channel.connect(this.cluster_name);
            Relayer.this.log.info("%s: joined bridge cluster '%s'", this.channel.getAddress(), this.cluster_name);
        }

        protected void stop() {
            Relayer.this.log.info("%s: leaving bridge cluster '%s'", this.channel.getAddress(), this.channel.getClusterName());
            Util.close((Closeable)this.channel);
        }

        @Override
        public void receive(Message msg) {
            Relay2Header hdr = (Relay2Header)msg.getHeader(Relayer.this.relay.getId());
            if (hdr == null) {
                Relayer.this.log.warn("received a message without a relay header; discarding it");
                return;
            }
            Relayer.this.relay.handleRelayMessage(hdr, msg);
        }

        @Override
        public void viewAccepted(View new_view) {
            View old_view = this.view;
            Map<String, List<Address>> sites = Util.getSites(new_view, Relayer.this.relay.site());
            List<String> removed_routes = this.removedRoutes(old_view, new_view);
            HashSet<String> up2 = new HashSet<String>();
            HashSet<String> down2 = new HashSet<String>(removed_routes);
            this.view = new_view;
            for (String string : sites.keySet()) {
                if (Relayer.this.routes.containsKey(string)) continue;
                up2.add(string);
            }
            Relayer.this.log.trace("[Relayer " + this.channel.getAddress() + "] view: " + new_view);
            for (Map.Entry entry : sites.entrySet()) {
                String key = (String)entry.getKey();
                List val = (List)entry.getValue();
                List<Route> existing = Relayer.this.routes.get(key);
                ArrayList<Route> newRoutes = existing != null ? new ArrayList<Route>(existing) : new ArrayList();
                newRoutes.removeIf(r -> !val.contains(r.siteMaster()));
                val.stream().filter(addr -> !this.contains((List<Route>)newRoutes, (Address)addr)).forEach(addr -> newRoutes.add(new Route((Address)addr, this.channel, Relayer.this.relay, Relayer.this.log).stats(Relayer.this.stats)));
                if (newRoutes.isEmpty()) {
                    Relayer.this.routes.remove(key);
                    down2.add(key);
                    continue;
                }
                Relayer.this.routes.put(key, newRoutes);
            }
            if (!removed_routes.isEmpty() && Relayer.this.log.isTraceEnabled()) {
                Relayer.this.log.trace("%s: removing routes %s from routing table", removed_routes);
            }
            removed_routes.forEach(Relayer.this.routes.keySet()::remove);
            if (!down2.isEmpty()) {
                Relayer.this.relay.sitesChange(true, down2.toArray(new String[0]));
            }
            if (!up2.isEmpty()) {
                Relayer.this.relay.sitesChange(false, up2.toArray(new String[0]));
            }
        }

        public String toString() {
            return String.format("bridge %s", this.cluster_name);
        }

        protected boolean contains(List<Route> routes, Address addr) {
            return routes.stream().anyMatch(route -> route.siteMaster().equals(addr));
        }

        protected List<String> removedRoutes(View old_view, View new_view) {
            ArrayList<String> l = new ArrayList<String>();
            if (old_view == null) {
                return l;
            }
            List<String> old_routes = Stream.of(old_view.getMembersRaw()).filter(a -> a instanceof SiteUUID).map(s -> ((SiteUUID)s).getSite()).collect(Collectors.toList());
            List new_routes = Stream.of(new_view.getMembersRaw()).filter(a -> a instanceof SiteUUID).map(s -> ((SiteUUID)s).getSite()).collect(Collectors.toList());
            old_routes.removeAll(new_routes);
            return old_routes;
        }
    }
}

