/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.jetty11;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_jetty.JettyHTTPDestination;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.InvalidPathException;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.jetty.WebSocketServletHolder;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletRequest;
import org.apache.cxf.transport.websocket.jetty.WebSocketVirtualServletResponse;
import org.apache.cxf.transport.websocket.jetty11.JettyWebSocketHandler;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;

public class Jetty11WebSocketDestination
extends JettyHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(Jetty11WebSocketDestination.class);
    private static final String REQUEST_ID_KEY = "requestId";
    private static final String RESPONSE_ID_KEY = "responseId";
    private final Executor executor;
    private JettyWebSocketServerContainer webSocketServerContainer;

    public Jetty11WebSocketDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, JettyHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory == null ? null : new URL(Jetty11WebSocketDestination.getNonWSAddress(ei)), serverEngineFactory);
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest request, HttpServletResponse response) throws IOException {
        JettyWebSocketCreator creator;
        JettyWebSocketServerContainer wssc = this.getWebSocketContainer(context);
        if (wssc.upgrade(creator = this.getCreator(), request, response)) {
            ((Request)request).setHandled(true);
            return;
        }
        super.invoke(config, context, request, response);
    }

    private static String getNonWSAddress(EndpointInfo endpointInfo) {
        Object address = endpointInfo.getAddress();
        if (((String)address).startsWith("ws")) {
            address = "http" + ((String)address).substring(2);
        }
        return address;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return Jetty11WebSocketDestination.getNonWSAddress(endpointInfo);
    }

    Server getServer(ServletConfig config, ServletContext context) {
        ContextHandler.Context c = (ContextHandler.Context)context;
        ContextHandler h = c.getContextHandler();
        return h.getServer();
    }

    public JettyWebSocketCreator getCreator() {
        return new Creator();
    }

    public synchronized JettyWebSocketServerContainer getWebSocketContainer(ServletContext context) {
        if (this.webSocketServerContainer == null) {
            this.webSocketServerContainer = JettyWebSocketServerContainer.getContainer((ServletContext)context);
            if (this.webSocketServerContainer == null) {
                this.webSocketServerContainer = JettyWebSocketServerContainer.ensureContainer((ServletContext)context);
            }
            return this.webSocketServerContainer;
        }
        return this.webSocketServerContainer;
    }

    protected JettyHTTPHandler createJettyHTTPHandler(JettyHTTPDestination jhd, boolean cmExact) {
        return new JettyWebSocketHandler(jhd, cmExact, this);
    }

    public void shutdown() {
        super.shutdown();
    }

    private void invoke(final byte[] data, final int offset, final int length, final Session session) {
        this.executeServiceTask(new Runnable(){

            @Override
            public void run() {
                WebSocketVirtualServletResponse response = null;
                try {
                    Jetty11WebSocketHolder holder = new Jetty11WebSocketHolder(session);
                    response = Jetty11WebSocketDestination.this.createServletResponse(holder);
                    WebSocketVirtualServletRequest request = Jetty11WebSocketDestination.this.createServletRequest(data, offset, length, holder, session);
                    String reqid = request.getHeader(Jetty11WebSocketDestination.REQUEST_ID_KEY);
                    if (reqid != null) {
                        if (WebSocketUtils.isContainingCRLF(reqid)) {
                            LOG.warning("Invalid characters (CR/LF) in header requestId");
                        } else {
                            response.setHeader(Jetty11WebSocketDestination.RESPONSE_ID_KEY, reqid);
                        }
                    }
                    Jetty11WebSocketDestination.this.invoke(null, null, request, response);
                }
                catch (InvalidPathException ex) {
                    Jetty11WebSocketDestination.this.reportErrorStatus(session, 400, response);
                }
                catch (Exception e) {
                    LOG.log(Level.WARNING, "Failed to invoke service", e);
                    Jetty11WebSocketDestination.this.reportErrorStatus(session, 500, response);
                }
            }
        });
    }

    private void executeServiceTask(Runnable r) {
        try {
            this.executor.execute(r);
        }
        catch (RejectedExecutionException e) {
            LOG.warning("Executor queue is full, run the service invocation task in caller thread.  Users can specify a larger executor queue to avoid this.");
            r.run();
        }
    }

    private void reportErrorStatus(Session session, int i, HttpServletResponse resp) {
        try {
            resp.sendError(i);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private WebSocketVirtualServletRequest createServletRequest(byte[] data, int offset, int length, WebSocketServletHolder holder, Session session) throws IOException {
        return new WebSocketVirtualServletRequest(holder, new ByteArrayInputStream(data, offset, length), session);
    }

    private WebSocketVirtualServletResponse createServletResponse(WebSocketServletHolder holder) throws IOException {
        return new WebSocketVirtualServletResponse(holder);
    }

    private class Creator
    implements JettyWebSocketCreator {
        private Creator() {
        }

        public Object createWebSocket(JettyServerUpgradeRequest req, JettyServerUpgradeResponse resp) {
            return new WebSocketAdapter(){
                Session session;

                public void onWebSocketConnect(Session session) {
                    this.session = session;
                }

                public void onWebSocketBinary(byte[] payload, int offset, int len) {
                    Jetty11WebSocketDestination.this.invoke(payload, offset, len, this.session);
                }

                public void onWebSocketText(String message) {
                    try {
                        byte[] bdata = message.getBytes("utf-8");
                        this.onWebSocketBinary(bdata, 0, bdata.length);
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
            };
        }
    }

    class Jetty11WebSocketHolder
    implements WebSocketServletHolder {
        final Session session;

        Jetty11WebSocketHolder(Session s) {
            this.session = s;
        }

        @Override
        public String getAuthType() {
            return null;
        }

        @Override
        public String getContextPath() {
            return this.getHttpServletRequest(this.session.getUpgradeRequest()).getContextPath();
        }

        @Override
        public String getLocalAddr() {
            return null;
        }

        @Override
        public String getLocalName() {
            return null;
        }

        @Override
        public int getLocalPort() {
            return 0;
        }

        @Override
        public Locale getLocale() {
            return null;
        }

        @Override
        public Enumeration<Locale> getLocales() {
            return null;
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public String getRemoteAddr() {
            return null;
        }

        @Override
        public String getRemoteHost() {
            return null;
        }

        @Override
        public int getRemotePort() {
            return 0;
        }

        @Override
        public String getRequestURI() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public StringBuffer getRequestURL() {
            return new StringBuffer(this.session.getUpgradeRequest().getRequestURI().toString());
        }

        @Override
        public DispatcherType getDispatcherType() {
            return null;
        }

        @Override
        public boolean isSecure() {
            return false;
        }

        @Override
        public String getPathInfo() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getPathTranslated() {
            return this.session.getUpgradeRequest().getRequestURI().getPath();
        }

        @Override
        public String getScheme() {
            return "ws";
        }

        @Override
        public String getServerName() {
            return null;
        }

        @Override
        public String getServletPath() {
            return "";
        }

        @Override
        public ServletContext getServletContext() {
            return null;
        }

        @Override
        public int getServerPort() {
            return ((InetSocketAddress)this.session.getLocalAddress()).getPort();
        }

        @Override
        public Principal getUserPrincipal() {
            return null;
        }

        @Override
        public Object getAttribute(String name) {
            UpgradeRequest upgradeRequest = this.session.getUpgradeRequest();
            return this.getHttpServletRequest(upgradeRequest).getAttribute(name);
        }

        @Override
        public void write(byte[] data, int offset, int length) throws IOException {
            this.session.getRemote().sendBytes(ByteBuffer.wrap(data, offset, length));
        }

        private HttpServletRequest getHttpServletRequest(UpgradeRequest upgradeRequest) {
            if (upgradeRequest instanceof JettyServerUpgradeRequest) {
                return ((JettyServerUpgradeRequest)upgradeRequest).getHttpServletRequest();
            }
            throw new IllegalStateException("Unsupported upgrade request class: " + upgradeRequest.getClass());
        }
    }
}

