/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsn.jms;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.activemq.artemis.jms.client.ActiveMQTopic;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.wsn.AbstractPublisher;
import org.apache.cxf.wsn.jms.InvalidTopicException;
import org.apache.cxf.wsn.jms.JmsTopicExpressionConverter;
import org.oasis_open.docs.wsn.b_2.InvalidTopicExpressionFaultType;
import org.oasis_open.docs.wsn.b_2.NotificationMessageHolderType;
import org.oasis_open.docs.wsn.b_2.Notify;
import org.oasis_open.docs.wsn.b_2.TopicExpressionType;
import org.oasis_open.docs.wsn.br_2.PublisherRegistrationFailedFaultType;
import org.oasis_open.docs.wsn.br_2.RegisterPublisher;
import org.oasis_open.docs.wsn.br_2.ResourceNotDestroyedFaultType;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationFailedFault;
import org.oasis_open.docs.wsn.brw_2.PublisherRegistrationRejectedFault;
import org.oasis_open.docs.wsn.brw_2.ResourceNotDestroyedFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;

public abstract class JmsPublisher
extends AbstractPublisher {
    private static final Logger LOGGER = LogUtils.getL7dLogger(JmsPublisher.class);
    private Connection connection;
    private JmsTopicExpressionConverter topicConverter = new JmsTopicExpressionConverter();
    private JAXBContext jaxbContext;
    private Session advisory;
    private MessageConsumer notificationConsumer;
    private Map<Destination, Object> producers;
    private final String notificationTopicName;

    public JmsPublisher(String name) {
        this(name, "activemq.notifications");
    }

    public JmsPublisher(String name, String notificationTopicName) {
        super(name);
        this.notificationTopicName = notificationTopicName;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Notify.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXB context", e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(NotificationMessageHolderType messageHolder) {
        Session session = null;
        try {
            ActiveMQTopic topic = this.topicConverter.toActiveMQTopic(messageHolder.getTopic());
            session = this.connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)topic);
            Notify notify = new Notify();
            notify.getNotificationMessage().add(messageHolder);
            StringWriter writer = new StringWriter();
            this.jaxbContext.createMarshaller().marshal((Object)notify, (Writer)writer);
            TextMessage message = session.createTextMessage(writer.toString());
            producer.send((Message)message);
        }
        catch (JMSException | JAXBException | InvalidTopicException e) {
            LOGGER.log(Level.WARNING, "Error dispatching message", e);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (JMSException e) {
                    LOGGER.log(Level.FINE, "Error closing session", e);
                }
            }
        }
    }

    @Override
    protected void validatePublisher(RegisterPublisher registerPublisherRequest) throws InvalidTopicExpressionFault, PublisherRegistrationFailedFault, PublisherRegistrationRejectedFault, ResourceUnknownFault, TopicNotSupportedFault {
        super.validatePublisher(registerPublisherRequest);
        try {
            if (this.topic != null && !this.topic.isEmpty()) {
                int size = this.topic.size();
                ActiveMQTopic[] childrenDestinations = new ActiveMQTopic[size];
                for (int i = 0; i < size; ++i) {
                    childrenDestinations[i] = this.topicConverter.toActiveMQTopic((TopicExpressionType)this.topic.get(i));
                }
            }
        }
        catch (InvalidTopicException e) {
            InvalidTopicExpressionFaultType fault = new InvalidTopicExpressionFaultType();
            throw new InvalidTopicExpressionFault(e.getMessage(), fault);
        }
    }

    @Override
    protected void start() throws PublisherRegistrationFailedFault {
        if (this.demand) {
            try {
                this.producers = new HashMap<Destination, Object>();
                this.advisory = this.connection.createSession(false, 1);
                Topic notificationsTopic = this.advisory.createTopic(this.notificationTopicName);
                this.notificationConsumer = this.advisory.createConsumer((Destination)notificationsTopic);
                this.notificationConsumer.setMessageListener(this::onMessage);
            }
            catch (Exception e) {
                PublisherRegistrationFailedFaultType fault = new PublisherRegistrationFailedFaultType();
                throw new PublisherRegistrationFailedFault("Error starting demand-based publisher", fault, (Throwable)e);
            }
        }
    }

    @Override
    protected void destroy() throws ResourceNotDestroyedFault {
        try {
            if (this.notificationConsumer != null) {
                this.notificationConsumer.close();
            }
            if (this.advisory != null) {
                this.advisory.close();
            }
        }
        catch (Exception e) {
            ResourceNotDestroyedFaultType fault = new ResourceNotDestroyedFaultType();
            throw new ResourceNotDestroyedFault("Error destroying publisher", fault, (Throwable)e);
        }
        finally {
            super.destroy();
        }
    }

    public synchronized void onMessage(Message event) {
        try {
            String type = event.getStringProperty("_AMQ_NotifType");
            String routing = event.getStringProperty("_AMQ_RoutingName");
            if (routing != null) {
                int consumerCount;
                TopicExpressionType topic = this.topicConverter.toTopicExpression(routing);
                ActiveMQTopic destination = this.topicConverter.toActiveMQTopic(topic);
                Object producer = this.producers.get(destination);
                if ("CONSUMER_CREATED".equalsIgnoreCase(type)) {
                    int consumerCount2 = event.getIntProperty("_AMQ_ConsumerCount");
                    if (consumerCount2 > 0 && producer == null) {
                        producer = this.startSubscription(topic);
                        this.producers.put((Destination)destination, producer);
                    }
                } else if ("CONSUMER_CLOSED".equalsIgnoreCase(type) && (consumerCount = event.getIntProperty("_AMQ_ConsumerCount")) == 0 && producer != null) {
                    Object sub = this.producers.remove(destination);
                    this.stopSubscription(sub);
                }
            }
        }
        catch (JMSException | InvalidTopicException ex) {
            LOGGER.log(Level.WARNING, "Error consuming message", ex);
        }
    }

    protected abstract Object startSubscription(TopicExpressionType var1);

    protected abstract void stopSubscription(Object var1);
}

