/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.SystemPropertyAction;
import org.apache.cxf.configuration.jsse.TLSParameterBase;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.ClientAuthentication;
import org.apache.cxf.configuration.security.FiltersType;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http.HttpServerEngineSupport;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.NoUpgradeHTTP2CServerConnectionFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.ThreadingParameters;
import org.apache.cxf.transport.https.SSLUtils;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class JettyHTTPServerEngine
implements ServerEngine,
HttpServerEngineSupport {
    public static final String DO_NOT_CHECK_URL_PROP = "org.apache.cxf.transports.http_jetty.DontCheckUrl";
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPServerEngine.class);
    private int port;
    private String host;
    private String protocol = "http";
    private Boolean isSessionSupport = false;
    private int sessionTimeout = -1;
    private Boolean isReuseAddress = true;
    private Boolean continuationsEnabled = true;
    private int maxIdleTime = 200000;
    private Boolean sendServerVersion = true;
    private int servantCount;
    private Server server;
    private Connector connector;
    private List<Handler> handlers;
    private ContextHandlerCollection contexts;
    private Container.Listener mBeanContainer;
    private SessionHandler sessionHandler;
    private ThreadPool threadPool;
    private TLSServerParameters tlsServerParameters;
    private ThreadingParameters threadingParameters;
    private boolean configFinalized;
    private List<String> registedPaths = new CopyOnWriteArrayList<String>();

    public JettyHTTPServerEngine(Container.Listener mBeanContainer, String host, int port) {
        this.host = host;
        this.port = port;
        this.mBeanContainer = mBeanContainer;
    }

    public JettyHTTPServerEngine() {
    }

    public void setThreadPool(ThreadPool p) {
        this.threadPool = p;
    }

    public void setPort(int p) {
        this.port = p;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setContinuationsEnabled(boolean enabled) {
        this.continuationsEnabled = enabled;
    }

    public boolean getContinuationsEnabled() {
        return this.continuationsEnabled;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public void shutdown() {
        this.registedPaths.clear();
        if (this.shouldDestroyPort()) {
            if (this.servantCount == 0) {
                JettyHTTPServerEngineFactory.destroyForPort(this.port);
            } else {
                LOG.log(Level.WARNING, "FAILED_TO_SHUTDOWN_ENGINE_MSG", this.port);
            }
        }
    }

    private boolean shouldDestroyPort() {
        String s = SystemPropertyAction.getPropertyOrNull((String)("org.apache.cxf.transports.http_jetty.DontClosePort." + this.port));
        if (s == null) {
            s = SystemPropertyAction.getPropertyOrNull((String)"org.apache.cxf.transports.http_jetty.DontClosePort");
        }
        return Boolean.valueOf(s) == false;
    }

    private boolean shouldCheckUrl(Bus bus) {
        Object prop = null;
        if (bus != null) {
            prop = bus.getProperty(DO_NOT_CHECK_URL_PROP);
        }
        if (prop == null) {
            prop = SystemPropertyAction.getPropertyOrNull((String)DO_NOT_CHECK_URL_PROP);
        }
        return !PropertyUtils.isTrue((Object)prop);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server s) {
        this.server = s;
    }

    public void setConnector(Connector c) {
        this.connector = c;
    }

    public void setHandlers(List<Handler> h) {
        this.handlers = h;
    }

    public void setSessionSupport(boolean support) {
        this.isSessionSupport = support;
    }

    public boolean isSessionSupport() {
        return this.isSessionSupport;
    }

    public List<Handler> getHandlers() {
        return this.handlers;
    }

    public Connector getConnector() {
        return this.connector;
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean reuse) {
        this.isReuseAddress = reuse;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public void setMaxIdleTime(int maxIdle) {
        this.maxIdleTime = maxIdle;
    }

    protected void checkRegistedContext(URL url) {
        String path = url.getPath();
        for (String registedPath : this.registedPaths) {
            if (path.equals(registedPath)) {
                throw new Fault(new Message("ADD_HANDLER_CONTEXT_IS_USED_MSG", LOG, new Object[]{url, registedPath}));
            }
            if (path.equals(HttpUriMapper.getContextName((String)registedPath))) {
                throw new Fault(new Message("ADD_HANDLER_CONTEXT_IS_USED_MSG", LOG, new Object[]{url, registedPath}));
            }
            if (!registedPath.equals(HttpUriMapper.getContextName((String)path))) continue;
            throw new Fault(new Message("ADD_HANDLER_CONTEXT_CONFILICT_MSG", LOG, new Object[]{url, registedPath}));
        }
    }

    private Server createServer() {
        Server s = null;
        if (this.connector != null && this.connector.getServer() != null) {
            s = this.connector.getServer();
        }
        if (this.threadPool != null) {
            try {
                if (s == null) {
                    s = new Server(this.threadPool);
                } else {
                    s.addBean((Object)this.threadPool);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s == null) {
            s = new Server();
        }
        ErrorHandler eh = new ErrorHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                String msg = (String)request.getAttribute("javax.servlet.error.message");
                if (StringUtils.isEmpty((String)msg) || msg.contains("org.apache.cxf.interceptor.Fault")) {
                    msg = HttpStatus.getMessage((int)response.getStatus());
                    request.setAttribute("javax.servlet.error.message", (Object)msg);
                }
                if (response instanceof Response) {
                    ((Response)response).setStatusWithReason(response.getStatus(), msg);
                }
                super.handle(target, baseRequest, request, response);
            }

            protected void writeErrorPage(HttpServletRequest request, Writer writer, int code, String message, boolean showStacks) throws IOException {
                super.writeErrorPage(request, writer, code, message, false);
            }
        };
        s.addBean((Object)eh);
        return s;
    }

    @Override
    public synchronized void addServant(URL url, JettyHTTPHandler handler) {
        if (this.shouldCheckUrl(handler.getBus())) {
            this.checkRegistedContext(url);
        }
        this.initializeContexts();
        SecurityHandler securityHandler = null;
        if (this.server == null) {
            DefaultHandler defaultHandler = null;
            this.server = this.createServer();
            this.addServerMBean();
            if (this.connector == null) {
                this.connector = this.createConnector(this.getHost(), this.getPort(), handler.getBus());
                if (LOG.isLoggable(Level.FINER)) {
                    JettyHTTPServerEngine.logConnector((ServerConnector)this.connector);
                }
            }
            this.server.addConnector(this.connector);
            this.setupThreadPool();
            int numberOfHandlers = 1;
            if (this.handlers != null) {
                numberOfHandlers += this.handlers.size();
            }
            Handler existingHandler = this.server.getHandler();
            HandlerCollection handlerCollection = null;
            boolean existingHandlerCollection = existingHandler instanceof HandlerCollection;
            if (existingHandlerCollection) {
                handlerCollection = (HandlerCollection)existingHandler;
            }
            if (!(existingHandlerCollection || existingHandler == null && numberOfHandlers <= 1)) {
                handlerCollection = new HandlerCollection();
                if (existingHandler != null) {
                    handlerCollection.addHandler(existingHandler);
                }
                this.server.setHandler((Handler)handlerCollection);
            }
            if (this.handlers != null && !this.handlers.isEmpty()) {
                for (Handler h : this.handlers) {
                    if (h instanceof DefaultHandler) {
                        defaultHandler = (DefaultHandler)h;
                        continue;
                    }
                    if (h instanceof SecurityHandler && ((SecurityHandler)h).getHandler() == null) {
                        ((SecurityHandler)h).setHandler((Handler)handler);
                        securityHandler = (SecurityHandler)h;
                        continue;
                    }
                    handlerCollection.addHandler(h);
                }
            }
            if (handlerCollection != null) {
                handlerCollection.addHandler((Handler)this.contexts);
                if (defaultHandler != null) {
                    handlerCollection.addHandler(defaultHandler);
                }
            } else {
                this.server.setHandler((Handler)this.contexts);
            }
            try {
                this.server.start();
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "START_UP_SERVER_FAILED_MSG", new Object[]{e.getMessage(), this.port});
                try {
                    this.server.stop();
                    this.server.destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.server = null;
                throw new Fault(new Message("START_UP_SERVER_FAILED_MSG", LOG, new Object[]{e.getMessage(), this.port}), (Throwable)e);
            }
        }
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        ContextHandler context = handler.createContextHandler();
        context.setContextPath(contextName);
        if (this.isSessionSupport.booleanValue()) {
            SessionHandler sh = this.configureSession();
            if (securityHandler != null) {
                sh.setHandler(securityHandler);
            } else {
                sh.setHandler((Handler)handler);
            }
            context.setHandler((Handler)sh);
        } else if (securityHandler != null) {
            context.setHandler(securityHandler);
        } else {
            context.setHandler((Handler)handler);
        }
        this.contexts.addHandler((Handler)context);
        ContextHandler.Context sc = context.getServletContext();
        handler.setServletContext((ServletContext)sc);
        String smap = this.getHandlerName(url, context);
        handler.setName(smap);
        if (this.contexts.isStarted()) {
            try {
                context.start();
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "ADD_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
            }
        }
        this.registedPaths.add(url.getPath());
        ++this.servantCount;
    }

    private SessionHandler configureSession() {
        SessionHandler sh = null;
        try {
            if (Server.getVersion().startsWith("9.2") || Server.getVersion().startsWith("9.3")) {
                if (this.sessionHandler == null) {
                    this.sessionHandler = new SessionHandler();
                }
                sh = new SessionHandler();
                Method get = ReflectionUtil.getDeclaredMethod(SessionHandler.class, (String)"getSessionManager", (Class[])new Class[0]);
                Method set = ReflectionUtil.getDeclaredMethod(SessionHandler.class, (String)"setSessionManager", (Class[])new Class[]{get.getReturnType()});
                if (this.getSessionTimeout() >= 0) {
                    Method setMaxInactiveInterval = ReflectionUtil.getDeclaredMethod(get.getReturnType(), (String)"setMaxInactiveInterval", (Class[])new Class[]{Integer.TYPE});
                    ((Method)ReflectionUtil.setAccessible((AccessibleObject)setMaxInactiveInterval)).invoke(((Method)ReflectionUtil.setAccessible((AccessibleObject)get)).invoke((Object)this.sessionHandler, new Object[0]), 20);
                }
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)set)).invoke((Object)sh, ((Method)ReflectionUtil.setAccessible((AccessibleObject)get)).invoke((Object)this.sessionHandler, new Object[0]));
            } else {
                sh = new SessionHandler();
                if (this.getSessionTimeout() >= 0) {
                    Method setMaxInactiveInterval = ReflectionUtil.getDeclaredMethod(SessionHandler.class, (String)"setMaxInactiveInterval", (Class[])new Class[]{Integer.TYPE});
                    ((Method)ReflectionUtil.setAccessible((AccessibleObject)setMaxInactiveInterval)).invoke((Object)sh, 20);
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sh;
    }

    private String getHandlerName(URL url, ContextHandler context) {
        String contextPath = context.getContextPath();
        String path = url.getPath();
        if (path.startsWith(contextPath)) {
            if ("/".equals(contextPath)) {
                return path;
            }
            return path.substring(contextPath.length());
        }
        return HttpUriMapper.getResourceBase((String)url.getPath());
    }

    private void initializeContexts() {
        if (this.contexts == null) {
            this.contexts = new ContextHandlerCollection();
            if (this.server != null) {
                if (this.server.getHandler() instanceof ContextHandlerCollection) {
                    this.contexts = (ContextHandlerCollection)this.server.getHandler();
                } else {
                    this.server.setHandler((Handler)this.contexts);
                }
            }
        }
    }

    private void addServerMBean() {
        if (this.mBeanContainer == null) {
            return;
        }
        try {
            Method[] methods;
            Container container = JettyHTTPServerEngine.getContainer(this.server);
            for (Method m : methods = ReflectionUtil.getDeclaredMethods(container.getClass())) {
                if (!"addEventListener".equals(m.getName())) continue;
                ((Method)ReflectionUtil.setAccessible((AccessibleObject)m)).invoke((Object)container, this.mBeanContainer);
            }
            this.mBeanContainer.beanAdded(null, (Object)this.server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            throw new RuntimeException(r);
        }
    }

    private void removeServerMBean() {
        try {
            this.mBeanContainer.beanRemoved(null, (Object)this.server);
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception r) {
            throw new RuntimeException(r);
        }
    }

    private Connector createConnector(String hosto, int porto, Bus bus) {
        SslContextFactory.Server sslcf = null;
        if (this.tlsServerParameters != null) {
            sslcf = new SslContextFactory.Server(){

                protected void doStart() throws Exception {
                    this.setSslContext(JettyHTTPServerEngine.this.createSSLContext((SslContextFactory)this));
                    super.doStart();
                    this.checkKeyStore();
                }

                public void checkKeyStore() {
                }
            };
            this.decorateCXFJettySslSocketConnector(sslcf);
        }
        int major = 9;
        int minor = 0;
        try {
            String[] version = Server.getVersion().split("\\.");
            major = Integer.parseInt(version[0]);
            minor = Integer.parseInt(version[1]);
        }
        catch (Exception version) {
            // empty catch block
        }
        ServerConnector result = (ServerConnector)this.createConnectorJetty(sslcf, hosto, porto, major, minor, bus);
        try {
            result.setPort(porto);
            if (hosto != null) {
                result.setHost(hosto);
            }
            result.setReuseAddress(this.isReuseAddress());
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    AbstractConnector createConnectorJetty(SslContextFactory.Server sslcf, String hosto, int porto, int major, int minor, Bus bus) {
        ServerConnector result;
        try {
            HttpConfiguration httpConfig = new HttpConfiguration();
            httpConfig.setSendServerVersion(this.getSendServerVersion().booleanValue());
            HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
            ArrayList<Object> connectionFactories = new ArrayList<Object>();
            result = new ServerConnector(this.server);
            if (this.tlsServerParameters != null) {
                block19: {
                    Constructor[] cons;
                    connectionFactories.add(httpFactory);
                    httpConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer(this.tlsServerParameters.isSniHostCheck()));
                    if (this.isHttp2Enabled(bus)) {
                        try {
                            Constructor[] cons2;
                            ALPNServerConnectionFactory alpn = new ALPNServerConnectionFactory(new String[0]);
                            alpn.setDefaultProtocol(httpFactory.getProtocol());
                            Constructor[] constructorArray = cons2 = ReflectionUtil.getDeclaredConstructors(SslConnectionFactory.class);
                            int n = constructorArray.length;
                            for (int i = 0; i < n; ++i) {
                                Constructor c = constructorArray[i];
                                if (c.getParameterCount() != 2 || c.getParameterTypes()[1] != String.class || !c.getParameterTypes()[0].isInstance(sslcf)) continue;
                                SslConnectionFactory scf = (SslConnectionFactory)c.newInstance(sslcf, alpn.getProtocol());
                                connectionFactories.add(scf);
                            }
                            connectionFactories.add(alpn);
                            connectionFactories.add(new HTTP2ServerConnectionFactory(httpConfig));
                        }
                        finally {
                            if (connectionFactories.size() == 1) {
                            }
                            break block19;
                        }
                    }
                    for (Constructor c : cons = ReflectionUtil.getDeclaredConstructors(SslConnectionFactory.class)) {
                        if (c.getParameterCount() != 2 || c.getParameterTypes()[1] != String.class || !c.getParameterTypes()[0].isInstance(sslcf)) continue;
                        SslConnectionFactory scf = (SslConnectionFactory)c.newInstance(sslcf, httpFactory.getProtocol());
                        connectionFactories.add(scf);
                    }
                }
                result.setConnectionFactories(connectionFactories);
                String proto = major > 9 || major == 9 && minor >= 3 ? "SSL" : "SSL-HTTP/1.1";
                result.setDefaultProtocol(proto);
            } else if (this.isHttp2Enabled(bus)) {
                block20: {
                    connectionFactories.add(httpFactory);
                    try {
                        connectionFactories.add((Object)new NoUpgradeHTTP2CServerConnectionFactory(httpConfig));
                    }
                    catch (Throwable ex) {
                        try {
                            connectionFactories.add(new HTTP2CServerConnectionFactory(httpConfig));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!this.isHttp2Required(bus)) break block20;
                        throw ex;
                    }
                }
                result.setConnectionFactories(connectionFactories);
            }
            if (this.getMaxIdleTime() > 0) {
                result.setIdleTimeout(Long.valueOf(this.getMaxIdleTime()).longValue());
            }
        }
        catch (RuntimeException rex) {
            throw rex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    protected SSLContext createSSLContext(SslContextFactory scf) throws Exception {
        String proto = this.tlsServerParameters.getSecureSocketProtocol() == null ? "TLS" : this.tlsServerParameters.getSecureSocketProtocol();
        boolean allowSSLv3 = "SSLv3".equals(proto);
        if (allowSSLv3 || !this.tlsServerParameters.getIncludeProtocols().isEmpty()) {
            ArrayList excludedProtocols = new ArrayList();
            for (String excludedProtocol : scf.getExcludeProtocols()) {
                if (this.tlsServerParameters.getIncludeProtocols().contains(excludedProtocol) || allowSSLv3 && ("SSLv3".equals(excludedProtocol) || "SSLv2Hello".equals(excludedProtocol))) continue;
                excludedProtocols.add(excludedProtocol);
            }
            String[] revisedProtocols = new String[excludedProtocols.size()];
            excludedProtocols.toArray(revisedProtocols);
            scf.setExcludeProtocols(revisedProtocols);
        }
        for (String p : this.tlsServerParameters.getExcludeProtocols()) {
            scf.addExcludeProtocols(new String[]{p});
        }
        SSLContext context = this.tlsServerParameters.getJsseProvider() == null ? SSLContext.getInstance(JettyHTTPServerEngine.detectProto(proto, allowSSLv3)) : SSLContext.getInstance(JettyHTTPServerEngine.detectProto(proto, allowSSLv3), this.tlsServerParameters.getJsseProvider());
        KeyManager[] keyManagers = this.tlsServerParameters.getKeyManagers();
        KeyManager[] configuredKeyManagers = SSLUtils.configureKeyManagersWithCertAlias((TLSParameterBase)this.tlsServerParameters, (KeyManager[])keyManagers);
        context.init(configuredKeyManagers, this.tlsServerParameters.getTrustManagers(), this.tlsServerParameters.getSecureRandom());
        String[] supportedCipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getServerSupportedCipherSuites((SSLContext)context);
        if (this.tlsServerParameters.getCipherSuitesFilter() != null && this.tlsServerParameters.getCipherSuitesFilter().isSetExclude()) {
            String[] excludedCipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getFilteredCiphersuites((FiltersType)this.tlsServerParameters.getCipherSuitesFilter(), (String[])supportedCipherSuites, (Logger)LOG, (boolean)true);
            scf.setExcludeCipherSuites(excludedCipherSuites);
        }
        String[] includedCipherSuites = org.apache.cxf.configuration.jsse.SSLUtils.getCiphersuitesToInclude((List)this.tlsServerParameters.getCipherSuites(), (FiltersType)this.tlsServerParameters.getCipherSuitesFilter(), (String[])context.getServerSocketFactory().getDefaultCipherSuites(), (String[])supportedCipherSuites, (Logger)LOG);
        scf.setIncludeCipherSuites(includedCipherSuites);
        return context;
    }

    protected static String detectProto(String proto, boolean allowSSLv3) {
        if (allowSSLv3 && JavaUtils.getJavaMajorVersion() >= 14) {
            return "SSL";
        }
        return proto;
    }

    protected void setClientAuthentication(SslContextFactory.Server con, ClientAuthentication clientAuth) {
        con.setWantClientAuth(true);
        if (clientAuth != null) {
            if (clientAuth.isSetWant()) {
                con.setWantClientAuth(clientAuth.isWant().booleanValue());
            }
            if (clientAuth.isSetRequired()) {
                con.setNeedClientAuth(clientAuth.isRequired().booleanValue());
            }
        }
    }

    private void decorateCXFJettySslSocketConnector(SslContextFactory.Server con) {
        this.setClientAuthentication(con, this.tlsServerParameters.getClientAuthentication());
        con.setCertAlias(this.tlsServerParameters.getCertAlias());
        con.setEndpointIdentificationAlgorithm(null);
    }

    private static Container getContainer(Object server) {
        if (server instanceof Container) {
            return (Container)server;
        }
        try {
            return (Container)server.getClass().getMethod("getContainer", new Class[0]).invoke(server, new Object[0]);
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void logConnector(ServerConnector connector) {
        try {
            String h = connector.getHost();
            int port = connector.getPort();
            LOG.finer("connector.host: " + (String)(h == null ? "null" : "\"" + h + "\""));
            LOG.finer("connector.port: " + port);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setupThreadPool() {
        if (this.isSetThreadingParameters()) {
            ThreadPool pl = this.getThreadPool();
            AbstractConnector aconn = (AbstractConnector)this.connector;
            int acc = aconn.getAcceptors() * 2;
            if (this.getThreadingParameters().isSetMaxThreads() && this.getThreadingParameters().getMaxThreads() <= acc) {
                throw new Fault(new Message("NOT_ENOUGH_THREADS", LOG, new Object[]{this.port, acc + 1, this.getThreadingParameters().getMaxThreads(), acc}));
            }
            if (!(pl instanceof QueuedThreadPool)) {
                throw new Fault(new Message("NOT_A_QUEUED_THREAD_POOL", LOG, new Object[]{pl.getClass()}));
            }
            if (this.getThreadingParameters().isThreadNamePrefixSet()) {
                ((QueuedThreadPool)pl).setName(this.getThreadingParameters().getThreadNamePrefix());
            }
            if (this.getThreadingParameters().isSetMinThreads()) {
                ((QueuedThreadPool)pl).setMinThreads(this.getThreadingParameters().getMinThreads());
            }
            if (this.getThreadingParameters().isSetMaxThreads()) {
                ((QueuedThreadPool)pl).setMaxThreads(this.getThreadingParameters().getMaxThreads());
            }
        }
    }

    private ThreadPool getThreadPool() {
        ThreadPool pool = this.server.getThreadPool();
        if (pool == null) {
            pool = new QueuedThreadPool();
            try {
                this.server.getClass().getMethod("setThreadPool", ThreadPool.class).invoke((Object)this.server, pool);
            }
            catch (RuntimeException t) {
                throw t;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return pool;
    }

    @Override
    public synchronized void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        String smap = HttpUriMapper.getResourceBase((String)url.getPath());
        boolean found = false;
        if (this.server != null && this.server.isRunning()) {
            for (Handler handler : this.contexts.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler;
                Handler jh;
                if (!(handler instanceof ContextHandler) || !((jh = (contextHandler = (ContextHandler)handler).getHandler()) instanceof JettyHTTPHandler) || !contextName.equals(contextHandler.getContextPath()) && (!StringUtils.isEmpty((String)contextName) || !"/".equals(contextHandler.getContextPath())) || !((JettyHTTPHandler)jh).getName().equals(smap)) continue;
                try {
                    this.contexts.removeHandler(handler);
                    handler.stop();
                    handler.destroy();
                }
                catch (Exception ex) {
                    LOG.log(Level.WARNING, "REMOVE_HANDLER_FAILED_MSG", new Object[]{ex.getMessage()});
                }
                found = true;
                break;
            }
        }
        if (!found) {
            LOG.log(Level.WARNING, "CAN_NOT_FIND_HANDLER_MSG", new Object[]{url});
        }
        this.registedPaths.remove(url.getPath());
        --this.servantCount;
    }

    @Override
    public synchronized Handler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        Handler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler.getHandler();
                break;
            }
        }
        return ret;
    }

    public synchronized ContextHandler getContextHandler(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        ContextHandler ret = null;
        if (this.server != null) {
            for (Handler handler : this.server.getChildHandlersByClass(ContextHandler.class)) {
                ContextHandler contextHandler;
                if (!(handler instanceof ContextHandler) || !contextName.equals((contextHandler = (ContextHandler)handler).getContextPath())) continue;
                ret = contextHandler;
                break;
            }
        }
        return ret;
    }

    private boolean isSsl() {
        if (this.connector == null) {
            return false;
        }
        try {
            return "https".equalsIgnoreCase(this.connector.getDefaultConnectionFactory().getProtocol());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void retrieveListenerFactory() {
        if (this.tlsServerParameters != null) {
            if (this.connector != null && !this.isSsl()) {
                LOG.warning("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support SSL connections.");
                return;
            }
            this.protocol = "https";
        } else {
            if (this.isSsl()) {
                throw new RuntimeException("Connector " + this.connector + " for JettyServerEngine Port " + this.port + " does not support non-SSL connections.");
            }
            this.protocol = "http";
        }
        LOG.fine("Configured port " + this.port + " for \"" + this.protocol + "\".");
    }

    @PostConstruct
    public void finalizeConfig() {
        this.retrieveListenerFactory();
        this.checkConnectorPort();
        this.configFinalized = true;
    }

    private void checkConnectorPort() {
        int cp;
        if (null != this.connector && this.port != (cp = ((ServerConnector)this.connector).getPort())) {
            throw new UncheckedIOException(new IOException("Error: Connector port " + cp + " does not match with the server engine port " + this.port));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stop() throws Exception {
        this.registedPaths.clear();
        if (this.server != null) {
            try {
                if (this.connector != null) {
                    this.connector.stop();
                    if (this.connector instanceof Closeable) {
                        ((Closeable)this.connector).close();
                    }
                }
            }
            finally {
                if (this.contexts != null && this.contexts.getHandlers() != null) {
                    for (Handler h : this.contexts.getHandlers()) {
                        h.stop();
                    }
                    this.contexts.stop();
                }
                this.contexts = null;
                this.server.stop();
                if (this.mBeanContainer != null) {
                    this.removeServerMBean();
                }
                this.server.destroy();
                this.server = null;
            }
        }
    }

    public void setTlsServerParameters(TLSServerParameters params) {
        this.tlsServerParameters = params;
        if (this.configFinalized) {
            this.retrieveListenerFactory();
        }
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public boolean isSetThreadingParameters() {
        return this.threadingParameters != null;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }

    public void setSendServerVersion(Boolean sendServerVersion) {
        this.sendServerVersion = sendServerVersion;
    }

    public Boolean getSendServerVersion() {
        return this.sendServerVersion;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
}

