/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.jboss.logging.Logger;
import org.jboss.threads.JBossExecutors;
import org.wildfly.common.Assert;
import org.wildfly.common.lock.ExtendedLock;
import org.wildfly.common.lock.Locks;

public final class ViewExecutor
extends AbstractExecutorService {
    private static final Logger log = Logger.getLogger((String)"org.jboss.threads.view-executor");
    private static final Runnable[] NO_RUNNABLES = new Runnable[0];
    private final Executor delegate;
    private final ExtendedLock lock;
    private final Condition shutDownCondition;
    private final ArrayDeque<Runnable> queue;
    private final Set<TaskWrapper> allWrappers = Collections.newSetFromMap(new ConcurrentHashMap());
    private int queueLimit;
    private short submittedCount;
    private short maxCount;
    private short runningCount;
    private int state = 0;
    private volatile Thread.UncaughtExceptionHandler handler;
    private volatile Runnable terminationTask;
    private static final int ST_RUNNING = 0;
    private static final int ST_SHUTDOWN_REQ = 1;
    private static final int ST_SHUTDOWN_INT_REQ = 2;
    private static final int ST_STOPPED = 3;

    ViewExecutor(Builder builder) {
        int queueLimit;
        this.delegate = builder.getDelegate();
        this.maxCount = (short)builder.getMaxSize();
        this.queueLimit = queueLimit = builder.getQueueLimit();
        this.handler = builder.getUncaughtHandler();
        this.queue = new ArrayDeque(Math.min(queueLimit, builder.getQueueInitialSize()));
        this.lock = Locks.reentrantLock();
        this.shutDownCondition = this.lock.newCondition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(Runnable command) {
        block8: {
            this.lock.lock();
            try {
                if (this.state != 0) {
                    throw new RejectedExecutionException("Executor has been shut down");
                }
                short submittedCount = this.submittedCount;
                if (this.runningCount + submittedCount < this.maxCount) {
                    this.submittedCount = (short)(submittedCount + 1);
                    TaskWrapper tw = new TaskWrapper(JBossExecutors.classLoaderPreservingTask(command));
                    this.allWrappers.add(tw);
                    try {
                        this.delegate.execute(tw);
                        break block8;
                    }
                    catch (Throwable t) {
                        this.submittedCount = (short)(this.submittedCount - 1);
                        this.allWrappers.remove(tw);
                        throw t;
                    }
                }
                if (this.queue.size() < this.queueLimit) {
                    this.queue.add(command);
                    break block8;
                }
                throw new RejectedExecutionException("No executor queue space remaining");
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean interrupt) {
        this.lock.lock();
        int oldState = this.state;
        if (oldState < 1) {
            boolean emptyQueue;
            try {
                emptyQueue = this.queue.isEmpty();
            }
            catch (Throwable t) {
                this.lock.unlock();
                throw t;
            }
            if (this.runningCount == 0 && this.submittedCount == 0 && emptyQueue) {
                this.state = 3;
                try {
                    this.shutDownCondition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
                this.runTermination();
                return;
            }
        }
        this.state = interrupt ? 2 : 1;
        this.lock.unlock();
        if (interrupt && oldState < 2) {
            for (TaskWrapper wrapper : this.allWrappers) {
                wrapper.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        Runnable[] tasks;
        this.lock.lock();
        int oldState = this.state;
        try {
            tasks = this.queue.toArray(NO_RUNNABLES);
            this.queue.clear();
        }
        catch (Throwable t) {
            this.lock.unlock();
            throw t;
        }
        if (oldState < 2) {
            if (this.runningCount == 0 && this.submittedCount == 0) {
                this.state = 3;
                try {
                    this.shutDownCondition.signalAll();
                }
                finally {
                    this.lock.unlock();
                }
                this.runTermination();
            } else {
                this.lock.unlock();
                this.state = 2;
                for (TaskWrapper wrapper : this.allWrappers) {
                    wrapper.interrupt();
                }
            }
        } else {
            this.lock.unlock();
        }
        return Arrays.asList(tasks);
    }

    @Override
    public boolean isShutdown() {
        this.lock.lock();
        try {
            boolean bl = this.state >= 1;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isTerminated() {
        this.lock.lock();
        try {
            boolean bl = this.state == 3;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.state == 3) {
                boolean bl = true;
                return bl;
            }
            long nanos = unit.toNanos(timeout);
            if (nanos <= 0L) {
                boolean bl = false;
                return bl;
            }
            long elapsed = 0L;
            long start = System.nanoTime();
            do {
                this.shutDownCondition.awaitNanos(nanos - elapsed);
                if (this.state != 3) continue;
                boolean bl = true;
                return bl;
            } while ((elapsed = System.nanoTime() - start) < nanos);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.handler;
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        Assert.checkNotNullParam((String)"handler", (Object)handler);
        this.handler = handler;
    }

    public Runnable getTerminationTask() {
        return this.terminationTask;
    }

    public void setTerminationTask(Runnable terminationTask) {
        this.terminationTask = terminationTask;
    }

    public String toString() {
        return "view of " + this.delegate;
    }

    public static Builder builder(Executor delegate) {
        Assert.checkNotNullParam((String)"delegate", (Object)delegate);
        return new Builder(delegate);
    }

    private void runTermination() {
        Runnable task = this.terminationTask;
        this.terminationTask = null;
        if (task != null) {
            try {
                task.run();
            }
            catch (Throwable t) {
                try {
                    this.handler.uncaughtException(Thread.currentThread(), t);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    static /* synthetic */ short access$110(ViewExecutor x0) {
        short s = x0.submittedCount;
        x0.submittedCount = (short)(s - 1);
        return s;
    }

    static /* synthetic */ short access$208(ViewExecutor x0) {
        short s = x0.runningCount;
        x0.runningCount = (short)(s + 1);
        return s;
    }

    static /* synthetic */ short access$210(ViewExecutor x0) {
        short s = x0.runningCount;
        x0.runningCount = (short)(s - 1);
        return s;
    }

    static /* synthetic */ short access$108(ViewExecutor x0) {
        short s = x0.submittedCount;
        x0.submittedCount = (short)(s + 1);
        return s;
    }

    class TaskWrapper
    implements Runnable {
        private volatile Thread thread;
        private Runnable command;

        TaskWrapper(Runnable command) {
            this.command = command;
        }

        void interrupt() {
            Thread thread = this.thread;
            if (thread != null) {
                thread.interrupt();
            }
        }

        /*
         * Loose catch block
         */
        @Override
        public void run() {
            this.thread = Thread.currentThread();
            while (true) {
                block22: {
                    block23: {
                        ViewExecutor.this.lock.lock();
                        try {
                            ViewExecutor.access$110(ViewExecutor.this);
                            ViewExecutor.access$208(ViewExecutor.this);
                        }
                        finally {
                            ViewExecutor.this.lock.unlock();
                        }
                        try {
                            this.command.run();
                        }
                        catch (Throwable t) {
                            try {
                                ViewExecutor.this.handler.uncaughtException(Thread.currentThread(), t);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        ViewExecutor.this.lock.lock();
                        ViewExecutor.access$210(ViewExecutor.this);
                        try {
                            this.command = (Runnable)ViewExecutor.this.queue.pollFirst();
                        }
                        catch (Throwable t) {
                            ViewExecutor.this.lock.unlock();
                            throw t;
                        }
                        if (ViewExecutor.this.runningCount + ViewExecutor.this.submittedCount < ViewExecutor.this.maxCount && this.command != null) {
                            ViewExecutor.access$108(ViewExecutor.this);
                            ViewExecutor.this.lock.unlock();
                            break block22;
                        }
                        if (this.command != null || ViewExecutor.this.runningCount != 0 || ViewExecutor.this.submittedCount != 0 || ViewExecutor.this.state == 0) break block23;
                        ViewExecutor.this.state = 3;
                        try {
                            ViewExecutor.this.shutDownCondition.signalAll();
                        }
                        finally {
                            ViewExecutor.this.lock.unlock();
                        }
                        ViewExecutor.this.runTermination();
                        this.thread = null;
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    ViewExecutor.this.lock.unlock();
                    return;
                }
                try {
                    ViewExecutor.this.delegate.execute(this);
                    this.thread = null;
                    return;
                }
                catch (Throwable t) {
                    log.warn((Object)"Failed to resubmit executor task to delegate executor (executing task immediately instead)", t);
                    continue;
                }
                break;
            }
            finally {
                this.thread = null;
            }
        }
    }

    public static final class Builder {
        private final Executor delegate;
        private short maxSize = 1;
        private int queueLimit = Integer.MAX_VALUE;
        private int queueInitialSize = 256;
        private Thread.UncaughtExceptionHandler handler = JBossExecutors.loggingExceptionHandler();

        Builder(Executor delegate) {
            this.delegate = delegate;
        }

        public int getMaxSize() {
            return this.maxSize;
        }

        public Builder setMaxSize(int maxSize) {
            Assert.checkMinimumParameter((String)"maxSize", (int)1, (int)maxSize);
            Assert.checkMaximumParameter((String)"maxSize", (int)Short.MAX_VALUE, (int)maxSize);
            this.maxSize = (short)maxSize;
            return this;
        }

        public int getQueueLimit() {
            return this.queueLimit;
        }

        public Builder setQueueLimit(int queueLimit) {
            Assert.checkMinimumParameter((String)"queueLimit", (int)0, (int)queueLimit);
            this.queueLimit = queueLimit;
            return this;
        }

        public Executor getDelegate() {
            return this.delegate;
        }

        public Thread.UncaughtExceptionHandler getUncaughtHandler() {
            return this.handler;
        }

        public Builder setUncaughtHandler(Thread.UncaughtExceptionHandler handler) {
            this.handler = handler;
            return this;
        }

        public int getQueueInitialSize() {
            return this.queueInitialSize;
        }

        public Builder setQueueInitialSize(int queueInitialSize) {
            this.queueInitialSize = queueInitialSize;
            return this;
        }

        public ViewExecutor build() {
            return new ViewExecutor(this);
        }
    }
}

