/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf.handlers;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.cxf.CXFInvocationHandler;
import org.apache.cxf.jca.cxf.CXFInvocationHandlerData;
import org.apache.cxf.jca.cxf.handlers.CXFInvocationHandlerBase;

public class ObjectMethodInvocationHandler
extends CXFInvocationHandlerBase {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final String TO_STRING_METHOD_NAME = "toString";
    private static final Logger LOG = LogUtils.getL7dLogger(ObjectMethodInvocationHandler.class);

    public ObjectMethodInvocationHandler(CXFInvocationHandlerData data) {
        super(data);
        LOG.fine("ObjectMethodInvocationHandler instance created");
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object ret = null;
        LOG.fine(this + " on " + method);
        ret = method.getDeclaringClass().equals(Object.class) ? (EQUALS_METHOD_NAME.equals(method.getName()) ? this.doEquals(args[0]) : (TO_STRING_METHOD_NAME.equals(method.getName()) ? this.doToString() : method.invoke(this.getData().getTarget(), args))) : this.invokeNext(proxy, method, args);
        return ret;
    }

    private Boolean doEquals(Object rhs) {
        InvocationHandler rhsHandler;
        Boolean ret = Boolean.FALSE;
        if (rhs instanceof Proxy && (rhsHandler = Proxy.getInvocationHandler(rhs)) instanceof CXFInvocationHandler) {
            ret = this.getData().getTarget() == ((CXFInvocationHandler)rhsHandler).getData().getTarget();
        }
        return ret;
    }

    private String doToString() {
        return "ConnectionHandle. Associated ManagedConnection: " + this.getData().getManagedConnection();
    }
}

