/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.descriptor;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public abstract class AbstractTestDescriptor
implements TestDescriptor {
    private final UniqueId uniqueId;
    private final String displayName;
    private final TestSource source;
    private TestDescriptor parent;
    protected final Set<TestDescriptor> children = Collections.synchronizedSet(new LinkedHashSet(16));

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName) {
        this(uniqueId, displayName, null);
    }

    protected AbstractTestDescriptor(UniqueId uniqueId, String displayName, TestSource source) {
        this.uniqueId = Preconditions.notNull(uniqueId, "UniqueId must not be null");
        this.displayName = Preconditions.notBlank(displayName, "displayName must not be null or blank");
        this.source = source;
    }

    @Override
    public final UniqueId getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public final String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Set<TestTag> getTags() {
        return Collections.emptySet();
    }

    @Override
    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public final Optional<TestDescriptor> getParent() {
        return Optional.ofNullable(this.parent);
    }

    @Override
    public final void setParent(TestDescriptor parent) {
        this.parent = parent;
    }

    @Override
    public final Set<? extends TestDescriptor> getChildren() {
        return Collections.unmodifiableSet(this.children);
    }

    @Override
    public void addChild(TestDescriptor child) {
        Preconditions.notNull(child, "child must not be null");
        child.setParent(this);
        this.children.add(child);
    }

    @Override
    public void removeChild(TestDescriptor child) {
        Preconditions.notNull(child, "child must not be null");
        this.children.remove(child);
        child.setParent(null);
    }

    @Override
    public void removeFromHierarchy() {
        Preconditions.condition(!this.isRoot(), "cannot remove the root of a hierarchy");
        this.parent.removeChild(this);
        this.children.forEach(child -> child.setParent(null));
        this.children.clear();
    }

    @Override
    public Optional<? extends TestDescriptor> findByUniqueId(UniqueId uniqueId) {
        Preconditions.notNull(uniqueId, "UniqueId must not be null");
        if (this.getUniqueId().equals(uniqueId)) {
            return Optional.of(this);
        }
        return this.children.stream().map(child -> child.findByUniqueId(uniqueId)).filter(Optional::isPresent).findAny().orElse(Optional.empty());
    }

    public final int hashCode() {
        return this.uniqueId.hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TestDescriptor that = (TestDescriptor)other;
        return this.getUniqueId().equals(that.getUniqueId());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getUniqueId();
    }
}

