/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.license;

import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.license.ILicenseFamily;
import org.apache.rat.license.SimpleLicenseFamily;

public class ILicenseFamilyBuilder
implements ILicenseFamily.Builder {
    private String licenseFamilyCategory;
    private String licenseFamilyName;

    @Override
    public ILicenseFamily.Builder setLicenseFamilyCategory(String licenseFamilyCategory) {
        this.licenseFamilyCategory = licenseFamilyCategory;
        return this;
    }

    @Override
    public String getCategory() {
        return this.licenseFamilyCategory;
    }

    @Override
    public ILicenseFamily.Builder setLicenseFamilyName(String licenseFamilyName) {
        this.licenseFamilyName = licenseFamilyName;
        return this;
    }

    @Override
    public ILicenseFamily build() {
        if (StringUtils.isBlank(this.licenseFamilyCategory)) {
            throw new ConfigurationException("LicenseFamily Category must be specified");
        }
        if (StringUtils.isBlank(this.licenseFamilyName)) {
            throw new ConfigurationException("LicenseFamily Name must be specified");
        }
        return new SimpleLicenseFamily(this.licenseFamilyCategory, this.licenseFamilyName);
    }
}

