/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.configuration;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.rat.ConfigurationException;
import org.apache.rat.configuration.LicenseReader;
import org.apache.rat.configuration.MatcherReader;
import org.apache.rat.configuration.XMLConfigurationReader;

public enum Format {
    XML(XMLConfigurationReader.class, "xml"),
    TXT(null, "txt", "text");

    private final String[] suffix;
    private Constructor<MatcherReader> matcherReader;
    private Constructor<LicenseReader> licenseReader;

    private Format(Class<?> reader, String ... suffix) {
        if (reader != null) {
            try {
                this.matcherReader = MatcherReader.class.isAssignableFrom(reader) ? reader.getConstructor(new Class[0]) : null;
                this.licenseReader = LicenseReader.class.isAssignableFrom(reader) ? reader.getConstructor(new Class[0]) : null;
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new ConfigurationException("Error retrieving no argument constructor for " + reader.getName(), e);
            }
        }
        this.suffix = suffix;
    }

    public MatcherReader matcherReader() {
        try {
            return this.matcherReader == null ? null : this.matcherReader.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ConfigurationException("Can not instantiate MatcherReader for " + this.name(), e);
        }
    }

    public LicenseReader licenseReader() {
        try {
            return this.licenseReader == null ? null : this.licenseReader.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new ConfigurationException("Can not instantiate LicenseReader for " + this.name(), e);
        }
    }

    public static Format fromName(String name) {
        String[] parts = name.split("\\.");
        String suffix = parts[parts.length - 1];
        for (Format f : Format.values()) {
            if (!Arrays.asList(f.suffix).contains(suffix)) continue;
            return f;
        }
        throw new IllegalArgumentException(String.format("No such suffix: %s", suffix));
    }

    public static Format fromURL(URL url) {
        return Format.fromName(url.getFile());
    }

    public static Format fromFile(File file) throws MalformedURLException {
        return Format.fromURL(file.toURI().toURL());
    }
}

