/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis.matchers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.IHeaderMatcher;
import org.apache.rat.analysis.matchers.AbstractSimpleMatcher;

public class SPDXMatcherFactory {
    private static final Map<String, Match> matchers = new HashMap<String, Match>();
    public static final SPDXMatcherFactory INSTANCE = new SPDXMatcherFactory();
    private static Pattern groupSelector = Pattern.compile(".*SPDX-License-Identifier:\\s([A-Za-z0-9\\.\\-]+)");
    private String lastLine = null;
    private Match lastMatch;

    private SPDXMatcherFactory() {
    }

    public IHeaderMatcher create(String spdxId) {
        if (StringUtils.isBlank(spdxId)) {
            throw new ConfigurationException("'spdx' type matcher requires a name");
        }
        Match matcher = matchers.get(spdxId);
        if (matcher == null) {
            matcher = new Match(spdxId);
            matchers.put(spdxId, matcher);
        }
        return matcher;
    }

    private boolean check(String line, Match caller) {
        if (this.lastLine == null || !this.lastLine.equals(line)) {
            Matcher matcher = groupSelector.matcher(line);
            this.lastMatch = matcher.find() ? matchers.get(matcher.group(1)) : null;
        }
        return this.lastMatch != null && caller.spdxId.equals(this.lastMatch.spdxId);
    }

    public class Match
    extends AbstractSimpleMatcher {
        String spdxId;

        Match(String spdxId) {
            super("SPDX:" + spdxId);
            Objects.requireNonNull(spdxId, "SpdxId is required");
            this.spdxId = spdxId;
        }

        @Override
        protected boolean doMatch(String line) {
            return SPDXMatcherFactory.this.check(line, this);
        }
    }
}

