/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Objects;
import org.apache.rat.ConfigurationException;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.analysis.UnknownLicense;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.license.ILicense;

class HeaderCheckWorker {
    public static final int DEFAULT_NUMBER_OF_RETAINED_HEADER_LINES = 50;
    private final int numberOfRetainedHeaderLines;
    private final BufferedReader reader;
    private final ILicense license;
    private final Document document;
    private int headerLinesToRead;
    private boolean finished = false;

    public HeaderCheckWorker(Reader reader, ILicense license, Document name) {
        this(reader, 50, license, name);
    }

    public HeaderCheckWorker(Reader reader, int numberOfRetainedHeaderLine, ILicense license, Document name) {
        Objects.requireNonNull(reader, "Reader may not be null");
        Objects.requireNonNull(license, "License may not be null");
        if (numberOfRetainedHeaderLine < 0) {
            throw new ConfigurationException("numberOfRetainedHeaderLine may not be less than zero");
        }
        this.reader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.numberOfRetainedHeaderLines = numberOfRetainedHeaderLine;
        this.license = license;
        this.document = name;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void read() throws RatHeaderAnalysisException {
        if (!this.finished) {
            StringBuilder headers = new StringBuilder();
            this.headerLinesToRead = this.numberOfRetainedHeaderLines;
            try {
                while (this.readLine(headers)) {
                }
                if (this.license.finalizeState().asBoolean()) {
                    this.document.getMetaData().reportOnLicense(this.license);
                } else {
                    this.document.getMetaData().reportOnLicense(UnknownLicense.INSTANCE);
                    this.document.getMetaData().set(new MetaData.Datum("http://org/apache/rat/meta-data#HeaderSample", headers.toString()));
                }
            }
            catch (IOException e) {
                throw new RatHeaderAnalysisException("Cannot read header for " + this.document, e);
            }
            this.license.reset();
        }
        this.finished = true;
    }

    boolean readLine(StringBuilder headers) throws IOException {
        boolean result;
        String line = this.reader.readLine();
        boolean bl = result = line != null;
        if (result) {
            if (this.headerLinesToRead-- > 0) {
                headers.append(line);
                headers.append('\n');
            }
            switch (this.license.matches(line)) {
                case t: {
                    result = false;
                    break;
                }
                case f: 
                case i: {
                    result = true;
                }
            }
        }
        return result;
    }
}

