/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.analysis;

import java.io.IOException;
import java.io.Reader;
import org.apache.rat.analysis.HeaderCheckWorker;
import org.apache.rat.analysis.RatHeaderAnalysisException;
import org.apache.rat.api.Document;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.license.ILicense;

class DocumentHeaderAnalyser
implements IDocumentAnalyser {
    private final ILicense license;

    public DocumentHeaderAnalyser(ILicense license) {
        this.license = license;
    }

    @Override
    public void analyse(Document document) throws RatDocumentAnalysisException {
        try (Reader reader = document.reader();){
            HeaderCheckWorker worker = new HeaderCheckWorker(reader, this.license, document);
            worker.read();
        }
        catch (IOException e) {
            throw new RatDocumentAnalysisException("Cannot read header", e);
        }
        catch (RatHeaderAnalysisException e) {
            throw new RatDocumentAnalysisException("Cannot analyse header", e);
        }
    }
}

